/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection;

import oracle.dbtools.raptor.cloud.auth.AuthenticationFailedException;
import oracle.dbtools.raptor.cloud.connection.ui.BaseConnectionPanel;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.auth.BasicScheme;

public abstract class CConnectionType {
    public abstract String getType();

    protected abstract String getClientID();

    protected abstract String getClientSecret();

    public final void signRequest(HttpRequest httpRequest) throws AuthenticationFailedException {
        Header header;
        UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(this.getClientID(), this.getClientSecret());
        BasicScheme basicScheme = new BasicScheme();
        try {
            header = basicScheme.authenticate((Credentials)usernamePasswordCredentials, httpRequest);
        }
        catch (AuthenticationException authenticationException) {
            throw new AuthenticationFailedException(authenticationException);
        }
        httpRequest.addHeader(header);
    }

    public abstract Class<? extends BaseConnectionPanel> getConnectionEditorClass();

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object object) {
        return object == this;
    }

    public String toString() {
        return this.getType();
    }
}

