/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.auth.basic;

import java.awt.Component;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.ide.net.URIFactory;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.cloud.CloudBrowserResources;
import oracle.dbtools.raptor.cloud.auth.Authentication;
import oracle.dbtools.raptor.cloud.auth.AuthenticationCanceledException;
import oracle.dbtools.raptor.cloud.auth.AuthenticationEngine;
import oracle.dbtools.raptor.cloud.auth.AuthenticationFailedException;
import oracle.dbtools.raptor.cloud.auth.basic.AuthenticationPanel;
import oracle.dbtools.raptor.cloud.auth.basic.BasicAuthenticationHandler;
import oracle.dbtools.raptor.cloud.connection.CConnectionInfo;
import oracle.dbtools.raptor.cloud.connection.CConnectionType;
import oracle.dbtools.raptor.cloud.connection.Client;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class BasicAuthenticationEngine
implements AuthenticationEngine {
    private static final String GRANT_TYPE = "grant_type";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String ENCODING_UTF8 = "UTF-8";
    private static final String AUTH_PATH = "/oauth2/token";
    private Client m_client;

    @Override
    public void init(Client client) {
        this.m_client = client;
    }

    @Override
    public Authentication authenticate(CConnectionInfo cConnectionInfo) throws AuthenticationFailedException {
        HttpPost httpPost = this.createPost(cConnectionInfo);
        HttpEntity httpEntity = this.promptForAuthentication(cConnectionInfo);
        httpPost.setEntity(httpEntity);
        return this.doPost(httpPost);
    }

    private HttpPost createPost(CConnectionInfo cConnectionInfo) throws AuthenticationFailedException {
        URI uRI = cConnectionInfo.getServerRoot();
        URI uRI2 = URIFactory.newURI((URI)uRI, (String)AUTH_PATH);
        HttpPost httpPost = new HttpPost(uRI2);
        this.signRequest((HttpRequest)httpPost);
        return httpPost;
    }

    @Override
    public Authentication reauthenticate(Authentication authentication, CConnectionInfo cConnectionInfo) throws AuthenticationFailedException {
        HttpPost httpPost = this.createPost(cConnectionInfo);
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
        arrayList.add(new BasicNameValuePair(GRANT_TYPE, "refresh_token"));
        arrayList.add(new BasicNameValuePair("refresh_token", authentication.getRefreshToken()));
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(arrayList, ENCODING_UTF8));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AuthenticationFailedException(unsupportedEncodingException);
        }
        return this.doPost(httpPost);
    }

    private HttpEntity promptForAuthentication(final CConnectionInfo cConnectionInfo) throws AuthenticationFailedException {
        Callable<HttpEntity> callable = new Callable<HttpEntity>(){

            @Override
            public HttpEntity call() throws AuthenticationFailedException {
                AuthenticationPanel authenticationPanel = new AuthenticationPanel();
                Namespace namespace = new Namespace();
                namespace.put("AuthenticationConnection", (Object)cConnectionInfo);
                TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)Ide.getMainWindow(), CloudBrowserResources.getString("AUTHENTICATION_TITLE"), (Traversable)authenticationPanel, namespace);
                tDialogLauncher.setPackDialog(true);
                tDialogLauncher.initDialog().setInitialFocus(authenticationPanel.getInitialFocusComponent());
                if (!tDialogLauncher.showDialog()) {
                    throw new AuthenticationCanceledException();
                }
                String string = (String)namespace.get("AuthenticationUsername");
                char[] cArray = (char[])namespace.get("AuthenticationPassword");
                ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
                arrayList.add(new BasicNameValuePair(BasicAuthenticationEngine.GRANT_TYPE, BasicAuthenticationEngine.PASSWORD));
                arrayList.add(new BasicNameValuePair(BasicAuthenticationEngine.USERNAME, string));
                arrayList.add(new BasicNameValuePair(BasicAuthenticationEngine.PASSWORD, new String(cArray)));
                try {
                    return new UrlEncodedFormEntity(arrayList, BasicAuthenticationEngine.ENCODING_UTF8);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new AuthenticationFailedException(unsupportedEncodingException);
                }
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                return (HttpEntity)callable.call();
            }
            FutureTask<HttpEntity> futureTask = new FutureTask<HttpEntity>(callable);
            SwingUtilities.invokeAndWait(futureTask);
            return futureTask.get();
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof AuthenticationFailedException) {
                throw (AuthenticationFailedException)((Object)throwable);
            }
            throw new AuthenticationFailedException(throwable);
        }
        catch (Exception exception) {
            if (exception instanceof AuthenticationFailedException) {
                throw (AuthenticationFailedException)((Object)exception);
            }
            throw new AuthenticationFailedException(exception);
        }
    }

    private void signRequest(HttpRequest httpRequest) throws AuthenticationFailedException {
        CConnectionType cConnectionType = this.m_client.getConnectionType();
        cConnectionType.signRequest(httpRequest);
    }

    private Authentication doPost(HttpPost httpPost) throws AuthenticationFailedException {
        HttpEntity httpEntity;
        StringBuilder stringBuilder = new StringBuilder(httpPost.getRequestLine().toString());
        stringBuilder.append('\n').append(httpPost.getURI().toString());
        HttpEntity httpEntity2 = httpPost.getAllHeaders();
        if (httpEntity2 != null) {
            httpEntity = httpEntity2;
            int n = ((HttpEntity)httpEntity).length;
            for (int i = 0; i < n; ++i) {
                HttpEntity httpEntity3 = httpEntity[i];
                stringBuilder.append('\n').append(httpEntity3.toString());
            }
        }
        if (URLEncodedUtils.isEncoded((HttpEntity)(httpEntity = httpPost.getEntity()))) {
            try {
                List list = URLEncodedUtils.parse((HttpEntity)httpEntity);
                stringBuilder.append('\n').append("Encoded entity contents: " + URLEncodedUtils.format((List)list, (String)ENCODING_UTF8));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.log(stringBuilder.toString());
        try {
            return this.m_client.executeRequest((HttpUriRequest)httpPost, new BasicAuthenticationHandler());
        }
        catch (AuthenticationFailedException authenticationFailedException) {
            throw authenticationFailedException;
        }
        catch (ClientProtocolException clientProtocolException) {
            throw new AuthenticationFailedException(clientProtocolException);
        }
        catch (UnknownHostException unknownHostException) {
            throw new AuthenticationFailedException(CloudBrowserResources.format("MESSAGE_UNKNOWN_HOST", unknownHostException.getMessage()));
        }
        catch (IOException iOException) {
            throw new AuthenticationFailedException(iOException);
        }
    }

    private void log(String string) {
        Logger.fine(AuthenticationEngine.class, (String)string);
    }
}

