/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask.utils;

import java.awt.Component;
import java.awt.Frame;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.CommonArb;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.DummyElement;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.db.ConnectionException;

public abstract class AbstractLoadChildrenTask
extends DatabaseQueryTask<List<Element>> {
    protected static final Logger LOGGER = Logger.getLogger(AbstractLoadChildrenTask.class.getName());
    private Element _parent;

    public AbstractLoadChildrenTask(Element element) {
        super(AbstractLoadChildrenTask.getTaskName(element), IRaptorTaskRunMode.IDE_STATUSBAR, false, true, true);
        assert (element instanceof Subject);
        this._parent = element;
        this.setMessage(this.getDescriptor().getName());
        this.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                AbstractLoadChildrenTask.this.cleanupOnError();
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                Throwable throwable = raptorTaskEvent.getThrowable();
                ExceptionDialogRunnable exceptionDialogRunnable = new ExceptionDialogRunnable(AbstractLoadChildrenTask.this.getConnectionName(), DatabaseNavigatorResources.getString("CONNECTION_FILTER_CONNECT_ERROR"), throwable);
                if (SwingUtilities.isEventDispatchThread()) {
                    exceptionDialogRunnable.run();
                } else {
                    try {
                        SwingUtilities.invokeLater(exceptionDialogRunnable);
                    }
                    catch (Exception exception) {
                        AbstractLoadChildrenTask.this.log(exception);
                    }
                }
                AbstractLoadChildrenTask.this.cleanupOnError();
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                if (AbstractLoadChildrenTask.this._parent instanceof Folder) {
                    ((Folder)AbstractLoadChildrenTask.this._parent).remove(DummyElement.INSTANCE);
                }
                UpdateMessage.fireChildRemoved((Subject)((Subject)AbstractLoadChildrenTask.this._parent), (Element)DummyElement.INSTANCE);
                try {
                    List list = (List)AbstractLoadChildrenTask.this.getResult();
                    if (AbstractLoadChildrenTask.this._parent instanceof Folder) {
                        for (Element element : list) {
                            ((Folder)AbstractLoadChildrenTask.this._parent).add(element);
                        }
                    }
                    UpdateMessage.fireChildrenAdded((Subject)((Subject)AbstractLoadChildrenTask.this._parent), (Collection)list);
                    if (AbstractLoadChildrenTask.this._parent instanceof Dirtyable) {
                        ((Dirtyable)AbstractLoadChildrenTask.this._parent).markDirty(false);
                    }
                }
                catch (InterruptedException interruptedException) {
                    AbstractLoadChildrenTask.this.log(interruptedException);
                }
                catch (ExecutionException executionException) {
                    AbstractLoadChildrenTask.this.log(executionException);
                }
            }
        });
    }

    protected abstract List<Element> doWork() throws TaskException;

    @Override
    public abstract String getConnectionName();

    protected void checkStatus(String string) throws AbortException {
        try {
            this.checkCanProceed();
        }
        catch (ExecutionException executionException) {
            throw new AbortException(string);
        }
    }

    protected static String getTaskName(Element element) {
        return DatabaseNavigatorResources.format("LOAD_CHILDREN_TASK_NAME", element.getShortLabel());
    }

    @Override
    public String getQuery() {
        return null;
    }

    protected void cleanupOnError() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AbstractLoadChildrenTask.this._parent instanceof Node) {
                    Node node = (Node)AbstractLoadChildrenTask.this._parent;
                    try {
                        node.close();
                    }
                    catch (Exception exception) {
                        AbstractLoadChildrenTask.this.log(exception);
                    }
                } else if (AbstractLoadChildrenTask.this._parent instanceof Subject) {
                    UpdateMessage.fireObjectClosed((Subject)((Subject)AbstractLoadChildrenTask.this._parent));
                }
            }
        });
    }

    protected void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    protected static class ExceptionDialogRunnable
    implements Runnable {
        Throwable m_ex;
        String m_msg;
        private String connName;

        public ExceptionDialogRunnable(String string, String string2, Throwable throwable) {
            Throwable throwable2;
            this.connName = string;
            while ((throwable instanceof ConnectionException || throwable instanceof DBException) && (throwable2 = throwable.getCause()) instanceof Exception) {
                throwable = throwable2;
            }
            this.m_ex = throwable;
            this.m_msg = string2;
        }

        @Override
        public void run() {
            String string = CommonArb.getString("ERROR_CONNECTING");
            Frame frame = IdeUtil.getMainWindow();
            if (this.m_ex instanceof SQLException) {
                SQLErrorDialog.showErrorDialog((String)this.connName, (Component)frame, (String)string, (SQLException)((SQLException)this.m_ex));
            } else {
                String string2 = this.m_ex instanceof ConnectionException ? MessageFormat.format(this.m_msg, this.m_ex.getLocalizedMessage()) : this.m_ex.getLocalizedMessage();
                ExceptionDialog.showExceptionDialog((Component)frame, (Throwable)this.m_ex, (String)string, (String)string2, null);
            }
        }
    }
}

