/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.apex.importer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.apex.importer.ApexImportArb;
import oracle.dbtools.raptor.apex.importer.ApexImporter;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Encodings;

public class ApexImportFilePanel
extends DefaultTraversablePanel {
    private FilePanel _f;

    public ApexImportFilePanel() {
        this.setLayout(new GridBagLayout());
        this._f = new FilePanel();
        JLabel jLabel = new JLabel(ApexImportArb.getString("FILE_TEXT"));
        this.add(jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 0, 0), 0, 0));
        this.add(this._f, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(10, 1, 10, 0), 0, 0));
        this.setDefaultTitle(ApexImportArb.getString("FILE_TITLE"));
    }

    public void onEntry(TraversableContext traversableContext) {
        super.onEntry(traversableContext);
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (this._f.getFileName() == null || this._f.getFileName().trim().equals("")) {
            throw new TraversalException(ApexImportArb.getString("FILE_REQUIRED"));
        }
        File file = new File(this._f.getFileName());
        if (!file.exists()) {
            throw new TraversalException(ApexImportArb.getString("FILE_NOT_FOUND"));
        }
        Map<String, String> map = ApexImporter.getInfo(this._f.getFileName());
        if (map == null || map.get("p_id") == null) {
            throw new TraversalException(ApexImportArb.getString("FILE_NOT_VALID"));
        }
        traversableContext.put("FILENAME", (Object)this._f.getFileName());
        traversableContext.put("SCRIPT.ENCODING", (Object)this._f.getEncoding());
    }

    static class FilePanel
    extends JPanel
    implements ActionListener {
        private JButton _browse;
        private JTextField _file;
        private JComboBox _encoding;

        public FilePanel() {
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel(ApexImportArb.getString("IMPORT_FILE_PROMPT")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 5, 0, 5), 0, 0));
            this._file = new JTextField();
            this.add((Component)this._file, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(2, 1, 0, 5), 0, 0));
            this._browse = new JButton(ApexImportArb.getString("IMPORT_FILE_BROWSE"));
            this._browse.addActionListener(this);
            this.add((Component)this._browse, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 1, 0, 0), 0, 0));
            JLabel jLabel = new JLabel(ApexImportArb.getString("IMPORT_FILE_ENCODING"));
            this.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 5, 0, 5), 0, 0));
            this._encoding = this.createComboBox();
            this.add((Component)this._encoding, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 1, 0, 5), 0, 0));
            jLabel.setLabelFor(this._encoding);
            this._file.requestFocus();
        }

        public String getFileName() {
            return this._file.getText();
        }

        public String getEncoding() {
            return this._encoding.getSelectedItem().toString();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            URLFileChooser uRLFileChooser = new URLFileChooser();
            uRLFileChooser.setSelectionScope(2);
            uRLFileChooser.setSelectionMode(0);
            int n = uRLFileChooser.showSaveDialog((Component)Ide.getMainWindow());
            if (n == 0) {
                this._file.setText(uRLFileChooser.getSelectedURL().getFile());
            }
        }

        JComboBox createComboBox() {
            JComboBox jComboBox = new JComboBox();
            Encodings.initComboBox(jComboBox, (boolean)true, (String)"UTF-8");
            return jComboBox;
        }
    }
}

