/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.RepaintManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.proformatter.FormatterMenu;
import oracle.dbtools.proformatter.SQLFormatter;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleManager;
import oracle.dbtools.raptor.DefaultProviderForSQLPATH;
import oracle.dbtools.raptor.ISQLEditor;
import oracle.dbtools.raptor.InitializeConnectionListener;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.config.BindConfig;
import oracle.dbtools.raptor.config.ConfigChangeListener;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.connections.ConnectionTypeRegistry;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.raptor.dbdiff.ui.DBDiffWizMain;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.conn.ConnectionPrompt;
import oracle.dbtools.raptor.editors.ActiveViewStatusChanger;
import oracle.dbtools.raptor.export.wizard.ExportWizMain;
import oracle.dbtools.raptor.insight.DatabaseInsightAddin;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorManager;
import oracle.dbtools.raptor.navigator.net.DBRecognizer;
import oracle.dbtools.raptor.navigator.net.DBURLFactoryHelper;
import oracle.dbtools.raptor.navigator.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.newscriptrunner.ProviderForSQLPATH;
import oracle.dbtools.raptor.newscriptrunner.SQLPLUS;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.nls.INLSSupplier;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.queryBuilder.QueryBuilderController;
import oracle.dbtools.raptor.refactor.RefactorMenu;
import oracle.dbtools.raptor.schemacopy.wizard.CopyWizMain;
import oracle.dbtools.raptor.status.StatusEditorAddin;
import oracle.dbtools.raptor.status.StatusUrlFileSystemHelper;
import oracle.dbtools.raptor.status.StatusUrlStreamHandler;
import oracle.dbtools.raptor.utils.ClosedConnectionListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DefaultProviderTnsnamesDir;
import oracle.dbtools.raptor.utils.IdeLogImpl;
import oracle.dbtools.raptor.utils.IdeMessageLogger;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.MessageLogging;
import oracle.dbtools.raptor.utils.NamedSwingWorker;
import oracle.dbtools.raptor.utils.ProvideTnsnamesDir;
import oracle.dbtools.raptor.utils.RaptorDbDisconnectListener;
import oracle.dbtools.raptor.utils.SQLExceptionListener;
import oracle.dbtools.raptor.utils.SQLExceptionListenerRegistry;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.dbtools.util.CheckThreadViolationRepaintManager;
import oracle.dbtools.util.Debug;
import oracle.dbtools.util.EventDispatchThreadHangMonitor;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.EditorPluginsFactory;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.Preferences;
import oracle.ide.controller.IdeAction;
import oracle.ide.db.DBURLFactory;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.IdeProperties;
import oracle.ide.model.Project;
import oracle.ide.model.Recognizer;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.view.ActiveViewListener;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.db.DBException;
import oracle.javatools.db.ora.OracleDatabaseFactory;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.util.Copyable;
import oracle.jdbc.OracleConnection;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.ConnectionsEvent;
import oracle.jdeveloper.db.ConnectionsListener;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;
import oracle.jdevimpl.db.adapter.PasswordPrompter;

public class RaptorDBAddin
implements Addin,
ShutdownHook {
    private static ISQLEditor m_iSqlEditor;
    private static boolean m_autoCommitWorking;
    private RaptorDbDisconnectListener m_disconnectListener = new RaptorDbDisconnectListener();

    public void initialize() {
        IdeAction ideAction;
        Object object;
        DocumentExtensions documentExtensions;
        BindConfig bindConfig;
        URLFileSystem.addURLStreamHandlerFactory((URLStreamHandlerFactory)new StatusUrlStreamHandler());
        URLFileSystem.registerHelper((String)"sqldev.status", (URLFileSystemHelper)new StatusUrlFileSystemHelper());
        EditorManager.getEditorManager().registerDynamic((EditorAddin)new StatusEditorAddin());
        Preferences preferences = Preferences.getPreferences();
        DBConfig dBConfig = DBConfig.getInstance((PropertyStorage)preferences);
        BindConfig bindConfig2 = BindConfig.getInstance((PropertyStorage)preferences);
        IdeSettings ideSettings = Ide.getSettings();
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.sqldeveloper");
        DBConfig dBConfig2 = (DBConfig)clientSetting.getData("DBConfig");
        if (dBConfig2 != null) {
            clientSetting.putData("DBConfig", (Copyable)dBConfig2);
            ideSettings.putLegacyData("DBConfig", (Copyable)dBConfig);
        }
        if ((bindConfig = (BindConfig)clientSetting.getData("BindConfig")) != null) {
            clientSetting.putData("BindConfig", (Copyable)bindConfig);
            ideSettings.putLegacyData("BindConfig", (Copyable)bindConfig2);
        }
        if ((documentExtensions = (DocumentExtensions)clientSetting.getData("document-extensions-options")) != null) {
            clientSetting.putData("document-extensions-options", (Copyable)documentExtensions);
        }
        preferences.addStructureChangeListener((StructureChangeListener)new ConfigChangeListener());
        ResultSetFormatter.setMaxRows((int)dBConfig.getInt("MAXSCRIPTROWS"));
        ResultSetFormatter.setMaxLines((int)dBConfig.getInt("MAXSCRIPTLINES"));
        ExitCommand.addShutdownHook((ShutdownHook)this);
        Recognizer.mapExtensionToClass((String)".jpr", Project.class);
        Recognizer.mapExtensionToClass((String)".jws", Workspace.class);
        TNSHelper.setProvideTnsnamesDir((ProvideTnsnamesDir)new DefaultProviderTnsnamesDir());
        SQLPLUS.setSqlpathProvider((ProviderForSQLPATH)new DefaultProviderForSQLPATH());
        this.initConnectionStore();
        this.initNavigator();
        Recognizer.registerLowPriorityRecognizer((Recognizer)new DBRecognizer());
        DBURLFactory.registerHelper((DBURLFactory.Helper)new DBURLFactoryHelper());
        InitializeConnectionListener initializeConnectionListener = new InitializeConnectionListener();
        initializeConnectionListener.register();
        ConnectionPrompt connectionPrompt = new ConnectionPrompt();
        DatabaseProviderHelper.setPasswordPrompter((PasswordPrompter)connectionPrompt);
        this.initSettings(clientSetting);
        IdeAction ideAction2 = IdeAction.find((int)66);
        if (ideAction2 != null) {
            object = CreateDialogArb.getString("MENU_VIEW_CONNECTIONS");
            ideAction2.putValue("Name", (Object)StringUtils.stripMnemonic((String)object));
            ideAction2.putValue("MnemonicKey", (Object)new Integer(StringUtils.getMnemonicKeyCode((String)object)));
        }
        if ((object = Ide.findCmdID((String)"ConnectionNavigator.TOGGLE_TOOLBAR_CMD_ID")) != null && (ideAction = IdeAction.find((int)((Integer)object))) != null) {
            String string = CreateDialogArb.getString("MENU_VIEW_TOOLBARS_CONNECTIONS");
            ideAction.putValue("Name", (Object)StringUtils.stripMnemonic((String)string));
            ideAction.putValue("MnemonicKey", (Object)new Integer(StringUtils.getMnemonicKeyCode((String)string)));
        }
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)new ActiveViewStatusChanger());
        QueryBuilderController.getInstance();
        CodeEditor.registerFactory((EditorPluginsFactory)new DatabaseInsightAddin());
        this.initMenus();
        Ide.addIdeListener((IdeListener)new IdeListener(){

            public void addinsLoaded(IdeEvent ideEvent) {
                boolean bl = false;
                if (bl) {
                    UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
                    uIDefaults.put("ProgressBarUI", "oracle.javatools.ui.plaf.theme.ThemedProgressBarUI");
                    uIDefaults.put("TabbedPaneUI", "oracle.javatools.ui.plaf.theme.ThemedTabbedPaneUI");
                    uIDefaults.put("ButtonUI", "oracle.javatools.ui.plaf.theme.ThemedButtonUI");
                    uIDefaults.put("ToggleButtonUI", "oracle.javatools.ui.plaf.theme.ThemedToggleButtonUI");
                }
            }

            public void mainWindowOpened(IdeEvent ideEvent) {
                Log.setLogImpl((Log.ILog)new IdeLogImpl());
                Ide.removeIdeListener((IdeListener)this);
                Connections.getInstance().addConnectionDisconnectListener(RaptorDBAddin.this.m_disconnectListener);
                if (Debug.isDebugBuild() && RaptorExtensionConstants.isStandAlone()) {
                    long l = -1L;
                    String[] stringArray = Ide.getIdeArgs().getArgs();
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].equals("detect-hangs")) {
                            if (i >= stringArray.length) continue;
                            String string = stringArray[i + 1];
                            l = Long.valueOf(string);
                            continue;
                        }
                        if (!stringArray[i].equals("check-EDT-rule")) continue;
                        RepaintManager.setCurrentManager((RepaintManager)new CheckThreadViolationRepaintManager());
                    }
                    if (l > -1L) {
                        EventDispatchThreadHangMonitor.UNREASONABLE_DISPATCH_DURATION_MS = l;
                        EventDispatchThreadHangMonitor.initMonitoring();
                        EventDispatchThreadHangMonitor.INSTANCE.haveShownSomeComponent = true;
                    }
                }
            }

            public void mainWindowClosing(IdeEvent ideEvent) {
            }
        });
        this.initializeFormatter(dBConfig);
        SQLExceptionListenerRegistry.addListener((SQLExceptionListener)new ClosedConnectionListener());
        NLSProvider.setNLSSupplier((INLSSupplier)new INLSSupplier(){

            public DefaultNLSProvider getNLSProvider(Connection connection) {
                return ConnectionTypeDetails.getTypeDetails("", connection).getNLSProvider(connection);
            }

            public DefaultNLSProvider getNLSProvider(String string) {
                Connection connection = null;
                try {
                    connection = Connections.getInstance().getConnection(string);
                }
                catch (DBException dBException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
                }
                return ConnectionTypeDetails.getTypeDetails("", connection).getNLSProvider(connection);
            }
        });
        new NamedSwingWorker("CalendarActionControl initializer"){

            @Override
            public Object construct() {
                try {
                    Class.forName("oracle.dbtools.raptor.ui.controls.CalendarActionControl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, classNotFoundException.getStackTrace()[0].toString(), classNotFoundException);
                }
                return null;
            }
        }.start();
    }

    private void initializeFormatter(DBConfig dBConfig) {
        if (RaptorExtensionConstants.isStandAlone()) {
            int n = dBConfig.getInt("INDENT_CACHE_NUMBER");
            boolean bl = false;
            if (n == -1) {
                SQLFormatter.getInstance();
                bl = CodingStyleManager.getCodingStyleManager().getCodingStyleSQLOptions().getUseTab();
                n = CodingStyleManager.getCodingStyleManager().getCodingStyleSQLOptions().getNumSpaces();
                dBConfig.putBoolean("INDENT_CACHE_USE_TAB", bl);
                dBConfig.putInt("INDENT_CACHE_NUMBER", n);
            } else {
                bl = dBConfig.getBoolean("INDENT_CACHE_USE_TAB");
            }
            EditorProperties editorProperties = EditorProperties.getProperties();
            editorProperties.putIntegerProperty("indent-size", n);
            editorProperties.putBooleanProperty("use-tabs", bl);
            editorProperties.putIntegerProperty("tab-size", n);
        } else {
            SQLFormatter.getInstance();
        }
    }

    private void initMenus() {
        CopyWizMain.initMenu();
        ExportWizMain.initMenu();
        DBDiffWizMain.initMenu();
        RefactorMenu.init();
        FormatterMenu.init();
    }

    private void initNavigator() {
        IdeProperties ideProperties = Ide.getIdeProperties();
        ideProperties.setProperty("TreeAutoExpander.Enabled", Boolean.toString(false));
        NavigatorManager navigatorManager = DatabaseNavigatorManager.getInstance();
        navigatorManager.initialize();
    }

    private void initConnectionStore() {
        MessageLogging.setMessageLogger((MessageLogging)new IdeMessageLogger());
        DBUtil.setConnectionResolver((ConnectionResolver)Connections.getInstance());
        final DatabaseConnections databaseConnections = DatabaseConnections.getInstance();
        databaseConnections.addListener(new ConnectionsListener(){

            public void connectionAdded(ConnectionsEvent connectionsEvent) {
                this.saveConnections();
            }

            public void connectionRemoved(ConnectionsEvent connectionsEvent) {
                this.saveConnections();
            }

            public void connectionUpdated(ConnectionsEvent connectionsEvent) {
                this.saveConnections();
            }

            private void saveConnections() {
                try {
                    databaseConnections.saveConnections();
                }
                catch (ConnectionException connectionException) {
                    // empty catch block
                }
            }
        });
    }

    private void initSettings(ClientSetting clientSetting) {
        OracleDatabaseFactory.setDefaultAutocommit((boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerConnectionPanel(String string) {
        URL uRL = RaptorDBAddin.class.getClassLoader().getResource(string);
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            int n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                string2 = string2.trim();
                ++n;
                if (string2.length() <= 0) continue;
                int n2 = string2.indexOf(61);
                if (n2 < 0) {
                    throw new RuntimeException("Invalid INI file format at line " + n + " -- Expected key=value found " + string2);
                }
                String string3 = string2.substring(0, n2).trim();
                String string4 = string2.substring(n2 + 1, string2.length()).trim();
                Class<IConnectionPanel> clazz = null;
                try {
                    clazz = Class.forName(string4).asSubclass(IConnectionPanel.class);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logger.getLogger(RaptorDBAddin.class.getClass().getName()).log(Level.WARNING, classNotFoundException.getStackTrace()[0].toString(), classNotFoundException);
                }
                ConnectionTypeRegistry.registerConnectionType(string3, clazz, null);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(RaptorDBAddin.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(RaptorDBAddin.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
    }

    public static synchronized void registerSqlOpener(ISQLEditor iSQLEditor) {
        m_iSqlEditor = iSQLEditor;
    }

    public static ISQLEditor getSqlOpener() {
        return m_iSqlEditor;
    }

    public boolean canShutdown() {
        return true;
    }

    public void shutdown() {
        DBConfig dBConfig = DBConfig.getInstance();
        if (!dBConfig.getBoolean("SAVEBINDS").booleanValue()) {
            BindConfig.getInstance().clearBinds();
        }
        Connections.getInstance().removeConnectionDisconnectListener(this.m_disconnectListener);
    }

    public static void setAutoCommit(final boolean bl) {
        if (!m_autoCommitWorking) {
            RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("RaptorDBAddin.0"), true, IRaptorTaskRunMode.TASKVIEWER){

                protected Void doWork() throws TaskException {
                    m_autoCommitWorking = true;
                    OracleDatabaseFactory.setDefaultAutocommit((boolean)bl);
                    Connections connections = Connections.getInstance();
                    for (String string : connections.getConnNames()) {
                        try {
                            Connection connection;
                            ConnectionTypeDetails connectionTypeDetails;
                            if (!connections.isConnectionOpen(string) || (connectionTypeDetails = ConnectionTypeDetails.getTypeDetails(string, connection = connections.getConnection(string))) == null || !connectionTypeDetails.isSupportsAutocommit()) continue;
                            int n = ((OracleConnection)connection).getDefaultRowPrefetch();
                            int n2 = DBConfig.getInstance().getInt("ARRAYFETCHSIZE");
                            if (Connections.getInstance().isOracle(string) && n != n2) {
                                ((OracleConnection)connection).setDefaultRowPrefetch(DBConfig.getInstance().getInt("ARRAYFETCHSIZE"));
                            }
                            if (connection.getAutoCommit() == bl) continue;
                            connection.setAutoCommit(bl);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    m_autoCommitWorking = false;
                    return null;
                }
            };
            raptorTask.setCancellable(false);
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        }
    }
}

