/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.editors.DbEditor;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.ConnectionDetails;
import oracle.dbtools.raptor.utils.ConnectionDisconnectListener;
import oracle.dbtools.raptor.utils.DisconnectVetoException;
import oracle.ide.Context;
import oracle.ide.cmd.CloseNodeCommand;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.javatools.util.ModelUtil;

final class ConnectionCloseCleanup
implements ConnectionDisconnectListener {
    private static IdeAction CLOSE_ACTION;
    private static ConnectionCloseCleanup INSTANCE;

    ConnectionCloseCleanup() {
    }

    private static IdeAction getConnClosedAction() {
        if (CLOSE_ACTION == null) {
            CLOSE_ACTION = IdeAction.get((int)IDBEditor.CONN_CLOSED_CMD_ID);
        }
        return CLOSE_ACTION;
    }

    public static ConnectionCloseCleanup getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConnectionCloseCleanup();
        }
        return INSTANCE;
    }

    @Override
    public void checkDisconnect(ConnectionDetails connectionDetails) throws DisconnectVetoException {
        String string = connectionDetails.getQualifiedConnectionName();
        if (!this.checkSave(string)) {
            throw new DisconnectVetoException(connectionDetails, null);
        }
    }

    @Override
    public void connectionDisconnected(ConnectionDetails connectionDetails) {
        String string = connectionDetails.getQualifiedConnectionName();
        this.closeConnection(string);
    }

    private boolean isConnectionNode(String string, Node node) {
        URL uRL;
        boolean bl = false;
        if (node != null && (uRL = node.getURL()) != null) {
            bl = ModelUtil.areEqual((Object)string, (Object)DBURLFormatHelper.getConnectionName(uRL));
        }
        return bl;
    }

    private boolean checkSave(String string) {
        Node node;
        boolean bl = true;
        URL uRL = DBURLFormatHelper.getURL("sqldev.nav", string);
        HashSet<Node> hashSet = new HashSet<Node>();
        Object object = NodeFactory.getOpenNodes();
        while (object.hasNext()) {
            node = (Node)object.next();
            if (!node.isDirty() || !this.isConnectionNode(string, node)) continue;
            hashSet.add(node);
        }
        if (hashSet.size() > 0) {
            object = new ArrayList(hashSet);
            node = IdeActions.getFileCloseAction();
            String string2 = node.getCommand();
            Command command = CommandProcessor.createCommand((String)string2, (Context)new Context());
            CloseNodeCommand closeNodeCommand = command instanceof CloseNodeCommand ? (CloseNodeCommand)command : new CloseNodeCommand();
            int n = closeNodeCommand.checkSave((List)object, true);
            if (n == 0) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Node node2 = (Node)iterator.next();
                    if (!node2.isDirty()) continue;
                    try {
                        node2.revert();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private void closeConnection(final String string) {
        URL uRL = DBURLFormatHelper.getURL("sqldev.nav", string);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                List list = EditorManager.getEditorManager().getAllEditors();
                ArrayList<Editor> arrayList = new ArrayList<Editor>();
                for (Editor editor : list) {
                    if (editor == null) continue;
                    Context context = editor.getContext();
                    if (editor instanceof DbEditor) {
                        if (!ModelUtil.areEqual((Object)((DbEditor)editor).getConnectionName(), (Object)string)) continue;
                        editor.getController().handleEvent(ConnectionCloseCleanup.getConnClosedAction(), context);
                        continue;
                    }
                    if (!ConnectionCloseCleanup.this.isConnectionNode(string, context.getNode())) continue;
                    arrayList.add(editor);
                }
                EditorManager.getEditorManager().closeEditors(arrayList);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

