/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.ide.explorer.TNode;
import oracle.ide.model.DefaultFilter;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;

public abstract class BaseRaptorFilter
extends DefaultFilter {
    protected static final Logger LOGGER = Logger.getLogger(BaseRaptorFilter.class.getName());
    protected Map<Object, TNode> _cache;

    protected BaseRaptorFilter() {
    }

    protected String getURLProtocol() {
        TNode tNode = this.getOwner();
        if (tNode == null) {
            return null;
        }
        Element element = tNode.getData();
        return BaseRaptorFilter.getURLProtocol(element);
    }

    protected static String getURLProtocol(Element element) {
        URL uRL = element instanceof Locatable ? ((Locatable)element).getURL() : null;
        return uRL != null ? uRL.getProtocol() : null;
    }

    public final synchronized void cache(TNode tNode) {
        Element element = tNode.getData();
        Object object = this.getKey(element);
        if (object != null) {
            if (this._cache == null) {
                this._cache = new HashMap<Object, TNode>();
            }
            this._cache.put(object, tNode);
        }
    }

    public final synchronized void uncache(TNode tNode) {
        Element element;
        Object object;
        if (this._cache != null && (object = this.getKey(element = tNode.getData())) != null) {
            this._cache.remove(object);
        }
    }

    public final synchronized TNode lookup(Element element) {
        Object object = this.getKey(element);
        return object != null && this._cache != null ? this._cache.get(object) : null;
    }

    protected abstract Object getKey(Object var1);

    protected synchronized void clearCache() {
        if (this._cache != null) {
            this._cache.clear();
            this._cache = null;
        }
    }
}

