/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.proformatter.treePreferences.style.profile;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.proformatter.ConfigProFormat;
import oracle.dbtools.proformatter.SQLFormatterArb;
import oracle.dbtools.proformatter.SpacingType;
import oracle.dbtools.proformatter.treePreferences.CodingStyleSQLProfile;
import oracle.dbtools.proformatter.treePreferences.NameAndDatabase;
import oracle.dbtools.proformatter.treePreferences.style.preferences.CodingStyleSQLPreferences;
import oracle.dbtools.proformatter.treePreferences.style.profile.CodingStyleSQLProfiles;
import oracle.ide.Ide;
import oracle.ide.config.DTCache;
import oracle.ide.config.Preferences;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.net.URLFactory;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.data.PropertyStorage;

public class ProfileRepository {
    private static final String DEFAULT_PROFILES_FILE = "default_sql_profiles.xml";
    public static final String DEFAULT_PROFILES_NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"default-coding-sql-style-profiles");
    public static final String DEFAULT_PROFILES_ROOT_TAG = "SQLprofiles";
    public static final String DEFAULT_PROFILE_NAME = "SQL";
    private static ProfileRepository s_instance;
    private static Object s_lock;
    private CodingStyleSQLProfiles m_profiles;
    private Map<String, CodingStyleSQLProfile> m_defaultProfileMap;

    private ProfileRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProfileRepository getProfileRepository() {
        if (s_instance == null) {
            Object object = s_lock;
            synchronized (object) {
                if (s_instance == null) {
                    s_instance = new ProfileRepository();
                }
            }
        }
        return s_instance;
    }

    public CodingStyleSQLProfile getProfile(NameAndDatabase nameAndDatabase) {
        this.loadProfiles();
        return this.m_profiles.getProfile(nameAndDatabase);
    }

    public boolean containsKey(NameAndDatabase nameAndDatabase) {
        this.loadProfiles();
        return this.m_profiles.containsKey(nameAndDatabase);
    }

    public boolean contains(NameAndDatabase nameAndDatabase) {
        this.loadProfiles();
        return this.m_profiles.containsKey(nameAndDatabase.toString());
    }

    public List<CodingStyleSQLProfile> getProfiles() {
        this.loadProfiles();
        return Collections.unmodifiableList(new ArrayList<CodingStyleSQLProfile>(this.m_profiles.getProfileMap().values()));
    }

    public void addProfile(CodingStyleSQLProfile codingStyleSQLProfile) {
        NameAndDatabase nameAndDatabase = new NameAndDatabase(codingStyleSQLProfile.getName(), codingStyleSQLProfile.getSourceSql());
        String string = nameAndDatabase.toString();
        if (this.m_profiles.containsKey(string)) {
            CodingStyleSQLProfile codingStyleSQLProfile2 = this.m_profiles.getProfile(nameAndDatabase);
            codingStyleSQLProfile.copyTo(codingStyleSQLProfile2);
        } else {
            this.m_profiles.putProfile(nameAndDatabase, codingStyleSQLProfile);
        }
    }

    public void removeProfile(CodingStyleSQLProfile codingStyleSQLProfile) {
        this.m_profiles.removeProfile(new NameAndDatabase(codingStyleSQLProfile.getName(), codingStyleSQLProfile.getSourceSql()));
    }

    public CodingStyleSQLProfile getDefaultProfileByDatabase(NameAndDatabase nameAndDatabase) {
        this.loadProfiles();
        return this.m_defaultProfileMap.get(nameAndDatabase.toString());
    }

    public CodingStyleSQLProfile getDefaultProfileByDatabase(int n) {
        return this.getDefaultProfileByDatabase(new NameAndDatabase(DEFAULT_PROFILE_NAME, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProfiles() {
        if (this.m_profiles == null) {
            Object object = s_lock;
            synchronized (object) {
                if (this.m_profiles == null) {
                    CodingStyleSQLProfiles codingStyleSQLProfiles = this.loadDefaultProfiles();
                    this.m_defaultProfileMap = codingStyleSQLProfiles.getProfileMap();
                    Preferences preferences = Preferences.getPreferences();
                    boolean bl = preferences.getProperties().containsKey("CodingStyleSQLProfiles");
                    this.m_profiles = CodingStyleSQLProfiles.getInstance((PropertyStorage)preferences);
                    DTCache dTCache = Ide.getDTCache();
                    CodingStyleSQLProfiles codingStyleSQLProfiles2 = (CodingStyleSQLProfiles)((Object)dTCache.getData("CodingStyleSQLProfiles"));
                    if (codingStyleSQLProfiles2 != null) {
                        dTCache.remove("CodingStyleSQLProfiles");
                        codingStyleSQLProfiles2.copyTo((Object)this.m_profiles);
                    } else if (!bl) {
                        codingStyleSQLProfiles.copyTo((Object)this.m_profiles);
                        this.addOldSettingsAndSetActive();
                    }
                }
            }
        }
    }

    private void addOldSettingsAndSetActive() {
        ConfigProFormat configProFormat = ConfigProFormat.getInstance();
        CodingStyleSQLProfile codingStyleSQLProfile = new CodingStyleSQLProfile();
        codingStyleSQLProfile.setName(SQLFormatterArb.getString("PREVIOUS_FORMAT_PREFERENCES"));
        codingStyleSQLProfile.setUseTab(configProFormat.isUseTabCheckboxOpt());
        int n = 0;
        if (configProFormat.getUCChoiceOpt().equals("No Change")) {
            n = 1;
        }
        if (configProFormat.getUCChoiceOpt().equals("Keywords Uppercase")) {
            n = 0;
        }
        if (configProFormat.getUCChoiceOpt().equals("Whole SQL Uppercase")) {
            n = 2;
        }
        if (configProFormat.getUCChoiceOpt().equals("Whole SQL Lowercase")) {
            n = 3;
        }
        codingStyleSQLProfile.setUppercase(n);
        int n2 = 0;
        if (configProFormat.getTargetSQLChoiceOpt().equals(DEFAULT_PROFILE_NAME)) {
            n2 = 0;
        }
        if (configProFormat.getTargetSQLChoiceOpt().equals("ASP StringBuilder")) {
            n2 = 1;
        }
        if (configProFormat.getTargetSQLChoiceOpt().equals("C# StringBuilder")) {
            n2 = 2;
        }
        if (configProFormat.getTargetSQLChoiceOpt().equals("Concatenated SQL")) {
            n2 = 3;
        }
        if (configProFormat.getTargetSQLChoiceOpt().equals("Java StringBuffer")) {
            n2 = 4;
        }
        if (configProFormat.getTargetSQLChoiceOpt().equals("Java String")) {
            n2 = 5;
        }
        if (configProFormat.getTargetSQLChoiceOpt().equals("Java String 2")) {
            n2 = 6;
        }
        if (configProFormat.getTargetSQLChoiceOpt().equals("MSSQL String")) {
            n2 = 7;
        }
        if (configProFormat.getTargetSQLChoiceOpt().equals("Pascal String")) {
            n2 = 8;
        }
        if (configProFormat.getTargetSQLChoiceOpt().equals("PHP String")) {
            n2 = 9;
        }
        if (configProFormat.getTargetSQLChoiceOpt().equals("VB String (1)")) {
            n2 = 10;
        }
        if (configProFormat.getTargetSQLChoiceOpt().equals("VB String (2)")) {
            n2 = 11;
        }
        if (configProFormat.getTargetSQLChoiceOpt().equals("VB String (3)")) {
            n2 = 12;
        }
        if (configProFormat.getTargetSQLChoiceOpt().equals("VB String (4)")) {
            n2 = 13;
        }
        if (configProFormat.getTargetSQLChoiceOpt().equals("VB StringBuilder")) {
            n2 = 14;
        }
        if (configProFormat.getTargetSQLChoiceOpt().equals("HTML code")) {
            n2 = 15;
        }
        codingStyleSQLProfile.setTargetSql(n2);
        codingStyleSQLProfile.setForceDifference(configProFormat.isForceDifferenceCheckboxOpt());
        codingStyleSQLProfile.setSuppressComment(configProFormat.isSuppressComment());
        int n3 = 0;
        if (configProFormat.getSourceSQLChoiceOpt().equals("'")) {
            n3 = 1;
        }
        codingStyleSQLProfile.setSqlSourceEnclosed(n3);
        int n4 = 1;
        if (configProFormat.getSourceSQLChoiceOpt().equals("Any SQL")) {
            n4 = 1;
        }
        if (configProFormat.getSourceSQLChoiceOpt().toLowerCase().startsWith("db2")) {
            n4 = 2;
        }
        if (configProFormat.getSourceSQLChoiceOpt().equals("Oracle")) {
            n4 = 1;
        }
        if (configProFormat.getSourceSQLChoiceOpt().equals("Microsoft Access")) {
            n4 = 4;
        }
        if (configProFormat.getSourceSQLChoiceOpt().equals("Microsoft SQL Server")) {
            n4 = 5;
        }
        if (configProFormat.getSourceSQLChoiceOpt().equals("Sybase")) {
            n4 = 3;
        }
        if (configProFormat.getSourceSQLChoiceOpt().equals("MySql")) {
            n4 = 6;
        }
        codingStyleSQLProfile.setSourceSql(n4);
        codingStyleSQLProfile.setSmallSql(configProFormat.getSmallSQLTextFieldOpt());
        codingStyleSQLProfile.setReplaceComment(configProFormat.isReplaceComment());
        int n5 = 0;
        if (configProFormat.getQuoteCharacter().equals("\"")) {
            n5 = 1;
        }
        codingStyleSQLProfile.setQuoteChar(n5);
        codingStyleSQLProfile.setNumSpaces(configProFormat.getNumSpaces());
        int n6 = 1;
        if (configProFormat.getBracketSpacing().equals((Object)SpacingType.NONE)) {
            n6 = 1;
        }
        if (configProFormat.getBracketSpacing().equals((Object)SpacingType.UNCHANGED)) {
            n6 = 0;
        }
        if (configProFormat.getBracketSpacing().equals((Object)SpacingType.AROUND)) {
            n6 = 4;
        }
        if (configProFormat.getBracketSpacing().equals((Object)SpacingType.AFTER)) {
            n6 = 2;
        }
        if (configProFormat.getBracketSpacing().equals((Object)SpacingType.BEFORE)) {
            n6 = 3;
        }
        codingStyleSQLProfile.setBracketSpacing(n6);
        codingStyleSQLProfile.setBracketSpacingAndOrWhen(configProFormat.isLinebreakSelectBracketCheckboxOpt());
        int n7 = 0;
        if (configProFormat.getCommaSpacing().equals((Object)SpacingType.UNCHANGED)) {
            n7 = 0;
        }
        if (configProFormat.getCommaSpacing().equals((Object)SpacingType.NONE)) {
            n7 = 1;
        }
        if (configProFormat.getCommaSpacing().equals((Object)SpacingType.AFTER)) {
            n7 = 3;
        }
        if (configProFormat.getCommaSpacing().equals((Object)SpacingType.BEFORE)) {
            n7 = 2;
        }
        if (configProFormat.getCommaSpacing().equals((Object)SpacingType.AROUND)) {
            n7 = 4;
        }
        codingStyleSQLProfile.setCommaSpacing(n7);
        int n8 = 2;
        if (configProFormat.getOperatorSpacing().equals((Object)SpacingType.NONE)) {
            n8 = 1;
        }
        if (configProFormat.getOperatorSpacing().equals((Object)SpacingType.SINGLE)) {
            n8 = 2;
        }
        if (configProFormat.getOperatorSpacing().equals((Object)SpacingType.UNCHANGED)) {
            n8 = 0;
        }
        codingStyleSQLProfile.setOperatorSpacing(n8);
        codingStyleSQLProfile.setLineWidth(configProFormat.getLineWidthTextFieldOpt());
        codingStyleSQLProfile.setLineNum(configProFormat.getLineWidthTextFieldOpt());
        codingStyleSQLProfile.setBreakSelectBracket(configProFormat.isLinebreakSelectBracketCheckboxOpt());
        boolean bl = false;
        if (configProFormat.getBreakSchema().equals((Object)ConfigProFormat.BreakSchemaType.ONELINE)) {
            codingStyleSQLProfile.setBreakSchema(3);
        }
        codingStyleSQLProfile.setBreakKeyword(configProFormat.isBreakKeyword());
        codingStyleSQLProfile.setBreakJoin(configProFormat.isBreakJoin());
        codingStyleSQLProfile.setBreakCaseWhen(configProFormat.isBreakCaseWhen());
        codingStyleSQLProfile.setBreakCaseThen(configProFormat.isBreakCaseThen());
        codingStyleSQLProfile.setBreakCaseElse(configProFormat.isBreakCaseElse());
        codingStyleSQLProfile.setBreakCase(configProFormat.isBreakCase());
        codingStyleSQLProfile.setBreakCaseAndOr(configProFormat.isBreakCaseAndOr());
        codingStyleSQLProfile.setBreakBeforeComment(configProFormat.isBreakBeforeLineComment());
        codingStyleSQLProfile.setBreakBeforeConcat(configProFormat.isBreakBeforeConcat());
        codingStyleSQLProfile.setBreakBeforeComma(configProFormat.isBreakBeforeComma());
        codingStyleSQLProfile.setBreakBeforeAnd(configProFormat.isBreakBeforeAnd());
        codingStyleSQLProfile.setBreakAfterConcat(configProFormat.isBreakAfterConcat());
        codingStyleSQLProfile.setBreakAfterComma(configProFormat.isBreakAfterComma());
        codingStyleSQLProfile.setBreakAfterAnd(configProFormat.isBreakAfterAnd());
        codingStyleSQLProfile.setDblIndent(configProFormat.isDoubleIndent());
        codingStyleSQLProfile.setColored(configProFormat.isColored());
        codingStyleSQLProfile.setIndentAnd(configProFormat.isIndentAndOr());
        codingStyleSQLProfile.setAlignOperator(configProFormat.isAlignOperator());
        codingStyleSQLProfile.setAlignKeyword(configProFormat.isAlignKeyword());
        codingStyleSQLProfile.setAlignEqual(configProFormat.isAlignEqual());
        codingStyleSQLProfile.setAlignDecl(configProFormat.isAlignDecl());
        codingStyleSQLProfile.setAlignConcat(configProFormat.isAlignConcat());
        codingStyleSQLProfile.setAlignComment(configProFormat.isAlignComment());
        codingStyleSQLProfile.setAlignComma(configProFormat.isAlignComma());
        codingStyleSQLProfile.setAlignAs(configProFormat.isAlignOnAs());
        codingStyleSQLProfile.setSqlsourceCopied(configProFormat.isSourceSQLCopied());
        codingStyleSQLProfile.setNumCommas(configProFormat.getNumCommas());
        codingStyleSQLProfile.setMoreNewlines(false);
        this.addProfile(codingStyleSQLProfile);
        CodingStyleSQLPreferences.getInstance((PropertyStorage)Preferences.getPreferences()).setActiveProfile(new NameAndDatabase(codingStyleSQLProfile.getName(), codingStyleSQLProfile.getSourceSql()).toString());
    }

    private CodingStyleSQLProfiles loadDefaultProfiles() {
        CodingStyleSQLProfiles codingStyleSQLProfiles = new CodingStyleSQLProfiles();
        try {
            InputStream inputStream = ProfileRepository.class.getResourceAsStream(DEFAULT_PROFILES_FILE);
            Object2Dom object2Dom = Object2Dom.newInstance();
            CodingStyleSQLProfiles codingStyleSQLProfiles2 = (CodingStyleSQLProfiles)((Object)object2Dom.toObject(inputStream, CodingStyleSQLProfiles.class));
            codingStyleSQLProfiles2.copyTo((Object)codingStyleSQLProfiles);
            inputStream.close();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return codingStyleSQLProfiles;
    }

    public static void saveDefaultProfiles(CodingStyleSQLProfiles codingStyleSQLProfiles) {
        try {
            File file = new File(DEFAULT_PROFILES_FILE);
            URL uRL = URLFactory.newFileURL((File)file);
            Object2Dom object2Dom = Object2Dom.newInstance();
            object2Dom.setNamespaceURI(DEFAULT_PROFILES_NAMESPACE_URI);
            object2Dom.toDocument((Object)codingStyleSQLProfiles, DEFAULT_PROFILES_ROOT_TAG, uRL);
        }
        catch (Exception exception) {
            Logger.getLogger("ProfileRepository").log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public static void saveProfiles(URL uRL) {
        CodingStyleSQLProfiles codingStyleSQLProfiles = CodingStyleSQLProfiles.getInstance((PropertyStorage)Preferences.getPreferences());
        try {
            Object2Dom object2Dom = Object2Dom.newInstance();
            object2Dom.setNamespaceURI(DEFAULT_PROFILES_NAMESPACE_URI);
            object2Dom.toDocument((Object)codingStyleSQLProfiles, DEFAULT_PROFILES_ROOT_TAG, uRL);
        }
        catch (Exception exception) {
            Logger.getLogger("ProfileRepository").log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public static CodingStyleSQLProfiles importProfiles(URL uRL) {
        CodingStyleSQLProfiles codingStyleSQLProfiles = null;
        try {
            InputStream inputStream = uRL.openStream();
            Object2Dom object2Dom = Object2Dom.newInstance();
            codingStyleSQLProfiles = (CodingStyleSQLProfiles)((Object)object2Dom.toObject(inputStream, CodingStyleSQLProfiles.class));
            inputStream.close();
        }
        catch (Exception exception) {
            Logger.getLogger("ProfileRepository").log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return codingStyleSQLProfiles;
    }

    static {
        s_lock = new Object();
    }
}

