/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.proformatter.treePreferences.style.preferences;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.Document;
import oracle.dbtools.proformatter.SQLFormatterArb;
import oracle.dbtools.proformatter.treePreferences.CodingStyleSQLProfile;
import oracle.dbtools.proformatter.treePreferences.treetable.CodingStyleTreeBoolean;
import oracle.dbtools.proformatter.treePreferences.treetable.CodingStyleTreeCategory;
import oracle.dbtools.proformatter.treePreferences.treetable.CodingStyleTreeCategoryBoolean;
import oracle.dbtools.proformatter.treePreferences.treetable.CodingStyleTreeItem;
import oracle.dbtools.proformatter.treePreferences.treetable.CodingStyleTreeList;
import oracle.dbtools.proformatter.treePreferences.treetable.CodingStyleTreeNumber;
import oracle.dbtools.proformatter.treePreferences.treetable.CodingStyleTreeTable;
import oracle.dbtools.proformatter.treePreferences.treetable.CodingStyleTreeTableModel;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controls.TreeTableModel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Assert;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;

public abstract class CodingStyleTreeDisplayPanel
extends DefaultTraversablePanel
implements ChangeListener,
TreeSelectionListener {
    public static final String VARNAME = "varname";
    private CodingStyleSQLProfile m_profile;
    private CodingStyleTreeTableModel m_model;
    private CodingStyleTreeTable m_treeTable;
    private static final int MAP_READ = 0;
    private static final int MAP_WRITE = 1;
    private BasicEditorPane m_editor;
    private static String[] sqlSourceEnclosed = new String[]{"\"", "'"};
    private static String[] quoteChar = new String[]{"'", "\""};
    private static String[] targetSql = new String[]{SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_SQL"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_ASP_STRINGBUILD"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_C__STRINGBUILDER"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_CONCATENATED_SQL"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_JAVA_STRINGBUFFER"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_JAVA_STRING"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_JAVA_STRING_2"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_MSSQL_STRING"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_PASCAL_STRING"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_PHP_STRING"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_VB_STRING__1_"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_VB_STRING__2_"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_VB_STRING__3_"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_VB_STRING__4_"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_VB_STRINGBUILDER")};
    private static String[] breakSchema = new String[]{SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_LARGE_SQL"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_SMALL_SQL"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_CUSTOMIZED_SQL"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_1_LINE_SQL")};
    private static String[] operatorSpacing = new String[]{SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_KEEP_UNCHANGED"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_NO_SPACES__WHERE_A_B_C"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_ONE_SPACE__WHERE_A___B___C")};
    private static String[] commaSpacing = new String[]{SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_KEEP_UNCHANGED"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_NO_SPACES__SELECT_A_B_C_"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_ONE_SPACE_BEFORE__SELECT_A__B__C__"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_ONE_SPACE_AFTER__SELECT_A__B__C_"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_ONE_SPACE_AROUND__SELECT_A___B___C__")};
    private static String[] bracketSpacing = new String[]{SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_KEEP_UNCHANGED"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_NO_SPACES__MAX_C1__"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_ONE_SPACE_INSIDE__MAX__C1___"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_ONE_SPACE_OUTSIDE__MAX__C1___"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_ONE_SPACE_AROUND__MAX___C1____")};
    private static String[] uppercase = new String[]{SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_KEYWORDS_UPPERCASE"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_NO_CHANGE"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_WHOLE_SQL_UPPERCASE"), SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_WHOLE_SQL_LOWERCASE")};

    public CodingStyleTreeDisplayPanel() {
        this.setHelpID("f1_idedidesetsqlformat_html");
        this.m_editor = EditorFactory.createIdeEditorPane();
        this.m_editor.setDocument((Document)new BasicDocument("template.plsql"));
        this.m_editor.setText(this.getSample());
        this.m_editor.installPlugin((EditorPlugin)new LineHighlightPlugin());
        LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
        this.m_editor.installPlugin((EditorPlugin)lineGutterPlugin);
        this.m_editor.setEditable(false);
        this.m_model = this.createModel();
        this.m_model.addChangeListener(this);
        this.m_treeTable = new CodingStyleTreeTable((TreeTableModel)this.m_model);
        JTree jTree = this.m_treeTable.getTree();
        this.m_model.setTree(jTree);
        jTree.addTreeSelectionListener(this);
        jTree.expandRow(0);
        jTree.setSelectionPath(jTree.getPathForRow(0));
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.m_treeTable));
        jScrollPane.setMinimumSize(new Dimension(460, 300));
        Color color = this.m_treeTable.getBackground();
        jScrollPane.setBackground(color);
        jScrollPane.getViewport().setBackground(color);
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setLeftComponent(jScrollPane);
        jSplitPane.setRightComponent(new JScrollPane((Component)this.m_editor));
        this.setLayout(new BorderLayout());
        this.add(jSplitPane, "Center");
    }

    public abstract String getSample();

    public abstract String getPlatformString();

    public abstract int getPlatformInt();

    private CodingStyleTreeTableModel createModel() {
        CodingStyleTreeTableModel codingStyleTreeTableModel = new CodingStyleTreeTableModel(null);
        CodingStyleTreeCategory codingStyleTreeCategory = new CodingStyleTreeCategory(codingStyleTreeTableModel, SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_ROOT"), "f1_idedidesetsqlformat_html", this.getSample());
        codingStyleTreeTableModel.setRoot(codingStyleTreeCategory);
        codingStyleTreeCategory.addChild(this.inputOutput(codingStyleTreeTableModel));
        codingStyleTreeCategory.addChild(this.alignment(codingStyleTreeTableModel));
        codingStyleTreeCategory.addChild(this.indentation(codingStyleTreeTableModel));
        codingStyleTreeCategory.addChild(this.linebreaks(codingStyleTreeTableModel));
        codingStyleTreeCategory.addChild(this.caseTree(codingStyleTreeTableModel));
        codingStyleTreeCategory.addChild(this.whiteSpace(codingStyleTreeTableModel));
        codingStyleTreeCategory.addChild(this.other(codingStyleTreeTableModel));
        return codingStyleTreeTableModel;
    }

    private CodingStyleTreeCategory inputOutput(CodingStyleTreeTableModel codingStyleTreeTableModel) {
        String string = this.getSample();
        CodingStyleTreeCategory codingStyleTreeCategory = new CodingStyleTreeCategory(codingStyleTreeTableModel, SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_INPUTOUTPUT"), "f1_idedidesetsqlformat_html", string);
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("sqlsourceCopied", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_SOURCE_SQL_COPIED_OUT_OF_PROGRAM_CODE"), string));
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("sqlSourceEnclosed", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_SOURCE_SQL_ENCLOSED_IN"), string, sqlSourceEnclosed));
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("targetSql", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_OUTPUT_SQL"), string, targetSql));
        return codingStyleTreeCategory;
    }

    private CodingStyleTreeCategory alignment(CodingStyleTreeTableModel codingStyleTreeTableModel) {
        String string = this.getSample();
        CodingStyleTreeCategory codingStyleTreeCategory = new CodingStyleTreeCategory(codingStyleTreeTableModel, SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_ALIGNMENT"), "f1_idedidesetsqlformat_html", string);
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("alignKeyword", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_RIGHT_ALIGN_MASTER_KEYWORDS"), string));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("alignEqual", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_ALIGN_EQUALS_SIGNS"), string));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("alignOperator", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_ALIGN_OPERATOR_SIGNS"), string));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("alignAs", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_ALIGN_AS_KEYWORD"), string));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("alignComma", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_ALIGN_ON_COMMAS"), string));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("alignComment", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_ALIGN_ON_SINGLE_LINE_COMMENTS"), string));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("alignConcat", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_ALIGN_BARBAR_AT_END_OF_LINE"), string));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("alignDecl", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_ALIGN_VARIABLE_DECLARATION"), string));
        return codingStyleTreeCategory;
    }

    private CodingStyleTreeCategory indentation(CodingStyleTreeTableModel codingStyleTreeTableModel) {
        String string = this.getSample();
        CodingStyleTreeCategory codingStyleTreeCategory = new CodingStyleTreeCategory(codingStyleTreeTableModel, SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_INDENTATION"), "f1_idedidesetsqlformat_html", string);
        codingStyleTreeCategory.addChild(new CodingStyleTreeNumber("numSpaces", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_SPACES"), string, 1, 40));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("useTab", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_USE_TABULATOR"), string));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("dblIndent", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_INDENT_MAIN_KEYWORD_X2"), string));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("indentAnd", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_INDENT_AND_OR"), string));
        return codingStyleTreeCategory;
    }

    private CodingStyleTreeCategory linebreaks(CodingStyleTreeTableModel codingStyleTreeTableModel) {
        String string = this.getSample();
        CodingStyleTreeCategory codingStyleTreeCategory = new CodingStyleTreeCategory(codingStyleTreeTableModel, SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_LINE_BREAKS"), "f1_idedidesetsqlformat_html", string);
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("breakSchema", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_SCHEMA_TYPE"), string, breakSchema));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("breakKeyword", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_AFTER_SELECT_FROM_WHERE"), string));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("breakBeforeComma", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_BEFORE_COMMA"), string));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("breakBeforeAnd", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_BEFORE_AND_OR"), string));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("breakBeforeConcat", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_BEFORE_BARBAR"), string));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("breakAfterComma", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_AFTER_COMMA"), string));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("breakAfterAnd", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_AFTER_AND_OR"), string));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("breakAfterConcat", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_AFTER_BARBAR"), string));
        codingStyleTreeCategory.addChild(new CodingStyleTreeNumber("numCommas", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_NUMBER_OF_COMMAS_PER_LINE"), string, 1, 40));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("bracketSpacingAndOrWhen", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_FOR_BRACKETS_IN"), string));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("breakSelectBracket", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_FOR_SUBSELECT_BRACKETS"), string));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("breakJoin", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_FOR_JOIN_STATEMENTS"), string));
        codingStyleTreeCategory.addChild(new CodingStyleTreeNumber("lineWidth", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_MAX_LINE_WIDTH"), string, 1, 1000));
        codingStyleTreeCategory.addChild(new CodingStyleTreeNumber("smallSql", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_THREASHOLD_FOR_SMALL_SQL"), string, 1, 1000));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("breakBeforeComment", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_FORCE_LINEBREAK"), string));
        if (this.getPlatformInt() == 1) {
            codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("moreNewlines", SQLFormatterArb.getString("MORE_NEWLINES"), string));
        }
        return codingStyleTreeCategory;
    }

    private CodingStyleTreeCategory caseTree(CodingStyleTreeTableModel codingStyleTreeTableModel) {
        String string = this.getSample();
        CodingStyleTreeCategoryBoolean codingStyleTreeCategoryBoolean = new CodingStyleTreeCategoryBoolean(codingStyleTreeTableModel, SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_CASE_LINEBREAKS"), "f1_idedidesetsqlformat_html", string);
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("breakCase", "CASE", string));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("breakCaseWhen", "WHEN", string));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("breakCaseThen", "THEN", string));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("breakCaseElse", "ELSE", string));
        codingStyleTreeCategoryBoolean.addChild(new CodingStyleTreeBoolean("breakCaseAndOr", "AND/OR", string));
        return codingStyleTreeCategoryBoolean;
    }

    private CodingStyleTreeCategory whiteSpace(CodingStyleTreeTableModel codingStyleTreeTableModel) {
        String string = this.getSample();
        CodingStyleTreeCategory codingStyleTreeCategory = new CodingStyleTreeCategory(codingStyleTreeTableModel, SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_WHITE_SPACE_2"), "f1_idedidesetsqlformat_html", string);
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("operatorSpacing", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_SPACES_AROUND_OPERATORS"), string, operatorSpacing));
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("commaSpacing", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_SPACES_AROUND_COMMAS"), string, commaSpacing));
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("bracketSpacing", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_SPACES_AROUND_BRACKETS"), string, bracketSpacing));
        return codingStyleTreeCategory;
    }

    private CodingStyleTreeCategory other(CodingStyleTreeTableModel codingStyleTreeTableModel) {
        String string = this.getSample();
        CodingStyleTreeCategory codingStyleTreeCategory = new CodingStyleTreeCategory(codingStyleTreeTableModel, SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_OTHER"), "f1_idedidesetsqlformat_html", string);
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("suppressComment", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_DELETE_COMMENT"), string));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("replaceComment", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_COMENT_INSIDE_COMMENT"), string));
        codingStyleTreeCategory.addChild(new CodingStyleTreeBoolean("forceDifference", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_FORCE_DIFFERENCE"), string));
        codingStyleTreeCategory.addChild(new CodingStyleTreeList("uppercase", SQLFormatterArb.getString("CodingStyleTreeDisplayPanel_CASE_CHANGE"), string, uppercase));
        return codingStyleTreeCategory;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.m_profile != null) {
            this.saveToProfile(this.m_profile);
        }
        this.updatePreview();
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.updatePreview();
    }

    public void updatePreview() {
        if (this.m_profile != null) {
            this.m_editor.setEditable(true);
            this.m_editor.setText(this.m_profile.format(this.getSample()));
            this.m_editor.setCaretPosition(0);
            this.m_editor.setEditable(false);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_profile = (CodingStyleSQLProfile)traversableContext.find("ProProfile");
        this.loadFromProfile(this.m_profile);
        this.updatePreview();
    }

    private void loadFromProfile(CodingStyleSQLProfile codingStyleSQLProfile) {
        CodingStyleTreeCategory codingStyleTreeCategory = (CodingStyleTreeCategory)this.m_model.getRoot();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(CodingStyleSQLProfile.class);
            Map<String, Method> map = this.createPropertyMap(beanInfo, 0);
            this.loadSettingsFromCategory(codingStyleTreeCategory, codingStyleSQLProfile, map);
        }
        catch (IntrospectionException introspectionException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, introspectionException.getStackTrace()[0].toString(), introspectionException);
        }
    }

    private void loadSettingsFromCategory(CodingStyleTreeCategory codingStyleTreeCategory, CodingStyleSQLProfile codingStyleSQLProfile, Map<String, Method> map) {
        for (int i = 0; i < codingStyleTreeCategory.getChildCount(); ++i) {
            Object object;
            Object object2;
            CodingStyleTreeItem codingStyleTreeItem = codingStyleTreeCategory.getChild(i);
            if (codingStyleTreeItem instanceof CodingStyleTreeCategory) {
                object2 = (CodingStyleTreeCategory)codingStyleTreeItem;
                this.loadSettingsFromCategory((CodingStyleTreeCategory)object2, codingStyleSQLProfile, map);
                continue;
            }
            object2 = map.get(codingStyleTreeItem.getPropertyName());
            Assert.println((object2 == null ? 1 : 0) != 0, (String)("No write method for property " + codingStyleTreeItem.getPropertyName()));
            if (object2 == null || (object = this.invokeReadMethod((Method)object2, codingStyleSQLProfile)) == null) continue;
            codingStyleTreeItem.setValue(object);
        }
    }

    private void saveSettingsToCategory(CodingStyleTreeCategory codingStyleTreeCategory, CodingStyleSQLProfile codingStyleSQLProfile, Map<String, Method> map) {
        for (int i = 0; i < codingStyleTreeCategory.getChildCount(); ++i) {
            Object object;
            CodingStyleTreeItem codingStyleTreeItem = codingStyleTreeCategory.getChild(i);
            if (codingStyleTreeItem instanceof CodingStyleTreeCategory) {
                object = (CodingStyleTreeCategory)codingStyleTreeItem;
                this.saveSettingsToCategory((CodingStyleTreeCategory)object, codingStyleSQLProfile, map);
                continue;
            }
            object = map.get(codingStyleTreeItem.getPropertyName());
            Assert.println((object == null ? 1 : 0) != 0, (String)("No write method for property " + codingStyleTreeItem.getPropertyName()));
            if (object == null) continue;
            this.invokeWriteMethod((Method)object, codingStyleSQLProfile, codingStyleTreeItem.getValue());
        }
    }

    private Object invokeMethod(Method method, Object object, Object[] objectArray) {
        try {
            return method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            Assert.println((String)"invokeMethod", (Object)exception.toString());
            Assert.println((String)(method + ":"), (Object)object);
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return null;
        }
    }

    private Object invokeReadMethod(Method method, Object object) {
        return this.invokeMethod(method, object, new Object[0]);
    }

    private Object invokeWriteMethod(Method method, Object object, Object object2) {
        return this.invokeMethod(method, object, new Object[]{object2});
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        TableCellEditor tableCellEditor = this.m_treeTable.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        this.saveToProfile(this.m_profile);
    }

    private void saveToProfile(CodingStyleSQLProfile codingStyleSQLProfile) {
        CodingStyleTreeCategory codingStyleTreeCategory = (CodingStyleTreeCategory)this.m_model.getRoot();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(CodingStyleSQLProfile.class);
            Map<String, Method> map = this.createPropertyMap(beanInfo, 1);
            this.saveSettingsToCategory(codingStyleTreeCategory, codingStyleSQLProfile, map);
        }
        catch (IntrospectionException introspectionException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, introspectionException.getStackTrace()[0].toString(), introspectionException);
        }
    }

    private Map<String, Method> createPropertyMap(BeanInfo beanInfo, int n) {
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            String string = propertyDescriptor.getName();
            Method method = n == 0 ? propertyDescriptor.getReadMethod() : propertyDescriptor.getWriteMethod();
            hashMap.put(string, method);
        }
        return hashMap;
    }
}

