/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.Substr;
import oracle.dbtools.parser.plsql.SuggestedItem;
import oracle.dbtools.raptor.insight.CompletionInsight;

public class SqlHistory {
    public static final int minSuggestions = 3;
    public static final int maxSuggestions = 20;
    public static int suggestions = 3;
    private static Map<Integer, Set<Substr>> templates = new HashMap<Integer, Set<Substr>>();
    static final SimpleDateFormat formatter = new SimpleDateFormat("M/d/yy h:mm a");

    public static List<SuggestedItem> addTemplates(Set<String> set, String string, LexerToken lexerToken, Matrix matrix, int n) {
        Collection<Object> collection;
        if (templates.size() == 0) {
            SqlHistory.initHistoryDB();
        }
        HashSet<Substr> hashSet = new HashSet<Substr>();
        Substr.listSuggestions(set, string, null, SqlHistory.getTemplates(), hashSet, suggestions);
        if (hashSet.size() < suggestions && lexerToken != null && lexerToken.type == Token.IDENTIFIER) {
            collection = CompletionInsight.predict(n, SqlEarley.getInstance(), matrix);
            Substr.listSuggestions(collection, lexerToken.content, string.toLowerCase(), SqlHistory.getTemplates(), hashSet, suggestions);
        }
        if ((collection = SuggestedItem.addSuggestions(hashSet, "HISTORY")).size() == 3 && suggestions == 3) {
            collection.add(new SuggestedItem("HISTORY", null, "..."));
        }
        return collection;
    }

    private static void initHistoryDB() {
        try {
            Class<?> clazz = Class.forName("oracle.dbtools.worksheet.sqlhistory.db.HistoryDB");
            Method method = clazz.getDeclaredMethod("getInstance", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            System.err.println("Failed to init SQL History");
        }
    }

    public static Map<Integer, Set<Substr>> getTemplates() {
        return templates;
    }

    public static void generateTemplate(String string, String string2) {
        try {
            Date date = formatter.parse(string2);
            long l = date.getTime();
            int n = SqlEarley.getInstance().sql_statements;
            Set<Substr> set = templates.get(n);
            if (set == null) {
                set = new HashSet<Substr>();
                templates.put(n, set);
            }
            set.add(new Substr(0, string.length(), string, l, null));
        }
        finally {
            return;
        }
    }
}

