/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.awt.Component;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.plsql.Messages;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Service;
import oracle.ide.Ide;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;

public class Query {
    private static final Logger logger = Logger.getLogger(Query.class.getName());
    private String connectionName;
    private StringBuffer query = new StringBuffer();
    private List<String> binds = new ArrayList<String>();
    private String nodeOwner;
    private String tablespaceName;
    private boolean isDba = false;
    private boolean isTblSpace = false;
    private static final String OBJ_LIKE_CRITERIA = " and object_name like ? ";
    private static final String DATABASE_LINK_LIKE_CRITERIA = " and db_link like ? ";
    private static final String OBJ_CRITERIA = " and object_name = ? ";
    private static final String OBJECT_TYPE_CRITERIA = " and object_type = ? ";
    private static final String OBJECT_TYPES_CRITERIA_START = " and object_type in (";
    private static final String OBJECT_TYPES_CRITERIA = " ?";
    private static final String OBJECT_TYPES_CRITERIA_NEXT = ",";
    private static final String OBJECT_TYPES_CRITERIA_END = " )";
    private static final String OWNER_CRITERIA = " and owner = ? ";
    private static final String COL_OWNER_CRITERIA = " and c.owner = ? ";
    private static final String TBLSPACE_OWNER_CRITERIA = " and obj.owner = ? ";
    private static final String OWNER_CRITERIA_MAT_VIEW_LOG = " where log_owner = ? ";
    private static final String OBJ_LIKE_CRITERIA_MAT_VIEW_LOG1 = " and master like ? ";
    private static final String OBJ_LIKE_CRITERIA_MAT_VIEW_LOG2 = " where master like ? ";
    private final String QUERY_ALL_COLUMNS = "select c.column_name name, -1 LINE, -1 COL, null USAGE, o.object_type TYPE, c.OWNER, o.object_type OBJECT_TYPE, c.table_NAME OBJECT_NAME \n from sys.all_tab_columns c, all_objects o \n where c.table_name=o.object_name and c.owner = o.owner and rownum <= " + this.limit();
    private static final String COL_LIKE_CRITERIA = " and c.column_name like ? ";
    private final String QUERY_ALL_IDENTIFIERS = "select name, LINE, COL, USAGE, TYPE, OWNER, OBJECT_TYPE, OBJECT_NAME \n from sys.all_identifiers where rownum <= " + this.limit();
    private static final String NAME_LIKE_CRITERIA = " and name like ? ";
    private static final String USAGE_CRITERIA = " and usage = ? ";
    private static final String TYPE_CRITERIA = " and type = ? ";
    private final String QUERY_ALL_SOURCE = "select text name, LINE, instr(upper(text),upper(?)) COL, null USAGE, TYPE, OWNER, type OBJECT_TYPE, name OBJECT_NAME \n from sys.all_source where rownum <= " + this.limit() + " \n" + " and upper(text) like upper(?) and name not like 'BIN$%' \n" + " and (instr(text,'--')<=0 or instr(text,'--')>instr(upper(text),upper(?))) \n" + " and (instr(text,'/*')<=0 or instr(text,'/*')>instr(upper(text),upper(?)))";
    private static final String NAME_CRITERIA = " and name = ? ";
    private final String QUERY_ALL_PROCEDURES = "select null name, -1 LINE, -1 COL, null USAGE, object_type TYPE, OWNER, object_type OBJECT_TYPE, OBJECT_NAME \n from sys.all_procedures where rownum < " + this.limit();
    private static final String PKG_NAME = " and object_name = ? ";
    private static final String PROC_NAME = " and procedure_name = ? ";
    private static final String PLSQL_OBJ_TYPES = " and object_type in ('PROCEDURE','FUNCTION','PACKAGE') ";
    boolean prepareAllIdCalled = false;
    PreparedStatement ps = null;

    public Query(String string, String string2) {
        this.connectionName = string;
        this.nodeOwner = string2;
        this.checkDbaAccess(string);
    }

    public Query(String string, String string2, String string3) {
        this.connectionName = string;
        this.nodeOwner = string2;
        this.tablespaceName = string3;
        this.isTblSpace = true;
        this.checkDbaAccess(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDbaAccess(String string) {
        String string2 = "select 1 from DBA_OBJECTS where 1=2";
        Statement statement = null;
        try {
            Connection connection = Connections.getInstance().getConnection(string);
            if (connection != null) {
                statement = connection.createStatement();
                statement.execute(string2);
            }
            this.isDba = true;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() != 942) {
                logger.severe(this.query.toString());
                logger.severe(sQLException.getMessage());
            }
        }
        catch (DBException dBException) {
            logger.severe(dBException.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public int limit() {
        return 500;
    }

    public String QUERY_ALL_OBJECTS() {
        return "select null name, -1 LINE, -1 COL, null USAGE, \ncase when obj.object_type like 'JAVA%' then 'JAVA' else obj.object_type end  TYPE, \nOWNER, case when obj.object_type like 'JAVA%' then 'JAVA' else obj.object_type end  OBJECT_TYPE, \nobj.OBJECT_NAME \n from sys." + (this.isDba ? "dba_objects" : "all_objects") + " obj where rownum <= " + this.limit() + " and obj.object_type != 'TABLE PARTITION'" + " and obj.object_type != 'TABLE SUBPARTITION'" + " and obj.object_type != 'JAVA CLASS'";
    }

    public final String QUERY_ALL_OBJECTS_TBLSPACE() {
        return "select null name, -1 LINE, -1 COL, null USAGE, \ncase when obj.object_type like 'JAVA%' then 'JAVA' else obj.object_type end  TYPE, \nobj.OWNER, case when obj.object_type like 'JAVA%' then 'JAVA' else obj.object_type end  OBJECT_TYPE, \nobj.OBJECT_NAME \n from sys." + (this.isDba ? "dba_objects" : "all_objects") + " obj, sys.dba_segments seg where rownum <= " + this.limit() + " and obj.object_type != 'TABLE PARTITION'" + " and obj.object_type != 'TABLE SUBPARTITION'" + " and obj.object_type != 'JAVA CLASS'" + " and obj.object_name = seg.segment_name" + " and obj.owner = seg.owner" + " and seg.tablespace_name = '" + this.tablespaceName + "'" + " union " + "select null name, -1 LINE, -1 COL, null USAGE, \n" + "case when obj.object_type like 'JAVA%' then 'JAVA' else obj.object_type end  TYPE, \n" + "obj.OWNER, " + "case when obj.object_type like 'JAVA%' then 'JAVA' else obj.object_type end  OBJECT_TYPE, \n" + "obj.OBJECT_NAME \n" + " from sys." + (this.isDba ? "dba_objects" : "all_objects") + " obj, sys.dba_segments seg where rownum <= " + this.limit() + " and obj.object_type != 'TABLE PARTITION'" + " and obj.object_type != 'TABLE SUBPARTITION'" + " and obj.object_type != 'JAVA CLASS'" + " and obj.owner = seg.owner" + " and NOT obj.object_type in (select distinct segment_type from sys.dba_segments where tablespace_name = '" + this.tablespaceName + "')";
    }

    public final String QUERY_MAT_VIEW_LOG_OBJECTS() {
        return "select null name, -1 LINE, -1 COL, null USAGE, \n 'MATERIALIZED VIEW LOG' TYPE, log_owner OWNER, \n 'MATERIALIZED VIEW LOG' OBJECT_TYPE, master OBJECT_NAME \n from all_snapshot_logs";
    }

    public final String QUERY_DATABASE_LINK() {
        return "select null name, -1 LINE, -1 COL, null USAGE, \n 'DATABASE LINK' TYPE, owner OWNER, \n 'DATABASE LINK' OBJECT_TYPE, db_link OBJECT_NAME \n from all_db_links where rownum <= " + this.limit();
    }

    public void prepareAllObjects(String string, String string2) {
        String string3;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        String string4 = string3 = !this.isTblSpace ? this.QUERY_ALL_OBJECTS() : this.QUERY_ALL_OBJECTS_TBLSPACE();
        if (string != null && !"".equals(string) && string.indexOf(46) > 0) {
            String string5 = string.substring(0, string.indexOf(46));
            string = string.substring(string.indexOf(46) + 1);
            string3 = string3 + (!this.isTblSpace ? OWNER_CRITERIA : TBLSPACE_OWNER_CRITERIA);
            this.binds.add(string5.toUpperCase());
        }
        if (string != null && !"".equals(string)) {
            string3 = string3 + OBJ_LIKE_CRITERIA;
            this.binds.add(this.conditionalUpperCase(string));
        }
        if (!(string2 == null || "ALL".equals(string2) || "ALL OBJECTS".equals(string2) || "".equals(string2))) {
            string3 = string3 + OBJECT_TYPE_CRITERIA;
            this.binds.add(string2.toUpperCase());
        }
        this.query.append(string3);
    }

    private String conditionalUpperCase(String string) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (i == 0 && c == '\"') {
                if (string.endsWith("%")) {
                    return string.substring(1, string.length() - 2) + "%";
                }
                return string.substring(1, string.length() - 1);
            }
            if ('A' <= c && c <= 'Z') {
                bl2 = true;
            }
            if ('a' <= c && c <= 'z') {
                bl3 = true;
            }
            if (!bl2 || !bl3) continue;
            bl = true;
            break;
        }
        return bl ? string : string.toUpperCase();
    }

    public void prepareAllObjects(String string, String string2, String string3) {
        String string4;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        String string5 = string4 = !this.isTblSpace ? this.QUERY_ALL_OBJECTS() : this.QUERY_ALL_OBJECTS_TBLSPACE();
        if (string != null && !"".equals(string)) {
            string4 = string4 + OBJ_LIKE_CRITERIA;
            this.binds.add(this.conditionalUpperCase(string));
        }
        if (!(string2 == null || "ALL".equals(string2) || "ALL OBJECTS".equals(string2) || "".equals(string2))) {
            string4 = string4 + OBJECT_TYPE_CRITERIA;
            this.binds.add(string2.toUpperCase());
        }
        if (string3 != null && !"".equals(string3)) {
            string4 = string4 + (!this.isTblSpace ? OWNER_CRITERIA : TBLSPACE_OWNER_CRITERIA);
            this.binds.add(string3.toUpperCase());
        }
        this.query.append(string4);
    }

    public void prepareAllObjects(String string, String[] stringArray, String string2) {
        String string3;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        String string4 = string3 = !this.isTblSpace ? this.QUERY_ALL_OBJECTS() : this.QUERY_ALL_OBJECTS_TBLSPACE();
        if (string != null && !"".equals(string)) {
            string3 = string3 + OBJ_LIKE_CRITERIA;
            arrayList.add(this.conditionalUpperCase(string));
        }
        if (!(stringArray == null || stringArray.length <= 0 || "ALL".equals(stringArray[0]) || "ALL OBJECTS".equals(stringArray[0]) || "".equals(stringArray[0]))) {
            string3 = string3 + OBJECT_TYPES_CRITERIA_START;
            Object object = "";
            bl = false;
            bl2 = false;
            bl3 = false;
            for (String string5 : stringArray) {
                string3 = string3 + (String)object + OBJECT_TYPES_CRITERIA;
                arrayList.add(string5.toUpperCase());
                object = OBJECT_TYPES_CRITERIA_NEXT;
                if (string5.equals("MATERIALIZED VIEW LOG")) {
                    bl = true;
                } else {
                    bl3 = true;
                }
                if (!string5.equals("DATABASE LINK")) continue;
                bl2 = true;
            }
            string3 = string3 + OBJECT_TYPES_CRITERIA_END;
        }
        if (string2 != null && !"".equals(string2)) {
            string3 = string3 + (!this.isTblSpace ? OWNER_CRITERIA : TBLSPACE_OWNER_CRITERIA);
            arrayList.add(this.conditionalUpperCase(string2));
        }
        if (bl3) {
            for (String string6 : arrayList) {
                this.binds.add(string6);
            }
        } else {
            string3 = "";
        }
        if (bl) {
            if (bl3) {
                string3 = string3 + "\n union all \n";
            }
            string3 = string3 + this.QUERY_MAT_VIEW_LOG_OBJECTS();
            if (string2 != null && !"".equals(string2)) {
                string3 = string3 + OWNER_CRITERIA_MAT_VIEW_LOG;
                this.binds.add(string2.toUpperCase());
                if (string != null && !"".equals(string)) {
                    string3 = string3 + OBJ_LIKE_CRITERIA_MAT_VIEW_LOG1;
                    this.binds.add(string.toUpperCase());
                }
            } else if (string != null && !"".equals(string)) {
                string3 = string3 + OBJ_LIKE_CRITERIA_MAT_VIEW_LOG2;
                this.binds.add(string.toUpperCase());
            }
        }
        if (bl2) {
            if (bl3) {
                string3 = string3 + "\n union \n";
            }
            string3 = string3 + this.QUERY_DATABASE_LINK();
            if (string2 != null && !"".equals(string2)) {
                string3 = string3 + OWNER_CRITERIA;
                this.binds.add(string2.toUpperCase());
                if (string != null && !"".equals(string)) {
                    string3 = string3 + DATABASE_LINK_LIKE_CRITERIA;
                    this.binds.add(string.toUpperCase());
                }
            } else if (string != null && !"".equals(string)) {
                string3 = string3 + DATABASE_LINK_LIKE_CRITERIA;
                this.binds.add(string.toUpperCase());
            }
        }
        this.query.append(string3);
    }

    public void prepareObject(String string, String string2, String string3) {
        String string4;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        String string5 = string4 = !this.isTblSpace ? this.QUERY_ALL_OBJECTS() : this.QUERY_ALL_OBJECTS_TBLSPACE();
        if (string != null && !"".equals(string)) {
            string4 = string4 + " and object_name = ? ";
            this.binds.add(this.conditionalUpperCase(string));
        }
        if (string2 != null && !"ALL".equals(string2) && !"".equals(string2)) {
            string4 = string4 + OBJECT_TYPE_CRITERIA;
            this.binds.add(string2.toUpperCase());
        }
        if (string3 != null && !"".equals(string3)) {
            string4 = string4 + (!this.isTblSpace ? OWNER_CRITERIA : TBLSPACE_OWNER_CRITERIA);
            this.binds.add(this.conditionalUpperCase(string3));
        }
        this.query.append(string4);
    }

    public void prepareProcedure(String string, String string2) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        String string3 = this.QUERY_ALL_OBJECTS();
        if (string2 != null && !"".equals(string2)) {
            string3 = string3 + " and object_name = ? ";
            this.binds.add(this.conditionalUpperCase(string2));
        }
        string3 = string3 + PLSQL_OBJ_TYPES;
        if (string != null && !"".equals(string)) {
            string3 = string3 + OWNER_CRITERIA;
            this.binds.add(this.conditionalUpperCase(string));
        }
        this.query.append(string3);
        this.query.append("\n union all \n");
        string3 = this.QUERY_ALL_PROCEDURES;
        if (string2 != null && !"".equals(string2)) {
            string3 = string3 + PROC_NAME;
            this.binds.add(this.conditionalUpperCase(string2));
        }
        if (string != null && !"".equals(string)) {
            string3 = string3 + " and object_name = ? ";
            this.binds.add(this.conditionalUpperCase(string));
        }
        this.query.append(string3);
    }

    public void prepareAllColumns(String string, String string2) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        String string3 = this.QUERY_ALL_COLUMNS;
        if (string != null && !"".equals(string)) {
            string3 = string3 + COL_LIKE_CRITERIA;
            this.binds.add(this.conditionalUpperCase(string));
        }
        if (string2 != null && !"".equals(string2)) {
            string3 = string3 + COL_OWNER_CRITERIA;
            this.binds.add(this.conditionalUpperCase(string2));
        }
        this.query.append(string3);
    }

    public void prepareDatabaseLink(String string) {
        if (this.query.length() > 0) {
            this.query.append("\n union \n");
        }
        String string2 = this.QUERY_DATABASE_LINK();
        if (string != null && !"".equals(string)) {
            string2 = string2 + DATABASE_LINK_LIKE_CRITERIA;
            this.binds.add(string);
        }
        this.query.append(string2);
    }

    public void prepareAllIdentifiers(String string, String string2, String string3) {
        if (this.prepareAllIdCalled) {
            return;
        }
        this.prepareAllIdCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        String string4 = this.QUERY_ALL_IDENTIFIERS;
        if (string != null && !"".equals(string)) {
            if (string.indexOf(46) > 0) {
                String string5 = string.substring(0, string.indexOf(46));
                string = string.substring(string.indexOf(46) + 1);
                string4 = string4 + " and object_name = ? ";
                this.binds.add(this.conditionalUpperCase(string5));
            }
            string4 = string4 + NAME_LIKE_CRITERIA;
            this.binds.add(this.conditionalUpperCase(string));
        }
        if (string2 != null && !"ALL".equals(string2) && !"".equals(string2)) {
            string4 = string4 + TYPE_CRITERIA;
            this.binds.add(string2);
        }
        if (string3 != null && !"ALL".equals(string3) && !"".equals(string3)) {
            string4 = string4 + USAGE_CRITERIA;
            this.binds.add(string3);
        }
        this.query.append(string4);
    }

    public void prepareAllSource(String string, String string2) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.QUERY_ALL_SOURCE);
        this.binds.add(string2);
        this.binds.add("%" + string2 + "%");
        this.binds.add(string2);
        this.binds.add(string2);
        if (string != null && !"".equals(string)) {
            this.query.append(OWNER_CRITERIA);
            this.binds.add(this.conditionalUpperCase(string));
        }
    }

    public void prepareAllSource(String string, String string2, String string3) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append("select * from (" + this.QUERY_ALL_SOURCE);
        this.query.append("\n and type like 'PACKAGE%'");
        this.query.append(NAME_CRITERIA);
        this.query.append("\n) where col = 1 or substr(name/*text*/,col-1,1)=' '");
        this.query.append("\n order by type, line");
        this.binds.add(string3);
        this.binds.add("%" + string3 + "%");
        this.binds.add(string3);
        this.binds.add(string3);
        this.binds.add(string2.toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<URL> fetch(String string) {
        long l = System.currentTimeMillis();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        ResultSet resultSet = null;
        try {
            Connection connection = DBUtil.getConnectionResolver().getConnection(this.connectionName);
            this.ps = connection.prepareStatement("select * from ( \n" + this.query.toString() + "\n ) where rownum <= " + this.limit() + "\n order by name, CASE WHEN USAGE = 'DECLARATION' OR " + "USAGE = 'DEFINITION' THEN 0 ELSE 1 END, usage, type, owner, object_name, line, col");
            for (int i = 1; i <= this.binds.size(); ++i) {
                this.ps.setObject(i, this.binds.get(i - 1));
            }
            resultSet = this.ps.executeQuery();
            while (resultSet.next()) {
                String string2;
                if (resultSet.getRow() >= this.limit()) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)MessageFormat.format(Messages.getString("Query.0"), this.limit()), (String)Messages.getString("Query.1"), null);
                }
                URL uRL = null;
                int n = resultSet.getInt("LINE");
                if (n >= 0) {
                    int n2 = resultSet.getInt("COL");
                    string2 = resultSet.getString("USAGE");
                    String string3 = resultSet.getString("TYPE");
                    String string4 = resultSet.getString("NAME");
                    if (n2 <= 0) {
                        n2 = string4.toUpperCase().indexOf(string.toUpperCase()) + 1;
                    }
                    String string5 = Service.into2chars((String)("" + Service.pair((int)n, (int)n2) + OBJECT_TYPES_CRITERIA_NEXT + string2 + OBJECT_TYPES_CRITERIA_NEXT + string3 + OBJECT_TYPES_CRITERIA_NEXT + string4 + '\uffff' + string));
                    uRL = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", this.connectionName, string5, resultSet.getString("OWNER"), resultSet.getString("OBJECT_TYPE")), resultSet.getString("OBJECT_NAME"));
                } else {
                    String string6 = resultSet.getString("OBJECT_NAME");
                    string2 = resultSet.getString("NAME");
                    if (string2 != null) {
                        string6 = string6 + "." + string2;
                    }
                    uRL = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", this.connectionName, null, resultSet.getString("OWNER"), resultSet.getString("OBJECT_TYPE")), string6);
                }
                if (uRL == null) continue;
                arrayList.add(uRL);
            }
        }
        catch (DBException dBException) {
            logger.severe(this.query.toString());
            logger.severe(dBException.getMessage());
        }
        catch (SQLException sQLException) {
            logger.severe(this.query.toString());
            logger.severe(sQLException.getMessage());
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (this.ps != null) {
                try {
                    this.ps.close();
                }
                catch (SQLException sQLException) {}
            }
            this.ps = null;
        }
        long l2 = System.currentTimeMillis();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL fetch() {
        long l = System.currentTimeMillis();
        ResultSet resultSet = null;
        try {
            Connection connection = DBUtil.getConnectionResolver().getConnection(this.connectionName);
            this.ps = connection.prepareStatement(this.query.toString());
            for (int i = 1; i <= this.binds.size(); ++i) {
                this.ps.setObject(i, this.binds.get(i - 1));
            }
            resultSet = this.ps.executeQuery();
            URL uRL = null;
            while (resultSet.next()) {
                String string;
                int n = resultSet.getInt("LINE");
                String string2 = resultSet.getString("OWNER");
                if (n >= 0) {
                    int n2 = resultSet.getInt("COL");
                    string = resultSet.getString("USAGE");
                    String string3 = resultSet.getString("TYPE");
                    String string4 = resultSet.getString("NAME");
                    String string5 = Service.into2chars((String)("" + Service.pair((int)n, (int)n2) + OBJECT_TYPES_CRITERIA_NEXT + string + OBJECT_TYPES_CRITERIA_NEXT + string3 + OBJECT_TYPES_CRITERIA_NEXT + string4));
                    if (uRL == null || string2.equalsIgnoreCase(this.nodeOwner)) {
                        URL uRL2 = DBURLFormatHelper.getURL("sqldev.nav", this.connectionName, string5, string2, resultSet.getString("OBJECT_TYPE"));
                        uRL = DBURLFormatHelper.getURL(uRL2, resultSet.getString("OBJECT_NAME"));
                    }
                } else {
                    String string6 = resultSet.getString("OBJECT_NAME");
                    string = resultSet.getString("NAME");
                    if (string != null) {
                        string6 = string6 + "." + string;
                    }
                    if (uRL == null || string2.equalsIgnoreCase(this.nodeOwner)) {
                        uRL = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", this.connectionName, null, string2, resultSet.getString("OBJECT_TYPE")), string6);
                    }
                }
                if (!string2.equalsIgnoreCase(this.nodeOwner)) continue;
                break;
            }
            URL uRL3 = uRL;
            return uRL3;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 17011) {
                URL uRL = null;
                return uRL;
            }
            logger.severe(this.query.toString());
            logger.severe(sQLException.getMessage());
        }
        catch (DBException dBException) {
            logger.severe(this.query.toString());
            logger.severe(dBException.getMessage());
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (this.ps != null) {
                try {
                    this.ps.close();
                }
                catch (SQLException sQLException) {}
            }
            this.ps = null;
            long l2 = System.currentTimeMillis();
            if (l + 5000L < l2) {
                System.out.println(this.query.toString());
            }
        }
        return null;
    }

    public void cancel() {
        if (this.ps != null) {
            try {
                this.ps.cancel();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Class.forName("oracle.jdbc.OracleDriver");
        Connection connection = DriverManager.getConnection("jdbc:oracle:thin:@localhost:1521:xe", "hr", "hr");
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT CURSOR(select 1 from dual)FROM dual", 1004, 1007);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        Object object = resultSet.getObject(1);
        ResultSet resultSet2 = (ResultSet)object;
        resultSet2.next();
        System.out.println(resultSet2.getObject(1));
    }
}

