/*
 * Decompiled with CFR 0.152.
 */
package com.sun.el.parser;

import com.sun.el.lang.EvaluationContext;
import com.sun.el.parser.ELParserTreeConstants;
import com.sun.el.parser.SimpleNode;
import com.sun.el.util.MessageFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.el.ELException;
import javax.el.FunctionMapper;

public final class AstFunction
extends SimpleNode {
    protected String localName = "";
    protected String prefix = "";

    public AstFunction(int n) {
        super(n);
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getOutputName() {
        if (this.prefix == null) {
            return this.localName;
        }
        return this.prefix + ":" + this.localName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Class getType(EvaluationContext evaluationContext) throws ELException {
        FunctionMapper functionMapper = evaluationContext.getFunctionMapper();
        if (functionMapper == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.null"));
        }
        Method method = functionMapper.resolveFunction(this.prefix, this.localName);
        if (method == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.method", this.getOutputName()));
        }
        return method.getReturnType();
    }

    public Object getValue(EvaluationContext evaluationContext) throws ELException {
        FunctionMapper functionMapper = evaluationContext.getFunctionMapper();
        if (functionMapper == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.null"));
        }
        Method method = functionMapper.resolveFunction(this.prefix, this.localName);
        if (method == null) {
            throw new ELException(MessageFactory.get("error.fnMapper.method", this.getOutputName()));
        }
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray = null;
        Object object = null;
        int n = this.jjtGetNumChildren();
        if (n > 0) {
            objectArray = new Object[n];
            try {
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = this.children[i].getValue(evaluationContext);
                    objectArray[i] = AstFunction.coerceToType(objectArray[i], classArray[i]);
                }
            }
            catch (ELException eLException) {
                throw new ELException(MessageFactory.get("error.function", this.getOutputName()), (Throwable)eLException);
            }
        }
        try {
            object = method.invoke(null, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ELException(MessageFactory.get("error.function", this.getOutputName()), (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ELException(MessageFactory.get("error.function", this.getOutputName()), invocationTargetException.getCause());
        }
        return object;
    }

    public void setLocalName(String string) {
        this.localName = string;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public String toString() {
        return ELParserTreeConstants.jjtNodeName[this.id] + "[" + this.getOutputName() + "]";
    }
}

