/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.diffmerge.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import oracle.ide.diffmerge.DiffMergeArguments;
import oracle.ide.diffmerge.DiffMergeResource;
import oracle.ide.diffmerge.view.ResourceTextNode;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.algorithm.directory.DirectoryFile;
import oracle.javatools.compare.algorithm.directory.DirectoryList;

public class ResourceDirectoryNode
extends ResourceTextNode {
    private DirectoryList _directoryList;
    private final Observer _directoryListObserver = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            ResourceDirectoryNode.this.markDirty(((DirectoryList)o).isModified());
        }
    };

    public ResourceDirectoryNode(DiffMergeResource resource) {
        this(null, resource);
    }

    public ResourceDirectoryNode(DiffMergeArguments arguments, DiffMergeResource resource) {
        super(arguments, resource);
        if (!resource.isDirectory()) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void markDirty(boolean dirty) {
        super.markDirty(dirty);
        if (dirty) {
            return;
        }
        if (this._directoryList != null) {
            this._directoryList.clearModified();
            this._directoryList.notifyObservers();
        }
    }

    @Override
    public boolean isDirty() {
        if (super.isDirty()) {
            return true;
        }
        return this._directoryList != null && this._directoryList.isModified();
    }

    @Override
    protected void openImpl() throws IOException {
        super.openImpl();
    }

    @Override
    protected void closeImpl() throws IOException {
        super.closeImpl();
        this._directoryList.deleteObserver(this._directoryListObserver);
        this._directoryList = null;
    }

    @Override
    protected void setUpReadOnly(TextBuffer textBuffer) {
        textBuffer.setReadOnly(!this.getResource().canModify());
    }

    @Override
    protected void loadTextBufferData(TextBuffer textBuffer) throws IOException {
        this._directoryList = this.createDirectoryList(this.getResource());
        for (int i = 0; i < this._directoryList.getSize(); ++i) {
            textBuffer.append((char[])this._directoryList.getFile(i).getData());
        }
        this._directoryList.addObserver(this._directoryListObserver);
    }

    private DirectoryList createDirectoryList(DiffMergeResource resource) throws IOException {
        DiffMergeResource[] resources;
        DirectoryList directoryList = new DirectoryList();
        for (DiffMergeResource resource0 : resources = resource.listResources()) {
            DirectoryFileAdapter directoryFile = new DirectoryFileAdapter(resource0);
            directoryFile.setCanRead(resource0.canRead());
            directoryFile.setCanWrite(resource0.canWrite());
            directoryList.appendFile((DirectoryFile)directoryFile);
        }
        return directoryList;
    }

    @Override
    protected void saveImpl(DiffMergeResource resource) throws IOException {
        ArrayList<DiffMergeResource> resources = new ArrayList<DiffMergeResource>();
        for (int i = 0; i < this._directoryList.getSize(); ++i) {
            resources.add(((DirectoryFileAdapter)this._directoryList.getFile(i)).getResource());
        }
        resource.setResources(resources.toArray(new DiffMergeResource[0]));
    }

    public DirectoryList getDirectoryList() {
        return this._directoryList;
    }

    @Override
    protected void attachTextBufferListener(TextBuffer textBuffer) {
    }

    @Override
    protected void detachTextBufferListener(TextBuffer textBuffer) {
    }

    private class DirectoryFileAdapter
    extends DirectoryFile {
        private final DiffMergeResource _resource;

        DirectoryFileAdapter(DiffMergeResource resource) {
            super(resource.isDirectory(), resource.getName(), resource.getID());
            this._resource = resource;
        }

        DiffMergeResource getResource() {
            return this._resource;
        }
    }
}

