/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.diffmerge.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.UndoableEdit;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.diffmerge.DiffMergeActions;
import oracle.ide.diffmerge.DiffMergeArguments;
import oracle.ide.diffmerge.DiffMergeConstants;
import oracle.ide.diffmerge.DiffMergeController;
import oracle.ide.diffmerge.DiffMergeNode;
import oracle.ide.diffmerge.DiffMergeResource;
import oracle.ide.diffmerge.impl.LocalActionCache;
import oracle.ide.diffmerge.model.FileResource;
import oracle.ide.diffmerge.res.ResourceUtil;
import oracle.ide.diffmerge.view.ResourceDecorator;
import oracle.ide.diffmerge.view.ResourceDirectoryNode;
import oracle.ide.diffmerge.view.ResourceTextNode;
import oracle.ide.diffmerge.view.UndoableEditCommand;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareDifference;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareMode;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareModelFactory;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.CompareViewFactory;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.EditableContributor;
import oracle.javatools.compare.algorithm.directory.DirectoryCompareContributor;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareContributor;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.compare.view.BaseCompareView;
import oracle.javatools.compare.view.ComparePopupManager;
import oracle.javatools.compare.view.CompareToolTipProvider;
import oracle.javatools.compare.view.EditorPaneView;
import oracle.javatools.compare.view.ViewEditEvent;
import oracle.javatools.compare.view.ViewEditListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.FindHighlightPlugin;
import oracle.javatools.patch.PatchCompareView;

public class DiffMergeView
implements ViewEditListener {
    private final LocalActionCache _localActionCache;
    private Context _context;
    private MainPanel _panel;
    private CompareContributor _contributorS;
    private CompareContributor _contributorT;
    private CompareContributor _contributorA;
    private CompareView _compareView;
    private JLabel _statusLabel;
    private Highlighter _highlighter;
    private NodeListener _nodeListener;
    private static final String OPEN_RESULT_NODE = "ToolView.OPEN_RESULT_NODE";
    private static final String SOURCE_FILE_PATH = "DiffMergeView.SOURCE_FILE_PATH";
    private static final String TARGET_FILE_PATH = "DiffMergeView.TARGET_FILE_PATH";
    private static final String ANCESTOR_FILE_PATH = "DiffMergeView.ANCESTOR_FILE_PATH";
    private static final String CONFLICTS_FILE_PATH = "DiffMergeView.CONFLICTS_FILE_PATH";

    public DiffMergeView(LocalActionCache localActionCache) {
        this._localActionCache = localActionCache;
    }

    public void menuWillShow(ContextMenu popupMenu) {
        float section = 1.0f;
        if (this._compareView instanceof BaseCompareView) {
            Action[] editActions = ((BaseCompareView)this._compareView).getEditActions();
            for (int i = 0; editActions != null && i < editActions.length; ++i) {
                if (editActions[i] == null) {
                    section += 1.0f;
                    continue;
                }
                popupMenu.add((Component)new JMenuItem(editActions[i]), section);
            }
            section += 1.0f;
        }
        popupMenu.add((Component)this.createLocalMenuItem(17), section);
        popupMenu.add((Component)this.createLocalMenuItem(18), section);
        popupMenu.add((Component)this.createLocalMenuItem(19), section);
        popupMenu.add((Component)this.createLocalMenuItem(22), section);
        popupMenu.add((Component)this.createLocalMenuItem(DiffMergeConstants.NAVIGATE_FIRST_DIFFERENCE_CMD_ID), section += 1.0f);
        popupMenu.add((Component)this.createLocalMenuItem(DiffMergeConstants.NAVIGATE_PREVIOUS_DIFFERENCE_CMD_ID), section);
        popupMenu.add((Component)this.createLocalMenuItem(DiffMergeConstants.NAVIGATE_NEXT_DIFFERENCE_CMD_ID), section);
        popupMenu.add((Component)this.createLocalMenuItem(DiffMergeConstants.NAVIGATE_LAST_DIFFERENCE_CMD_ID), section);
    }

    public void updateEditorContextualActions() {
        this.updateAction(17);
        this.updateAction(18);
        this.updateAction(19);
        this.updateAction(20);
        this.updateAction(24);
        this.updateAction(DiffMergeConstants.SEARCH_HIGHLIGHT_CMD_ID);
        this.updateAction(DiffMergeConstants.SEARCH_CLEAR_HIGHLIGHTS_CMD_ID);
        this.updateAction(DiffMergeConstants.NAVIGATE_FIRST_DIFFERENCE_CMD_ID);
        this.updateAction(DiffMergeConstants.NAVIGATE_PREVIOUS_DIFFERENCE_CMD_ID);
        this.updateAction(DiffMergeConstants.NAVIGATE_NEXT_DIFFERENCE_CMD_ID);
        this.updateAction(DiffMergeConstants.NAVIGATE_LAST_DIFFERENCE_CMD_ID);
    }

    public void setContext(Context context) {
        this._context = context;
    }

    public Context getContext() {
        return this._context;
    }

    public final JComponent getGUI() {
        return this.getPanel();
    }

    private MainPanel getPanel() {
        if (this._panel == null) {
            this._panel = new MainPanel();
        }
        return this._panel;
    }

    public final void updateActions() {
        IdeAction[] actions;
        for (IdeAction action : actions = DiffMergeActions.getActions()) {
            action.updateAction();
        }
        for (IdeAction action : actions = this._localActionCache.getCachedActions()) {
            action.updateAction();
        }
    }

    public final void updateAction(int id) {
        IdeAction action = DiffMergeActions.getAction(id);
        if (action != null) {
            action.updateAction();
        }
        if ((action = this._localActionCache.findLocalAction(id)) != null) {
            action.updateAction();
        }
    }

    protected final AbstractButton createToolButton(int id) {
        IdeAction action = this._localActionCache.getLocalAction(id);
        ToolButton toolButton = !action.isToggle() ? new ToolButton((Action)action) : new ToggleToolButton((ToggleAction)action);
        toolButton.setMargin(new Insets(0, 0, 0, 0));
        return toolButton;
    }

    protected final String getResourceString(String name) {
        return ResourceUtil.getResourceBundle().getString(name);
    }

    protected final ImageIcon getResourceIcon(String name) {
        return ResourceUtil.getResourceIcon(name);
    }

    protected final JMenu createMenu(String name) {
        JMenu menu = new JMenu(StringUtils.stripMnemonic((String)name));
        int mnemonic = StringUtils.getMnemonicKeyCode((String)name);
        if (mnemonic != 0) {
            menu.setMnemonic((char)mnemonic);
        }
        return menu;
    }

    protected final JMenuItem createLocalMenuItem(int id) {
        return Ide.getMenubar().createMenuItem((ToggleAction)this._localActionCache.getLocalAction(id));
    }

    protected final JMenuItem createMenuItem(int id) {
        return Ide.getMenubar().createMenuItem((ToggleAction)DiffMergeActions.getAction(id));
    }

    public void open() {
        try {
            this.getNode().open();
        }
        catch (IOException ioe) {
            ExceptionDialog.showExceptionDialog((Component)this.getGUI(), (Throwable)ioe, (String)this.getResourceString("IO_ERROR_TITLE"), null, null);
            return;
        }
        this.openImpl();
        if (this._nodeListener == null) {
            this._nodeListener = new NodeListener(){

                public void nodeDirtyStateChanged(NodeEvent e, boolean isNowDirty) {
                    DiffMergeView.this.updateAction(9);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DiffMergeView.this.updateAction(9);
                        }
                    });
                }

                public void nodeOpened(NodeEvent ne) {
                    DiffMergeView.this.updateActions();
                }

                public void nodeClosed(NodeEvent ne) {
                    DiffMergeView.this.updateActions();
                }

                public void nodeSaved(NodeEvent ne) {
                    DiffMergeView.this.updateAction(9);
                }

                public void nodeReverted(NodeEvent ne) {
                    DiffMergeView.this.updateActions();
                }
            };
        }
        this._context.getNode().addNodeListener(this._nodeListener);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DiffMergeView.this.updateActions();
            }
        });
    }

    public void close() {
        this._context.getNode().removeNodeListener(this._nodeListener);
        this._nodeListener = null;
        this.closeImpl();
        try {
            this.getNode().close();
        }
        catch (IOException ioe) {
            ExceptionDialog.showExceptionDialog((Component)this.getGUI(), (Throwable)ioe, (String)this.getResourceString("IO_ERROR_TITLE"), null, null);
            return;
        }
    }

    public void revert() {
        this.closeImpl();
        this.openImpl();
        this.getPanel().redraw();
    }

    protected void setOpenResultNode(Node node) {
        this._context.setProperty(OPEN_RESULT_NODE, (Object)node);
    }

    protected Node getOpenResultNode() {
        return (Node)this._context.getProperty(OPEN_RESULT_NODE);
    }

    protected void removeOpenResultNode() {
        this._context.removeProperty(OPEN_RESULT_NODE);
    }

    protected int getExitCode() {
        DiffMergeNode node = this.getNode();
        DiffMergeArguments arguments = node != null ? node.getArguments() : null;
        return arguments == null || !arguments.isMergeTask() || node.isSaved() ? 0 : -1;
    }

    private DiffMergeNode getNode() {
        return (DiffMergeNode)((Object)this.getContext().getProperty("DiffMergeEditor.NODE"));
    }

    public CompareView getCompareView() {
        return this._compareView;
    }

    public void initializeFromNode() {
        DiffMergeNode node = this.getNode();
        DiffMergeArguments arguments = node != null ? node.getArguments() : null;
        this._localActionCache.getLocalAction(DiffMergeConstants.VIEW_IGNORE_WHITESPACE_CMD_ID).setState(arguments == null || arguments.isIgnoreWhitespace());
    }

    public String getSourceFilePath() {
        return (String)this.getContext().getProperty(SOURCE_FILE_PATH);
    }

    public void setSourceFilePath(String source) {
        this.getContext().setProperty(SOURCE_FILE_PATH, (Object)source);
    }

    public String getTargetFilePath() {
        return (String)this.getContext().getProperty(TARGET_FILE_PATH);
    }

    public void setTargetFilePath(String target) {
        this.getContext().setProperty(TARGET_FILE_PATH, (Object)target);
    }

    public String getAncestorFilePath() {
        return (String)this.getContext().getProperty(ANCESTOR_FILE_PATH);
    }

    public void setAncestorFilePath(String ancestor) {
        this.getContext().setProperty(ANCESTOR_FILE_PATH, (Object)ancestor);
    }

    public String getConflictsFilePath() {
        return (String)this.getContext().getProperty(CONFLICTS_FILE_PATH);
    }

    public void setConflictsFilePath(String conflicts) {
        this.getContext().setProperty(CONFLICTS_FILE_PATH, (Object)conflicts);
    }

    public boolean hasMergeConflicts() {
        return this._compareView != null && this._compareView.getModel().getResolvedCount() < this._compareView.getModel().getConflictCount();
    }

    private String getResourceFilePath(DiffMergeResource resource) {
        while (resource instanceof ResourceDecorator) {
            resource = ((ResourceDecorator)resource).getResource();
        }
        return resource instanceof FileResource ? ((FileResource)resource).getPath() : null;
    }

    protected void openImpl() {
        CompareModel compareModel;
        String filePath;
        DiffMergeNode node = this.getNode();
        final DiffMergeArguments arguments = node.getArguments();
        if (this._compareView != null || arguments == null) {
            return;
        }
        if (arguments.isMergeTask()) {
            filePath = this.getResourceFilePath(arguments.getOutput());
            if (filePath != null) {
                this.setConflictsFilePath(filePath);
            }
        } else {
            filePath = this.getResourceFilePath(arguments.getSource());
            if (filePath != null) {
                this.setSourceFilePath(filePath);
            }
            if ((filePath = this.getResourceFilePath(arguments.getTarget())) != null) {
                this.setTargetFilePath(filePath);
            }
            this.setAncestorFilePath((filePath = this.getResourceFilePath(arguments.getAncestor())) != null ? filePath : "");
        }
        if (arguments.getCompareType() == CompareType.TEXT) {
            this._contributorS = new TextCompareContributorImpl((ResourceTextNode)node.getSourceNode());
            this._contributorT = new TextCompareContributorImpl((ResourceTextNode)node.getTargetNode());
            this._contributorA = arguments.getAncestor() != null ? new TextCompareContributorImpl((ResourceTextNode)node.getAncestorNode()) : null;
        } else {
            this._contributorS = new DirectoryCompareContributorImpl((ResourceDirectoryNode)node.getSourceNode());
            this._contributorT = new DirectoryCompareContributorImpl((ResourceDirectoryNode)node.getTargetNode());
            this._contributorA = arguments.getAncestor() != null ? new DirectoryCompareContributorImpl((ResourceDirectoryNode)node.getAncestorNode()) : null;
        }
        this.initializeIgnoreWhitespace();
        if (!arguments.isMergeTask()) {
            try {
                compareModel = CompareModelFactory.createCompareModel((CompareContributor)this._contributorS, (CompareContributor)this._contributorT, (CompareType)arguments.getCompareType());
                if (arguments.isDiffOutput()) {
                    this._compareView = CompareViewFactory.createView((CompareModel)compareModel, (CompareMode)CompareMode.TWO_WAY_COMPARE, PatchCompareView.class);
                }
                this._compareView = CompareViewFactory.createCompareView((CompareModel)compareModel);
            }
            catch (CompareFailedException cfe) {
                cfe.printStackTrace();
                return;
            }
        } else {
            if (arguments.getCompareType() == CompareType.TEXT) {
                String contributorType = DiffMergeView.getResourceType(arguments.getOutput());
                ((ResourceCompareContributor)this._contributorS).setType(contributorType);
                ((ResourceCompareContributor)this._contributorT).setType(contributorType);
                ((ResourceCompareContributor)this._contributorA).setType(contributorType);
            }
            compareModel = new SequenceCompareModel((SequenceCompareContributor)this._contributorS, (SequenceCompareContributor)this._contributorT, (SequenceCompareContributor)this._contributorA, arguments.getDifferenceBlocks());
            compareModel.setType(arguments.getCompareType());
            ((ResourceCompareContributor)this._contributorS).setEditable(false);
            ((ResourceCompareContributor)this._contributorT).setEditable(false);
            ((ResourceCompareContributor)this._contributorA).setEditable(true);
            this._compareView = CompareViewFactory.createMergeView((CompareModel)compareModel);
        }
        if (this._compareView != null && this._compareView instanceof BaseCompareView) {
            BaseCompareView actionMenuView = (BaseCompareView)this._compareView;
            actionMenuView.addPopupManager(new ComparePopupManager(){

                public void showPopup(MouseEvent me) {
                    ContextMenu contextMenu = DiffMergeController.getInstance().getContextMenu();
                    if (contextMenu == null) {
                        return;
                    }
                    Context context = new Context(DiffMergeView.this.getContext());
                    Node element = context.getNode();
                    context.setSelection(new Element[]{element});
                    context.setElement((Element)element);
                    context.setEvent((EventObject)me);
                    contextMenu.show(context);
                }

                public void hidePopup() {
                }
            });
        }
        if (this._compareView != null && this._compareView instanceof EditorPaneView) {
            BasicEditorPane[] editorPanes;
            EditorPaneView editorPaneView = (EditorPaneView)this._compareView;
            for (BasicEditorPane editorPane : editorPanes = editorPaneView.getEditorPanes()) {
                class EditUpdateListener
                extends FocusAdapter
                implements CaretListener {
                    EditUpdateListener() {
                    }

                    @Override
                    public void caretUpdate(CaretEvent ce) {
                        DiffMergeView.this.updateEditorContextualActions();
                    }

                    @Override
                    public void focusGained(FocusEvent fe) {
                        DiffMergeView.this.updateEditorContextualActions();
                    }

                    @Override
                    public void focusLost(FocusEvent fe) {
                        DiffMergeView.this.updateEditorContextualActions();
                    }
                }
                EditUpdateListener l = new EditUpdateListener();
                editorPane.addFocusListener((FocusListener)l);
                editorPane.addCaretListener((CaretListener)l);
            }
        }
        if (this._compareView != null && this._compareView instanceof BaseCompareView) {
            BaseCompareView statusView = (BaseCompareView)this._compareView;
            statusView.addStatusListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    DiffMergeView.this.updateEditorContextualActions();
                    DiffMergeView.this.updateStatus();
                }
            });
        }
        if (this._compareView != null && this._compareView instanceof BaseCompareView) {
            BaseCompareView navigableView = (BaseCompareView)this._compareView;
            navigableView.addPositionListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    DiffMergeView.this.updateEditorContextualActions();
                }
            });
        }
        if (this._compareView != null && this._compareView instanceof BaseCompareView) {
            BaseCompareView editableView = (BaseCompareView)this._compareView;
            editableView.addViewEditListener((ViewEditListener)this);
        }
        if (this._compareView != null && this._compareView instanceof BaseCompareView) {
            BaseCompareView toolTipView = (BaseCompareView)this._compareView;
            if (arguments.getSourceAnnotations() != null || arguments.getTargetAnnotations() != null) {
                toolTipView.setToolTipProvider(new CompareToolTipProvider(){

                    public String getToolTipText(ContributorKind contributorKind, CompareDifference difference) {
                        if (!(difference instanceof SequenceCompareDifference)) {
                            return null;
                        }
                        Object annotation = null;
                        if (contributorKind == ContributorKind.FIRST && arguments.getSourceAnnotations() != null) {
                            annotation = arguments.getSourceAnnotations().get(((SequenceCompareDifference)difference).getId());
                        }
                        if (contributorKind == ContributorKind.SECOND && arguments.getTargetAnnotations() != null) {
                            annotation = arguments.getTargetAnnotations().get(((SequenceCompareDifference)difference).getId());
                        }
                        if (annotation != null) {
                            return MessageFormat.format(DiffMergeView.this.getResourceString("ANNOTATION_TEMPLATE"), annotation);
                        }
                        return null;
                    }
                });
            }
        }
        if (this._compareView != null) {
            this.getPanel().open(this._compareView.getGUI());
        }
        this._nodeListener = new NodeListener(){

            public void nodeSaved(NodeEvent ne) {
                DiffMergeNode node = DiffMergeView.this.getNode();
                if (node == null) {
                    return;
                }
                node.setSaved(true);
                if (node.getArguments().getCompareType() == CompareType.DIRECTORY) {
                    DiffMergeView.this.clearCommandProcessorStacks();
                }
            }
        };
        this.getNode().addNodeListener(this._nodeListener);
        this.updateStatus();
    }

    private void clearCommandProcessorStacks() {
        try {
            CommandProcessor.getInstance().invoke(new Command(-1, 2){

                public int doit() {
                    return 0;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void closeImpl() {
        if (this._compareView == null) {
            return;
        }
        this.getPanel().close(this._compareView.getGUI());
        this.invokeClearHighlights();
        this._compareView = null;
        this._contributorS = null;
        this._contributorT = null;
        this._contributorA = null;
        this.getNode().removeNodeListener(this._nodeListener);
        this._nodeListener = null;
        this.updateStatus();
    }

    public void viewEditHappened(ViewEditEvent vee) {
        if (!vee.getViewEdit().isSignificant()) {
            return;
        }
        UndoableEditCommand command = new UndoableEditCommand((UndoableEdit)vee.getViewEdit());
        command.setContext(this.getContext());
        try {
            CommandProcessor.getInstance().invoke((Command)command);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DiffMergeNode node = this.getNode();
        if (node.getArguments() != null && node.getArguments().isMergeTask()) {
            node.getAncestorNode().markDirty(true);
        }
        this.updateAction(5);
        this.updateAction(6);
        this.updateAction(9);
        this.updateEditorContextualActions();
        this.updateStatus();
    }

    protected void updateStatus() {
        DiffMergeArguments arguments = null;
        if (this.getContext().getNode() != null) {
            arguments = this.getNode().getArguments();
        }
        if (this._compareView == null || arguments == null) {
            this.setStatus(" ");
            return;
        }
        if (!arguments.isMergeTask()) {
            int[] diffCount = this._compareView.getModel().getDifferenceTypeCounts();
            int diffs = this._compareView.getModel().getDifferenceCount();
            if (diffs == 0) {
                this.setStatus(this.getResourceString("COMPARE_STATUS_ZERO"));
                return;
            }
            this.setStatus(MessageFormat.format(this.getResourceString("COMPARE_STATUS_FORMAT"), String.valueOf(diffs), String.valueOf(diffCount[0]), String.valueOf(diffCount[1]), String.valueOf(diffCount[2])));
            return;
        }
        int conflicts = this._compareView.getModel().getConflictCount();
        int resolved = this._compareView.getModel().getResolvedCount();
        if (conflicts == 0) {
            this.setStatus(this.getResourceString("MERGE_STATUS_ZERO"));
            return;
        }
        this.setStatus(MessageFormat.format(this.getResourceString("MERGE_STATUS_FORMAT"), String.valueOf(conflicts), String.valueOf(resolved), String.valueOf(conflicts - resolved)));
    }

    protected void setStatus(String status) {
        if (this._statusLabel != null) {
            this._statusLabel.setText(status);
        }
    }

    public JLabel getStatusLabel() {
        if (this._statusLabel == null) {
            this._statusLabel = new JLabel();
            this.updateStatus();
        }
        return this._statusLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIgnoreWhitespace() {
        this.initializeIgnoreWhitespace();
        try {
            this.revert();
        }
        finally {
            this.clearCommandProcessorStacks();
        }
    }

    private void initializeIgnoreWhitespace() {
        DiffMergeArguments arguments = this.getNode().getArguments();
        if (arguments.getCompareType() != CompareType.TEXT) {
            return;
        }
        boolean ignoreWhitespace = DiffMergeActions.getAction(DiffMergeConstants.VIEW_IGNORE_WHITESPACE_CMD_ID).getState();
        if (this._contributorS != null) {
            ((TextCompareContributor)this._contributorS).setIgnoreWhitespace(ignoreWhitespace);
        }
        if (this._contributorT != null) {
            ((TextCompareContributor)this._contributorT).setIgnoreWhitespace(ignoreWhitespace);
        }
        if (this._contributorA != null) {
            ((TextCompareContributor)this._contributorA).setIgnoreWhitespace(ignoreWhitespace);
        }
    }

    private static final String getResourceType(DiffMergeResource resource) {
        return DiffMergeView.getResourceType(resource.getName());
    }

    private static final String getResourceType(String resourceName) {
        int i = resourceName.indexOf(46);
        return (i < 0 ? resourceName : resourceName.substring(i + 1)).toLowerCase();
    }

    public boolean hasFindHighlighting() {
        return this._highlighter != null && this._highlighter.hasFindHighlighting();
    }

    public void invokeHighlight() {
        this.invokeClearHighlights();
        EditorPaneView editorPaneView = (EditorPaneView)this._compareView;
        BasicEditorPane editorPane = editorPaneView.getCurrentEditorPane();
        String selectedText = editorPane.getSelectedText();
        this._highlighter = new Highlighter(editorPaneView.getEditorPanes());
        this._highlighter.install();
        this._highlighter.findText(selectedText, 0, true, true, false, true);
    }

    public void invokeClearHighlights() {
        if (this._highlighter == null) {
            return;
        }
        this._highlighter.clearFindHighlighting();
        this._highlighter = null;
    }

    private class MainPanel
    extends JPanel {
        MainPanel() {
            super(new BorderLayout());
        }

        public void open(Component component) {
            this.add(component, "Center");
        }

        public void close(Component component) {
            this.remove(component);
        }

        public void redraw() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainPanel.this.validate();
                    MainPanel.this.revalidate();
                    MainPanel.this.repaint();
                }
            });
        }
    }

    private class Highlighter {
        private final BasicEditorPane[] _editorPanes;
        private final FindHighlightPlugin[] _findHighlightPlugins;

        Highlighter(BasicEditorPane[] editorPanes) {
            this._editorPanes = editorPanes;
            this._findHighlightPlugins = new FindHighlightPlugin[this._editorPanes.length];
            for (int i = 0; i < this._editorPanes.length; ++i) {
                this._findHighlightPlugins[i] = new FindHighlightPlugin();
            }
        }

        void install() {
            for (int i = 0; i < this._editorPanes.length; ++i) {
                this._findHighlightPlugins[i].install(this._editorPanes[i]);
            }
        }

        void deinstall() {
            for (int i = 0; i < this._editorPanes.length; ++i) {
                this._findHighlightPlugins[i].deinstall(this._editorPanes[i]);
            }
        }

        void findText(String searchText, int startOffset, boolean searchForward, boolean matchCase, boolean wrapAround, boolean highlightOccurrences) {
            for (FindHighlightPlugin findHighlightPlugin : this._findHighlightPlugins) {
                findHighlightPlugin.findText(searchText, startOffset, searchForward, matchCase, wrapAround, highlightOccurrences);
            }
        }

        void clearFindHighlighting() {
            for (FindHighlightPlugin findHighlightPlugin : this._findHighlightPlugins) {
                findHighlightPlugin.clearFindHighlighting();
            }
        }

        boolean hasFindHighlighting() {
            for (FindHighlightPlugin findHighlightPlugin : this._findHighlightPlugins) {
                if (!findHighlightPlugin.hasFindHighlighting()) continue;
                return true;
            }
            return false;
        }
    }

    private class TextCompareContributorImpl
    extends TextCompareContributor
    implements ResourceCompareContributor {
        private final ResourceTextNode _resourceTextNode;
        private TextBuffer _textBuffer;
        private String _type;

        TextCompareContributorImpl(ResourceTextNode resourceTextNode) {
            this._resourceTextNode = resourceTextNode;
            this.addTextBufferListeners();
        }

        public String getShortLabel() {
            return this._resourceTextNode.getResource().getLabel();
        }

        public String getLongLabel() {
            return this._resourceTextNode.getResource().getLabel();
        }

        @Override
        public void setType(String type) {
            this._type = type;
        }

        public String getType() {
            if (this._type == null) {
                this._type = DiffMergeView.getResourceType(this._resourceTextNode.getResource());
            }
            return this._type;
        }

        @Override
        public TextBuffer getTextBuffer() {
            if (this._textBuffer == null) {
                this._textBuffer = this._resourceTextNode.acquireTextBuffer();
            }
            return this._textBuffer;
        }

        @Override
        public void setEditable(boolean editable) {
            this.getTextBuffer().setReadOnly(!editable);
        }

        public boolean isEditable() {
            return this._textBuffer != null ? !this._textBuffer.isReadOnly() : false;
        }

        public boolean isModified() {
            return this._textBuffer != null ? this._textBuffer.isModified() : false;
        }
    }

    private class DirectoryCompareContributorImpl
    extends DirectoryCompareContributor
    implements ResourceCompareContributor {
        private final ResourceDirectoryNode _resourceDirectoryNode;
        private TextBuffer _textBuffer;

        DirectoryCompareContributorImpl(ResourceDirectoryNode resourceDirectoryNode) {
            this._resourceDirectoryNode = resourceDirectoryNode;
            this._textBuffer = this._resourceDirectoryNode.acquireTextBuffer();
            this.setDirectoryList(this._resourceDirectoryNode.getDirectoryList());
            this.addDirectoryListListeners();
        }

        public String getShortLabel() {
            return this._resourceDirectoryNode.getResource().getLabel();
        }

        public String getLongLabel() {
            return this._resourceDirectoryNode.getResource().getLabel();
        }

        @Override
        public void setType(String type) {
        }

        @Override
        public TextBuffer getTextBuffer() {
            if (this._textBuffer == null) {
                this._textBuffer = this._resourceDirectoryNode.acquireTextBuffer();
            }
            return this._textBuffer;
        }

        @Override
        public void setEditable(boolean editable) {
            this.getTextBuffer().setReadOnly(!editable);
        }

        public boolean isEditable() {
            return this._textBuffer != null ? !this._textBuffer.isReadOnly() : false;
        }

        public boolean isModified() {
            return this.getDirectoryList() != null ? this.getDirectoryList().isModified() : false;
        }
    }

    private static interface ResourceCompareContributor
    extends EditableContributor {
        public void setType(String var1);

        public void setEditable(boolean var1);

        public TextBuffer getTextBuffer();
    }
}

