/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.diffmerge.diff3;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.ide.diffmerge.diff3.Diff3Model;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;

public class Diff3Format {
    private static final String RIGHT_MERGE_MARKER = "<<<<<<<";
    private static final String BLOCK_MARKER = "=======";
    private static final String LEFT_MERGE_MARKER = ">>>>>>>";
    private Class _annotationClass = Diff3Model.Annotation.class;
    private long _currentDifferenceId = 0L;

    private synchronized Object createDifferenceId() {
        return new Long(this._currentDifferenceId++);
    }

    public Class getAnnotationClass() {
        return this._annotationClass;
    }

    public void setAnnotationClass(Class annotationClass) {
        this._annotationClass = annotationClass;
    }

    public Diff3Model parse(Reader reader) throws IOException {
        ArrayList<SequenceCompareDifference> differenceBlocks = new ArrayList<SequenceCompareDifference>();
        ReadWriteLock firstReadWriteLock = new ReadWriteLock();
        ReadWriteLock secondReadWriteLock = new ReadWriteLock();
        ReadWriteLock ancestorReadWriteLock = new ReadWriteLock();
        TextBuffer firstTextBuffer = TextBufferFactory.createTextBuffer((ReadWriteLock)firstReadWriteLock);
        TextBuffer secondTextBuffer = TextBufferFactory.createTextBuffer((ReadWriteLock)secondReadWriteLock);
        TextBuffer ancestorTextBuffer = TextBufferFactory.createTextBuffer((ReadWriteLock)ancestorReadWriteLock);
        TextBuffer inputTextBuffer = TextBufferFactory.createArrayTextBuffer();
        firstTextBuffer.writeLock();
        secondTextBuffer.writeLock();
        ancestorTextBuffer.writeLock();
        inputTextBuffer.writeLock();
        inputTextBuffer.read(reader);
        HashMap<Object, Object> sourceAnnotations = new HashMap<Object, Object>();
        HashMap<Object, Object> targetAnnotations = new HashMap<Object, Object>();
        LineMap inputLineMap = inputTextBuffer.getLineMap();
        boolean STATE_NORMAL = false;
        boolean STATE_LOCAL_VERSION_BLOCK = true;
        int STATE_OTHER_VERSION_BLOCK = 2;
        int state = 0;
        SequenceCompareDifference differenceBlock = null;
        String pushbackLine = null;
        int i = 0;
        while (true) {
            String line;
            if (pushbackLine == null) {
                int lineLength;
                if (i >= inputLineMap.getLineCount()) break;
                int lineOffset = inputLineMap.getLineStartOffset(i);
                line = inputTextBuffer.getString(lineOffset, lineLength = inputLineMap.getLineEndOffset(i) - lineOffset);
                int markerMatchIndex = Math.max(Math.max(line.indexOf(RIGHT_MERGE_MARKER), line.indexOf(BLOCK_MARKER)), line.indexOf(LEFT_MERGE_MARKER));
                if (markerMatchIndex > 0) {
                    pushbackLine = line.substring(markerMatchIndex);
                    line = line.substring(0, markerMatchIndex) + inputTextBuffer.getEOLType();
                }
                ++i;
            } else {
                line = pushbackLine;
                pushbackLine = null;
            }
            if (line.startsWith(RIGHT_MERGE_MARKER)) {
                state = 1;
                if (differenceBlock != null) {
                    this.prepareDifferenceBlock(differenceBlock, firstTextBuffer, secondTextBuffer, ancestorTextBuffer);
                    differenceBlocks.add(differenceBlock);
                }
                differenceBlock = this.createDifferenceBlock(2, firstTextBuffer, secondTextBuffer, ancestorTextBuffer);
                Object annotation = this.extractAnnotation(line);
                if (annotation == null) continue;
                targetAnnotations.put(differenceBlock.getId(), annotation);
                continue;
            }
            if (line.startsWith(LEFT_MERGE_MARKER)) {
                state = 0;
                if (differenceBlock != null) {
                    Object annotation = this.extractAnnotation(line);
                    if (annotation != null) {
                        sourceAnnotations.put(differenceBlock.getId(), annotation);
                    }
                    this.prepareDifferenceBlock(differenceBlock, firstTextBuffer, secondTextBuffer, ancestorTextBuffer);
                    differenceBlocks.add(differenceBlock);
                }
                differenceBlock = null;
                continue;
            }
            if (line.startsWith(BLOCK_MARKER)) {
                state = 2;
                continue;
            }
            if (state == 0 || state == 1) {
                secondTextBuffer.append(line.toCharArray());
            }
            if (state == 0 || state == 2) {
                firstTextBuffer.append(line.toCharArray());
            }
            if (state != 0) continue;
            ancestorTextBuffer.append(line.toCharArray());
        }
        if (differenceBlock != null) {
            this.prepareDifferenceBlock(differenceBlock, firstTextBuffer, secondTextBuffer, ancestorTextBuffer);
            differenceBlocks.add(differenceBlock);
        }
        firstTextBuffer.writeUnlock();
        secondTextBuffer.writeUnlock();
        ancestorTextBuffer.writeUnlock();
        inputTextBuffer.writeUnlock();
        Diff3Model model = new Diff3Model();
        model.setFirstTextBuffer(firstTextBuffer);
        model.setSecondTextBuffer(secondTextBuffer);
        model.setAncestorTextBuffer(ancestorTextBuffer);
        model.setDifferenceBlocks(differenceBlocks.toArray(new SequenceCompareDifference[0]));
        model.setSourceAnnotations(sourceAnnotations);
        model.setTargetAnnotations(targetAnnotations);
        return model;
    }

    private SequenceCompareDifference createDifferenceBlock(int type, TextBuffer firstTextBuffer, TextBuffer secondTextBuffer, TextBuffer ancestorTextBuffer) {
        SequenceCompareDifference differenceBlock = new SequenceCompareDifference(type);
        differenceBlock.setConflict(true);
        differenceBlock.setId(this.createDifferenceId());
        differenceBlock.setFirstStart(firstTextBuffer.getLineMap().getLineCount() - 1);
        differenceBlock.setSecondStart(secondTextBuffer.getLineMap().getLineCount() - 1);
        differenceBlock.setAncestorStart(ancestorTextBuffer.getLineMap().getLineCount() - 1);
        return differenceBlock;
    }

    private void prepareDifferenceBlock(SequenceCompareDifference differenceBlock, TextBuffer firstTextBuffer, TextBuffer secondTextBuffer, TextBuffer ancestorTextBuffer) {
        differenceBlock.setFirstLength(Math.max(0, firstTextBuffer.getLineMap().getLineCount() - differenceBlock.getStart(ContributorKind.FIRST) - 1));
        differenceBlock.setSecondLength(Math.max(0, secondTextBuffer.getLineMap().getLineCount() - differenceBlock.getStart(ContributorKind.SECOND) - 1));
        differenceBlock.setAncestorLength(Math.max(0, ancestorTextBuffer.getLineMap().getLineCount() - differenceBlock.getStart(ContributorKind.ANCESTOR) - 1));
    }

    private Object extractAnnotation(String line) {
        try {
            int i = line.indexOf(32);
            return i >= 0 ? this._annotationClass.getConstructor(String.class).newInstance(line.substring(i).trim()) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

