/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.diffmerge;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import oracle.ide.diffmerge.DiffMergeArguments;
import oracle.ide.diffmerge.DiffMergeResource;
import oracle.ide.diffmerge.DiffMergeTask;
import oracle.ide.diffmerge.diff3.Diff3Format;
import oracle.ide.diffmerge.diff3.Diff3Model;
import oracle.ide.diffmerge.model.TextBufferResource;
import oracle.ide.diffmerge.res.ResourceUtil;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.algorithm.directory.DirectoryFile;

public class DiffMergeResolveTask
extends DiffMergeTask {
    private final DiffMergeArguments _arguments = new DiffMergeArguments();
    private final DiffMergeResource _conflicts;

    private DiffMergeResolveTask(DiffMergeResource conflicts, DiffMergeResource output) {
        this._arguments.setOutput(output);
        this._arguments.setMergeTask(true);
        this._arguments.setCompareType(CompareType.TEXT);
        this._conflicts = conflicts;
    }

    private DiffMergeResolveTask(DiffMergeResource conflicts, DiffMergeResource output, DiffMergeResource source, DiffMergeResource target) {
        this._arguments.setOutput(output);
        this._arguments.setMergeTask(true);
        this._arguments.setCompareType(CompareType.DIRECTORY);
        this._conflicts = conflicts;
        this._arguments.setSource(source);
        this._arguments.setTarget(target);
        this._arguments.setAncestor(output);
    }

    public static final DiffMergeResolveTask createDirectoryTask(DiffMergeResource conflicts, DiffMergeResource output, DiffMergeResource source, DiffMergeResource target) {
        return new DiffMergeResolveTask(conflicts, output, source, target);
    }

    public static final DiffMergeResolveTask createTextFileTask(DiffMergeResource conflicts, DiffMergeResource output) {
        return new DiffMergeResolveTask(conflicts, output);
    }

    @Override
    public final DiffMergeArguments createArguments() throws Exception {
        Diff3Model diff3Model = new Diff3Format().parse(new InputStreamReader(this._conflicts.openInputStream()));
        this._arguments.setDifferenceBlocks(diff3Model.getDifferenceBlocks());
        String sourceLabel = this.createContributorName(diff3Model.getSourceAnnotations());
        String targetLabel = this.createContributorName(diff3Model.getTargetAnnotations());
        String ancestorLabel = ResourceUtil.getResourceBundle().getString("CONFLICTS_RESULT_NAME");
        if (this._arguments.getCompareType() == CompareType.DIRECTORY) {
            if (this._arguments.getSource() == null || this._arguments.getTarget() == null || this._arguments.getAncestor() == null) {
                throw new IllegalArgumentException();
            }
            this._arguments.setSource(new DirectoryTextBufferResource(sourceLabel, diff3Model.getFirstTextBuffer(), this._arguments.getSource()));
            this._arguments.setTarget(new DirectoryTextBufferResource(targetLabel, diff3Model.getSecondTextBuffer(), this._arguments.getTarget()));
            this._arguments.setAncestor(new DirectoryTextBufferResource(ancestorLabel, diff3Model.getAncestorTextBuffer(), this._arguments.getAncestor()));
        } else {
            this._arguments.setSource(new TextBufferResource(sourceLabel, diff3Model.getFirstTextBuffer()));
            this._arguments.setTarget(new TextBufferResource(targetLabel, diff3Model.getSecondTextBuffer()));
            this._arguments.setAncestor(new TextBufferResource(ancestorLabel, diff3Model.getAncestorTextBuffer()));
        }
        this._arguments.setSourceAnnotations(diff3Model.getSourceAnnotations());
        this._arguments.setTargetAnnotations(diff3Model.getTargetAnnotations());
        return this._arguments;
    }

    private String createContributorName(Map annotations) {
        HashSet annotationsSet = new HashSet(annotations.values());
        Object[] annotationsArray = annotationsSet.toArray();
        Arrays.sort(annotationsArray);
        ResourceBundle bundle = ResourceUtil.getResourceBundle();
        if (annotationsArray.length <= 0) {
            return MessageFormat.format(bundle.getString("CONTRIBUTOR_TEMPLATE"), bundle.getString("CONTRIBUTOR_NONE_NAME"));
        }
        if (annotationsArray.length == 1) {
            return MessageFormat.format(bundle.getString("CONTRIBUTOR_TEMPLATE"), annotationsArray[0].toString());
        }
        String contributorList = annotationsArray[0].toString();
        for (int i = 1; i < annotationsArray.length; ++i) {
            contributorList = MessageFormat.format(bundle.getString("CONTRIBUTOR_DELIMITER_TEMPLATE"), contributorList, annotationsArray[1].toString());
        }
        return MessageFormat.format(bundle.getString("CONTRIBUTOR_MULTI_TEMPLATE"), contributorList);
    }

    private class DirectoryTextBufferResource
    extends TextBufferResource {
        private final DiffMergeResource _directory;

        DirectoryTextBufferResource(String label, TextBuffer textBuffer, DiffMergeResource directory) {
            super(label, textBuffer);
            this._directory = directory;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public boolean canModify() {
            return this._directory.canModify();
        }

        @Override
        public DiffMergeResource[] listResources() throws IOException {
            ArrayList<DiffMergeResource> resources = new ArrayList<DiffMergeResource>();
            DiffMergeResource[] directoryResources = this._directory.listResources();
            StringWriter sw = new StringWriter();
            this.getTextBuffer().write((Writer)sw);
            BufferedReader br = new BufferedReader(new StringReader(sw.toString()));
            try {
                String line;
                while ((line = br.readLine()) != null && !line.trim().equals("")) {
                    int i;
                    DirectoryFile directoryFile = DirectoryFile.parseFile((String)line);
                    for (i = 0; i < directoryResources.length; ++i) {
                        if (!directoryFile.getName().equals(directoryResources[i].getName())) continue;
                        resources.add(directoryResources[i]);
                        break;
                    }
                    if (i < directoryResources.length) continue;
                    throw new IllegalStateException();
                }
            }
            catch (ParseException pe) {
                pe.printStackTrace();
            }
            return resources.toArray(new DiffMergeResource[0]);
        }

        @Override
        public void setResources(DiffMergeResource[] resources) throws IOException {
            this._directory.setResources(resources);
        }
    }
}

