/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.diffmerge;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.diffmerge.DiffMergeArguments;
import oracle.ide.diffmerge.DiffMergeConstants;
import oracle.ide.diffmerge.DiffMergeController;
import oracle.ide.diffmerge.DiffMergeCustomizer;
import oracle.ide.diffmerge.DiffMergeNode;
import oracle.ide.diffmerge.impl.LocalActionCache;
import oracle.ide.diffmerge.res.ResourceUtil;
import oracle.ide.diffmerge.view.DiffMergeView;
import oracle.ide.editor.Editor;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.DynamicStatusProvider;
import oracle.ide.view.View;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.view.EditorPaneView;
import oracle.javatools.editor.BasicEditorPane;

public class DiffMergeEditor
extends Editor
implements FindableEditor,
DynamicStatusProvider {
    public static final String CUSTOMIZER = "DiffMergeEditor.CUSTOMIZER";
    public static final String ARGS = "DiffMergeEditor.ARGS";
    private DiffMergeArguments _arguments;
    private DiffMergeView _control;
    private DiffMergeCustomizer _customizer;
    private Toolbar _toolbar;
    private final LocalActionCache _localActionCache;
    private JFrame _helpFrame;
    private Collection _statusChangeListeners = new ArrayList();

    public DiffMergeEditor() {
        DiffMergeController.getInstance();
        this._localActionCache = new LocalActionCache((View)this);
    }

    public boolean isCompleteState() {
        return ((DiffMergeNode)((Object)this.getContext().getProperty("DiffMergeEditor.NODE"))).isSaved();
    }

    DiffMergeCustomizer getCustomizer() {
        return this._customizer;
    }

    public BasicEditorPane getFocusedEditorPane() {
        CompareView compareView = this._control != null ? this._control.getCompareView() : null;
        return compareView instanceof EditorPaneView ? ((EditorPaneView)compareView).getCurrentEditorPane() : null;
    }

    public JComponent[] getCustomCells() {
        JComponent[] jComponentArray;
        if (this._control != null) {
            JComponent[] jComponentArray2 = new JComponent[1];
            jComponentArray = jComponentArray2;
            jComponentArray2[0] = this._control.getStatusLabel();
        } else {
            jComponentArray = new JComponent[]{};
        }
        return jComponentArray;
    }

    public boolean isExpandable(JComponent customCell) {
        return true;
    }

    public void addChangeListener(ChangeListener l) {
        this._statusChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this._statusChangeListeners.remove(l);
    }

    private void fireStatusStateChanged() {
        ChangeEvent ce = new ChangeEvent((Object)this);
        Iterator itr = this._statusChangeListeners.iterator();
        while (itr.hasNext()) {
            ((ChangeListener)itr.next()).stateChanged(ce);
        }
    }

    public Component getFixedTopMargin() {
        return this.getToolbar();
    }

    public DiffMergeView getDiffMergeControl() {
        return this._control;
    }

    public DiffMergeArguments getArguments() {
        return this._arguments;
    }

    public synchronized void setContext(Context context) {
        if (context != null) {
            super.setContext(context);
            this._arguments = this.getArguments(context);
            this.getContext().setProperty("DiffMergeEditor.NODE", context.getNode() instanceof DiffMergeNode ? context.getNode() : new DiffMergeNode(this._arguments));
            this._customizer = (DiffMergeCustomizer)context.getProperty(CUSTOMIZER);
            if (this._customizer == null) {
                this._customizer = new DiffMergeCustomizer();
            }
        }
    }

    protected DiffMergeArguments getArguments(Context context) {
        if (context.getNode() instanceof DiffMergeNode) {
            return ((DiffMergeNode)context.getNode()).getArguments();
        }
        if (context.containsProperty(ARGS)) {
            return (DiffMergeArguments)context.getProperty(ARGS);
        }
        return null;
    }

    public void open() {
        if (this._arguments == null) {
            return;
        }
        try {
            this._control = new DiffMergeView(this._localActionCache);
            this._control.setContext(this.getContext());
            this._control.initializeFromNode();
            this._control.open();
        }
        catch (Exception e) {
            this._customizer.getExceptionHandler().handleException(e, (Component)Ide.getMainWindow());
        }
        this.fireStatusStateChanged();
    }

    public void close() {
        super.close();
        if (this._control != null) {
            this._control.close();
        }
        this._control = null;
        if (this._toolbar != null) {
            this._toolbar.removeAll();
            this._toolbar.dispose();
        }
        this._toolbar = null;
        this._arguments = null;
        this.fireStatusStateChanged();
    }

    public Object getEditorAttribute(String attribute) {
        if (attribute != null && attribute.equals("scrollable")) {
            return Boolean.FALSE;
        }
        if (attribute != null && attribute.equals("custom_vertical_scrollbar")) {
            return null;
        }
        if (attribute != null && attribute.equals("horizontal_scrollbar_policy")) {
            return 31;
        }
        if (attribute != null && attribute.equals("vertical_scrollbar_policy")) {
            return 21;
        }
        return super.getEditorAttribute(attribute);
    }

    public void update(Object observed, UpdateMessage change) {
        if (observed instanceof DiffMergeNode && change.getMessageID() == UpdateMessage.OBJECT_RELOADED && this._control != null) {
            this._control.revert();
        }
    }

    public ContextMenu getContextMenu() {
        return DiffMergeController.getInstance().getContextMenu();
    }

    public Controller getController() {
        return DiffMergeController.getInstance();
    }

    public Component getGUI() {
        return this.getDiffMergeControl().getGUI();
    }

    public Context getContext(EventObject event) {
        Context context = super.getContext(event);
        if (context != null && context instanceof Context) {
            context.setView((View)this);
        }
        return context;
    }

    public Toolbar getToolbar() {
        if (this._toolbar != null) {
            return this._toolbar;
        }
        this._toolbar = new Toolbar();
        this._toolbar.addToggleButton((ToggleAction)this.getLocalAction(DiffMergeConstants.VIEW_IGNORE_WHITESPACE_CMD_ID));
        this._toolbar.addSeparator();
        this._toolbar.add((ToggleAction)this.getLocalAction(DiffMergeConstants.NAVIGATE_FIRST_DIFFERENCE_CMD_ID));
        this._toolbar.add((ToggleAction)this.getLocalAction(DiffMergeConstants.NAVIGATE_PREVIOUS_DIFFERENCE_CMD_ID));
        this._toolbar.add((ToggleAction)this.getLocalAction(DiffMergeConstants.NAVIGATE_NEXT_DIFFERENCE_CMD_ID));
        this._toolbar.add((ToggleAction)this.getLocalAction(DiffMergeConstants.NAVIGATE_LAST_DIFFERENCE_CMD_ID));
        this._toolbar.addSeparator();
        this._toolbar.add((ToggleAction)this.getLocalAction(DiffMergeConstants.SEARCH_HIGHLIGHT_CMD_ID));
        this._toolbar.add((ToggleAction)this.getLocalAction(DiffMergeConstants.SEARCH_CLEAR_HIGHLIGHTS_CMD_ID));
        return this._toolbar;
    }

    protected IdeAction getLocalAction(int cmdId) {
        return this._localActionCache.getLocalAction(cmdId);
    }

    public void openHelp() throws Exception {
        URL helpUrl = this.getHelpURL();
        if (helpUrl == null) {
            return;
        }
        if (this._helpFrame == null) {
            JEditorPane editorPane = new JEditorPane();
            editorPane.setEditable(false);
            try {
                editorPane.setPage(helpUrl);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return;
            }
            this._helpFrame = new JFrame(this.getHelpTitle());
            this._helpFrame.setSize(800, 600);
            IdeUtil.centerWindow(null, (Component)this._helpFrame);
            this._helpFrame.getContentPane().add(new JScrollPane(editorPane));
        }
        if (this._helpFrame != null) {
            this._helpFrame.setVisible(true);
        }
    }

    public void closeHelp() {
        if (this._helpFrame == null) {
            return;
        }
        this._helpFrame.setVisible(false);
        this._helpFrame.dispose();
        this._helpFrame = null;
    }

    protected String getHelpTitle() {
        return this.getResourceString("HELP_DEFAULT_TITLE");
    }

    protected URL getHelpURL() {
        return DiffMergeEditor.class.getResource(this.getResourceString("HELP_DIFFMERGE_LOCATION"));
    }

    protected final String getResourceString(String name) {
        return ResourceUtil.getResourceBundle().getString(name);
    }

    protected final ImageIcon getResourceIcon(String name) {
        return ResourceUtil.getResourceIcon(name);
    }
}

