/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.parser.plsql.StackParser;
import oracle.dbtools.util.Service;

public class SqlId {
    public int fileCnt = 0;
    private int sqlCnt = 0;
    private int changeCnt = 0;
    private String prefix = " ";
    private Set<String> fileExtensions;

    public void walkDir(File file) throws FileNotFoundException, Exception {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.walkDir(file2);
            }
        } else {
            this.rewrite(file);
        }
    }

    public SqlId(String string, Set<String> set) {
        this.prefix = string;
        this.fileExtensions = set;
    }

    public void rewrite(File file) throws FileNotFoundException, Exception {
        int n;
        String string = " /* " + this.prefix;
        String string2 = file.getName();
        if (string2.length() > 4 && (n = string2.lastIndexOf(46)) >= 0 && n < string2.length() - 3) {
            String string3 = "*" + string2.substring(n).toLowerCase();
            if (this.fileExtensions.contains("*.*") || this.fileExtensions.contains(string3)) {
                String string4 = Service.readFile(new FileInputStream(file));
                List<LexerToken> list = LexerToken.parse(string4);
                LazyNode lazyNode = StackParser.parse(list);
                List<Integer> list2 = SqlId.getInsertionsPoints(lazyNode, list);
                int n2 = -1;
                int n3 = 0;
                StringBuilder stringBuilder = new StringBuilder();
                for (LexerToken object2 : list) {
                    if (!list2.contains(++n2)) continue;
                    ++this.sqlCnt;
                    if (string.equals(string4.substring(object2.end, object2.end + string.length()))) continue;
                    stringBuilder.append(string4.substring(n3, object2.end));
                    n3 = object2.end;
                    stringBuilder.append(string + UUID.randomUUID().toString().substring(0, 6) + " */ ");
                    ++this.changeCnt;
                }
                stringBuilder.append(string4.substring(n3));
                FileWriter fileWriter = new FileWriter(file);
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                bufferedWriter.write(stringBuilder.toString());
                bufferedWriter.close();
                ++this.fileCnt;
            }
        }
    }

    private static List<Integer> getInsertionsPoints(LazyNode lazyNode, List<LexerToken> list) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        if ("insert".equalsIgnoreCase(lazyNode.startToken) || "update".equalsIgnoreCase(lazyNode.startToken) || "delete".equalsIgnoreCase(lazyNode.startToken) || "select".equalsIgnoreCase(lazyNode.startToken) || "with".equalsIgnoreCase(lazyNode.startToken) || "merge".equalsIgnoreCase(lazyNode.startToken)) {
            linkedList.add(lazyNode.from);
        } else if ("cursor".equalsIgnoreCase(lazyNode.startToken) || "for".equalsIgnoreCase(lazyNode.startToken)) {
            int n = -1;
            int n2 = lazyNode.from;
            int n3 = lazyNode.to;
            if ("for".equalsIgnoreCase(lazyNode.startToken)) {
                int n4 = -1;
                for (LazyNode lazyNode2 : lazyNode.shallowChildren()) {
                    if (++n4 == 0) {
                        n2 = lazyNode2.from;
                        n3 = lazyNode2.to;
                        continue;
                    }
                    linkedList.addAll(SqlId.getInsertionsPoints(lazyNode2, list));
                }
            }
            for (LexerToken lexerToken : list) {
                if (++n >= n3) break;
                if (n < n2 || !"select".equalsIgnoreCase(lexerToken.content)) continue;
                linkedList.add(n);
                break;
            }
        } else {
            for (LazyNode lazyNode3 : lazyNode.shallowChildren()) {
                linkedList.addAll(SqlId.getInsertionsPoints(lazyNode3, list));
            }
        }
        return linkedList;
    }

    public static void main(String[] stringArray) throws Exception {
        switch (stringArray.length) {
            default: {
                System.out.println("Usage: java -jar <utils-nodeps.jar> \n<directory> <prefix> \ne.g. \njava -jar C:\\sqld\\sqldeveloper\\lib\\oracle.sqldeveloper.utils-nodeps.jar\nC:\\Apex_code APEX");
                return;
            }
            case 1: 
            case 2: 
        }
        File file = new File(stringArray[0]);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("*.plb");
        hashSet.add("*.pls");
        hashSet.add("*.pkb");
        SqlId sqlId = new SqlId(" ", hashSet);
        if (!file.exists()) {
            System.out.println("Specified directory does not exist.");
        }
        if (stringArray.length == 2) {
            sqlId.prefix = stringArray[1];
        }
        sqlId.walkDir(file);
        System.out.println(sqlId.log());
    }

    public String log() {
        return "Processed " + this.fileCnt + " files, found " + this.sqlCnt + " statements, stamped " + this.changeCnt + " of them";
    }
}

