/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SqlCYK;
import oracle.dbtools.parser.plsql.UnifiedRules;
import oracle.dbtools.util.Array;
import oracle.dbtools.util.Service;

public class SqlEarley
extends Earley {
    private static SqlEarley instance = null;
    private static Set<RuleTuple> origRules;
    private int begin;
    private int dotted_name;
    public int decl_id;
    private int distinct;
    private int function_expression;
    public int multiset_except;
    public int sql_statements;
    private int subprg_body;
    private int start;
    public int table_reference;
    public boolean fifteenPctLAImpr = true;
    Integer LAsuspect = null;
    private Set<Integer> keywords = new TreeSet<Integer>();

    public static void main(String[] stringArray) throws Exception {
        Cell cell;
        boolean bl = false;
        block0: for (RuleTuple ruleTuple : origRules) {
            if (ruleTuple.head.contains("'EXEC'")) {
                System.out.println(ruleTuple.toString());
                continue;
            }
            if (bl) continue;
            for (int i = 0; i < ruleTuple.rhs.length; ++i) {
                if (!ruleTuple.rhs[i].contains("'EXEC'")) continue;
                System.out.println(ruleTuple.toString());
                continue block0;
            }
        }
        String string = Service.readFile(SqlCYK.class, "test.sql");
        long l = System.currentTimeMillis();
        List<LexerToken> list = LexerToken.parse(string);
        if (list.size() > Integer.MAX_VALUE) {
            throw new AssertionError((Object)(list.size() + " tokens"));
        }
        long l2 = System.currentTimeMillis();
        System.out.println("Lex time = " + (l2 - l));
        l = System.currentTimeMillis();
        SqlEarley sqlEarley = SqlEarley.getInstance();
        l2 = System.currentTimeMillis();
        System.out.println("Earley init time = " + (l2 - l));
        Matrix matrix = new Matrix(sqlEarley);
        Visual visual = null;
        if (list.size() < 1000) {
            visual = new Visual(list, sqlEarley);
        }
        l = System.currentTimeMillis();
        sqlEarley.parse(list, matrix);
        l2 = System.currentTimeMillis();
        System.out.println("Earley parse time = " + (l2 - l));
        if (visual != null) {
            visual.draw(matrix);
        }
        if ((cell = (Cell)matrix.get(Service.lPair(0, list.size()))) != null) {
            System.out.println(list.size() + " tokens, top = " + cell.toString());
        } else {
            System.out.println("***** Syntactically Invalid fargment *****");
        }
        l = System.currentTimeMillis();
        ParseNode parseNode = sqlEarley.forest(list, matrix);
        l2 = System.currentTimeMillis();
        System.out.println("Reduction time = " + (l2 - l));
        if (list.size() < 1000) {
            parseNode.printTree();
        }
    }

    public static SqlEarley getInstance() {
        if (instance == null) {
            instance = new SqlEarley();
        }
        return instance;
    }

    private SqlEarley() {
        super(origRules);
        this.initKeywords();
        this.begin = this.getSymbol("'BEGIN'");
        this.dotted_name = this.getSymbol("dotted_name");
        this.decl_id = this.getSymbol("decl_id");
        this.distinct = this.getSymbol("'DISTINCT'");
        this.function_expression = this.getSymbol("function_expression");
        this.multiset_except = this.getSymbol("multiset_except");
        this.sql_statements = this.getSymbol("sql_statements");
        this.subprg_body = this.getSymbol("subprg_body");
        this.start = this.getSymbol("'START'");
        this.table_reference = this.getSymbol("table_reference");
    }

    @Override
    protected boolean scan(Matrix matrix, List<LexerToken> list) {
        if (matrix.size() == 0) {
            long l = 0L;
            if (Visual.visited != null) {
                l = System.nanoTime();
            }
            this.initCell(matrix, new int[]{this.sql_statements, this.subprg_body}, 0);
            if (Visual.visited != null) {
                long l2 = System.nanoTime();
                long[] lArray = Visual.visited[0];
                lArray[0] = lArray[0] + (long)((int)(l2 - l));
            }
            return true;
        }
        long l = 0L;
        if (Visual.visited != null) {
            l = System.nanoTime();
        }
        Long l3 = (Long)matrix.lastKey();
        int n = Service.lY(l3);
        if (list.size() <= n) {
            return false;
        }
        LexerToken lexerToken = list.get(n);
        Integer n2 = (Integer)this.symbolIndexes.get("'" + lexerToken.content.toUpperCase() + "'");
        this.LAsuspect = null;
        if (this.fifteenPctLAImpr && n + 1 < list.size()) {
            LexerToken lexerToken2 = list.get(n + 1);
            this.LAsuspect = (Integer)this.symbolIndexes.get("'" + lexerToken2.content.toUpperCase() + "'");
        }
        for (int i = this.allXs.length - 1; 0 <= i; --i) {
            int n3 = this.allXs[i];
            this.scan(matrix, n, list, n3, n2);
        }
        this.scan(matrix, n, list, n, n2);
        return true;
    }

    public void initCell(Matrix matrix, int[] nArray, int n) {
        int[] nArray2 = null;
        block0: for (int i = 0; i < this.rules.length; ++i) {
            Earley.Tuple tuple = this.rules[i];
            for (int n2 : nArray) {
                if (tuple.head != n2) continue;
                nArray2 = Array.insert(nArray2, this.makeEarleyCell(i, 0));
                continue block0;
            }
        }
        matrix.put(Service.lPair(n, n), new Earley.EarleyCell(nArray2));
        this.allXs = Array.insert(this.allXs, n);
    }

    private void scan(Matrix matrix, int n, List<LexerToken> list, int n2, Integer n3) {
        long l = 0L;
        if (Visual.visited != null) {
            l = System.nanoTime();
        }
        int[] nArray = null;
        Cell cell = (Cell)matrix.get(Service.lPair(n2, n));
        if (cell == null) {
            return;
        }
        for (int i = 0; i < cell.size(); ++i) {
            int n4 = cell.getPosition(i);
            int n5 = cell.getRule(i);
            Earley.Tuple tuple = this.rules[n5];
            if (tuple.size() - 1 < n4 || !this.isScannedSymbol(n, list, n4, tuple, n3) || !this.lookaheadOK(tuple, n4 + 1)) continue;
            nArray = Array.insert(nArray, this.makeEarleyCell(n5, n4 + 1));
        }
        if (nArray == null) {
            return;
        }
        if (Visual.visited != null) {
            long l2 = System.nanoTime();
            long[] lArray = Visual.visited[n2];
            int n6 = n + 1;
            lArray[n6] = lArray[n6] + (long)((int)(l2 - l));
        }
        matrix.put(Service.lPair(n2, n + 1), new Earley.EarleyCell(nArray));
        this.allXs = Array.insert(this.allXs, n2);
    }

    @Override
    protected boolean lookaheadOK(Earley.Tuple tuple, int n) {
        if (n > tuple.size() - 1) {
            return true;
        }
        int n2 = tuple.content(n);
        return this.LAsuspect == null || !this.isTerminal(n2) || n2 == this.LAsuspect;
    }

    @Override
    protected boolean isIdentifier(int n, List<LexerToken> list, int n2, Integer n3) {
        if (n2 != this.identifier) {
            return false;
        }
        if (n3 != null && this.keywords.contains(n3)) {
            return false;
        }
        LexerToken lexerToken = list.get(n);
        if (lexerToken.type == Token.DQUOTED_STRING) {
            return true;
        }
        if (lexerToken.type != Token.IDENTIFIER) {
            return false;
        }
        if (n3 == null) {
            return true;
        }
        LexerToken lexerToken2 = null;
        if (0 < n) {
            lexerToken2 = list.get(n - 1);
        }
        return lexerToken2 != null && !"YEAR".equalsIgnoreCase(lexerToken2.content) && !"HOUR".equalsIgnoreCase(lexerToken2.content) && !"MINUTE".equalsIgnoreCase(lexerToken2.content) || !"TO".equalsIgnoreCase(lexerToken.content);
    }

    @Override
    protected boolean notConfusedAsId(int n, int n2, int n3) {
        return !(n == this.begin && (n2 == this.dotted_name || n2 == this.decl_id) && n3 == 0 || n == this.start && n2 == this.table_reference && n3 == 1 || n == this.distinct && n2 == this.multiset_except && n3 == 3);
    }

    void initKeywords() {
        this.keywords.add(this.getSymbol("'SELECT'"));
        this.keywords.add(this.getSymbol("'FROM'"));
        this.keywords.add(this.getSymbol("'WHERE'"));
        this.keywords.add(this.getSymbol("'AND'"));
        this.keywords.add(this.getSymbol("'OR'"));
        this.keywords.add(this.getSymbol("'NOT'"));
        this.keywords.add(this.getSymbol("'UNION'"));
        this.keywords.add(this.getSymbol("'ALL'"));
        this.keywords.add(this.getSymbol("'INNER'"));
        this.keywords.add(this.getSymbol("'LEFT'"));
        this.keywords.add(this.getSymbol("'NATURAL'"));
        this.keywords.add(this.getSymbol("'FULL'"));
        this.keywords.add(this.getSymbol("'OUTER'"));
        this.keywords.add(this.getSymbol("'JOIN'"));
        this.keywords.add(this.getSymbol("'ON'"));
        this.keywords.add(this.getSymbol("'CREATE'"));
        this.keywords.add(this.getSymbol("'ALTER'"));
        this.keywords.add(this.getSymbol("'TABLE'"));
        this.keywords.add(this.getSymbol("'TABLESPACE'"));
        this.keywords.add(this.getSymbol("'VALUES'"));
        this.keywords.add(this.getSymbol("'NUMBER'"));
        this.keywords.add(this.getSymbol("'VARCHAR2'"));
        this.keywords.add(this.getSymbol("'DATE'"));
        this.keywords.add(this.getSymbol("'INTEGER'"));
        this.keywords.add(this.getSymbol("'MULTISET'"));
        this.keywords.add(this.getSymbol("'CASE'"));
        this.keywords.add(this.getSymbol("'WHEN'"));
    }

    @Override
    protected ParseNode tree(List<LexerToken> list, Matrix matrix, int n, int n2, int n3, int n4) {
        if (n + 1 == n2) {
            Earley.Tuple tuple = this.rules[n3];
            if (tuple.rhs[0] == this.function_expression) {
                throw new AssertionError((Object)"unwind tree");
            }
        }
        return super.tree(list, matrix, n, n2, n3, n4);
    }

    static {
        try {
            origRules = UnifiedRules.getRules();
            origRules.remove(new RuleTuple("identifier", new String[]{"idq"}));
            origRules.remove(new RuleTuple("identifier", new String[]{"id"}));
            origRules.add(new RuleTuple("EXEC[UTE]", new String[]{"'EXEC'"}));
            origRules.add(new RuleTuple("EXEC[UTE]", new String[]{"'EXECU'"}));
            origRules.add(new RuleTuple("EXEC[UTE]", new String[]{"'EXECUT'"}));
            origRules.add(new RuleTuple("EXEC[UTE]", new String[]{"'EXECUTE'"}));
            origRules.add(new RuleTuple("EXECUTE", new String[]{"EXEC[UTE]", "stmt"}));
            origRules.add(new RuleTuple("sql_statement", new String[]{"EXECUTE"}));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

