/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.util.Array;
import oracle.dbtools.util.Service;

public class ParseNode
implements Comparable {
    public int from;
    public int to;
    ParseNode lft = null;
    ParseNode rgt = null;
    private int[] symbols = new int[0];
    public Set<ParseNode> topLevel = null;
    private Parser parser;

    public int compareTo(Object object) {
        ParseNode parseNode = (ParseNode)object;
        if (this.from != parseNode.from) {
            return this.from - parseNode.from;
        }
        return this.to - parseNode.to;
    }

    public String toString() {
        return this.toString(0);
    }

    public List<ParseNode> descendants() {
        ArrayList<ParseNode> arrayList = new ArrayList<ParseNode>();
        arrayList.add(this);
        for (ParseNode parseNode : this.children()) {
            arrayList.addAll(parseNode.descendants());
        }
        return arrayList;
    }

    public List<ParseNode> ancestors(int n) {
        return this.intermediates(n, n + 1);
    }

    public List<ParseNode> intermediates(int n, int n2) {
        ArrayList<ParseNode> arrayList = new ArrayList<ParseNode>();
        if (this.from <= n && n2 <= this.to) {
            arrayList.add(this);
        }
        for (ParseNode parseNode : this.children()) {
            if (parseNode.from > n || n2 > parseNode.to) continue;
            arrayList.addAll(parseNode.intermediates(n, n2));
        }
        return arrayList;
    }

    public ParseNode ancestor(int n, int n2, int n3) {
        ParseNode parseNode = this.parent(n, n2);
        if (parseNode == this || parseNode == null) {
            return null;
        }
        if (parseNode.contains(n3)) {
            return parseNode;
        }
        return this.ancestor(parseNode.from, parseNode.to, n3);
    }

    public ParseNode descendant(int n, int n2, int n3) {
        if (this.contains(n3)) {
            return this;
        }
        for (ParseNode parseNode : this.children()) {
            if (parseNode.from > n || n2 > parseNode.to) continue;
            if (parseNode.contains(n3)) {
                return parseNode;
            }
            return parseNode.descendant(n, n2, n3);
        }
        return null;
    }

    public ParseNode parent(int n, int n2) {
        ParseNode parseNode = null;
        ParseNode parseNode2 = this;
        do {
            if (!parseNode2.isAuxiliary()) {
                parseNode = parseNode2;
            }
            if ((parseNode2 = parseNode2.childAt(n, n2)) != null) continue;
            return null;
        } while (parseNode2.from != n || parseNode2.to != n2);
        return parseNode;
    }

    public ParseNode childAt(int n, int n2) {
        if (this.topLevel != null) {
            for (ParseNode parseNode : this.children()) {
                if (parseNode.from > n || n2 > parseNode.to) continue;
                return parseNode;
            }
            return null;
        }
        if (this.lft != null && this.lft.from <= n && n2 <= this.lft.to) {
            return this.lft;
        }
        if (this.rgt != null && this.rgt.from <= n && n2 <= this.rgt.to) {
            return this.rgt;
        }
        return null;
    }

    void print(int n) {
        System.out.println(this.toString(n));
    }

    public ParseNode leafAtPos(int n) {
        if (this.children().size() == 0 && n == this.from) {
            return this;
        }
        for (ParseNode parseNode : this.children()) {
            if (parseNode.from > n || n >= parseNode.to) continue;
            return parseNode.leafAtPos(n);
        }
        return null;
    }

    private void calculateDepth(Map<Long, Integer> map, int n) {
        map.put(Service.lPair(this.from, this.to), n);
        for (ParseNode parseNode : this.children()) {
            parseNode.calculateDepth(map, n + 1);
        }
    }

    Map<Long, Integer> calculateDepth() {
        TreeMap<Long, Integer> treeMap = new TreeMap<Long, Integer>();
        this.calculateDepth(treeMap, 0);
        return treeMap;
    }

    public void printTree() {
        Map<Long, Integer> map = this.calculateDepth();
        boolean bl = false;
        for (ParseNode parseNode : this.descendants()) {
            int n = map.get(Service.lPair(parseNode.from, parseNode.to));
            parseNode.print(n);
        }
    }

    public void printBinaryTree(int n) {
        this.print(n);
        if (this.lft != null) {
            this.lft.printBinaryTree(n + 1);
        }
        if (this.rgt != null) {
            this.rgt.printBinaryTree(n + 1);
        }
        if (this.topLevel != null) {
            for (ParseNode parseNode : this.topLevel) {
                parseNode.printBinaryTree(n + 1);
            }
        }
    }

    public String content(List<LexerToken> list) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (int i = this.from; i < this.to; ++i) {
                stringBuilder.append(list.get((int)i).content);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.err.println("src out of sync with parse tree?");
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, indexOutOfBoundsException.getStackTrace()[0].toString(), indexOutOfBoundsException);
        }
        return stringBuilder.toString();
    }

    public int[] content() {
        return this.symbols;
    }

    public void addContent(int n) {
        this.symbols = Array.insert(this.symbols, n);
    }

    public boolean contains(int n) {
        return this.symbols[Array.indexOf(this.symbols, n)] == n;
    }

    public void addTopLevel(ParseNode parseNode) {
        if (this.topLevel == null) {
            this.topLevel = new TreeSet<ParseNode>();
        }
        this.topLevel.add(parseNode);
    }

    public ParseNode(int n, int n2, int n3, int n4, Parser parser) {
        this.from = n;
        this.to = n2;
        this.addContent(n3);
        this.addContent(n4);
        this.parser = parser;
    }

    protected String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
        stringBuffer.append(this.interval() + " ");
        int[] nArray = this.content();
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            Integer n3 = nArray[i];
            if (n3 == -1) continue;
            String string = this.parser.allSymbols[n3];
            stringBuffer.append("  " + string);
        }
        return stringBuffer.toString();
    }

    public String interval() {
        return "[" + this.from + "," + this.to + ")";
    }

    public boolean isAuxiliary() {
        if (this.contains(-1)) {
            return true;
        }
        if (this.from + 1 == this.to) {
            return false;
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int[] nArray = this.content();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer n2 = nArray[i];
            String string = this.parser.allSymbols[n2];
            if (string.indexOf("+") < 0 || "'+'".equals(string)) {
                bl = false;
            }
            if ("concat".equals(string)) {
                bl2 = true;
            }
            if ("rawbnf".equals(string)) {
                bl3 = true;
            }
            if (!"block".equals(string)) continue;
            bl4 = true;
        }
        return bl;
    }

    public Set<ParseNode> children() {
        TreeSet<ParseNode> treeSet = new TreeSet<ParseNode>();
        if (this.topLevel != null) {
            for (ParseNode parseNode : this.topLevel) {
                if (parseNode.isAuxiliary()) {
                    treeSet.addAll(parseNode.children());
                    continue;
                }
                treeSet.add(parseNode);
            }
            return treeSet;
        }
        if (this.lft == null) {
            return treeSet;
        }
        if (this.lft.isAuxiliary()) {
            treeSet.addAll(this.lft.children());
        } else {
            treeSet.add(this.lft);
        }
        if (this.rgt == null) {
            return treeSet;
        }
        if (this.rgt.isAuxiliary()) {
            treeSet.addAll(this.rgt.children());
        } else {
            treeSet.add(this.rgt);
        }
        return treeSet;
    }

    public void moveInterval(int n) {
        this.from += n;
        this.to += n;
        if (this.topLevel != null) {
            for (ParseNode parseNode : this.topLevel) {
                parseNode.moveInterval(n);
            }
        } else {
            if (this.lft != null) {
                this.lft.moveInterval(n);
            }
            if (this.rgt != null) {
                this.rgt.moveInterval(n);
            }
        }
    }
}

