/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.dbtools.parser.CYK;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.util.Array;
import oracle.dbtools.util.Service;

public class Matrix
extends TreeMap<Long, Cell> {
    private Parser parser;

    public Matrix(Parser parser) {
        this.parser = parser;
    }

    public boolean contains(int n, int n2, int n3) {
        Cell cell = (Cell)this.get(Service.lPair(n, n2));
        if (cell == null) {
            return false;
        }
        boolean bl = this.parser instanceof CYK;
        boolean bl2 = this.parser instanceof Earley;
        for (int i = 0; i < cell.size(); ++i) {
            if (bl && cell.getSymbol(i) == n3) {
                return true;
            }
            if (!bl2) continue;
            Earley earley = (Earley)this.parser;
            Earley.Tuple tuple = earley.rules[cell.getRule(i)];
            if (tuple.head != n3 || tuple.rhs.length != cell.getPosition(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() throws RuntimeException {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            int n = Service.lX(l);
            int n2 = Service.lY(l);
            stringBuffer.append("[" + n + "," + n2 + ")");
            Cell cell = (Cell)this.get(Service.lPair(n, n2));
            if (cell == null) {
                throw new AssertionError((Object)("no value corresponding to the key [" + n + "," + n2 + ")"));
            }
            for (int i = 0; i < cell.size() && i < 6; ++i) {
                if (i == 5) {
                    stringBuffer.append(" ...");
                }
                if (this.parser instanceof CYK) {
                    stringBuffer.append("  " + this.parser.allSymbols[cell.getSymbol(i)]);
                    continue;
                }
                if (this.parser instanceof Earley) {
                    ((Earley)this.parser).toString(cell.getRule(i), cell.getPosition(i), stringBuffer);
                    continue;
                }
                stringBuffer.append("unknown content: " + this.parser.getClass().getName());
                break;
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    List<Integer> getCykBackptrs(int n, int n2, int n3) {
        long l = Service.lPair(n, n2);
        long l2 = Service.lPair(0, n2 + 1);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        SortedMap sortedMap = this.subMap(l, l2);
        for (long l3 : sortedMap.keySet()) {
            Cell cell;
            int n4 = Service.lX(l3);
            Cell cell2 = (Cell)this.get(Service.lPair(n, n4));
            if (cell2 == null || (cell = (Cell)this.get(Service.lPair(n4, n2))) == null) continue;
            for (int n5 : cell2.getContent()) {
                for (int n6 : cell.getContent()) {
                    int n7;
                    int[] nArray = ((CYK)this.parser).doubleRhsRules.get(Service.lPair(n5, n6));
                    if (nArray == null || nArray[n7 = Array.indexOf(nArray, n3)] != n3 || arrayList.contains(n4)) continue;
                    arrayList.add(n4);
                }
            }
        }
        return arrayList;
    }

    List<Integer> getEarleyBackptrs(int n, int n2, Cell cell, int n3) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (n == n2 && n == 0) {
            arrayList.add(n);
            return arrayList;
        }
        int n4 = cell.getRule(n3);
        Earley.Tuple tuple = ((Earley)this.parser).rules[n4];
        int n5 = cell.getPosition(n3);
        if (n == n2) {
            long l = Service.lPair(0, n2);
            long l2 = Service.lPair(n, n2);
            NavigableMap navigableMap = this.subMap(l, true, l2, true);
            Iterator iterator = navigableMap.keySet().iterator();
            block0: while (iterator.hasNext()) {
                long l3 = (Long)iterator.next();
                int n6 = Service.lX(l3);
                Cell cell2 = (Cell)this.get(Service.lPair(n6, n));
                if (cell2 == null) continue;
                for (int i = 0; i < cell2.size(); ++i) {
                    Earley.Tuple tuple2 = ((Earley)this.parser).rules[cell2.getRule(i)];
                    int n7 = cell2.getPosition(i);
                    if (n7 >= tuple2.rhs.length || tuple2.rhs[n7] != tuple.head) continue;
                    if (arrayList.contains(n6)) continue block0;
                    arrayList.add(n6);
                    continue block0;
                }
            }
            return arrayList;
        }
        Cell cell3 = (Cell)this.get(Service.lPair(n, n2 - 1));
        if (cell3 != null) {
            for (int i = 0; i < cell3.size(); ++i) {
                int n8;
                int n9 = cell3.getRule(i);
                if (n4 != n9 || (n8 = cell3.getPosition(i)) + 1 != n5) continue;
                Earley.Tuple tuple3 = ((Earley)this.parser).rules[n9];
                if (tuple3.rhs[n8] != ((Earley)this.parser).identifier && tuple3.rhs[n8] != ((Earley)this.parser).string_literal && tuple3.rhs[n8] != ((Earley)this.parser).digits && this.parser.allSymbols[tuple3.rhs[n8]].charAt(0) != '\'') continue;
                arrayList.add(n2 + 1);
                break;
            }
        }
        long l = Service.lPair(n, n2);
        long l4 = Service.lPair(n2, n2);
        NavigableMap navigableMap = this.subMap(l, true, l4, true);
        Iterator iterator = navigableMap.keySet().iterator();
        block3: while (iterator.hasNext()) {
            Cell cell4;
            long l5 = (Long)iterator.next();
            int n10 = Service.lX(l5);
            Cell cell5 = (Cell)this.get(Service.lPair(n, n10));
            if (cell5 == null || (cell4 = (Cell)this.get(Service.lPair(n10, n2))) == null) continue;
            for (int i = 0; i < cell5.size(); ++i) {
                for (int j = 0; j < cell4.size(); ++j) {
                    int n11;
                    int n12 = cell5.getRule(i);
                    int n13 = cell4.getRule(j);
                    int n14 = cell5.getPosition(i);
                    int n15 = cell4.getPosition(j);
                    Earley.Tuple tuple4 = ((Earley)this.parser).rules[n12];
                    Earley.Tuple tuple5 = ((Earley)this.parser).rules[n13];
                    if (tuple5.size() != n15 || n12 != n4 || n14 + 1 != n5 || (n11 = tuple4.content(n14)) != tuple5.head) continue;
                    arrayList.add(n10);
                    continue block3;
                }
            }
        }
        return arrayList;
    }
}

