/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.parser.Token;
import oracle.dbtools.util.Service;

public class LexerToken {
    public String content;
    public int begin;
    public int end;
    public Token type;

    public LexerToken(CharSequence charSequence, int n, int n2, Token token) {
        this.content = ((Object)charSequence).toString().intern();
        this.begin = n;
        this.end = n2;
        this.type = token;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        return "[" + this.begin + "," + this.end + ") " + this.content + "   <" + (Object)((Object)this.type) + ">";
    }

    public static void print(List<LexerToken> list) {
        int n = 0;
        for (LexerToken lexerToken : list) {
            System.out.print(n + "    ");
            lexerToken.print();
            ++n;
        }
    }

    public static void print(List<LexerToken> list, int n, int n2) {
        LexerToken.print(list, n, n2, false);
    }

    public static void print(List<LexerToken> list, int n, int n2, boolean bl) {
        for (int i = n; i < n2; ++i) {
            if (bl) {
                System.err.print(" " + list.get((int)i).content);
                continue;
            }
            System.out.print(" " + list.get((int)i).content);
        }
        if (bl) {
            System.err.println();
        } else {
            System.out.println();
        }
    }

    private static LinkedList<LexerToken> tokenize(String string, boolean bl) {
        LinkedList<LexerToken> linkedList = new LinkedList<LexerToken>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "(){}[]^-|!*+./><='\",;:%@?/\\# \n\r\t", true);
        int n = 0;
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().intern();
            n += string3.length();
            LexerToken lexerToken = null;
            if (linkedList.size() > 0) {
                lexerToken = linkedList.getLast();
            }
            if (lexerToken != null && lexerToken.type == Token.COMMENT && (!lexerToken.content.endsWith("*/") || lexerToken.content.equals("/*/"))) {
                lexerToken.content = "*".equals(string3) || "/".equals(string3) ? lexerToken.content + string3 : "/* ... ";
                lexerToken.end = n;
                if (lexerToken == null || lexerToken.type != Token.COMMENT || !lexerToken.content.endsWith("*/") || lexerToken.content.equals("/*/")) continue;
                lexerToken.content = string.substring(lexerToken.begin, lexerToken.end);
                continue;
            }
            if (lexerToken != null && lexerToken.type == Token.LINE_COMMENT && !"\n".equals(string3)) {
                lexerToken.content = lexerToken.content + string3;
                continue;
            }
            if (lexerToken != null && lexerToken.type == Token.LINE_COMMENT && "\n".equals(string3)) {
                lexerToken.end = n - string3.length();
                lexerToken.end = lexerToken.begin + lexerToken.content.length();
            }
            if (!(lexerToken == null || lexerToken.type != Token.QUOTED_STRING || "'".equals(string3) || lexerToken.content.endsWith("'") && lexerToken.content.length() > 1)) {
                if ("q".equals(string2)) {
                    string2 = string3;
                }
                lexerToken.content = lexerToken.content.length() < 100 ? lexerToken.content + string3 : "dumMy" + string3;
                lexerToken.end = lexerToken.begin + lexerToken.content.length();
                continue;
            }
            if (!(lexerToken == null || lexerToken.type != Token.QUOTED_STRING || !"'".equals(string3) || string2 != null && !lexerToken.content.endsWith(LexerToken.quoteDelimiter(string2)) || lexerToken.content.endsWith("'") && lexerToken.content.length() > 1 || string2 != null && lexerToken.content.equals("'" + string2))) {
                string2 = null;
                lexerToken.end = n;
                lexerToken.content = string.substring(lexerToken.begin, lexerToken.end).intern();
                continue;
            }
            if (lexerToken != null && lexerToken.type == Token.DQUOTED_STRING && !"\"".equals(string3) && (!lexerToken.content.endsWith("\"") || lexerToken.content.length() <= 1)) continue;
            if (lexerToken != null && lexerToken.type == Token.DQUOTED_STRING && "\"".equals(string3)) {
                lexerToken.end = n;
                lexerToken.content = string.substring(lexerToken.begin, lexerToken.end);
                continue;
            }
            if ("*".equals(string3) && lexerToken != null && "/".equals(lexerToken.content)) {
                lexerToken.content = lexerToken.content + string3;
                lexerToken.end = lexerToken.begin + lexerToken.content.length();
                lexerToken.type = Token.COMMENT;
                continue;
            }
            if ("-".equals(string3) && lexerToken != null && "-".equals(lexerToken.content)) {
                lexerToken.content = lexerToken.content + string3;
                lexerToken.type = Token.LINE_COMMENT;
                continue;
            }
            if (("rem".equalsIgnoreCase(string3) || "rema".equalsIgnoreCase(string3) || "remar".equalsIgnoreCase(string3) || "remark".equalsIgnoreCase(string3)) && (lexerToken == null || "\n".equals(lexerToken.content) || "\r".equals(lexerToken.content))) {
                linkedList.add(new LexerToken(string3, n - 1, -9, Token.LINE_COMMENT));
                continue;
            }
            if ("@".equalsIgnoreCase(string3) && (lexerToken == null || "\n".equals(lexerToken.content) || "\r".equals(lexerToken.content))) {
                linkedList.add(new LexerToken(string3, n - 1, -11, Token.IDENTIFIER));
                continue;
            }
            if (lexerToken != null && lexerToken.type == Token.IDENTIFIER && lexerToken.end == -11 && lexerToken.content.startsWith("@") && !"\n".equals(string3) && !"\r".equals(string3)) {
                lexerToken.content = lexerToken.content + string3;
                continue;
            }
            if (lexerToken != null && lexerToken.type == Token.IDENTIFIER && lexerToken.end == -11 && lexerToken.content.startsWith("@") && ("\n".equals(string3) || "\r".equals(string3))) {
                lexerToken.end = n - 1;
                linkedList.add(new LexerToken(string3, n - 1, n, Token.WS));
                continue;
            }
            if (bl && "'".equals(string3)) {
                if (lexerToken != null && "q".equals(lexerToken.content)) {
                    string2 = "q";
                    lexerToken.content = string3;
                    lexerToken.type = Token.QUOTED_STRING;
                    continue;
                }
                linkedList.add(new LexerToken(string3, n - 1, -10, Token.QUOTED_STRING));
                continue;
            }
            if (bl && "\"".equals(string3)) {
                linkedList.add(new LexerToken(string3, n - 1, -11, Token.DQUOTED_STRING));
                continue;
            }
            if ("(){}[]^-|!*+./><='\",;:%@?/\\#".contains(string3)) {
                linkedList.add(new LexerToken(string3, n - 1, n, Token.OPERATION));
                continue;
            }
            if (" \n\r\t".contains(string3)) {
                linkedList.add(new LexerToken(string3, n - 1, n, Token.WS));
                continue;
            }
            if ('0' <= string3.charAt(0) && string3.charAt(0) <= '9') {
                if (LexerToken.fixedExponent(string3, linkedList, n - string3.length())) continue;
                linkedList.add(new LexerToken(string3, n - string3.length(), n, Token.DIGITS));
                continue;
            }
            linkedList.add(new LexerToken(string3, n - string3.length(), n, Token.IDENTIFIER));
        }
        return linkedList;
    }

    private static boolean fixedExponent(String string, LinkedList<LexerToken> linkedList, int n) {
        if (!(string.contains("e") || string.contains("f") || string.contains("d"))) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "efd", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            n += string2.length();
            if ('0' <= string2.charAt(0) && string2.charAt(0) <= '9') {
                linkedList.add(new LexerToken(string2, n - string2.length(), n, Token.DIGITS));
                continue;
            }
            linkedList.add(new LexerToken(string2, n - string2.length(), n, Token.IDENTIFIER));
        }
        return true;
    }

    public static List<LexerToken> parse(String string) {
        return LexerToken.parse(string, false, true);
    }

    public static List<LexerToken> parse(String string, boolean bl) {
        return LexerToken.parse(string, bl, true);
    }

    public static List<LexerToken> parse(String string, boolean bl, boolean bl2) {
        ArrayList<LexerToken> arrayList = new ArrayList<LexerToken>();
        LexerToken.parse(string, bl, bl2, arrayList);
        return arrayList;
    }

    private static void parse(String string, boolean bl, boolean bl2, List<LexerToken> list) {
        LexerToken lexerToken = null;
        for (LexerToken lexerToken2 : LexerToken.tokenize(string, bl2)) {
            if (lexerToken2.type == Token.QUOTED_STRING) {
                if (lexerToken != null && lexerToken.type == Token.QUOTED_STRING) {
                    lexerToken.content = lexerToken.content + lexerToken2.content;
                    lexerToken.end = lexerToken2.end;
                    continue;
                }
                if (lexerToken != null && lexerToken.type == Token.IDENTIFIER && "n".equalsIgnoreCase(lexerToken.content) && lexerToken.end == lexerToken2.begin) {
                    lexerToken.begin = lexerToken2.begin;
                    lexerToken.end = lexerToken2.end;
                    lexerToken.type = lexerToken2.type;
                    lexerToken.content = lexerToken2.content;
                    continue;
                }
            }
            if (lexerToken2.content.startsWith("@")) {
                lexerToken2.end = lexerToken2.begin + lexerToken2.content.length();
            }
            if ("#".equals(lexerToken2.content) && lexerToken != null && lexerToken.type == Token.IDENTIFIER) {
                ++lexerToken.end;
                lexerToken.content = lexerToken.content + "#";
                continue;
            }
            if (bl || lexerToken2.type != Token.WS && lexerToken2.type != Token.COMMENT && lexerToken2.type != Token.LINE_COMMENT) {
                list.add(lexerToken2);
            }
            lexerToken = lexerToken2;
        }
    }

    public static int scanner2parserOffset(List<LexerToken> list, int n) {
        int n2 = -1;
        for (LexerToken lexerToken : list) {
            ++n2;
            if (lexerToken.end <= n) continue;
            break;
        }
        return n2;
    }

    private static String quoteDelimiter(String string) {
        if ("<".equals(string)) {
            return ">";
        }
        if ("[".equals(string)) {
            return "]";
        }
        if ("{".equals(string)) {
            return "}";
        }
        if ("(".equals(string)) {
            return ")";
        }
        return string;
    }

    public static void moveInterval(List<LexerToken> list, int n) {
        for (LexerToken lexerToken : list) {
            lexerToken.begin += n;
            lexerToken.end += n;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string = Service.readFile(LexerToken.class, "test.sql");
        System.gc();
        long l = System.currentTimeMillis();
        long l2 = Runtime.getRuntime().totalMemory();
        long l3 = Runtime.getRuntime().freeMemory();
        System.out.println("mem=" + (l2 - l3));
        List<LexerToken> list = LexerToken.parse(string, true, true);
        long l4 = System.currentTimeMillis();
        System.out.println("Lexer time = " + (l4 - l));
        System.gc();
        l2 = Runtime.getRuntime().totalMemory();
        l3 = Runtime.getRuntime().freeMemory();
        System.out.println("mem1=" + (l2 - l3));
        System.out.println("#Tokens=" + list.size());
        LexerToken.print(list);
    }
}

