/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.util.Array;
import oracle.dbtools.util.Service;

public class Earley
extends Parser {
    public Tuple[] rules;
    public int identifier = -1;
    protected int string_literal = -1;
    protected int digits = -1;
    protected int[] allXs = null;
    protected Map<Integer, int[]> predicts = new HashMap<Integer, int[]>();
    public boolean skipRanges = true;
    private Map<Long, ParseNode> explored = new HashMap<Long, ParseNode>();

    public static void main(String[] stringArray) throws Exception {
        String string = Service.readFile(Earley.class, "test.sql");
        List<LexerToken> list = LexerToken.parse(string);
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        treeSet.add(new RuleTuple("P", new String[]{"S"}));
        treeSet.add(new RuleTuple("S", new String[]{"S", "'+'", "M"}));
        treeSet.add(new RuleTuple("S", new String[]{"M"}));
        treeSet.add(new RuleTuple("M", new String[]{"M", "'*'", "T"}));
        treeSet.add(new RuleTuple("M", new String[]{"T"}));
        treeSet.add(new RuleTuple("T", new String[]{"'('", "P", "')'"}));
        treeSet.add(new RuleTuple("T", new String[]{"digits"}));
        treeSet.add(new RuleTuple("T", new String[]{"identifier"}));
        treeSet.add(new RuleTuple("T", new String[]{"string_literal"}));
        Earley earley = new Earley(treeSet);
        Matrix matrix = new Matrix(earley);
        Visual visual = null;
        visual = new Visual(list, earley);
        long l = System.currentTimeMillis();
        earley.parse(list, matrix);
        long l2 = System.currentTimeMillis();
        System.out.println("Earley parse time = " + (l2 - l));
        System.out.println("#tokens=" + list.size());
        if (visual != null) {
            visual.draw(matrix);
        }
    }

    public void parse(List<LexerToken> list, Matrix matrix) {
        int n;
        do {
            n = matrix.size();
            if (!this.scan(matrix, list)) break;
            this.complete(matrix);
            this.predict(matrix);
        } while (n != matrix.size());
    }

    public Earley(Set<RuleTuple> set) {
        super(set);
        this.rules = new Tuple[set.size()];
        int n = 0;
        for (RuleTuple ruleTuple : set) {
            if (ruleTuple.rhs.length == 0) {
                throw new AssertionError((Object)("empty production " + ruleTuple.toString()));
            }
            int n2 = (Integer)this.symbolIndexes.get(ruleTuple.head);
            int[] nArray = new int[ruleTuple.rhs.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = (Integer)this.symbolIndexes.get(ruleTuple.rhs[i]);
            }
            this.rules[n++] = new Tuple(n2, nArray);
        }
        this.identifier = (Integer)this.symbolIndexes.get("identifier");
        try {
            this.string_literal = (Integer)this.symbolIndexes.get("string_literal");
            this.digits = (Integer)this.symbolIndexes.get("digits");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.precomputePredictions();
        this.filterSingleRhsRules();
    }

    protected void precomputePredictions() {
        Object object;
        int n;
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        HashMap<Integer, int[]> hashMap2 = new HashMap<Integer, int[]>();
        for (n = 0; n < this.rules.length; ++n) {
            object = (int[])hashMap.get(this.rules[n].head);
            int[] nArray = (int[])hashMap2.get(this.rules[n].head);
            object = Array.insert((int[])object, this.rules[n].rhs[0]);
            nArray = Array.insert(nArray, n);
            hashMap.put(this.rules[n].head, (int[])object);
            hashMap2.put(this.rules[n].head, nArray);
        }
        do {
            n = this.size(hashMap);
            object = hashMap.keySet().iterator();
            while (object.hasNext()) {
                int n2 = (Integer)object.next();
                int[] nArray = (int[])hashMap.get(n2);
                int[] nArray2 = Array.merge(nArray, new int[0]);
                for (int n3 : nArray) {
                    nArray2 = Array.merge(nArray2, (int[])hashMap.get(n3));
                }
                hashMap.put(n2, nArray2);
            }
        } while (n != this.size(hashMap));
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n4 = (Integer)iterator.next();
            int[] nArray = (int[])hashMap2.get(n4);
            for (int n5 : (int[])hashMap.get(n4)) {
                nArray = Array.merge(nArray, (int[])hashMap2.get(n5));
            }
            this.predicts.put(n4, nArray);
        }
    }

    private void filterSingleRhsRules() {
        Object object;
        int n;
        HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        HashMap<Integer, int[]> hashMap2 = new HashMap<Integer, int[]>();
        for (n = 0; n < this.allSymbols.length; ++n) {
            hashMap.put(n, new int[]{n});
        }
        for (n = 0; n < this.rules.length; ++n) {
            object = (int[])hashMap.get(this.rules[n].rhs[0]);
            int[] nArray = (int[])hashMap2.get(this.rules[n].rhs[0]);
            object = Array.insert((int[])object, this.rules[n].head);
            nArray = Array.insert(nArray, this.rules[n].head);
            hashMap.put(this.rules[n].rhs[0], (int[])object);
            hashMap2.put(this.rules[n].rhs[0], nArray);
        }
        do {
            n = this.size(hashMap);
            object = hashMap.keySet().iterator();
            while (object.hasNext()) {
                int n2 = (Integer)object.next();
                int[] nArray = (int[])hashMap.get(n2);
                int[] nArray2 = Array.merge(nArray, new int[0]);
                for (int n3 : nArray) {
                    nArray2 = Array.merge(nArray2, (int[])hashMap.get(n3));
                }
                hashMap.put(n2, nArray2);
            }
        } while (n != this.size(hashMap));
        this.singleRhsRules = new HashSet[this.allSymbols.length];
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n4 = (Integer)iterator.next();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int n5 : (int[])hashMap.get(n4)) {
                hashSet.add(n5);
            }
            this.singleRhsRules[n4] = hashSet;
        }
    }

    private int size(Map<Integer, int[]> map) {
        int n = 0;
        for (int[] nArray : map.values()) {
            n += nArray.length;
        }
        return n;
    }

    EarleyCell insert(EarleyCell earleyCell, int n, int n2) {
        if (earleyCell == null) {
            earleyCell = new EarleyCell(null);
        }
        earleyCell.content = Array.insert(earleyCell.content, this.makeEarleyCell(n, n2));
        return earleyCell;
    }

    protected boolean scan(Matrix matrix, List<LexerToken> list) {
        long l = 0L;
        if (Visual.visited != null) {
            l = System.nanoTime();
        }
        if (matrix.size() == 0) {
            int[] nArray = null;
            for (int i = 0; i < this.rules.length; ++i) {
                Tuple tuple = this.rules[i];
                String string = this.allSymbols[tuple.head];
                if (string.charAt(string.length() - 1) == ')') continue;
                nArray = Array.insert(nArray, this.makeEarleyCell(i, 0));
            }
            matrix.put(Service.lPair(0, 0), new EarleyCell(nArray));
            this.allXs = Array.insert(this.allXs, 0);
            if (Visual.visited != null) {
                long l2 = System.nanoTime();
                long[] lArray = Visual.visited[0];
                lArray[0] = lArray[0] + (long)((int)(l2 - l));
            }
            return true;
        }
        Long l3 = (Long)matrix.lastKey();
        int n = Service.lY(l3);
        if (list.size() <= n) {
            return false;
        }
        LexerToken lexerToken = list.get(n);
        Integer n2 = (Integer)this.symbolIndexes.get("'" + lexerToken.content.toUpperCase() + "'");
        for (int i = this.allXs.length - 1; 0 <= i; --i) {
            int n3 = this.allXs[i];
            this.scan(matrix, n, list, n3, n2);
        }
        this.scan(matrix, n, list, n, n2);
        return true;
    }

    private void scan(Matrix matrix, int n, List<LexerToken> list, int n2, Integer n3) {
        long l = 0L;
        if (Visual.visited != null) {
            l = System.nanoTime();
        }
        int[] nArray = null;
        Cell cell = (Cell)matrix.get(Service.lPair(n2, n));
        if (cell == null) {
            return;
        }
        for (int i = 0; i < cell.size(); ++i) {
            int n4 = cell.getPosition(i);
            int n5 = cell.getRule(i);
            Tuple tuple = this.rules[n5];
            if (tuple.size() - 1 < n4 || !this.isScannedSymbol(n, list, n4, tuple, n3)) continue;
            nArray = Array.insert(nArray, this.makeEarleyCell(n5, n4 + 1));
        }
        if (nArray == null) {
            return;
        }
        if (Visual.visited != null) {
            long l2 = System.nanoTime();
            long[] lArray = Visual.visited[n2];
            int n6 = n + 1;
            lArray[n6] = lArray[n6] + (long)((int)(l2 - l));
        }
        matrix.put(Service.lPair(n2, n + 1), new EarleyCell(nArray));
        this.allXs = Array.insert(this.allXs, n2);
    }

    protected boolean isScannedSymbol(int n, List<LexerToken> list, int n2, Tuple tuple, Integer n3) {
        int n4 = tuple.content(n2);
        LexerToken lexerToken = list.get(n);
        if (n4 == this.digits && lexerToken.type == Token.DIGITS) {
            return true;
        }
        if (n4 == this.string_literal && lexerToken.type == Token.QUOTED_STRING) {
            return true;
        }
        return n3 != null && n3 == n4 || this.isIdentifier(n, list, n4, n3) && (n3 == null || this.notConfusedAsId(n3, tuple.head, n2));
    }

    protected boolean notConfusedAsId(int n, int n2, int n3) {
        return true;
    }

    protected boolean isIdentifier(int n, List<LexerToken> list, int n2, Integer n3) {
        LexerToken lexerToken = list.get(n);
        return n2 == this.identifier && lexerToken.type == Token.IDENTIFIER;
    }

    void predict(Matrix matrix) {
        long l = 0L;
        if (Visual.visited != null) {
            l = System.nanoTime();
        }
        Long l2 = (Long)matrix.lastKey();
        int n = Service.lY(l2);
        long l3 = Service.lPair(n, n);
        EarleyCell earleyCell = (EarleyCell)matrix.get(l3);
        int[] nArray = null;
        if (earleyCell != null) {
            nArray = earleyCell.content;
        }
        NavigableMap navigableMap = matrix.subMap(Service.lPair(0, n), true, l2, true);
        Iterator iterator = navigableMap.keySet().iterator();
        while (iterator.hasNext()) {
            long l4 = (Long)iterator.next();
            Cell cell = (Cell)matrix.get(l4);
            for (int i = 0; i < cell.size(); ++i) {
                int n2 = cell.getPosition(i);
                int n3 = cell.getRule(i);
                Tuple tuple = this.rules[n3];
                if (tuple.size() <= n2) continue;
                int n4 = tuple.content(n2);
                int[] nArray2 = this.predicts.get(n4);
                nArray = Array.merge(nArray, nArray2);
            }
        }
        if (Visual.visited != null) {
            long l5 = System.nanoTime();
            long[] lArray = Visual.visited[n];
            int n5 = n;
            lArray[n5] = lArray[n5] + (long)((int)(l5 - l));
        }
        if (nArray == null || nArray.length <= 0) {
            return;
        }
        matrix.put(l3, new EarleyCell(nArray));
    }

    void complete(Matrix matrix) {
        Long l = (Long)matrix.lastKey();
        int n = Service.lY(l);
        block0: for (int i = this.allXs.length - 1; 0 <= i; --i) {
            int n2 = this.allXs[i];
            long l2 = 0L;
            if (Visual.visited != null) {
                l2 = System.nanoTime();
            }
            EarleyCell earleyCell = null;
            int n3 = n;
            while (true) {
                int n4 = (earleyCell = (EarleyCell)matrix.get(Service.lPair(n2, n))) == null ? 0 : earleyCell.size();
                NavigableMap navigableMap = matrix.subMap(Service.lPair(0, n), true, l, true);
                Iterator iterator = navigableMap.keySet().iterator();
                while (iterator.hasNext()) {
                    Tuple tuple;
                    int n5;
                    int n6;
                    boolean bl;
                    Cell cell;
                    long l3 = (Long)iterator.next();
                    int n7 = Service.lX(l3);
                    Cell cell2 = (Cell)matrix.get(Service.lPair(n2, n7));
                    if (cell2 == null || (cell = (Cell)matrix.get(l3)) == null) continue;
                    HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
                    boolean bl2 = bl = 100 < cell2.size() && 10 < cell.size();
                    if (bl) {
                        for (n6 = 0; n6 < cell.size(); ++n6) {
                            n5 = cell.getRule(n6);
                            Tuple tuple2 = this.rules[n5];
                            hashMap.put(tuple2.head, new int[0]);
                        }
                        for (n6 = 0; n6 < cell2.size(); ++n6) {
                            int n8;
                            int[] nArray;
                            n5 = cell2.getPosition(n6);
                            int n9 = cell2.getRule(n6);
                            tuple = this.rules[n9];
                            if (tuple.size() == n5 || (nArray = (int[])hashMap.get(n8 = tuple.content(n5))) == null) continue;
                            int[] nArray2 = Array.insert(nArray, Service.pair(n9, n5));
                            hashMap.put(n8, nArray2);
                        }
                    }
                    for (n6 = 0; n6 < cell.size(); ++n6) {
                        n5 = cell.getPosition(n6);
                        int n10 = cell.getRule(n6);
                        tuple = this.rules[n10];
                        if (tuple.size() != n5) continue;
                        if (bl) {
                            int[] nArray = (int[])hashMap.get(tuple.head);
                            if (nArray == null) continue;
                            for (int n11 : nArray) {
                                int n12;
                                int n13 = Service.Y(n11);
                                int n14 = Service.X(n11);
                                Tuple tuple3 = this.rules[n14];
                                if (tuple3.size() == n13 || (n12 = tuple3.content(n13)) != tuple.head || !this.lookaheadOK(tuple3, n13 + 1)) continue;
                                earleyCell = this.insert(earleyCell, n14, n13 + 1);
                                if (!this.skipRanges || this.rules[n14].rhs.length != n13 + 1 || n7 >= n3 || this.allSymbols[this.rules[n14].head].charAt(0) == '\"') continue;
                                n3 = n7;
                            }
                            continue;
                        }
                        for (int j = 0; j < cell2.size(); ++j) {
                            int n11;
                            int n15 = cell2.getPosition(j);
                            int n16 = cell2.getRule(j);
                            Tuple tuple4 = this.rules[n16];
                            if (tuple4.size() == n15 || (n11 = tuple4.content(n15)) != tuple.head || !this.lookaheadOK(tuple4, n15 + 1)) continue;
                            earleyCell = this.insert(earleyCell, n16, n15 + 1);
                            if (!this.skipRanges || this.rules[n16].rhs.length != n15 + 1 || n7 >= n3 || this.allSymbols[this.rules[n16].head].charAt(0) == '\"') continue;
                            n3 = n7;
                        }
                    }
                }
                if (this.skipRanges && n2 < n3 && n3 < n) {
                    for (int j = n2 + 1; j < n3; ++j) {
                        this.allXs = Array.delete(this.allXs, j);
                    }
                }
                if (Visual.visited != null) {
                    long l4 = System.nanoTime();
                    Visual.visited[n2][n] = Service.addlY(Visual.visited[n2][n], (int)(l4 - l2));
                }
                if (earleyCell == null || earleyCell.size() == n4) continue block0;
                matrix.put(Service.lPair(n2, n), earleyCell);
            }
        }
    }

    protected boolean lookaheadOK(Tuple tuple, int n) {
        return true;
    }

    void toHtml(int n, int n2, boolean bl, int n3, int n4, int n5, Matrix matrix, StringBuffer stringBuffer) {
        block14: {
            int n6;
            Tuple tuple = this.rules[n];
            String string = "+1";
            if (bl) {
                stringBuffer.append("<b>");
                string = "+2";
            }
            stringBuffer.append("<font size=" + string + " color=blue>" + this.allSymbols[tuple.head] + ":</font> ");
            String string2 = "<font size=" + string + " bgcolor=rgb(150,200,150))>";
            String string3 = "<font size=" + string + " bgcolor=rgb(150,150,200))>";
            stringBuffer.append(string2);
            for (n6 = 0; n6 < tuple.rhs.length; ++n6) {
                if (n2 == n6) {
                    stringBuffer.append("</font>" + string3);
                }
                stringBuffer.append(this.allSymbols[tuple.rhs[n6]] + " ");
            }
            stringBuffer.append("</font>");
            if (bl) {
                stringBuffer.append("</b>");
            }
            if (n4 == -1) {
                return;
            }
            if (!bl || n3 + n5 == 0) break block14;
            if (n4 < n3 || n3 == n5) {
                stringBuffer.append("<i> predict from </i>");
                Cell cell = (Cell)matrix.get(Service.lPair(n4, n5));
                for (int i = 0; i < cell.size(); ++i) {
                    int n7 = cell.getPosition(i);
                    int n8 = cell.getRule(i);
                    Tuple tuple2 = this.rules[n8];
                    if (n7 >= tuple2.rhs.length || tuple2.rhs[n7] != tuple.head) continue;
                    this.toHtml(n8, n7, false, -1, -1, -1, null, stringBuffer);
                    return;
                }
            } else if (n5 < n4) {
                stringBuffer.append("<i> scan from </i>");
                Cell cell = (Cell)matrix.get(Service.lPair(n3, n5 - 1));
                for (int i = 0; i < cell.size(); ++i) {
                    int n9 = cell.getPosition(i);
                    int n10 = cell.getRule(i);
                    Tuple tuple3 = this.rules[n10];
                    if (n10 != n || n9 + 1 != n2) continue;
                    this.toHtml(n10, n9, false, -1, -1, -1, null, stringBuffer);
                    return;
                }
            } else {
                stringBuffer.append("<i> complete from </i>");
                n6 = 0;
                Cell cell = (Cell)matrix.get(Service.lPair(n3, n4));
                Cell cell2 = (Cell)matrix.get(Service.lPair(n4, n5));
                for (int i = 0; i < cell.size(); ++i) {
                    for (int j = 0; j < cell2.size(); ++j) {
                        int n11;
                        int n12 = cell.getPosition(i);
                        int n13 = cell2.getPosition(j);
                        int n14 = cell.getRule(i);
                        int n15 = cell2.getRule(j);
                        Tuple tuple4 = this.rules[n14];
                        Tuple tuple5 = this.rules[n15];
                        if (tuple4.size() != n12 && tuple5.size() != n13 || tuple5.size() != n13 || n14 != n || n12 + 1 != n2 || (n11 = tuple4.content(n12)) != tuple5.head) continue;
                        if (n6 != 0) {
                            stringBuffer.append("<b> or </b>");
                        }
                        this.toHtml(n14, n12, false, -1, -1, -1, null, stringBuffer);
                        stringBuffer.append("<i> and </i>");
                        this.toHtml(n15, n13, false, -1, -1, -1, null, stringBuffer);
                        n6 = 1;
                    }
                }
            }
        }
    }

    void toString(int n, int n2, StringBuffer stringBuffer) {
        Tuple tuple = this.rules[n];
        stringBuffer.append(tuple.toString(n2));
    }

    @Override
    public ParseNode treeForACell(List<LexerToken> list, Matrix matrix, Cell cell, int n, int n2) {
        this.explored = new HashMap<Long, ParseNode>();
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; i < cell.size(); ++i) {
            n3 = cell.getRule(i);
            n4 = cell.getPosition(i);
            if (this.rules[n3].rhs.length != n4) continue;
            return this.tree(list, matrix, n, n2, n3, n4);
        }
        if (n3 != -1 && n4 != -1 && n + 1 == n2) {
            return this.tree(list, matrix, n, n2, n3, n4);
        }
        return null;
    }

    private long encode(int n, int n2, int n3, int n4) {
        return Service.lPair(Service.pair(n, n2), Service.pair(n3, n4));
    }

    protected ParseNode tree(List<LexerToken> list, Matrix matrix, int n, int n2, int n3, int n4) {
        long l = this.encode(n, n2, n3, n4);
        ParseNode parseNode = this.explored.get(l);
        if (parseNode != null) {
            return parseNode;
        }
        ParseNode parseNode2 = this.followScan(list, matrix, n, n2, n3, n4);
        if (parseNode2 == null) {
            parseNode2 = this.followComplete(list, matrix, n, n2, n3, n4);
        }
        this.explored.put(l, parseNode2);
        return parseNode2;
    }

    private ParseNode followScan(List<LexerToken> list, Matrix matrix, int n, int n2, int n3, int n4) {
        Cell cell = (Cell)matrix.get(Service.lPair(n, n2 - 1));
        if (cell == null) {
            return null;
        }
        for (int i = 0; i < cell.size(); ++i) {
            int n5 = cell.getRule(i);
            int n6 = cell.getPosition(i);
            if (n5 != n3 || n6 + 1 != n4) continue;
            Tuple tuple = this.rules[n3];
            LexerToken lexerToken = list.get(n2 - 1);
            Integer n7 = (Integer)this.symbolIndexes.get("'" + lexerToken.content.toUpperCase() + "'");
            if (!this.isScannedSymbol(n2 - 1, list, n6, tuple, n7)) continue;
            ParseNode parseNode = new ParseNode(n2 - 1, n2, this.rules[n5].rhs[n6], this.rules[n5].rhs[n6], this);
            if (n + 1 == n2) {
                if (this.rules[n5].rhs.length == 1) {
                    parseNode.addContent(this.rules[n5].head);
                }
                return parseNode;
            }
            int n8 = this.rules[n5].head;
            if (n4 != this.rules[n5].rhs.length) {
                n8 = -1;
            }
            ParseNode parseNode2 = new ParseNode(n, n2, n8, n8, this);
            parseNode2.lft = this.tree(list, matrix, n, n2 - 1, n5, n6);
            parseNode2.rgt = parseNode;
            return parseNode2;
        }
        return null;
    }

    private ParseNode followComplete(List<LexerToken> list, Matrix matrix, int n, int n2, int n3, int n4) {
        for (int i = n2 - 1; n <= i; --i) {
            Cell cell;
            Cell cell2 = (Cell)matrix.get(Service.lPair(n, i));
            if (cell2 == null || (cell = (Cell)matrix.get(Service.lPair(i, n2))) == null) continue;
            for (int j = 0; j < cell2.size(); ++j) {
                int n5 = cell2.getRule(j);
                int n6 = cell2.getPosition(j);
                if (n5 != n3 || n6 + 1 != n4) continue;
                for (int k = 0; k < cell.size(); ++k) {
                    int n7 = cell.getRule(k);
                    int n8 = cell.getPosition(k);
                    if (this.rules[n7].rhs.length != n8 || this.rules[n5].rhs.length <= n6 || this.rules[n7].head != this.rules[n5].rhs[n6]) continue;
                    int n9 = this.rules[n5].head;
                    if (this.rules[n5].rhs.length != n6 + 1) {
                        n9 = -1;
                    }
                    ParseNode parseNode = new ParseNode(n, n2, n9, n9, this);
                    try {
                        if (n != i) {
                            parseNode.lft = this.tree(list, matrix, n, i, n5, n6);
                            parseNode.rgt = this.tree(list, matrix, i, n2, n7, n8);
                        } else if (n7 != n3 || n8 != n4) {
                            parseNode = this.tree(list, matrix, i, n2, n7, n8);
                            if (n9 != -1) {
                                parseNode.addContent(n9);
                            }
                        }
                    }
                    catch (AssertionError assertionError) {
                        if (((Throwable)((Object)assertionError)).getMessage().startsWith("unwind")) continue;
                        throw assertionError;
                    }
                    return parseNode;
                }
            }
        }
        throw new AssertionError((Object)("unwind " + this.rules[n3].toString(n4) + " @[" + n + "," + n2 + ")"));
    }

    public String print(int n) {
        return this.rules[Service.X(n)].toString(Service.Y(n));
    }

    protected int makeEarleyCell(int n, int n2) {
        return Service.pair(n, n2);
    }

    int ruleFromEarleyCell(int n) {
        return Service.X(n);
    }

    public class EarleyCell
    implements Cell {
        int[] content = null;

        public EarleyCell(int[] nArray) {
            this.content = nArray;
        }

        @Override
        public int getSymbol(int n) {
            throw new AssertionError((Object)"N/A");
        }

        @Override
        public int getRule(int n) {
            return Service.X(this.content[n]);
        }

        @Override
        public int getPosition(int n) {
            return Service.Y(this.content[n]);
        }

        @Override
        public int size() {
            return this.content.length;
        }

        @Override
        public int[] getContent() {
            throw new AssertionError((Object)"Legacy CYK method called by Earley");
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("{ ");
            for (int i = 0; i < this.content.length; ++i) {
                if (0 < i) {
                    stringBuilder.append(" , ");
                }
                Tuple tuple = Earley.this.rules[this.getRule(i)];
                stringBuilder.append(tuple.toString(this.getPosition(i)));
            }
            stringBuilder.append(" }");
            return stringBuilder.toString();
        }
    }

    public class Tuple
    implements Comparable<Tuple> {
        public int head;
        public int[] rhs;

        public Tuple(int n, int[] nArray) {
            this.head = n;
            this.rhs = nArray;
        }

        public int size() {
            return this.rhs.length;
        }

        public int content(int n) {
            return this.rhs[n];
        }

        public boolean equals(Object object) {
            return this == object || object instanceof Tuple && this.compareTo((Tuple)object) == 0;
        }

        public int hashCode() {
            throw new RuntimeException("hashCode inconssitent with equals");
        }

        @Override
        public int compareTo(Tuple tuple) {
            if (this.head == 0 || tuple.head == 0) {
                throw new RuntimeException("head==0 || src.head==0");
            }
            int n = this.head - tuple.head;
            if (n != 0) {
                return n;
            }
            n = this.rhs.length - tuple.rhs.length;
            if (n != 0) {
                return n;
            }
            for (int i = 0; i < this.rhs.length; ++i) {
                n = this.rhs[i] - tuple.rhs[i];
                if (n == 0) continue;
                return n;
            }
            return 0;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(Earley.this.allSymbols[this.head] + ":");
            for (int n : this.rhs) {
                stringBuilder.append("  " + Earley.this.allSymbols[n]);
            }
            stringBuilder.append(";");
            return stringBuilder.toString();
        }

        public String toString(int n) {
            StringBuilder stringBuilder = new StringBuilder(Earley.this.allSymbols[this.head] + ":");
            for (int i = 0; i < this.rhs.length; ++i) {
                stringBuilder.append(' ');
                if (n == i) {
                    stringBuilder.append('!');
                }
                stringBuilder.append(Earley.this.allSymbols[this.rhs[i]]);
            }
            if (n == this.rhs.length) {
                stringBuilder.append('!');
            }
            stringBuilder.append(";");
            return stringBuilder.toString();
        }
    }
}

