/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.datamodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.DistinctArrayList;
import oracle.xml.xqxp.datamodel.FSChoiceType;
import oracle.xml.xqxp.datamodel.FSMultiArgType;
import oracle.xml.xqxp.datamodel.FSPrimeChoiceType;
import oracle.xml.xqxp.datamodel.FSSequenceType;
import oracle.xml.xqxp.datamodel.FSType;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;

public class FSTypeUtil {
    public static final int QUANTIFIER_SUM = 0;
    public static final int QUANTIFIER_CHOICE = 1;
    public static final int QUANTIFIER_PRODUCT = 2;
    private static final int[][] sumTable = new int[][]{{3, 3, 3, 3}, {3, 4, 3, 4}, {3, 3, 3, 3}, {3, 4, 3, 4}};
    private static final int[][] choiceTable = new int[][]{{1, 2, 3, 4}, {2, 2, 4, 4}, {3, 4, 3, 4}, {4, 4, 4, 4}};
    private static final int[][] productTable = choiceTable;
    private static final boolean[][] lessThanTable = new boolean[][]{{true, true, true, true}, {false, true, false, true}, {false, false, true, true}, {false, false, false, true}};
    public static QName UNTYPED_ATOMIC_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "untypedAtomic");
    public static QName UNTYPED_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "untyped");
    public static int EBV_VALID = 0;
    public static int EBV_INVALID = 1;
    public static int EBV_UNKNOWN = 2;
    public static int EBV_VALUE_TRUE = 3;
    public static int EBV_VALUE_FALSE = 4;
    private static int[] aggregateQuan = new int[]{2, 2, 1, 1};

    public static int calculateQuantifier(int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                return sumTable[n - 1][n2 - 1];
            }
            case 1: {
                return choiceTable[n - 1][n2 - 1];
            }
            case 2: {
                return productTable[n - 1][n2 - 1];
            }
        }
        return 99;
    }

    public static boolean quantifierLessThan(int n, int n2) {
        if (n == n2) {
            return true;
        }
        return lessThanTable[n - 1][n2 - 1];
    }

    public static boolean quantifierAtLeastOne(int n) {
        return n == 1 || n == 3;
    }

    public static int castable(FSType fSType, OXMLSequenceType oXMLSequenceType) {
        switch (fSType.getKind()) {
            case 2: {
                return FSTypeUtil.castable((OXMLSequenceType)fSType, oXMLSequenceType);
            }
            case 6: {
                FSPrimeChoiceType fSPrimeChoiceType = (FSPrimeChoiceType)fSType;
                if (fSPrimeChoiceType.types == null) {
                    return oXMLSequenceType == OXMLSequenceType.EMPTY_SEQUENCE ? 0 : 1;
                }
                int n = fSPrimeChoiceType.types.size();
                for (int i = 0; i < n; ++i) {
                    int n2 = FSTypeUtil.castable((OXMLSequenceType)fSPrimeChoiceType.types.get(i), oXMLSequenceType);
                    if (n2 == 1) {
                        return 1;
                    }
                    if (n2 != 2) continue;
                    return 2;
                }
                return 0;
            }
        }
        return 2;
    }

    private static int castable(OXMLSequenceType oXMLSequenceType, OXMLSequenceType oXMLSequenceType2) {
        if (oXMLSequenceType.isAnyAtomicType() || oXMLSequenceType2.isAnyAtomicType()) {
            return 2;
        }
        if (oXMLSequenceType == oXMLSequenceType2) {
            return 0;
        }
        if (oXMLSequenceType.isOfType(oXMLSequenceType2)) {
            return 0;
        }
        int n = oXMLSequenceType2.getPrimitiveId();
        int n2 = oXMLSequenceType.getPrimitiveId();
        int n3 = n2 = n2 == 22 ? 5 : n2;
        if (n == 22) {
            return OXMLItem.castTable[n2][5] ? 0 : 1;
        }
        if (OXMLItem.castTable[n2][n]) {
            return 0;
        }
        return 1;
    }

    private static int getBasicType(int n) {
        int n2 = n;
        if (n == 21 || n == 20) {
            n2 = 6;
        } else if (n == 22) {
            n2 = 5;
        }
        return n2;
    }

    public static FSType arithmeticOK(FSType fSType, FSType fSType2, int n) {
        DistinctArrayList distinctArrayList = new DistinctArrayList();
        switch (fSType.getKind()) {
            case 2: {
                FSTypeUtil.arithmeticOK((OXMLSequenceType)fSType, fSType2, n, distinctArrayList);
                break;
            }
            case 6: {
                FSPrimeChoiceType fSPrimeChoiceType = (FSPrimeChoiceType)fSType;
                if (fSPrimeChoiceType.types == null) break;
                int n2 = fSPrimeChoiceType.types.size();
                for (int i = 0; i < n2; ++i) {
                    FSTypeUtil.arithmeticOK((OXMLSequenceType)fSPrimeChoiceType.types.get(i), fSType2, n, distinctArrayList);
                }
                break;
            }
            default: {
                throw new XQException("invalid FSType - arithmeticOK");
            }
        }
        int n3 = distinctArrayList.size();
        if (n3 > 0) {
            return n3 == 1 ? (FSType)distinctArrayList.get(0) : new FSPrimeChoiceType(distinctArrayList.getArrayList());
        }
        return null;
    }

    private static void arithmeticOK(OXMLSequenceType oXMLSequenceType, FSType fSType, int n, DistinctArrayList distinctArrayList) {
        switch (fSType.getKind()) {
            case 2: {
                OXMLSequenceType oXMLSequenceType2 = FSTypeUtil.arithmeticOK(oXMLSequenceType, (OXMLSequenceType)fSType, n);
                if (oXMLSequenceType2 != null) {
                    distinctArrayList.add(oXMLSequenceType2);
                }
                return;
            }
            case 6: {
                FSPrimeChoiceType fSPrimeChoiceType = (FSPrimeChoiceType)fSType;
                if (fSPrimeChoiceType.types == null) {
                    return;
                }
                int n2 = fSPrimeChoiceType.types.size();
                for (int i = 0; i < n2; ++i) {
                    OXMLSequenceType oXMLSequenceType3 = FSTypeUtil.arithmeticOK(oXMLSequenceType, (OXMLSequenceType)fSPrimeChoiceType.types.get(i), n);
                    if (oXMLSequenceType3 == null) continue;
                    distinctArrayList.add(oXMLSequenceType3);
                }
                break;
            }
            default: {
                throw new XQException("invalid FSType - arithmeticOK");
            }
        }
    }

    private static OXMLSequenceType arithmeticOK(OXMLSequenceType oXMLSequenceType, OXMLSequenceType oXMLSequenceType2, int n) {
        if (oXMLSequenceType.isAnyAtomicType()) {
            return oXMLSequenceType;
        }
        if (oXMLSequenceType2.isAnyAtomicType()) {
            return oXMLSequenceType2;
        }
        int n2 = oXMLSequenceType.getPrimitiveId();
        int n3 = oXMLSequenceType2.getPrimitiveId();
        int n4 = -1;
        try {
            n4 = OXMLItem.getCase(FSTypeUtil.getBasicType(n2), FSTypeUtil.getBasicType(n3), n);
        }
        catch (XQException xQException) {
            return null;
        }
        if (n4 >= 17 && n4 <= 20 || n4 == 37) {
            return oXMLSequenceType;
        }
        if (n4 == 36 || n4 == 38) {
            return oXMLSequenceType2;
        }
        if (n4 != 0 && n4 != 12 && n2 == 22 && n3 == 22) {
            return oXMLSequenceType;
        }
        return OXMLSequenceType.arithmeticTypeMatching[n4];
    }

    public static int gtComparisonOK(FSType fSType) {
        switch (fSType.getKind()) {
            case 2: {
                return FSTypeUtil.gtComparisonOK((OXMLSequenceType)fSType);
            }
            case 6: {
                FSPrimeChoiceType fSPrimeChoiceType = (FSPrimeChoiceType)fSType;
                if (fSPrimeChoiceType.types == null) {
                    return 0;
                }
                int n = fSPrimeChoiceType.types.size();
                boolean bl = true;
                boolean bl2 = true;
                for (int i = 0; i < n; ++i) {
                    int n2 = FSTypeUtil.gtComparisonOK((OXMLSequenceType)fSPrimeChoiceType.types.get(i));
                    if (n2 == 0) {
                        bl = false;
                        continue;
                    }
                    if (n2 == 1) {
                        bl2 = false;
                        continue;
                    }
                    bl2 = false;
                    bl = false;
                }
                return bl2 ? 0 : (bl ? 1 : 2);
            }
        }
        throw new XQException("invalid FSType - comparisonOK");
    }

    private static int gtComparisonOK(OXMLSequenceType oXMLSequenceType) {
        if (oXMLSequenceType.isAnyAtomicType()) {
            return 2;
        }
        int n = oXMLSequenceType.getPrimitiveId();
        switch (n) {
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return 1;
            }
        }
        return 0;
    }

    public static int valueComparisonOK(FSType fSType, FSType fSType2, int n) {
        return FSTypeUtil.comparisonOK(fSType, fSType2, n, false);
    }

    public static int generalComparisonOK(FSType fSType, FSType fSType2, int n) {
        return FSTypeUtil.comparisonOK(fSType, fSType2, n, true);
    }

    private static int comparisonOK(FSType fSType, FSType fSType2, int n, boolean bl) {
        switch (fSType.getKind()) {
            case 2: {
                return FSTypeUtil.comparisonOK((OXMLSequenceType)fSType, fSType2, n, bl);
            }
            case 6: {
                FSPrimeChoiceType fSPrimeChoiceType = (FSPrimeChoiceType)fSType;
                if (fSPrimeChoiceType.types == null) {
                    return fSType2.isEmpty() ? 0 : 1;
                }
                int n2 = fSPrimeChoiceType.types.size();
                boolean bl2 = true;
                boolean bl3 = true;
                for (int i = 0; i < n2; ++i) {
                    int n3 = FSTypeUtil.comparisonOK((OXMLSequenceType)fSPrimeChoiceType.types.get(i), fSType2, n, bl);
                    if (n3 == 1) {
                        bl3 = false;
                        continue;
                    }
                    if (n3 == 0) {
                        bl2 = false;
                        continue;
                    }
                    bl3 = false;
                    bl2 = false;
                }
                return bl3 ? 0 : (bl2 ? 1 : 2);
            }
        }
        throw new XQException("invalid FSType - comparisonOK");
    }

    private static int comparisonOK(OXMLSequenceType oXMLSequenceType, FSType fSType, int n, boolean bl) {
        switch (fSType.getKind()) {
            case 2: {
                return FSTypeUtil.comparisonOK(oXMLSequenceType, (OXMLSequenceType)fSType, n, bl);
            }
            case 6: {
                FSPrimeChoiceType fSPrimeChoiceType = (FSPrimeChoiceType)fSType;
                if (fSPrimeChoiceType.types == null) {
                    return oXMLSequenceType.isEmpty() ? 0 : 1;
                }
                int n2 = fSPrimeChoiceType.types.size();
                boolean bl2 = true;
                boolean bl3 = true;
                for (int i = 0; i < n2; ++i) {
                    int n3 = FSTypeUtil.comparisonOK(oXMLSequenceType, (OXMLSequenceType)fSPrimeChoiceType.types.get(i), n, bl);
                    if (n3 == 0) {
                        bl2 = false;
                        continue;
                    }
                    if (n3 == 1) {
                        bl3 = false;
                        continue;
                    }
                    bl3 = false;
                    bl2 = false;
                }
                return bl3 ? 0 : (bl2 ? 1 : 2);
            }
        }
        throw new XQException("invalid FSType - comparisonOK");
    }

    private static int comparisonOK(OXMLSequenceType oXMLSequenceType, OXMLSequenceType oXMLSequenceType2, int n, boolean bl) {
        if (oXMLSequenceType.isAnyAtomicType()) {
            return 2;
        }
        int n2 = oXMLSequenceType.getPrimitiveId();
        int n3 = oXMLSequenceType2.getPrimitiveId();
        switch (n) {
            case 212: 
            case 213: 
            case 214: 
            case 215: {
                switch (n2) {
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 18: 
                    case 19: {
                        return 1;
                    }
                }
                if (n2 == 6 || n3 == 6) {
                    return 1;
                }
                if ((n2 != 20 || n3 != 21) && (n2 != 21 || n3 != 20)) break;
                return 1;
            }
        }
        if (n2 == 0) {
            if (bl) {
                return 0;
            }
            n2 = 1;
        }
        if (oXMLSequenceType2.isAnyAtomicType()) {
            return 2;
        }
        if (n3 == 0) {
            if (bl) {
                return 0;
            }
            n3 = 1;
        }
        if (n2 == n3) {
            return 0;
        }
        if (FSTypeUtil.isNumeric(n2) && FSTypeUtil.isNumeric(n3)) {
            return 0;
        }
        if (n2 == 1 && n3 == 17 || n3 == 1 && n2 == 17) {
            return 0;
        }
        if (!(n2 != 6 && n2 != 21 && n2 != 20 || n3 != 6 && n3 != 21 && n3 != 20)) {
            return 0;
        }
        return 1;
    }

    private static boolean isNumeric(int n) {
        return n <= 5 && n >= 3 || n == 22;
    }

    public static void addPrime(FSType fSType, FSType fSType2, FSPrimeChoiceType fSPrimeChoiceType) {
        FSTypeUtil.addPrime(fSType, fSPrimeChoiceType);
        FSTypeUtil.addPrime(fSType2, fSPrimeChoiceType);
    }

    static void addPrime(FSType fSType, FSPrimeChoiceType fSPrimeChoiceType) {
        FSTypeUtil.addPrime(fSType, fSPrimeChoiceType.types);
    }

    static void addPrime(FSType fSType, ArrayList arrayList) {
        FSType fSType2 = fSType.prime();
        if (fSType2 != null) {
            if (fSType2.getKind() == 6) {
                arrayList.addAll(((FSPrimeChoiceType)fSType2).types);
            } else if (fSType2 != FSType.NoneType) {
                arrayList.add(fSType2);
            }
        } else {
            ((FSMultiArgType)fSType).calculatePrime(arrayList);
        }
    }

    public static boolean calculateFnData(FSType fSType, FSPrimeChoiceType fSPrimeChoiceType) {
        boolean bl = true;
        ArrayList arrayList = new ArrayList();
        FSTypeUtil.addPrime(fSType, arrayList);
        int n = arrayList.size();
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            OXMLSequenceType oXMLSequenceType;
            OXMLSequenceType oXMLSequenceType2 = (OXMLSequenceType)arrayList.get(i);
            if (oXMLSequenceType2 != (oXMLSequenceType = FSTypeUtil.applyDataOn(oXMLSequenceType2))) {
                bl = false;
            }
            FSTypeUtil.addPrime((FSType)oXMLSequenceType, fSPrimeChoiceType);
            n2 = FSTypeUtil.calculateQuantifier(n2, oXMLSequenceType2.quantifier(), 1);
        }
        n2 = FSTypeUtil.calculateQuantifier(n2, fSType.quantifier(), 2);
        fSPrimeChoiceType.setQuantifier(n2);
        return bl;
    }

    public static OXMLSequenceType applyDataOn(OXMLSequenceType oXMLSequenceType) {
        if (oXMLSequenceType.isItemType()) {
            return OXMLSequenceType.ANYATOMIC_ONE;
        }
        if (oXMLSequenceType.isNode()) {
            switch (oXMLSequenceType.getNodeType()) {
                case 1: 
                case 2: {
                    XSDNode xSDNode = oXMLSequenceType.getType();
                    return FSTypeUtil.applyDataOn(xSDNode, oXMLSequenceType.getOccurence());
                }
                case 3: 
                case 4: 
                case 9: 
                case 11: 
                case 92: {
                    return OXMLSequenceType.TUNTYPED;
                }
                case 7: 
                case 8: {
                    return OXMLSequenceType.TSTRING;
                }
                case 90: {
                    return OXMLSequenceType.TUNTYPED;
                }
            }
        }
        return oXMLSequenceType;
    }

    private static OXMLSequenceType applyDataOn(XSDNode xSDNode, int n) {
        if (xSDNode == null) {
            return OXMLSequenceType.getConstantType(n, 0);
        }
        switch (xSDNode.getNodeType()) {
            case 2: {
                return OXMLSequenceType.createValueType((XSDSimpleType)xSDNode, n);
            }
            case 1: {
                XSDComplexType xSDComplexType = (XSDComplexType)xSDNode;
                if (xSDComplexType.isSimpleContent()) {
                    return OXMLSequenceType.createValueType(xSDComplexType.getSimpleType(), n);
                }
                if (xSDComplexType.getContent() == 13) {
                    return OXMLSequenceType.getConstantType(n, 0);
                }
                throw new XQException("FOTY0012");
            }
            case 3: {
                return FSTypeUtil.applyDataOn(((XSDElement)xSDNode).getType(), n);
            }
            case 4: {
                return FSTypeUtil.applyDataOn(((XSDAttribute)xSDNode).getType(), n);
            }
        }
        return OXMLSequenceType.getConstantType(n, 0);
    }

    public static int isInOneOfTypes(FSType fSType, OXMLSequenceType[] oXMLSequenceTypeArray) {
        if (FSTypeUtil.isAnyAtomicType(fSType)) {
            return 2;
        }
        boolean bl = true;
        for (int i = 0; i < oXMLSequenceTypeArray.length; ++i) {
            int n = fSType.instanceOf(oXMLSequenceTypeArray[i]);
            if (n == 0) {
                return n;
            }
            if (n != 2) continue;
            bl = false;
        }
        return bl ? 1 : 2;
    }

    public static int hasEBV(FSType fSType) {
        if (fSType.isEmpty()) {
            return EBV_VALUE_FALSE;
        }
        if (FSTypeUtil.isAnyAtomicType(fSType)) {
            return fSType.quantifier() == 1 ? EBV_UNKNOWN : EBV_INVALID;
        }
        int n = FSTypeUtil.startWithNode(fSType);
        if (n == 0) {
            return EBV_VALUE_TRUE;
        }
        n = fSType.instanceOf(OXMLSequenceType.NODE_ONE_OR_MORE);
        if (n == 0) {
            return EBV_VALUE_TRUE;
        }
        OXMLSequenceType[] oXMLSequenceTypeArray = new OXMLSequenceType[]{OXMLSequenceType.NODE_ZERO_OR_MORE, OXMLSequenceType.TBOOLEAN_ZERO_OR_ONE, OXMLSequenceType.TSTRING_ZERO_OR_ONE, OXMLSequenceType.TANYURI_ZERO_OR_ONE, OXMLSequenceType.TUNTYPED_ZERO_OR_ONE, OXMLSequenceType.NUMERIC_ZERO_OR_ONE};
        return FSTypeUtil.isInOneOfTypes(fSType, oXMLSequenceTypeArray);
    }

    private static int startWithNode(FSType fSType) {
        FSSequenceType fSSequenceType;
        if (fSType.getKind() == 3 && (fSSequenceType = (FSSequenceType)fSType).hasNextType()) {
            int n = fSSequenceType.getNextType().instanceOf(OXMLSequenceType.NODE_ONE);
            fSSequenceType.reset();
            return n;
        }
        return 2;
    }

    public static boolean isAnyAtomicType(FSType fSType) {
        return fSType.getKind() == 2 && ((OXMLSequenceType)fSType).isAnyAtomicType();
    }

    public static boolean isComplicatedType(FSType fSType) {
        return fSType.getKind() > 2;
    }

    public static OXMLSequenceType aggregateFunctionHelper(FSType fSType, String string) {
        OXMLSequenceType oXMLSequenceType;
        boolean bl = fSType.getKind() == 2;
        int n = bl ? 1 : ((FSPrimeChoiceType)fSType).types.size();
        OXMLSequenceType oXMLSequenceType2 = oXMLSequenceType = bl ? (OXMLSequenceType)fSType : (OXMLSequenceType)((FSPrimeChoiceType)fSType).types.get(0);
        if (oXMLSequenceType.isAnyAtomicType()) {
            return oXMLSequenceType;
        }
        if (oXMLSequenceType.isOfType(OXMLSequenceType.TUNTYPED)) {
            oXMLSequenceType = OXMLSequenceType.TDOUBLE;
        } else {
            OXMLSequenceType[] oXMLSequenceTypeArray = null;
            oXMLSequenceTypeArray = string.equals("avg") ? OXMLSequenceType.avgTargetTypes : (string.equals("sum") ? OXMLSequenceType.sumTargetTypes : OXMLSequenceType.minTargetTypes);
            boolean bl2 = false;
            for (int i = 0; i < oXMLSequenceTypeArray.length; ++i) {
                if (!oXMLSequenceType.isOfTypeIgnoreOccurence(oXMLSequenceTypeArray[i])) continue;
                oXMLSequenceType = oXMLSequenceTypeArray[i];
                bl2 = true;
                break;
            }
            if (!bl2) {
                return null;
            }
        }
        for (int i = 1; i < n && (oXMLSequenceType = FSTypeUtil.promoteType(oXMLSequenceType, (OXMLSequenceType)((FSPrimeChoiceType)fSType).types.get(i))) != null && !oXMLSequenceType.isAnyAtomicType(); ++i) {
        }
        return oXMLSequenceType;
    }

    public static int aggregateQuantifier(int n) {
        return aggregateQuan[n - 1];
    }

    public static int typePromotable(FSType fSType, OXMLSequenceType oXMLSequenceType) {
        switch (fSType.getKind()) {
            case 2: {
                return FSTypeUtil.typePromotable((OXMLSequenceType)fSType, oXMLSequenceType);
            }
            case 6: {
                FSPrimeChoiceType fSPrimeChoiceType = (FSPrimeChoiceType)fSType;
                if (fSPrimeChoiceType.types == null) {
                    return oXMLSequenceType.isEmpty() ? 0 : 1;
                }
                int n = fSPrimeChoiceType.types.size();
                boolean bl = true;
                boolean bl2 = true;
                for (int i = 0; i < n; ++i) {
                    int n2 = FSTypeUtil.typePromotable((OXMLSequenceType)fSPrimeChoiceType.types.get(i), oXMLSequenceType);
                    if (n2 == 0) {
                        bl = false;
                        continue;
                    }
                    if (n2 == 1) {
                        bl2 = false;
                        continue;
                    }
                    bl2 = false;
                    bl = false;
                }
                return bl2 ? 0 : (bl ? 1 : 2);
            }
        }
        return 2;
    }

    private static int typePromotable(OXMLSequenceType oXMLSequenceType, OXMLSequenceType oXMLSequenceType2) {
        if (oXMLSequenceType.isAnyAtomicType()) {
            return 2;
        }
        if (oXMLSequenceType == oXMLSequenceType2) {
            return 0;
        }
        if (oXMLSequenceType.isOfTypeIgnoreOccurence(oXMLSequenceType2)) {
            return 0;
        }
        int n = oXMLSequenceType.getPrimitiveId();
        int n2 = oXMLSequenceType2.getPrimitiveId();
        boolean bl = false;
        if (FSTypeUtil.isNumeric(n) && FSTypeUtil.isNumeric(n2)) {
            switch (n2) {
                case 22: {
                    bl = n == 22;
                    break;
                }
                case 5: {
                    bl = n == 22 || n == 5;
                    break;
                }
                case 3: {
                    bl = n != 4;
                    break;
                }
                case 4: {
                    bl = true;
                }
            }
            return bl ? 0 : 1;
        }
        if (n2 == 1 && n == 17) {
            return 0;
        }
        return 1;
    }

    private static OXMLSequenceType promoteType(OXMLSequenceType oXMLSequenceType, OXMLSequenceType oXMLSequenceType2) {
        if (oXMLSequenceType2.isAnyAtomicType()) {
            return oXMLSequenceType2;
        }
        if (oXMLSequenceType2.isOfType(OXMLSequenceType.TUNTYPED)) {
            oXMLSequenceType2 = OXMLSequenceType.TDOUBLE;
        }
        if (oXMLSequenceType == oXMLSequenceType2) {
            return oXMLSequenceType;
        }
        if (oXMLSequenceType2.isOfTypeIgnoreOccurence(oXMLSequenceType)) {
            return oXMLSequenceType;
        }
        int n = oXMLSequenceType.getPrimitiveId();
        int n2 = oXMLSequenceType2.getPrimitiveId();
        if (FSTypeUtil.isNumeric(n) && FSTypeUtil.isNumeric(n2)) {
            switch (n) {
                case 22: {
                    return oXMLSequenceType2;
                }
                case 5: {
                    return n2 == 22 ? oXMLSequenceType : oXMLSequenceType2;
                }
                case 3: {
                    return n2 == 4 ? oXMLSequenceType2 : oXMLSequenceType;
                }
                case 4: {
                    return oXMLSequenceType;
                }
            }
        }
        if (n == 1 && n2 == 17 || n2 == 1 && n == 17) {
            return OXMLSequenceType.TSTRING;
        }
        return null;
    }

    static void appendQuanString(int n, StringBuffer stringBuffer) {
        switch (n) {
            case 2: {
                stringBuffer.append('?');
                break;
            }
            case 3: {
                stringBuffer.append('+');
                break;
            }
            case 4: 
            case 99: {
                stringBuffer.append('*');
            }
        }
    }

    private static void getTopLevelElements(XSDNode xSDNode, int n, DistinctArrayList distinctArrayList) {
        OXMLSequenceType oXMLSequenceType = OXMLSequenceType.createNodeType(xSDNode, n);
        distinctArrayList.add(oXMLSequenceType);
    }

    private static void getTopLevelElements(XMLSchemaNode xMLSchemaNode, int n, String string, DistinctArrayList distinctArrayList) {
        if (string.equals("*")) {
            XSDNode[] xSDNodeArray = xMLSchemaNode.getElementSet();
            for (int i = 0; i < xSDNodeArray.length; ++i) {
                FSTypeUtil.getTopLevelElements(xSDNodeArray[i], n, distinctArrayList);
            }
        } else {
            XSDElement xSDElement = xMLSchemaNode.getElement(string);
            if (xSDElement != null) {
                FSTypeUtil.getTopLevelElements(xSDElement, n, distinctArrayList);
            }
        }
    }

    private static void getTopLevelElementsKindTest(XMLSchema xMLSchema, int n, OXMLSequenceType oXMLSequenceType, DistinctArrayList distinctArrayList) {
        Hashtable hashtable = xMLSchema.getXMLSchemaNodeTable();
        for (XMLSchemaNode xMLSchemaNode : hashtable.values()) {
            XSDNode[] xSDNodeArray = xMLSchemaNode.getElementSet();
            for (int i = 0; i < xSDNodeArray.length; ++i) {
                FSTypeUtil.addTypeKindTest(xSDNodeArray[i], n, oXMLSequenceType, distinctArrayList, false);
            }
        }
    }

    private static void getTopLevelElements(XMLSchema xMLSchema, int n, String string, String string2, DistinctArrayList distinctArrayList) {
        if (string.equals("*")) {
            Hashtable hashtable = xMLSchema.getXMLSchemaNodeTable();
            Iterator iterator = hashtable.values().iterator();
            while (iterator.hasNext()) {
                FSTypeUtil.getTopLevelElements((XMLSchemaNode)iterator.next(), n, string2, distinctArrayList);
            }
            return;
        }
        XMLSchemaNode xMLSchemaNode = xMLSchema.getSchemaByTargetNS(string);
        if (xMLSchemaNode != null) {
            FSTypeUtil.getTopLevelElements(xMLSchemaNode, n, string2, distinctArrayList);
        }
    }

    public static FSType kindTest(FSType fSType, OXMLSequenceType oXMLSequenceType, boolean bl, boolean bl2) {
        switch (fSType.getKind()) {
            case 2: {
                return FSTypeUtil.kindTest((OXMLSequenceType)fSType, oXMLSequenceType, bl, bl2);
            }
            case 3: 
            case 4: 
            case 6: {
                FSMultiArgType fSMultiArgType = (FSMultiArgType)fSType;
                fSMultiArgType.reset();
                DistinctArrayList distinctArrayList = new DistinctArrayList();
                while (fSMultiArgType.hasNextType()) {
                    OXMLSequenceType oXMLSequenceType2 = fSMultiArgType.getNextType();
                    OXMLSequenceType oXMLSequenceType3 = FSTypeUtil.kindTest(oXMLSequenceType2, oXMLSequenceType, bl, bl2);
                    if (oXMLSequenceType3 == null) continue;
                    distinctArrayList.add(oXMLSequenceType3);
                }
                return FSTypeUtil.getTypeFromArrayList(distinctArrayList);
            }
        }
        return null;
    }

    private static OXMLSequenceType kindTest(OXMLSequenceType oXMLSequenceType, OXMLSequenceType oXMLSequenceType2) {
        return FSTypeUtil.kindTest(oXMLSequenceType, oXMLSequenceType2, false, false);
    }

    private static OXMLSequenceType kindTest(OXMLSequenceType oXMLSequenceType, OXMLSequenceType oXMLSequenceType2, boolean bl, boolean bl2) {
        QName qName;
        int n = oXMLSequenceType.isOfStaticTypeIgnoreOccurence(oXMLSequenceType2);
        if (n == 0) {
            return oXMLSequenceType;
        }
        int n2 = bl || bl2 ? 4 : 2;
        int n3 = oXMLSequenceType.getNodeType();
        QName qName2 = qName = n3 == 1 ? UNTYPED_QNAME : UNTYPED_ATOMIC_QNAME;
        if (n == 2) {
            return OXMLSequenceType.createSequenceType(oXMLSequenceType2, n2, oXMLSequenceType.getNodeName(), bl2 ? qName : null);
        }
        n = oXMLSequenceType2.isOfStaticTypeIgnoreOccurence(oXMLSequenceType);
        if (n != 1) {
            return OXMLSequenceType.createSequenceType(oXMLSequenceType2, n2, oXMLSequenceType.getNodeName(), bl2 ? qName : null);
        }
        return null;
    }

    public static FSType nameTest(FSType fSType, String string, String string2, int n, boolean bl, boolean bl2) {
        boolean bl3 = string.equals("*") || string2.equals("*");
        switch (fSType.getKind()) {
            case 2: {
                return FSTypeUtil.nameTest((OXMLSequenceType)fSType, string, string2, n, bl, bl2);
            }
            case 3: 
            case 4: 
            case 6: {
                FSMultiArgType fSMultiArgType = (FSMultiArgType)fSType;
                fSMultiArgType.reset();
                DistinctArrayList distinctArrayList = new DistinctArrayList();
                while (fSMultiArgType.hasNextType()) {
                    OXMLSequenceType oXMLSequenceType = fSMultiArgType.getNextType();
                    if ((oXMLSequenceType = FSTypeUtil.nameTest(oXMLSequenceType, string, string2, n, bl, bl2)) == null) continue;
                    distinctArrayList.add(oXMLSequenceType);
                }
                return FSTypeUtil.getTypeFromArrayList(distinctArrayList);
            }
        }
        return null;
    }

    private static OXMLSequenceType nameTest(OXMLSequenceType oXMLSequenceType, String string, String string2, int n, boolean bl, boolean bl2) {
        if (oXMLSequenceType.getNodeType() != n) {
            return null;
        }
        QName qName = oXMLSequenceType.getNodeName();
        if (qName == null || FSTypeUtil.isWildcard(qName)) {
            return bl || bl2 ? FSTypeUtil.nodeTestNoSchema(string, string2, null, n, bl2) : oXMLSequenceType;
        }
        boolean bl3 = FSTypeUtil.isWildcard(string);
        boolean bl4 = FSTypeUtil.isWildcard(string2);
        if (!bl3 && !string.equals(qName.getNamespaceURI())) {
            return null;
        }
        if (!bl4 && !string2.equals(qName.getLocalPart())) {
            return null;
        }
        if (bl3 && bl4) {
            return oXMLSequenceType;
        }
        return bl || bl2 ? FSTypeUtil.nodeTestNoSchema(bl3 ? qName.getNamespaceURI() : string, bl4 ? qName.getLocalPart() : string2, null, n, bl2) : oXMLSequenceType;
    }

    private static boolean isWildcard(String string) {
        return string == null || string.equals("*");
    }

    private static boolean isWildcard(QName qName) {
        String string = qName.getNamespaceURI();
        String string2 = qName.getLocalPart();
        return FSTypeUtil.isWildcard(string) && FSTypeUtil.isWildcard(string2);
    }

    private static boolean nameTest(XSDNode xSDNode, String string, String string2, int n) {
        int n2 = xSDNode.getNodeType();
        switch (n2) {
            case 0: 
            case 3: {
                if (n == 1) break;
                return false;
            }
            case 4: 
            case 7: {
                if (n == 2) break;
                return false;
            }
            default: {
                throw new XQException("invalid XSDNode type");
            }
        }
        switch (n2) {
            case 3: 
            case 4: {
                if (!FSTypeUtil.isNamespaceAllowed(string, xSDNode) || !string2.equals("*") && !string2.equals(xSDNode.getName())) break;
                return true;
            }
            case 0: 
            case 7: {
                XSDAny xSDAny = (XSDAny)xSDNode;
                if (!FSTypeUtil.isNamespaceAllowed(string, xSDNode)) break;
                return true;
            }
            default: {
                throw new XQException("invalid XSDNode type");
            }
        }
        return false;
    }

    public static void getDescendantType(FSType fSType, XMLSchema xMLSchema, HashMap hashMap, HashMap hashMap2, boolean bl) {
        switch (fSType.getKind()) {
            case 2: {
                if (bl) {
                    hashMap2.put(fSType, fSType);
                }
                FSTypeUtil.getDescendantType((OXMLSequenceType)fSType, xMLSchema, hashMap, hashMap2);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                FSMultiArgType fSMultiArgType = (FSMultiArgType)fSType;
                fSMultiArgType.reset();
                while (fSMultiArgType.hasNextType()) {
                    OXMLSequenceType oXMLSequenceType = fSMultiArgType.getNextType();
                    if (bl) {
                        hashMap2.put(oXMLSequenceType, oXMLSequenceType);
                    }
                    FSTypeUtil.getDescendantType(oXMLSequenceType, xMLSchema, hashMap, hashMap2);
                }
                break;
            }
        }
    }

    private static void getDescendantType(OXMLSequenceType oXMLSequenceType, XMLSchema xMLSchema, HashMap hashMap, HashMap hashMap2) {
        DistinctArrayList distinctArrayList = new DistinctArrayList();
        FSType fSType = FSTypeUtil.getChildType(oXMLSequenceType, xMLSchema, hashMap, "*", "*", null, distinctArrayList);
        if (fSType != null) {
            FSTypeUtil.getDescendantType(fSType, xMLSchema, hashMap, hashMap2, true);
            return;
        }
        int n = distinctArrayList.size();
        if (n <= 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            OXMLSequenceType oXMLSequenceType2 = (OXMLSequenceType)distinctArrayList.get(i);
            if (hashMap2.containsKey(oXMLSequenceType2)) continue;
            hashMap2.put(oXMLSequenceType2, oXMLSequenceType2);
            FSTypeUtil.getDescendantType(oXMLSequenceType2, xMLSchema, hashMap, hashMap2);
        }
    }

    public static FSType getChildType(FSType fSType, XMLSchema xMLSchema, HashMap hashMap, String string, String string2, OXMLSequenceType oXMLSequenceType) {
        DistinctArrayList distinctArrayList = new DistinctArrayList();
        switch (fSType.getKind()) {
            case 2: {
                OXMLSequenceType oXMLSequenceType2 = (OXMLSequenceType)fSType;
                FSType fSType2 = FSTypeUtil.getChildType(oXMLSequenceType2, xMLSchema, hashMap, string, string2, oXMLSequenceType, distinctArrayList);
                if (fSType2 == null) break;
                return fSType2;
            }
            case 3: 
            case 4: 
            case 6: {
                FSMultiArgType fSMultiArgType = (FSMultiArgType)fSType;
                FSTypeUtil.getChildType(fSMultiArgType, xMLSchema, hashMap, string, string2, oXMLSequenceType, distinctArrayList);
            }
        }
        return FSTypeUtil.getTypeFromArrayList(distinctArrayList);
    }

    private static FSType applyNodeTest(FSType fSType, String string, String string2, OXMLSequenceType oXMLSequenceType, int n) {
        FSType fSType2 = null;
        fSType2 = oXMLSequenceType == null ? FSTypeUtil.nameTest(fSType, string, string2, n, false, false) : FSTypeUtil.kindTest(fSType, oXMLSequenceType, false, false);
        return fSType2;
    }

    private static FSType getChildType(OXMLSequenceType oXMLSequenceType, XMLSchema xMLSchema, HashMap hashMap, String string, String string2, OXMLSequenceType oXMLSequenceType2, DistinctArrayList distinctArrayList) {
        FSType fSType = oXMLSequenceType.getChildrenType();
        if (fSType != null) {
            return FSTypeUtil.applyNodeTest(fSType, string, string2, oXMLSequenceType2, 1);
        }
        if (oXMLSequenceType.isNodeType(9)) {
            FSTypeUtil.getChildTypeFromDocType(oXMLSequenceType, xMLSchema, string, string2, oXMLSequenceType2, distinctArrayList);
            return null;
        }
        if (oXMLSequenceType.isAnyType()) {
            distinctArrayList.add(FSTypeUtil.nodeTestNoSchema(string, string2, oXMLSequenceType2, 1));
            return null;
        }
        ArrayList arrayList = null;
        if (hashMap != null) {
            arrayList = (ArrayList)hashMap.get(oXMLSequenceType.getType());
        }
        boolean bl = oXMLSequenceType.isTypeNameUntyped();
        FSTypeUtil.getChildType(oXMLSequenceType.getType(), oXMLSequenceType.quantifier(), string, string2, oXMLSequenceType2, distinctArrayList, bl);
        if (arrayList != null && arrayList.size() > 0) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                XSDComplexType xSDComplexType = (XSDComplexType)arrayList.get(i);
                if (oXMLSequenceType2 == null && xSDComplexType.getDerivedMethod() != "extension") continue;
                XSDGroup xSDGroup = xSDComplexType.getTypeGroup();
                XSDNode xSDNode = (XSDNode)xSDGroup.getNodeVector().get(1);
                FSTypeUtil.getChildType(xSDNode, oXMLSequenceType.quantifier(), string, string2, oXMLSequenceType2, distinctArrayList, bl);
            }
        }
        return null;
    }

    private static void getChildTypeFromDocType(OXMLSequenceType oXMLSequenceType, XMLSchema xMLSchema, String string, String string2, OXMLSequenceType oXMLSequenceType2, DistinctArrayList distinctArrayList) {
        if (oXMLSequenceType.isUntyped()) {
            distinctArrayList.add(FSTypeUtil.nodeTestNoSchema(string, string2, oXMLSequenceType2, 1));
            return;
        }
        DistinctArrayList distinctArrayList2 = new DistinctArrayList();
        QName qName = oXMLSequenceType.getNodeName();
        int n = oXMLSequenceType.quantifier();
        if (oXMLSequenceType.isAnyType()) {
            if (qName == null) {
                if (oXMLSequenceType2 == null) {
                    FSTypeUtil.getTopLevelElements(xMLSchema, n, string, string2, distinctArrayList);
                } else {
                    FSTypeUtil.getTopLevelElementsKindTest(xMLSchema, n, oXMLSequenceType2, distinctArrayList);
                }
            } else {
                FSTypeUtil.getTopLevelElements(xMLSchema, n, qName.getNamespaceURI(), qName.getLocalPart(), distinctArrayList2);
            }
        } else {
            OXMLSequenceType oXMLSequenceType3 = OXMLSequenceType.createNodeType(qName, oXMLSequenceType.getTypeName(), 1, oXMLSequenceType.isNillable(), oXMLSequenceType.getOccurence(), xMLSchema);
            FSTypeUtil.getTopLevelElementsKindTest(xMLSchema, n, oXMLSequenceType3, distinctArrayList2);
        }
        int n2 = distinctArrayList2.size();
        for (int i = 0; i < n2; ++i) {
            OXMLSequenceType oXMLSequenceType4 = (OXMLSequenceType)distinctArrayList2.get(i);
            if (oXMLSequenceType2 == null) {
                if ((oXMLSequenceType4 = FSTypeUtil.nameTest(oXMLSequenceType4, string, string2, 1, false, false)) == null) continue;
                distinctArrayList.add(oXMLSequenceType4);
                continue;
            }
            OXMLSequenceType oXMLSequenceType5 = FSTypeUtil.kindTest(oXMLSequenceType4, oXMLSequenceType2);
            if (oXMLSequenceType5 == null) continue;
            distinctArrayList.add(oXMLSequenceType5);
        }
    }

    private static void getChildType(FSMultiArgType fSMultiArgType, XMLSchema xMLSchema, HashMap hashMap, String string, String string2, OXMLSequenceType oXMLSequenceType, DistinctArrayList distinctArrayList) {
        fSMultiArgType.reset();
        while (fSMultiArgType.hasNextType()) {
            OXMLSequenceType oXMLSequenceType2 = fSMultiArgType.getNextType();
            FSType fSType = FSTypeUtil.getChildType(oXMLSequenceType2, xMLSchema, hashMap, string, string2, oXMLSequenceType, distinctArrayList);
            if (fSType == null) continue;
            distinctArrayList.add(fSType);
        }
    }

    public static FSType getTypeFromArrayList(DistinctArrayList distinctArrayList) {
        if (distinctArrayList != null) {
            int n = distinctArrayList.size();
            if (n == 1) {
                return (FSType)distinctArrayList.get(0);
            }
            FSChoiceType fSChoiceType = new FSChoiceType();
            for (int i = 0; i < distinctArrayList.size(); ++i) {
                FSType fSType = (FSType)distinctArrayList.get(i);
                fSChoiceType.addType(fSType);
            }
            return fSChoiceType;
        }
        return null;
    }

    private static void addTypeKindTest(XSDNode xSDNode, int n, OXMLSequenceType oXMLSequenceType, DistinctArrayList distinctArrayList, boolean bl) {
        OXMLSequenceType oXMLSequenceType2 = OXMLSequenceType.createNodeType(xSDNode, n);
        OXMLSequenceType oXMLSequenceType3 = FSTypeUtil.kindTest(oXMLSequenceType2, oXMLSequenceType);
        if (oXMLSequenceType3 != null) {
            if (bl) {
                oXMLSequenceType3 = oXMLSequenceType3.strip();
            }
            distinctArrayList.add(oXMLSequenceType3);
        }
    }

    private static void getChildType(XSDNode xSDNode, int n, String string, String string2, OXMLSequenceType oXMLSequenceType, DistinctArrayList distinctArrayList, boolean bl) {
        XSDNode xSDNode2 = xSDNode;
        if (xSDNode2 == null) {
            return;
        }
        int n2 = xSDNode2.getNodeType();
        if (n2 == 5) {
            Vector vector = ((XSDGroup)xSDNode2).getNodeVector();
            int n3 = vector.size();
            for (int i = 0; i < n3; ++i) {
                FSTypeUtil.getChildType((XSDNode)vector.get(i), n, string, string2, oXMLSequenceType, distinctArrayList, bl);
            }
            return;
        }
        if (n2 == 3 || n2 == 0) {
            if (oXMLSequenceType == null) {
                FSTypeUtil.addChildTypeByName(xSDNode2, n, string, string2, distinctArrayList, bl);
            } else {
                FSTypeUtil.addTypeKindTest(xSDNode2, n, oXMLSequenceType, distinctArrayList, bl);
            }
            return;
        }
        if (n2 != 1) {
            return;
        }
        XSDComplexType xSDComplexType = (XSDComplexType)xSDNode2;
        XSDNode[] xSDNodeArray = xSDComplexType.getElementSet();
        if (xSDNodeArray != null) {
            for (int i = 0; i < xSDNodeArray.length; ++i) {
                FSTypeUtil.getChildType(xSDNodeArray[i], n, string, string2, oXMLSequenceType, distinctArrayList, bl);
            }
        }
    }

    private static void addChildTypeByName(XSDNode xSDNode, int n, String string, String string2, DistinctArrayList distinctArrayList, boolean bl) {
        if (FSTypeUtil.nameTest(xSDNode, string, string2, 1)) {
            OXMLSequenceType oXMLSequenceType = OXMLSequenceType.createNodeType(xSDNode, n);
            if (bl) {
                oXMLSequenceType = oXMLSequenceType.strip();
            }
            distinctArrayList.add(oXMLSequenceType);
        }
    }

    private static boolean isNamespaceAllowed(String string, XSDNode xSDNode) {
        if (string.equals("*")) {
            return true;
        }
        return string.equals(xSDNode.getTargetNS());
    }

    private static boolean isNamespaceAllowedAnyNode(String string, XSDAny xSDAny) {
        if (string.equals("*")) {
            return true;
        }
        if (xSDAny.isAnyNamespaceAllowed()) {
            return true;
        }
        String[] stringArray = xSDAny.getNamespaceAllowed();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                return true;
            }
            return false;
        }
        String string2 = xSDAny.getNamespaceNotAllowed();
        if (string2 != null) {
            return !string.equals(string2);
        }
        return false;
    }

    public static boolean isATCPType(FSType fSType) {
        switch (fSType.getKind()) {
            case 2: {
                return FSTypeUtil.isATCPType((OXMLSequenceType)fSType);
            }
            case 3: 
            case 4: 
            case 6: {
                FSMultiArgType fSMultiArgType = (FSMultiArgType)fSType;
                fSMultiArgType.reset();
                while (fSMultiArgType.hasNextType()) {
                    if (FSTypeUtil.isATCPType(fSMultiArgType.getNextType())) continue;
                    return false;
                }
                return true;
            }
        }
        throw new XQException("invalid FSType");
    }

    private static boolean isATCPType(OXMLSequenceType oXMLSequenceType) {
        return oXMLSequenceType.isATCPType();
    }

    public static boolean isNodeType(FSType fSType, int n) {
        switch (fSType.getKind()) {
            case 2: {
                return FSTypeUtil.isNodeType((OXMLSequenceType)fSType, n);
            }
            case 3: 
            case 4: 
            case 6: {
                FSMultiArgType fSMultiArgType = (FSMultiArgType)fSType;
                fSMultiArgType.reset();
                while (fSMultiArgType.hasNextType()) {
                    if (fSMultiArgType.getNextType().isNodeType(n)) continue;
                    return false;
                }
                return true;
            }
        }
        throw new XQException("invalid FSType");
    }

    static boolean isNodeType(OXMLSequenceType oXMLSequenceType, int n) {
        return oXMLSequenceType.isNodeType(n);
    }

    public static FSType getAttribute(FSType fSType, HashMap hashMap, String string, String string2, OXMLSequenceType oXMLSequenceType) {
        DistinctArrayList distinctArrayList = new DistinctArrayList();
        switch (fSType.getKind()) {
            case 2: {
                OXMLSequenceType oXMLSequenceType2 = (OXMLSequenceType)fSType;
                FSType fSType2 = FSTypeUtil.getAttribute(oXMLSequenceType2, hashMap, string, string2, oXMLSequenceType, distinctArrayList);
                if (fSType2 == null) break;
                return fSType2;
            }
            case 3: 
            case 4: 
            case 6: {
                FSMultiArgType fSMultiArgType = (FSMultiArgType)fSType;
                FSTypeUtil.getAttribute(fSMultiArgType, hashMap, string, string2, oXMLSequenceType, distinctArrayList);
            }
        }
        return FSTypeUtil.getTypeFromArrayList(distinctArrayList);
    }

    private static void getAttributeByName(XSDNode xSDNode, int n, String string, String string2, DistinctArrayList distinctArrayList, boolean bl) {
        OXMLSequenceType oXMLSequenceType;
        if (xSDNode == null) {
            return;
        }
        if (xSDNode.getNodeType() != 1) {
            return;
        }
        XSDComplexType xSDComplexType = (XSDComplexType)xSDNode;
        XSDAttribute[] xSDAttributeArray = xSDComplexType.getAttributeDeclarations();
        XSDAny xSDAny = xSDComplexType.getAttributeWildcard();
        if (xSDAttributeArray != null) {
            for (int i = 0; i < xSDAttributeArray.length; ++i) {
                if (!FSTypeUtil.nameTest(xSDAttributeArray[i], string, string2, 2)) continue;
                oXMLSequenceType = OXMLSequenceType.createNodeType(xSDAttributeArray[i], n);
                if (bl) {
                    oXMLSequenceType = oXMLSequenceType.strip();
                }
                distinctArrayList.add(oXMLSequenceType);
            }
        }
        if (xSDAny != null && FSTypeUtil.isNamespaceAllowedAnyNode(string, xSDAny)) {
            QName qName = new QName(string, string2);
            oXMLSequenceType = OXMLSequenceType.createNodeType(qName, null, 2, false, 1);
            if (bl) {
                oXMLSequenceType = oXMLSequenceType.strip();
            }
            distinctArrayList.add(oXMLSequenceType);
        }
    }

    private static void getAttributeKindTest(XSDNode xSDNode, int n, OXMLSequenceType oXMLSequenceType, DistinctArrayList distinctArrayList, boolean bl) {
        OXMLSequenceType oXMLSequenceType2;
        OXMLSequenceType oXMLSequenceType3;
        if (xSDNode == null) {
            return;
        }
        if (xSDNode.getNodeType() != 1) {
            return;
        }
        XSDComplexType xSDComplexType = (XSDComplexType)xSDNode;
        XSDAttribute[] xSDAttributeArray = xSDComplexType.getAttributeDeclarations();
        XSDAny xSDAny = xSDComplexType.getAttributeWildcard();
        if (xSDAttributeArray != null) {
            for (int i = 0; i < xSDAttributeArray.length; ++i) {
                oXMLSequenceType3 = OXMLSequenceType.createNodeType(xSDAttributeArray[i], n);
                OXMLSequenceType oXMLSequenceType4 = FSTypeUtil.kindTest(oXMLSequenceType3, oXMLSequenceType);
                if (oXMLSequenceType4 == null) continue;
                if (bl) {
                    oXMLSequenceType4 = oXMLSequenceType4.strip();
                }
                distinctArrayList.add(oXMLSequenceType4);
            }
        }
        if (xSDAny != null && (oXMLSequenceType3 = FSTypeUtil.kindTest(oXMLSequenceType2 = OXMLSequenceType.createNodeType(xSDAny, n), oXMLSequenceType)) != null) {
            if (bl) {
                oXMLSequenceType3 = oXMLSequenceType3.strip();
            }
            distinctArrayList.add(oXMLSequenceType3);
        }
    }

    private static void getAttribute(FSMultiArgType fSMultiArgType, HashMap hashMap, String string, String string2, OXMLSequenceType oXMLSequenceType, DistinctArrayList distinctArrayList) {
        fSMultiArgType.reset();
        while (fSMultiArgType.hasNextType()) {
            OXMLSequenceType oXMLSequenceType2 = fSMultiArgType.getNextType();
            FSType fSType = FSTypeUtil.getAttribute(oXMLSequenceType2, hashMap, string, string2, oXMLSequenceType, distinctArrayList);
            if (fSType == null) continue;
            distinctArrayList.add(fSType);
        }
    }

    private static OXMLSequenceType nodeTestNoSchema(String string, String string2, OXMLSequenceType oXMLSequenceType, int n, boolean bl) {
        OXMLSequenceType oXMLSequenceType2 = null;
        if (oXMLSequenceType == null) {
            oXMLSequenceType2 = OXMLSequenceType.createNodeType(new QName(string, string2), bl ? (n == 1 ? UNTYPED_QNAME : UNTYPED_ATOMIC_QNAME) : null, n, false, 4);
        } else {
            int n2 = oXMLSequenceType.getNodeType();
            QName qName = n2 == 1 ? UNTYPED_QNAME : UNTYPED_ATOMIC_QNAME;
            oXMLSequenceType2 = OXMLSequenceType.createSequenceType(oXMLSequenceType, 4, null, bl ? qName : null);
        }
        return oXMLSequenceType2;
    }

    private static OXMLSequenceType nodeTestNoSchema(String string, String string2, OXMLSequenceType oXMLSequenceType, int n) {
        return FSTypeUtil.nodeTestNoSchema(string, string2, oXMLSequenceType, n, false);
    }

    private static FSType getAttribute(OXMLSequenceType oXMLSequenceType, HashMap hashMap, String string, String string2, OXMLSequenceType oXMLSequenceType2, DistinctArrayList distinctArrayList) {
        if (oXMLSequenceType.getNodeType() != 1) {
            return null;
        }
        FSType fSType = oXMLSequenceType.getAttributeType();
        if (fSType != null) {
            return FSTypeUtil.applyNodeTest(fSType, string, string2, oXMLSequenceType2, 2);
        }
        if (oXMLSequenceType.isAnyType()) {
            distinctArrayList.add(FSTypeUtil.nodeTestNoSchema(string, string2, oXMLSequenceType2, 2));
            return null;
        }
        ArrayList arrayList = null;
        int n = oXMLSequenceType.quantifier();
        if (hashMap != null) {
            arrayList = (ArrayList)hashMap.get(oXMLSequenceType.getType());
        }
        boolean bl = oXMLSequenceType.isTypeNameUntyped();
        if (oXMLSequenceType2 == null) {
            FSTypeUtil.getAttributeByName(oXMLSequenceType.getType(), n, string, string2, distinctArrayList, bl);
        } else {
            FSTypeUtil.getAttributeKindTest(oXMLSequenceType.getType(), n, oXMLSequenceType2, distinctArrayList, bl);
        }
        if (arrayList != null && arrayList.size() > 0) {
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                XSDComplexType xSDComplexType = (XSDComplexType)arrayList.get(i);
                if (xSDComplexType.getDerivedMethod() != "extension") continue;
                if (oXMLSequenceType2 == null) {
                    FSTypeUtil.getAttributeByName(xSDComplexType, n, string, string2, distinctArrayList, bl);
                    continue;
                }
                FSTypeUtil.getAttributeKindTest(xSDComplexType, n, oXMLSequenceType2, distinctArrayList, bl);
            }
        }
        return null;
    }

    public static HashMap getSchemaTypeChain(XMLSchema xMLSchema) {
        if (xMLSchema == null) {
            return null;
        }
        HashMap hashMap = new HashMap();
        Hashtable hashtable = xMLSchema.getXMLSchemaNodeTable();
        Iterator iterator = hashtable.values().iterator();
        while (iterator.hasNext()) {
            FSTypeUtil.getSchemaTypeChain((XMLSchemaNode)iterator.next(), hashMap);
        }
        return hashMap;
    }

    private static void getSchemaTypeChain(XMLSchemaNode xMLSchemaNode, HashMap hashMap) {
        Hashtable hashtable = xMLSchemaNode.getTypeDefinitionTable();
        for (XSDNode xSDNode : hashtable.values()) {
            XSDNode xSDNode2;
            XSDComplexType xSDComplexType;
            String string;
            if (xSDNode.getNodeType() != 1 || (string = (xSDComplexType = (XSDComplexType)xSDNode).getDerivedMethod()) != "extension" && string != "restriction" || (xSDNode2 = xSDComplexType.getBaseType()).getNodeType() != 1 || ((XSDComplexType)xSDNode2).isUrType()) continue;
            FSTypeUtil.addTypeChain((XSDComplexType)xSDNode2, xSDComplexType, hashMap);
        }
    }

    private static void addTypeChain(XSDComplexType xSDComplexType, XSDComplexType xSDComplexType2, HashMap hashMap) {
        XSDNode xSDNode;
        ArrayList<XSDComplexType> arrayList = (ArrayList<XSDComplexType>)hashMap.get(xSDComplexType);
        if (arrayList == null) {
            arrayList = new ArrayList<XSDComplexType>();
        }
        arrayList.add(xSDComplexType2);
        hashMap.put(xSDComplexType, arrayList);
        String string = xSDComplexType.getDerivedMethod();
        if (!(string != "extension" && string != "restriction" || (xSDNode = xSDComplexType.getBaseType()).getNodeType() != 1 || ((XSDComplexType)xSDNode).isUrType())) {
            FSTypeUtil.addTypeChain((XSDComplexType)xSDNode, xSDComplexType2, hashMap);
        }
    }

    public static FSType getChildrenOrAttrType(FSType fSType, int n) {
        boolean bl = n == 2;
        switch (fSType.getKind()) {
            case 2: {
                OXMLSequenceType oXMLSequenceType = (OXMLSequenceType)fSType;
                return bl ? oXMLSequenceType.getAttributeType() : oXMLSequenceType.getChildrenType();
            }
            case 3: 
            case 4: 
            case 6: {
                FSMultiArgType fSMultiArgType = null;
                boolean bl2 = false;
                FSMultiArgType fSMultiArgType2 = (FSMultiArgType)fSType;
                fSMultiArgType2.reset();
                while (fSMultiArgType2.hasNextType()) {
                    FSType fSType2;
                    OXMLSequenceType oXMLSequenceType = fSMultiArgType2.getNextType();
                    FSType fSType3 = fSType2 = bl ? oXMLSequenceType.getAttributeType() : oXMLSequenceType.getChildrenType();
                    if (fSType2 != null) {
                        if (fSMultiArgType == null) {
                            fSMultiArgType = new FSChoiceType();
                        }
                        if (fSType2.isEmpty()) continue;
                        fSMultiArgType.addType(fSType2);
                        continue;
                    }
                    if (!oXMLSequenceType.isAnyType() && !oXMLSequenceType.isTypeNameUntyped()) continue;
                    bl2 = true;
                }
                if (fSMultiArgType != null && fSMultiArgType.isEmpty() && bl2) {
                    return null;
                }
                return fSMultiArgType;
            }
        }
        return null;
    }

    public static void getDescendantChildrenType(FSType fSType, HashMap hashMap) {
        FSType fSType2 = FSTypeUtil.getChildrenOrAttrType(fSType, 1);
        if (fSType2 == null) {
            hashMap.put(OXMLSequenceType.ELEMENT_UNTYPED_ZERO_OR_MORE, Boolean.FALSE);
            return;
        }
        if (fSType2.isEmpty()) {
            return;
        }
        hashMap.put(fSType2, Boolean.TRUE);
        FSTypeUtil.getDescendantChildrenType(fSType2, hashMap);
    }

    static void stripType(FSType fSType, FSChoiceType fSChoiceType) {
        switch (fSType.getKind()) {
            case 2: {
                OXMLSequenceType oXMLSequenceType = (OXMLSequenceType)fSType;
                fSChoiceType.addType(oXMLSequenceType.strip());
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                FSMultiArgType fSMultiArgType = (FSMultiArgType)fSType;
                fSMultiArgType.reset();
                while (fSMultiArgType.hasNextType()) {
                    OXMLSequenceType oXMLSequenceType = fSMultiArgType.getNextType();
                    fSChoiceType.addType(oXMLSequenceType.strip());
                }
                break;
            }
        }
    }
}

