/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLLocator;
import oracle.xml.parser.v2.XMLOutputStream;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XMLSAXSerializer
extends DefaultHandler
implements XMLConstants,
LexicalHandler,
DeclHandler {
    public static final String ENCODING = "oracle.xml.parser.v2.XMLSAXSerializer.encoding";
    public static final String INDENT = "oracle.xml.parser.v2.XMLSAXSerializer.indent";
    public static final String OMIT_XML_DECL = "oracle.xml.parser.v2.XMLSAXSerializer.omit-xml-decl";
    boolean elemEmpty = true;
    boolean textPrinted = false;
    boolean firstElement = true;
    Boolean printXMLDecl = null;
    boolean inCDATA = false;
    boolean intSubset = false;
    int entityDepth = 0;
    String encoding = null;
    Locator locator = null;
    XMLOutputStream out;

    public XMLSAXSerializer(PrintWriter printWriter) {
        this.out = new XMLOutputStream(printWriter);
    }

    public XMLSAXSerializer(OutputStream outputStream) {
        this.out = new XMLOutputStream(outputStream);
    }

    public void setProperty(String string, Object object) {
        if (ENCODING.equals(string)) {
            try {
                this.out.setEncoding((String)object, true, true);
                this.encoding = (String)object;
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage());
            }
        } else if (INDENT.equals(string)) {
            if (Boolean.TRUE.equals(object)) {
                this.out.setOutputStyle(1);
            } else {
                this.out.setOutputStyle(2);
            }
        } else if (OMIT_XML_DECL.equals(string)) {
            this.printXMLDecl = Boolean.TRUE.equals(object) ? Boolean.FALSE : Boolean.TRUE;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void flush() throws IOException {
        this.out.flush();
        this.out.finalFlush();
    }

    public void startDocument() throws SAXException {
        String string = null;
        if (this.locator != null && this.locator instanceof XMLLocator) {
            XMLLocator xMLLocator = (XMLLocator)this.locator;
            String string2 = xMLLocator.getXMLVersion();
            if (string2 != null && this.printXMLDecl != Boolean.FALSE) {
                this.printXMLDecl = Boolean.TRUE;
            }
            string = xMLLocator.getStandalone();
            if (this.encoding == null) {
                this.encoding = xMLLocator.getEncoding();
                if (this.encoding != null) {
                    if (this.encoding.equals("")) {
                        this.encoding = "UTF-8";
                    }
                    try {
                        this.out.setEncoding(this.encoding, true, true);
                    }
                    catch (IOException iOException) {
                        throw new SAXException(iOException.getMessage());
                    }
                }
            }
        }
        try {
            if (this.printXMLDecl == Boolean.TRUE) {
                this.out.writeChars("<?xml version = '1.0'");
                if (this.encoding != null) {
                    this.out.writeChars(" encoding = '" + this.encoding + "'");
                }
                if (string != null) {
                    this.out.writeChars(" standalone = '" + string + "'");
                }
                this.out.writeChars("?>");
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            if (!this.textPrinted && !this.firstElement) {
                this.out.writeNewLine();
                this.out.writeIndent();
            }
            this.firstElement = false;
            this.elemEmpty = true;
            this.textPrinted = false;
            this.out.writeChars("<");
            this.out.writeChars(string3);
            this.printAttributes(string2, attributes);
            this.out.writeChars(">");
            this.out.addIndent(1);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            this.out.addIndent(-1);
            if (this.elemEmpty) {
                this.out.pop(1);
                this.out.writeChars("/>");
            } else {
                if (!this.textPrinted) {
                    this.out.writeNewLine();
                    this.out.writeIndent();
                }
                this.out.writeChars("</" + string3 + ">");
            }
            this.elemEmpty = false;
            this.textPrinted = false;
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            if (!this.textPrinted && !this.firstElement) {
                this.out.writeNewLine();
                this.out.writeIndent();
            }
            this.firstElement = false;
            this.elemEmpty = false;
            this.textPrinted = false;
            this.out.writeChars("<?");
            this.out.writeChars(string + " " + string2);
            this.out.writeChars("?>");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        this.elemEmpty = false;
        this.textPrinted = true;
        try {
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                if (!this.inCDATA && cArray[i] == '&') {
                    this.out.writeChars("&amp;");
                    continue;
                }
                if (!this.inCDATA && cArray[i] == '<') {
                    this.out.writeChars("&lt;");
                    continue;
                }
                this.out.write(cArray[i]);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            this.out.writeChars("<!DOCTYPE ");
            this.out.writeChars(string);
            if (string2 != null) {
                this.out.writeChars(" PUBLIC ");
                this.out.writeQuotedString(string2);
                this.out.writeChars(" ");
                this.out.writeQuotedString(string3);
            } else if (string3 != null) {
                this.out.writeChars(" SYSTEM ");
                this.out.writeQuotedString(string3);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    void intSubset() throws IOException {
        if (!this.intSubset) {
            this.intSubset = true;
            this.out.writeChars(" [");
            this.out.writeNewLine();
        }
    }

    public void endDTD() throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            if (this.intSubset) {
                this.out.writeChars("]");
            }
            this.intSubset = false;
            this.out.writeChars(">");
            this.out.writeNewLine();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void startEntity(String string) throws SAXException {
        if (this.entityDepth == 0 && !string.equals("[dtd]")) {
            try {
                this.out.writeChars("&" + string + ";");
            }
            catch (IOException iOException) {
                throw new SAXException(iOException.getMessage());
            }
        }
        ++this.entityDepth;
    }

    public void endEntity(String string) throws SAXException {
        --this.entityDepth;
    }

    public void startCDATA() throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            this.inCDATA = true;
            this.out.writeChars("<![CDATA[");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void endCDATA() throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            this.inCDATA = false;
            this.out.writeChars("]]>");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            if (!this.textPrinted && !this.firstElement) {
                this.out.writeNewLine();
                this.out.writeIndent();
            }
            this.firstElement = false;
            this.elemEmpty = false;
            this.textPrinted = false;
            this.out.writeChars("<!--");
            int n3 = n + n2;
            for (int i = n; i < n3; ++i) {
                this.out.write(cArray[i]);
            }
            this.out.writeChars("-->");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void elementDecl(String string, String string2) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            this.intSubset();
            this.out.writeChars("<!ELEMENT ");
            this.out.writeChars(string + " ");
            this.out.writeChars(string2);
            this.out.writeChars(">");
            this.out.writeNewLine();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            this.intSubset();
            this.out.writeChars("<!ATTLIST ");
            this.out.writeChars(string + " ");
            this.out.writeChars(" ");
            this.out.writeChars(string2 + " ");
            this.out.writeChars(string3);
            if (string4 != null) {
                this.out.writeChars(" " + string4);
            }
            if (string5 != null) {
                this.out.writeChars(" " + string5);
            }
            this.out.writeChars(">");
            this.out.writeNewLine();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            this.intSubset();
            this.out.writeChars("<!ENTITY ");
            this.out.writeChars(string + " ");
            this.out.writeChars(string2);
            this.out.writeChars(">");
            this.out.writeNewLine();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            this.intSubset();
            this.out.writeChars("<!ENTITY ");
            this.out.writeChars(string);
            if (string2 != null) {
                this.out.writeChars(" PUBLIC ");
                this.out.writeQuotedString(string2);
                this.out.writeChars(" ");
                this.out.writeQuotedString(string3);
            } else if (string3 != null) {
                this.out.writeChars(" SYSTEM ");
                this.out.writeQuotedString(string3);
            }
            this.out.writeChars(">");
            this.out.writeNewLine();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            this.intSubset();
            this.out.writeChars("<!NOTATION ");
            this.out.writeChars(string);
            if (string2 != null) {
                this.out.writeChars(" PUBLIC ");
                this.out.writeQuotedString(string2);
                if (string3 != null) {
                    this.out.writeChars(" ");
                    this.out.writeQuotedString(string3);
                }
            } else if (string3 != null) {
                this.out.writeChars(" SYSTEM ");
                this.out.writeQuotedString(string3);
            }
            this.out.writeChars(">");
            this.out.writeNewLine();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        if (this.entityDepth > 0) {
            return;
        }
        try {
            this.intSubset();
            this.out.writeChars("<!ENTITY ");
            this.out.writeChars(string);
            if (string2 != null) {
                this.out.writeChars(" PUBLIC ");
                this.out.writeQuotedString(string2);
                this.out.writeChars(" ");
                this.out.writeQuotedString(string3);
            } else if (string3 != null) {
                this.out.writeChars(" SYSTEM ");
                this.out.writeQuotedString(string3);
            }
            this.out.writeChars(" NDATA ");
            this.out.writeChars(string4);
            this.out.writeChars(">");
            this.out.writeNewLine();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
    }

    private void printAttributes(String string, Attributes attributes) throws SAXException, IOException {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            this.out.writeChars(" ");
            this.out.writeChars(attributes.getQName(i));
            XMLAttr.print1(this.out, attributes.getValue(i));
        }
    }
}

