/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.editor.ComboBoxEditorBehavior;
import oracle.bali.inspector.editor.EditorComponentSetup;
import oracle.bali.inspector.editor.PropertyValueApplier;
import oracle.bali.inspector.editor.PropertyValueApplierUtil;

public class ComboBoxEditorSetup
extends EditorComponentSetup {
    public boolean canConfigure(Component inlineEditor) {
        return inlineEditor instanceof JComboBox;
    }

    public void configure(PropertyEditorFactory2 propertyEditor, PropertyValueApplier applier, Component inlineEditor) {
        if (!this.canConfigure(inlineEditor)) {
            return;
        }
        JComboBox editor = (JComboBox)inlineEditor;
        PropertyValueApplierUtil.storePropertyValueApplier(applier, editor);
        ComboBoxEditorSetup.removeCurrentListeners(editor);
        ComboBoxEditorBehavior eventsListener = this.createBehavior(editor, propertyEditor);
        editor.addItemListener(eventsListener);
        editor.addPopupMenuListener(eventsListener);
        editor.addActionListener(new HidePopupActionListener());
        ComboBoxEditor comboBoxEditor = editor.getEditor();
        if (comboBoxEditor != null) {
            comboBoxEditor.addActionListener(eventsListener);
            Component editorComponent = comboBoxEditor.getEditorComponent();
            if (editorComponent instanceof JTextComponent) {
                editorComponent.addFocusListener(eventsListener);
            }
        }
    }

    protected ComboBoxEditorBehavior createBehavior(JComboBox editor, PropertyEditorFactory2 propertyEditor) {
        return new ComboBoxEditorBehavior(editor, propertyEditor);
    }

    static void removeCurrentListeners(JComboBox editor) {
        ArrayList<ComboBoxEditorBehavior> toRemove = new ArrayList<ComboBoxEditorBehavior>();
        ArrayList<HidePopupActionListener> toRemoveToo = new ArrayList<HidePopupActionListener>();
        for (PopupMenuListener l : editor.getPopupMenuListeners()) {
            if (l instanceof ComboBoxEditorBehavior) {
                toRemove.add((ComboBoxEditorBehavior)l);
            }
            if (!(l instanceof HidePopupActionListener)) continue;
            toRemoveToo.add((HidePopupActionListener)((Object)l));
        }
        ComboBoxEditor comboBoxEditor = editor.getEditor();
        for (ComboBoxEditorBehavior l : toRemove) {
            editor.removeItemListener(l);
            editor.removePopupMenuListener(l);
            if (comboBoxEditor == null) continue;
            comboBoxEditor.removeActionListener(l);
            Component editorComponent = comboBoxEditor.getEditorComponent();
            if (!(editorComponent instanceof JTextComponent)) continue;
            editorComponent.removeFocusListener(l);
        }
        for (HidePopupActionListener l : toRemoveToo) {
            editor.removeActionListener(l);
        }
    }

    public static class HidePopupActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (!(source instanceof JComboBox)) {
                return;
            }
            JComboBox combo = (JComboBox)source;
            combo.hidePopup();
        }
    }
}

