/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import oracle.bali.inspector.InspectorPropertyEditor;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.PropertyEditorFactory2ValueApplier;
import oracle.bali.inspector.editor.ComboBoxEditor;
import oracle.bali.inspector.editor.EditorComponentInfo;
import oracle.bali.inspector.editor.EditorFactoryUtils;
import oracle.bali.inspector.editor.PropertyValueApplier;
import oracle.bali.inspector.editor.PropertyValueApplierUtil;
import oracle.bali.inspector.editor.TextFieldEditorBehavior;
import oracle.bali.inspector.editor.ToStringConverter;

public class ComboBoxEditorBehavior
extends FocusAdapter
implements KeyListener,
PopupMenuListener,
ActionListener,
ItemListener,
DocumentListener {
    JComboBox editor;
    PropertyEditorFactory2 propertyEditor;
    boolean valueApplied;
    private boolean keyAlreadyPressed;

    public ComboBoxEditorBehavior(JComboBox editor, PropertyEditorFactory2 propertyEditor) {
        this.editor = editor;
        this.propertyEditor = propertyEditor;
        if (editor.isEditable()) {
            editor.putClientProperty("JComboBox.isTableCellEditor", true);
            JTextComponent realEditor = this.realEditor();
            if (realEditor != null) {
                this.addListenersTo(realEditor);
                TextFieldEditorBehavior.setDirty(realEditor, false);
            }
        }
    }

    private void addListenersTo(JTextComponent realEditor) {
        ArrayList<ComboBoxEditorBehavior> toRemove = new ArrayList<ComboBoxEditorBehavior>();
        for (KeyListener l : realEditor.getKeyListeners()) {
            if (!(l instanceof ComboBoxEditorBehavior)) continue;
            toRemove.add((ComboBoxEditorBehavior)l);
        }
        Document document = realEditor.getDocument();
        for (ComboBoxEditorBehavior l : toRemove) {
            realEditor.removeFocusListener(l);
            if (document == null) continue;
            document.removeDocumentListener(l);
        }
        realEditor.addKeyListener(this);
        if (document != null) {
            document.addDocumentListener(this);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        Object itemInComboBox = e.getItem();
        JList list = this.editorPopupList(this.editorUI());
        Object selectedInList = null;
        if (list != null) {
            selectedInList = list.getSelectedValue();
        }
        if (selectedInList != null && selectedInList != itemInComboBox) {
            this.applyValue(selectedInList);
            return;
        }
        this.applyValue(itemInComboBox);
    }

    private BasicComboBoxUI editorUI() {
        ComboBoxUI ui = this.editor.getUI();
        if (!(ui instanceof BasicComboBoxUI)) {
            return null;
        }
        return (BasicComboBoxUI)ui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JList editorPopupList(BasicComboBoxUI ui) {
        if (ui == null) {
            return null;
        }
        Field f = null;
        boolean accessible = false;
        try {
            f = BasicComboBoxUI.class.getDeclaredField("listBox");
            accessible = f.isAccessible();
            f.setAccessible(true);
            Object val = f.get(ui);
            if (!(val instanceof JList)) {
                JList jList = null;
                return jList;
            }
            JList jList = (JList)val;
            return jList;
        }
        catch (Exception e) {
            JList jList = null;
            return jList;
        }
        finally {
            if (f != null) {
                f.setAccessible(accessible);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.applyValueFromEditor();
    }

    private void applyValueFromEditor() {
        if (!this.editor.isEditable()) {
            return;
        }
        Object value = this.editor.getEditor().getItem();
        JTextComponent realEditor = this.realEditor();
        if (realEditor != null && TextFieldEditorBehavior.isDirty(realEditor)) {
            value = realEditor.getText();
            this.applyValue(value);
            this.valueApplied = true;
        }
    }

    private JTextComponent realEditor() {
        if (!this.editor.isEditable()) {
            return null;
        }
        Component realEditor = this.editor.getEditor().getEditorComponent();
        if (realEditor instanceof JTextComponent) {
            return (JTextComponent)realEditor;
        }
        return null;
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.makeComboBoxTableCellEditor(true);
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent event) {
        this.makeComboBoxTableCellEditor(false);
    }

    private void makeComboBoxTableCellEditor(boolean b) {
        if (this.editor.isEditable()) {
            return;
        }
        this.editor.putClientProperty("JComboBox.isTableCellEditor", b);
    }

    private void applyValue(Object selectedItem) {
        JTextComponent e;
        if (this.valueApplied) {
            this.valueApplied = false;
            return;
        }
        ToStringConverter converter = this.converter();
        this.updateToStringConverterInEditor(converter);
        String selectedItemAsText = this.asString(selectedItem, converter);
        PropertyValueApplier applier = PropertyValueApplierUtil.retrievePropertyValueApplier(this.editor);
        if (applier == null) {
            PropertyEditorFactory2ValueApplier.applyValueFromComboBoxEditor(this.propertyEditor, this.editor, converter);
            return;
        }
        int selectedIndex = this.editor.getSelectedIndex();
        String oldValue = this.propertyEditor.getAsText();
        if (oldValue == null && selectedItemAsText != null || oldValue != null && !oldValue.equals(selectedItemAsText)) {
            try {
                if (this.editor.isEditable()) {
                    this.validateInput();
                }
                this.propertyEditor.setAsText(selectedItemAsText);
                applier.apply(this.propertyEditor.getValue());
            }
            catch (Exception e2) {
                try {
                    this.editor.setSelectedIndex(selectedIndex);
                    this.propertyEditor.setAsText(oldValue);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                EditorFactoryUtils.showErrorMessage(this.editor.getParent(), e2, selectedItemAsText);
            }
        }
        if (this.editor.isEditable() && (e = this.realEditor()) != null) {
            String current = e.getText();
            boolean change = false;
            if (current != null) {
                change = !current.equals(selectedItemAsText);
            } else {
                boolean bl = change = selectedItemAsText != null;
            }
            if (change) {
                e.setText(selectedItemAsText);
            }
        }
    }

    protected void validateInput() {
    }

    private void updateToStringConverterInEditor(ToStringConverter converter) {
        if (!(this.editor instanceof ComboBoxEditor)) {
            return;
        }
        ComboBoxEditor comboBoxEditor = (ComboBoxEditor)this.editor;
        comboBoxEditor.setToStringConverter(converter);
    }

    private String asString(Object o, ToStringConverter converter) {
        if (converter != null) {
            return converter.convertToString(o);
        }
        return o != null ? o.toString() : null;
    }

    private ToStringConverter converter() {
        EditorComponentInfo info = this.propertyEditor.getEditorComponentInfo();
        if (info == null) {
            return null;
        }
        ToStringConverter converter = info.editorValueToStringConverter();
        if (converter != null) {
            return converter;
        }
        if (this.propertyEditor instanceof InspectorPropertyEditor) {
            InspectorPropertyEditor e = (InspectorPropertyEditor)this.propertyEditor;
            return e.getSelectedItemToStringConverter();
        }
        return null;
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        int keycode = e.getKeyCode();
        if (keycode == 27) {
            return;
        }
        if (keycode == 38) {
            return;
        }
        if (keycode == 40) {
            return;
        }
        if (keycode == 0) {
            return;
        }
        if (keycode == 10) {
            JTextComponent realEditor = this.realEditor();
            if (realEditor != null && TextFieldEditorBehavior.isDirty(realEditor)) {
                this.applyValueFromEditor();
            }
            return;
        }
        this.keyAlreadyPressed = true;
    }

    public void keyReleased(KeyEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        this.dirtyEditor(true);
    }

    public void removeUpdate(DocumentEvent e) {
        this.dirtyEditor(true);
    }

    public void changedUpdate(DocumentEvent e) {
        this.dirtyEditor(true);
    }

    private void dirtyEditor(boolean val) {
        if (!this.keyAlreadyPressed) {
            return;
        }
        JTextComponent realEditor = this.realEditor();
        if (realEditor != null) {
            TextFieldEditorBehavior.setDirty(realEditor, val);
        }
    }
}

