/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.beans;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.EventObject;
import java.util.Locale;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.inspector.DisplayValueRenderer;
import oracle.bali.inspector.ExtendedPropertyEditor;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.beans.ArrayPropertyEditor;
import oracle.bali.inspector.beans.BeansPropertyEditorRenderer;
import oracle.bali.inspector.beans.BeansPropertyEditorValueEditor;
import oracle.bali.inspector.editors.CharEditor;
import oracle.bali.inspector.editors.ColorEditor;
import oracle.bali.inspector.swing.AbstractTableCellEditor;
import oracle.bali.inspector.swing.NonNullComboBoxModel;
import sun.beans.editors.BoolEditor;
import sun.beans.editors.FontEditor;
import sun.beans.editors.IntEditor;

@Deprecated
abstract class AbstractPropertyEditorFactory
implements PropertyEditorFactory {
    private transient PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    protected static final Object INVALID_PROPERTY;
    private static final PropertyEditor INVALID_PROPERTY_EDITOR;
    private boolean _ignoreEvents;
    private Object _target;
    private transient Object _value;
    private transient Object _displayValue;
    private transient PropertyEditor _editor = INVALID_PROPERTY_EDITOR;
    private TableCellEditor _cellEditor;
    private Object _propertyID;

    protected AbstractPropertyEditorFactory(Object target) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        this._target = target;
        this.invalidateCachedValues();
    }

    public Object getTarget() {
        return this._target;
    }

    public void invalidateCachedValues() {
        this._value = INVALID_PROPERTY;
        this._displayValue = INVALID_PROPERTY;
    }

    public boolean updateValueIfNecessary(Object newValue) {
        if (newValue != this._value) {
            this._value = newValue;
            this._displayValue = INVALID_PROPERTY;
            return true;
        }
        return false;
    }

    public abstract Class getType();

    public abstract boolean setValue(Object var1) throws Exception;

    public abstract String getDisplayName();

    public String getName() {
        return null;
    }

    public String getShortDescription() {
        return null;
    }

    public boolean isExpert() {
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public abstract Object getValue(Object var1) throws Exception;

    public Object getDisplayValue() throws Exception {
        if (this._displayValue == INVALID_PROPERTY) {
            PropertyEditor editor;
            Object currValue = this.getValue(this._target);
            if (currValue != null && (editor = this.__getPropertyEditor()) != null) {
                this._ignoreEvents = true;
                editor.setValue(currValue);
                this._ignoreEvents = false;
                String newValue = editor.getAsText();
                if (newValue != null) {
                    currValue = newValue;
                }
            }
            this._displayValue = currValue;
        }
        return this._displayValue;
    }

    public PropertyEditorFactory getPropertyEditorFactory() {
        return this.__getPropertyEditor() != null ? this : null;
    }

    public Object getPropertyID() {
        if (this._propertyID == null) {
            this._propertyID = this.createPropertyID();
        }
        return this._propertyID;
    }

    public abstract boolean isReadable();

    public abstract boolean isWritable();

    public Object getEditorValue() {
        PropertyEditor editor = this.__getPropertyEditor();
        return editor == null ? null : editor.getValue();
    }

    public void setEditorValue(Object value) {
        PropertyEditor editor = this.__getPropertyEditor();
        if (editor != null) {
            this._ignoreEvents = true;
            editor.setValue(value);
            this._ignoreEvents = false;
        }
    }

    public boolean hasValueRenderer() {
        return true;
    }

    public TableCellRenderer getValueRenderer() {
        PropertyEditor editor = this.__getPropertyEditor();
        if (editor instanceof PropertyEditorFactory && ((PropertyEditorFactory)((Object)editor)).hasValueRenderer()) {
            return ((PropertyEditorFactory)((Object)editor)).getValueRenderer();
        }
        if (editor != null && editor.isPaintable()) {
            return BeansPropertyEditorRenderer.getTableCellRenderer();
        }
        return DisplayValueRenderer.getTableCellRenderer();
    }

    public boolean hasInPlaceEditor() {
        PropertyEditorFactory pef;
        Class propertyType = this.getType();
        if (Boolean.TYPE == propertyType || Date.class == propertyType) {
            return true;
        }
        PropertyEditor editor = this.__getPropertyEditor();
        PropertyEditorFactory propertyEditorFactory = pef = editor instanceof PropertyEditorFactory ? (PropertyEditorFactory)((Object)editor) : null;
        return editor == null ? false : editor.getAsText() != null || pef != null && pef.hasInPlaceEditor() || propertyType == String.class;
    }

    public TableCellEditor getInPlaceEditor(Locale editorLocale) {
        Class propertyType = this.getType();
        if (this._cellEditor == null) {
            TableCellEditor cellEditor = null;
            PropertyEditor editor = this.__getPropertyEditor();
            if (editor instanceof PropertyEditorFactory) {
                PropertyEditorFactory pef = (PropertyEditorFactory)((Object)editor);
                cellEditor = pef.getInPlaceEditor(editorLocale);
            } else if (Boolean.TYPE == propertyType) {
                Object[] items = new Object[]{Boolean.TRUE, Boolean.FALSE};
                NonNullComboBoxModel model = new NonNullComboBoxModel(items);
                JComboBox<Object> box = new JComboBox<Object>(model);
                box.setRenderer(new DefaultListCellRenderer(){

                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        if (Boolean.TRUE.equals(value)) {
                            value = "True";
                        } else if (Boolean.FALSE.equals(value)) {
                            value = "False";
                        }
                        return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    }
                });
                cellEditor = new DefaultCellEditor(box);
                box.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Heavyweight");
            } else {
                Object[] tags;
                Object[] objectArray = tags = editor == null ? null : editor.getTags();
                if (tags != null) {
                    NonNullComboBoxModel model = new NonNullComboBoxModel(tags);
                    JComboBox box = new JComboBox(model);
                    cellEditor = new DefaultCellEditor(box);
                    box.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Heavyweight");
                } else if (this._isNumber(propertyType)) {
                    NumberEditor numberEditor = new NumberEditor(propertyType);
                    cellEditor = numberEditor;
                } else if (editor != null && (editor.getAsText() != null || propertyType == String.class)) {
                    cellEditor = BeansPropertyEditorValueEditor.getTextFieldEditor();
                }
            }
            this._cellEditor = cellEditor;
        }
        return this._cellEditor;
    }

    public boolean hasTearOffEditor() {
        ExtendedPropertyEditor extendedEditor = this._getExtendedEditor();
        return extendedEditor == null ? false : extendedEditor.supportsSmallCustomEditor();
    }

    public Component getTearOffEditor() {
        ExtendedPropertyEditor extendedEditor = this._getExtendedEditor();
        return extendedEditor == null ? null : extendedEditor.getSmallCustomEditor();
    }

    public boolean hasAdvancedEditor() {
        PropertyEditor editor = this.__getPropertyEditor();
        return editor == null ? false : editor.supportsCustomEditor();
    }

    public Component getAdvancedEditor() {
        PropertyEditor editor = this.__getPropertyEditor();
        return editor == null ? null : editor.getCustomEditor();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    protected PropertyEditor createPropertyEditor() {
        Class<?> c;
        PropertyEditor arrayObjectEditor;
        PropertyEditor editor = null;
        Class propertyClass = this.getType();
        if (propertyClass != null && (editor = PropertyEditorManager.findEditor(propertyClass)) == null && propertyClass.isArray() && (arrayObjectEditor = PropertyEditorManager.findEditor(c = propertyClass.getComponentType())) != null) {
            editor = ArrayPropertyEditor.getPropertyEditor();
        }
        if (editor != null) {
            editor.addPropertyChangeListener(this.getPropertyChangeListener());
        }
        return editor;
    }

    protected void setCachedDisplayValue(Object value) {
        this._displayValue = value;
    }

    protected void setCachedValue(Object value) {
        this._value = value;
    }

    protected Object getCachedValue() {
        return this._value;
    }

    protected PropertyChangeListener getPropertyChangeListener() {
        return new Listen();
    }

    protected abstract Object createPropertyID();

    final PropertyEditor __getPropertyEditor() {
        if (this._editor == INVALID_PROPERTY_EDITOR) {
            this._editor = this.createPropertyEditor();
        }
        return this._editor;
    }

    private final ExtendedPropertyEditor _getExtendedEditor() {
        PropertyEditor editor = this.__getPropertyEditor();
        if (editor instanceof ExtendedPropertyEditor) {
            return (ExtendedPropertyEditor)editor;
        }
        return null;
    }

    private boolean _isNumber(Class type) {
        return type == Byte.class || type == Byte.TYPE || type == Double.class || type == Double.TYPE || type == BigDecimal.class || type == BigInteger.class || type == Float.class || type == Float.TYPE || type == Integer.class || type == Integer.TYPE || type == Long.class || type == Long.TYPE || type == Number.class || type == Short.class || type == Short.TYPE;
    }

    static {
        PropertyEditor colorEditor;
        PropertyEditor fontEditor;
        if (PropertyEditorManager.findEditor(Character.TYPE) == null) {
            PropertyEditorManager.registerEditor(Character.TYPE, CharEditor.class);
        }
        if ((fontEditor = PropertyEditorManager.findEditor(Font.class)) == null || fontEditor.getClass() == FontEditor.class) {
            PropertyEditorManager.registerEditor(Font.class, oracle.bali.inspector.editors.FontEditor.class);
        }
        if ((colorEditor = PropertyEditorManager.findEditor(Color.class)) == null || colorEditor.getClass() == sun.beans.editors.ColorEditor.class) {
            PropertyEditorManager.registerEditor(Color.class, ColorEditor.class);
        }
        if (PropertyEditorManager.findEditor(Integer.class) == null) {
            PropertyEditorManager.registerEditor(Integer.class, IntEditor.class);
        }
        if (PropertyEditorManager.findEditor(Boolean.class) == null) {
            PropertyEditorManager.registerEditor(Boolean.class, BoolEditor.class);
        }
        INVALID_PROPERTY = new Object();
        INVALID_PROPERTY_EDITOR = PropertyEditorManager.findEditor(Integer.TYPE);
    }

    private class NumberEditor
    extends AbstractTableCellEditor
    implements ActionListener {
        private NumberTextField _field = new NumberTextField();

        public NumberEditor(Class type) {
            this._field.setBorder((Border)new EmptyBorder(0, 2, 0, 0));
            this._field.setDataType(type);
            this._field.addActionListener((ActionListener)this);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof Number) {
                this._field.setNumber((Number)value);
            } else if (value instanceof String) {
                this._field.setText(value.toString());
            } else {
                this._field.setNumber(null);
            }
            return this._field;
        }

        public Object getCellEditorValue() {
            return this._field.getNumber();
        }

        public boolean isCellEditable(EventObject anEvent) {
            Object source;
            Object object = source = anEvent == null ? null : anEvent.getSource();
            if (source != null && source instanceof Component) {
                return ((Component)source).isEnabled();
            }
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            this.stopCellEditing();
        }
    }

    private class Listen
    implements PropertyChangeListener {
        private Listen() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (!AbstractPropertyEditorFactory.this._ignoreEvents) {
                AbstractPropertyEditorFactory.this._changeSupport.firePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
            }
        }
    }
}

