/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractButton;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.statusBar.StatusBar;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.ewt.util.MenuUtils;
import oracle.bali.inspector.ColumnModel;
import oracle.bali.inspector.EmptyModel;
import oracle.bali.inspector.FocusHelper;
import oracle.bali.inspector.GroupCellHandler;
import oracle.bali.inspector.InspectorAppearance;
import oracle.bali.inspector.InspectorGroup;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.PropertyEditorHandler;
import oracle.bali.inspector.PropertyExpansionState;
import oracle.bali.inspector.PropertyFilterer;
import oracle.bali.inspector.PropertyGroup;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.SwitchingCellEditor;
import oracle.bali.inspector.TableResizer;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;

public class PropertyInspector
extends JComponent
implements Accessible {
    public static final String PROPERTY_EXPANDED_GROUPS = "expandedGroups";
    public static final String PROPERTY_CATEGORIZED = "categorized";
    public static final String PROPERTY_FIND_VISIBLE = "findVisible";
    public static final String PROPERTY_INTERSECTION = "intersection";
    public static final String PROPERTY_ALPHABETIZE_GROUP_PROPERTIES = "alphabetizeGroupProperties";
    public static final String PROPERTY_STATUS_VISIBLE = "statusVisible";
    public static final String PROPERTY_ACTION_COMPONENT = "actionComponent";
    public static final String PROPERTY_WRITE_ONLY = "writeOnlyIncluded";
    public static final String PROPERTY_READ_ONLY = "readOnlyIncluded";
    public static final String ID_UNION_INTERSECTION = "union";
    public static final String ID_FIND = "find";
    public static final String ID_CATEGORIZED_SORTED = "categorized";
    public static final String ID_UNPIN_PIN = "pin";
    protected static final String ICON_FIND = "find";
    protected static final String ICON_UNION = "union";
    protected static final String ICON_INTERSECTION = "intersection";
    protected static final String ICON_PIN = "link";
    protected static final String ICON_UNPIN = "unlink";
    protected static final String ICON_CATEGORIZED = "categorized";
    protected static final String ICON_ALPHABETIZED = "alphabetized";
    protected static final String ICON_FIND_NEXT = "findNext";
    protected static final String ICON_FIND_PREVIOUS = "findPrevious";
    private static final boolean _USE_LEAD;
    private static final Dimension _BUTTON_SIZE;
    private static final float _SPLITTER_LOCATION = 0.92f;
    static final String __PROPERTY_TARGET_NAME = "targetName";
    private static final String _KEY_FIND = "FIND";
    private static final String _KEY_UNION = "UNION";
    private static final String _KEY_INTERSECTION = "INTERSECTION";
    private static final String _KEY_UNPIN = "UNPIN";
    private static final String _KEY_PIN = "PIN";
    private static final String _FIND_NEXT_ID = "next";
    private static final String _FIND_PREVIOUS_ID = "previous";
    static final String _SORTED_ID = "sorted";
    private static final String _KEY_CATEGORIZED = "CATEGORIZED";
    private static final String _KEY_SORTED = "SORTED";
    private static final String __RESOURCE_BUNDLE = "oracle.bali.inspector.resource.InspectorBundle";
    private static final String _KEY_FIND_LABEL = "FIND_LABEL";
    private static final String _KEY_FIND_NEXT = "FIND_NEXT";
    private static final String _KEY_FIND_PREVIOUS = "FIND_PREVIOUS";
    private static final String _KEY_MULTIPLE_SELECTION = "MULTIPLE_SELECTION";
    private static final String _KEY_FIND_ERROR = "FIND_ERROR";
    private static final String _KEY_FIND_ERROR_TITLE = "FIND_ERROR_TITLE";
    private static Object[] _sDEFAULT_FIND_ARRAY;
    private boolean _readOnlyIncluded;
    private boolean _writeOnlyIncluded;
    private boolean _splitterSet;
    private SwitchingCellEditor _editingInputHandler;
    private InspectorGroup _group;
    private ColumnModel _columnModel;
    private JTextArea _statusText;
    private ExtendedTable _table;
    private JPanel _findArea;
    private Listener _listener;
    private JTextField _findText;
    private JLabel _findLabel;
    private AbstractButton _findPreviousItem;
    private AbstractButton _findNextItem;
    private JSplitPane _splitter;
    private JScrollPane _tableScrollBox;
    private JScrollPane _statusTextScrollBox;
    private transient GroupCellHandler _groupCellHandler;
    private PropertyEditorHandler _propertyEditorHandler;
    private JToggleButton _findItem;
    private MultiIconButton _categorizedItem;
    private MultiIconButton _unionItem;
    private MultiIconButton _pinItem;
    private Component _actionToolBar;
    private transient JPanel _toolbarLabelArea;
    private boolean _statusDisplayed;
    private boolean _alphabetizeGroups;
    private JLabel _accessibleLabel;

    public PropertyInspector() {
        this(new InspectorGroup());
    }

    public PropertyInspector(InspectorGroup group) {
        this.setInspectorGroup(group);
        this._editingInputHandler = new SwitchingCellEditor(this);
        this._propertyEditorHandler = new PropertyEditorHandler(this, this._editingInputHandler);
        this._groupCellHandler = new GroupCellHandler(this);
        this._listener = new Listener();
        this.setLayout(new BorderLayout(0, 2));
        this._table = new ExtendedTable();
        this._table.getSelectionModel().addListSelectionListener(this._listener);
        this._table.setAutoCreateColumnsFromModel(false);
        this._table.setAutoResizeMode(4);
        this._statusText = new JTextArea(){

            public Color getBackground() {
                return UIManager.getColor("control");
            }
        };
        this._statusText.setFont(this._table.getFont());
        this._statusText.setEditable(false);
        this._statusText.setWrapStyleWord(true);
        this._statusText.setLineWrap(true);
        this._statusText.addFocusListener(this._listener);
        this._tableScrollBox = new JScrollPane(this._table, 20, 31);
        this._tableScrollBox.getViewport().addMouseListener(this._listener);
        this._tableScrollBox.addMouseListener(this._listener);
        this._statusTextScrollBox = new JScrollPane(this._statusText, 20, 31);
        this._splitter = new Splitter((Component)this._tableScrollBox, (Component)this._statusTextScrollBox);
        this.add("Center", this._splitter);
        this._statusDisplayed = true;
        this.add("North", this._buildTitleArea());
        this._columnModel = new ColumnModel();
        this._table.setColumnModel(this._columnModel);
        this.setUnderlyingPropertyModel(new EmptyModel());
        this.setColumnWidth(PropertyModel.COLUMN_DISPLAY_NAME, 160);
        this.setColumnWidth(PropertyModel.COLUMN_VALUE, 180);
        this._table.setPreferredScrollableViewportSize(new Dimension(340, 400));
        this.setColumnRenderer(PropertyModel.COLUMN_DISPLAY_NAME, this._groupCellHandler);
        this.setColumnEditor(PropertyModel.COLUMN_DISPLAY_NAME, this._groupCellHandler);
        this.setColumnRenderer(PropertyModel.COLUMN_VALUE, this._propertyEditorHandler);
        this.setColumnEditor(PropertyModel.COLUMN_VALUE, this._propertyEditorHandler);
        this.updateUI();
    }

    public void setVisibleColumns(Object[] visibleColumnIDs) {
        if (visibleColumnIDs == null) {
            visibleColumnIDs = new Object[]{};
        }
        this._columnModel.setVisibleColumnIDs(visibleColumnIDs);
    }

    public Object[] getVisibleColumns() {
        return this._columnModel.getVisibleColumnIDs();
    }

    public void setUnderlyingPropertyModel(PropertyModel newModel) {
        PropertyModel oldModel;
        if (newModel == null) {
            newModel = new EmptyModel();
        }
        if ((oldModel = this.getUnderlyingPropertyModel()) == newModel) {
            return;
        }
        this.__commitEdit();
        boolean intersection = this.isIntersection();
        boolean wasCategorized = this.isCategorized();
        PropertyFilterer oldFilterer = null;
        PropertyFilterer newFilterer = null;
        String oldTargetName = null;
        String newTargetName = null;
        Object[] oldFilteredColumns = null;
        Object[] oldFilteredValues = null;
        Object[] oldFilteredDefaults = null;
        if (oldModel != null) {
            oldFilterer = this._getPropertyFilterer();
            oldFilteredColumns = oldFilterer.__getFilteredColumns();
            oldFilteredValues = oldFilterer.__getFilteredValues();
            oldFilteredDefaults = oldFilterer.__getFilteredDefaults();
            oldTargetName = oldFilterer.getTargetDisplayName();
            oldFilterer.removeTableModelListener(this._listener);
            oldFilterer.removePropertyChangeListener(this._listener);
            oldFilterer.disposeFilterer();
        }
        newFilterer = new PropertyFilterer(newModel, this);
        newFilterer.addPropertyChangeListener(this._listener);
        this._columnModel.setPropertyModel(newFilterer);
        this.getPropertyTable().setModel(newFilterer);
        this.getPropertyTable().getSelectionModel().removeListSelectionListener(this._listener);
        this.getPropertyTable().setSelectionModel(new ImmutableSelectionModel());
        this.getPropertyTable().getSelectionModel().addListSelectionListener(this._listener);
        newFilterer.addTableModelListener(this._listener);
        newFilterer.setReadOnlyIncluded(this.isReadOnlyIncluded());
        newFilterer.setWriteOnlyIncluded(this.isWriteOnlyIncluded());
        newFilterer.setAlphabetizeGroupProperties(this.isAlphabetizeGroupProperties());
        if (oldFilteredColumns != null) {
            newFilterer.setFilterInfo(oldFilteredColumns, oldFilteredValues, oldFilteredDefaults);
        }
        Locale locale = LocaleUtils.getDefaultableLocale((Component)this);
        newFilterer.setLocale(locale);
        newFilterer.setUseIntersection(intersection);
        newTargetName = newFilterer.getTargetDisplayName();
        int sortMode = wasCategorized ? 2 : 1;
        newFilterer.setSortMode(sortMode);
        this._updateCaches(true);
        this._propertyEditorHandler.clear();
        this.repaint();
        this.firePropertyChange(__PROPERTY_TARGET_NAME, oldTargetName, newTargetName);
    }

    public PropertyModel getUnderlyingPropertyModel() {
        PropertyFilterer filterer = this._getPropertyFilterer();
        if (filterer != null) {
            return filterer.getFilteredModel();
        }
        return null;
    }

    public final PropertyModel getPropertyModel() {
        return this._getPropertyFilterer();
    }

    public void setInspectorGroup(InspectorGroup newGroup) {
        if (newGroup == null) {
            newGroup = new InspectorGroup();
        }
        if (newGroup != this._group) {
            if (this._group != null) {
                this._group.removeInspector(this);
            }
            this._group = newGroup;
            if (newGroup != null) {
                this._group.addInspector(this);
            }
        }
    }

    public InspectorGroup getInspectorGroup() {
        return this._group;
    }

    public void setColumnRenderer(Object columnID, TableCellRenderer renderer) {
        if (columnID == PropertyModel.COLUMN_DISPLAY_NAME && !(renderer instanceof GroupCellHandler)) {
            TableCellEditor h = this.getColumnEditor(PropertyModel.COLUMN_DISPLAY_NAME);
            this._groupCellHandler = new GroupCellHandler(this, renderer, h);
            renderer = this._groupCellHandler;
            this.setColumnEditor(PropertyModel.COLUMN_DISPLAY_NAME, this._groupCellHandler);
            this._updateCaches(true);
        }
        TableColumn column = this._columnModel.getTableColumn(columnID);
        column.setCellRenderer(renderer);
        this.getPropertyTable().repaint();
    }

    public TableCellRenderer getColumnRenderer(Object columnID) {
        TableColumn column = this._columnModel.getTableColumn(columnID);
        TableCellRenderer r = column.getCellRenderer();
        if (columnID == PropertyModel.COLUMN_DISPLAY_NAME && r instanceof GroupCellHandler) {
            r = ((GroupCellHandler)r).getDefaultRenderer();
        }
        return r;
    }

    public void setColumnEditor(Object columnID, TableCellEditor editor) {
        if (columnID == PropertyModel.COLUMN_DISPLAY_NAME && !(editor instanceof GroupCellHandler)) {
            TableCellRenderer r = this.getColumnRenderer(PropertyModel.COLUMN_DISPLAY_NAME);
            this._groupCellHandler = new GroupCellHandler(this, r, editor);
            editor = this._groupCellHandler;
            this.setColumnRenderer(columnID, this._groupCellHandler);
            this._updateCaches(true);
        }
        TableColumn column = this._columnModel.getTableColumn(columnID);
        column.setCellEditor(editor);
        this.getPropertyTable().repaint();
    }

    public TableCellEditor getColumnEditor(Object columnID) {
        TableColumn column = this._columnModel.getTableColumn(columnID);
        TableCellEditor e = column.getCellEditor();
        if (columnID == PropertyModel.COLUMN_DISPLAY_NAME && e instanceof GroupCellHandler) {
            e = ((GroupCellHandler)e).getDefaultEditor();
        }
        return e;
    }

    public void setColumnWidth(Object columnID, int columnWidth) {
        TableColumn column = this._columnModel.getTableColumn(columnID);
        column.setWidth(columnWidth);
        column.setPreferredWidth(columnWidth);
    }

    public int getColumnWidth(Object columnID) {
        TableColumn column = this._columnModel.getTableColumn(columnID);
        if (column.getModelIndex() != -1) {
            return column.getWidth();
        }
        return -1;
    }

    public JTable getPropertyTable() {
        return this._table;
    }

    public void setWriteOnlyIncluded(boolean writeOnlyIncluded) {
        if (this._writeOnlyIncluded != writeOnlyIncluded) {
            this._writeOnlyIncluded = writeOnlyIncluded;
            PropertyFilterer pf = this._getPropertyFilterer();
            if (pf != null) {
                pf.setWriteOnlyIncluded(writeOnlyIncluded);
            }
            this.firePropertyChange(PROPERTY_WRITE_ONLY, !this._writeOnlyIncluded, this._writeOnlyIncluded);
        }
    }

    public boolean isWriteOnlyIncluded() {
        return this._writeOnlyIncluded;
    }

    public void setReadOnlyIncluded(boolean readOnlyIncluded) {
        if (this._readOnlyIncluded != readOnlyIncluded) {
            this._readOnlyIncluded = readOnlyIncluded;
            PropertyFilterer pf = this._getPropertyFilterer();
            if (pf != null) {
                pf.setReadOnlyIncluded(readOnlyIncluded);
            }
            this.firePropertyChange(PROPERTY_READ_ONLY, !this._readOnlyIncluded, this._readOnlyIncluded);
        }
    }

    public boolean isReadOnlyIncluded() {
        return this._readOnlyIncluded;
    }

    public void setColumnFilter(Object columnID, Object filterValue, Object defaultValue) {
        PropertyFilterer f = this._getPropertyFilterer();
        if (f != null) {
            f.setColumnFilter(columnID, filterValue, defaultValue);
        }
    }

    public Object getFilterValue(Object columnID) {
        PropertyFilterer f = this._getPropertyFilterer();
        return f != null ? f.getFilterValue(columnID) : PropertyModel.DOES_NOT_EXIST;
    }

    public Object getFilterDefaultValue(Object columnID) {
        PropertyFilterer f = this._getPropertyFilterer();
        return f != null ? f.getFilterDefaultValue(columnID) : PropertyModel.DOES_NOT_EXIST;
    }

    public void setStatusText(String text) {
        this._statusText.setText(text);
        this._statusText.setCaretPosition(0);
    }

    public String getStatusText() {
        return this._statusText.getText();
    }

    public PropertyGroup[] getExpandedGroups() {
        PropertyFilterer filter = this._getPropertyFilterer();
        return filter == null ? null : filter.getGroups(true);
    }

    public void setExpandedGroups(PropertyGroup[] expandedGroups) {
        PropertyFilterer filter = this._getPropertyFilterer();
        if (expandedGroups == null) {
            expandedGroups = new PropertyGroup[]{};
        }
        if (filter != null) {
            filter.setGroups(expandedGroups, true);
        }
    }

    public boolean isGroupExpanded(PropertyGroup group) {
        PropertyFilterer filter = this._getPropertyFilterer();
        return filter == null ? false : filter.isGroupExpanded(group);
    }

    public void setGroupExpanded(PropertyGroup group, boolean expanded) {
        PropertyFilterer filter = this._getPropertyFilterer();
        if (filter != null) {
            filter.setGroupExpanded(group, expanded);
        }
    }

    public PropertyGroup[] getCollapsedGroups() {
        PropertyFilterer filter = this._getPropertyFilterer();
        return filter == null ? null : filter.getGroups(false);
    }

    public void setCollapsedGroups(PropertyGroup[] collapsedGroups) {
        PropertyFilterer filter = this._getPropertyFilterer();
        if (collapsedGroups == null) {
            collapsedGroups = new PropertyGroup[]{};
        }
        if (filter != null) {
            filter.setGroups(collapsedGroups, false);
        }
    }

    public boolean isCategorized() {
        PropertyFilterer filter = this._getPropertyFilterer();
        return filter == null ? true : filter.isSorted() == 2;
    }

    public void setCategorized(boolean categorized) {
        if (this.isCategorized() != categorized) {
            this.__commitEdit();
            int sortMode = categorized ? 2 : 1;
            this._updateCategorizedItem(categorized);
            PropertyFilterer filterer = this._getPropertyFilterer();
            if (filterer != null) {
                filterer.setSortMode(sortMode);
            }
            this.firePropertyChange("categorized", !categorized, categorized);
        }
    }

    public boolean isFindVisible() {
        return this._findArea.isVisible();
    }

    public void setFindVisible(boolean visible) {
        if (this.isFindVisible() != visible) {
            this._findArea.setVisible(visible);
            if (visible) {
                this._findText.selectAll();
                this._findText.requestFocus();
            } else {
                this._findText.transferFocus();
            }
            this._findItem.setSelected(visible);
            this.revalidate();
            this.firePropertyChange(PROPERTY_FIND_VISIBLE, !visible, visible);
        }
    }

    public boolean isIntersection() {
        PropertyFilterer filter = this._getPropertyFilterer();
        return filter == null ? false : filter.getUseIntersection();
    }

    public void setIntersection(boolean intersection) {
        if (this.isIntersection() != intersection) {
            this.__commitEdit();
            PropertyFilterer filterer = this._getPropertyFilterer();
            if (filterer != null) {
                filterer.setUseIntersection(intersection);
            }
            this._updateIntersectionItem(intersection);
            this.firePropertyChange("intersection", !intersection, intersection);
        }
    }

    public void setActionToolBar(JToolBar newActionToolBar) {
        this.setActionComponent(newActionToolBar);
    }

    public JToolBar getActionToolBar() {
        Component c = this.getActionComponent();
        return c instanceof JToolBar ? (JToolBar)c : null;
    }

    public void setActionComponent(Component newActionComponent) {
        if (this._actionToolBar != newActionComponent) {
            Component old = this._actionToolBar;
            if (this._actionToolBar != null) {
                this._toolbarLabelArea.remove(this._actionToolBar);
            }
            this._actionToolBar = newActionComponent;
            if (this._actionToolBar != null) {
                this._toolbarLabelArea.add("North", this._actionToolBar);
            }
            this.firePropertyChange(PROPERTY_ACTION_COMPONENT, old, this._actionToolBar);
        }
    }

    public Component getActionComponent() {
        return this._actionToolBar;
    }

    public AbstractButton getStandardToolBarItem(String itemID) {
        if ("union".equals(itemID)) {
            return this._unionItem;
        }
        if ("categorized".equals(itemID)) {
            return this._categorizedItem;
        }
        if ("find".equals(itemID)) {
            return this._findItem;
        }
        if (ID_UNPIN_PIN.equals(itemID)) {
            return this._pinItem;
        }
        return null;
    }

    public void setStatusVisible(boolean displayStatus) {
        if (this._statusDisplayed != displayStatus) {
            this._statusDisplayed = displayStatus;
            if (this._statusDisplayed) {
                this.remove(this._tableScrollBox);
                this._splitter.setTopComponent(this._tableScrollBox);
                this.add("Center", this._splitter);
            } else {
                this.remove(this._splitter);
                this._splitter.setTopComponent(null);
                this.add("Center", this._tableScrollBox);
            }
            this.firePropertyChange(PROPERTY_STATUS_VISIBLE, !this._statusDisplayed, this._statusDisplayed);
            this.revalidate();
        }
    }

    public boolean isStatusVisible() {
        return this._statusDisplayed;
    }

    public void setAlphabetizeGroupProperties(boolean alphabetize) {
        if (this._alphabetizeGroups != alphabetize) {
            this._alphabetizeGroups = alphabetize;
            PropertyFilterer filter = this._getPropertyFilterer();
            if (filter != null) {
                filter.setAlphabetizeGroupProperties(this._alphabetizeGroups);
            }
            this.firePropertyChange(PROPERTY_ALPHABETIZE_GROUP_PROPERTIES, !this._alphabetizeGroups, this._alphabetizeGroups);
        }
    }

    public boolean isAlphabetizeGroupProperties() {
        return this._alphabetizeGroups;
    }

    public void updateUI() {
        super.updateUI();
        this._splitterSet = false;
        this._groupCellHandler.updateUI();
    }

    public void setLocale(Locale newLocale) {
        super.setLocale(newLocale);
        this._updateLabels(newLocale);
    }

    public void addNotify() {
        super.addNotify();
        this._updateLabels(this.getLocale());
    }

    public void doLayout() {
        super.doLayout();
        if (!this._splitterSet && this.getHeight() != 0) {
            this._splitter.setDividerLocation(0.92f);
            this._splitterSet = true;
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this._actionToolBar != null) {
            this._actionToolBar.setEnabled(enabled);
        }
        this._pinItem.setEnabled(enabled);
        this._findItem.setEnabled(enabled);
        this._unionItem.setEnabled(enabled);
        this._categorizedItem.setEnabled(enabled);
        this._findText.setEnabled(enabled);
        this._findLabel.setEnabled(enabled);
        this._findPreviousItem.setEnabled(enabled);
        this._findNextItem.setEnabled(enabled);
        this._statusText.setEnabled(enabled);
        this._splitter.setEnabled(enabled);
        this._tableScrollBox.setEnabled(enabled);
        this._tableScrollBox.getVerticalScrollBar().setEnabled(enabled);
        this._statusTextScrollBox.setEnabled(enabled);
        this._statusTextScrollBox.getVerticalScrollBar().setEnabled(enabled);
        this.getPropertyTable().setEnabled(enabled);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new Access();
            StatusBar bar = new StatusBar();
            this._accessibleLabel = new AccessLabel();
            bar.add((Component)this._accessibleLabel);
            bar.setVisible(false);
            this.add("South", (Component)bar);
        }
        return this.accessibleContext;
    }

    public PropertyExpansionState[] getExpandedProperties() {
        PropertyFilterer filterer = this._getPropertyFilterer();
        return filterer == null ? null : filterer.getExpandedProperties();
    }

    public void setExpandedProperties(PropertyExpansionState[] properties) {
        PropertyFilterer filterer = this._getPropertyFilterer();
        if (filterer != null) {
            filterer.setExpandedProperties(properties);
        }
    }

    public final boolean showAdvancedEditor(int rowIndex) {
        PropertyModel model = this.getPropertyModel();
        if (!model.isPropertyWritable(rowIndex)) {
            return false;
        }
        Object propertyID = model.getPropertyID(rowIndex);
        if (propertyID != null && propertyID != PropertyModel.DOES_NOT_EXIST) {
            PropertyEditorFactory editorFactory = model.getPropertyEditorFactory(rowIndex);
            return this._group.showAdvancedEditor(propertyID, editorFactory, this);
        }
        return false;
    }

    protected final void showAdvancedEditorDialog(int rowIndex) {
        this.showAdvancedEditor(rowIndex);
    }

    protected int findText(PropertyModel model, String searchText, int startRow, boolean searchForward, Object[] columns) {
        int textLen = searchText.length();
        Collator insensitiveCollator = Collator.getInstance(this.getLocale());
        insensitiveCollator.setStrength(0);
        int numRows = model.getRowCount();
        int currRow = startRow;
        do {
            for (int i = 0; i < columns.length; ++i) {
                int index = model.getColumnIndex(columns[i]);
                if (index == -1) continue;
                Object data = model.getValueAt(currRow, index);
                String currName = null;
                if (data instanceof String) {
                    currName = (String)data;
                }
                if (currName == null || currName.length() < textLen || !insensitiveCollator.equals(searchText, currName.substring(0, textLen))) continue;
                return currRow;
            }
        } while ((currRow = PropertyInspector._nextRow(currRow, searchForward, numRows)) != startRow);
        return -1;
    }

    protected final void showTearOffEditorPalette(int rowIndex) {
        PropertyModel model = this.getPropertyModel();
        if (!model.isPropertyWritable(rowIndex)) {
            return;
        }
        Object propertyID = model.getPropertyID(rowIndex);
        if (propertyID != null && propertyID != PropertyModel.DOES_NOT_EXIST) {
            PropertyEditorFactory editorFactory = model.getPropertyEditorFactory(rowIndex);
            this._group.showTearOffEditor(propertyID, editorFactory, this);
        }
    }

    protected void firePropertyChange(String name, Object old, Object newValue) {
        super.firePropertyChange(name, old, newValue);
    }

    protected JPopupMenu getMenuForPropertyGroup(PropertyGroup group, PropertyModel underlyingModel, Object column) {
        return null;
    }

    protected JPopupMenu getMenuForRow(int row, PropertyModel underlyingModel, Object column) {
        return null;
    }

    protected Icon getIcon(String imageName) {
        Image i = ImageUtils.getImageResource(PropertyInspector.class, (String)("images/" + imageName + ".gif"));
        return new ImageIcon(i);
    }

    protected void updateRowActions(int row, PropertyModel model) {
    }

    protected JTextField createFindTextField() {
        return new JTextField();
    }

    protected AbstractButton createFindNextButton() {
        JButton b = new JButton();
        b.setMargin(new Insets(0, 2, 0, 2));
        return b;
    }

    protected AbstractButton createFindPreviousButton() {
        JButton b = new JButton();
        b.setMargin(new Insets(0, 2, 0, 2));
        return b;
    }

    final String __getTargetDisplayName() {
        PropertyFilterer ds = this._getPropertyFilterer();
        return ds == null ? null : ((PropertyModel)ds).getTargetDisplayName();
    }

    private void _fireAccessibleChange(String s) {
        if (this._accessibleLabel != null) {
            this._accessibleLabel.setText(s);
        }
    }

    private void _updateLabels(Locale newLocale) {
        if (this._findLabel == null) {
            return;
        }
        String label = this.__getTranslatedString(_KEY_FIND_LABEL);
        this._findLabel.setText(StringUtils.stripMnemonic((String)label));
        this._findLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)label));
        label = this.__getTranslatedString(_KEY_FIND_NEXT);
        this._findNextItem.setToolTipText(label);
        label = this.__getTranslatedString(_KEY_FIND_PREVIOUS);
        this._findPreviousItem.setToolTipText(label);
        PropertyFilterer ds = this._getPropertyFilterer();
        if (ds != null) {
            ((PropertyModel)ds).setLocale(newLocale);
        }
    }

    private JPanel _buildTitleArea() {
        this._toolbarLabelArea = new JPanel(new BorderLayout());
        this._toolbarLabelArea.setBorder(new EmptyBorder(3, 3, 0, 3));
        String label = this.__getTranslatedString(_KEY_FIND);
        this._findItem = new ToggleButton(this.getIcon("find"));
        this._findItem.addItemListener(this._listener);
        this._findItem.setToolTipText(label);
        Icon[] unionImages = new Icon[]{this.getIcon("union"), this.getIcon("intersection")};
        label = this.__getTranslatedString(_KEY_UNION);
        this._unionItem = new MultiIconButton("union", unionImages);
        this._unionItem.addActionListener(this._listener);
        this._unionItem.setToolTipText(label);
        Icon[] pinImages = new Icon[]{this.getIcon(ICON_UNPIN), this.getIcon(ICON_PIN)};
        label = this.__getTranslatedString(_KEY_UNPIN);
        this._pinItem = new MultiIconButton(ID_UNPIN_PIN, pinImages);
        this._pinItem.addActionListener(this._listener);
        this._pinItem.setToolTipText(label);
        Icon[] categorizedImages = new Icon[]{this.getIcon("categorized"), this.getIcon(ICON_ALPHABETIZED)};
        label = this.__getTranslatedString(_KEY_CATEGORIZED);
        this._categorizedItem = new MultiIconButton("categorized", categorizedImages);
        this._categorizedItem.addActionListener(this._listener);
        this._categorizedItem.setToolTipText(label);
        JToolBar actionToolBar = new JToolBar();
        actionToolBar.setBorder(new EmptyBorder(0, 0, 0, 0));
        actionToolBar.add(this._findItem);
        actionToolBar.add(this._unionItem);
        actionToolBar.add(this._categorizedItem);
        this.setActionToolBar(actionToolBar);
        this._findArea = this._buildFindArea();
        this._toolbarLabelArea.add("South", this._findArea);
        return this._toolbarLabelArea;
    }

    private JPanel _buildFindArea() {
        JPanel findArea = new JPanel();
        findArea.setVisible(false);
        findArea.setLayout(new BorderLayout(3, 0));
        JPanel labelArea = new JPanel();
        labelArea.setLayout(new BorderLayout(5, 0));
        labelArea.setBorder(new EmptyBorder(2, 0, 5, 2));
        JTextField findText = this.createFindTextField();
        findText.addActionListener(this._listener);
        this._findText = findText;
        String label = this.__getTranslatedString(_KEY_FIND_LABEL);
        this._findLabel = new JLabel(StringUtils.stripMnemonic((String)label));
        this._findLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)label));
        this._findLabel.setLabelFor(this._findText);
        labelArea.add("West", this._findLabel);
        labelArea.add("Center", findText);
        label = this.__getTranslatedString(_KEY_FIND_NEXT);
        this._findNextItem = this.createFindNextButton();
        this._findNextItem.setIcon(this.getIcon(ICON_FIND_NEXT));
        this._findNextItem.setActionCommand(_FIND_NEXT_ID);
        this._findNextItem.setToolTipText(label);
        this._findNextItem.addActionListener(this._listener);
        label = this.__getTranslatedString(_KEY_FIND_PREVIOUS);
        this._findPreviousItem = this.createFindPreviousButton();
        this._findPreviousItem.setIcon(this.getIcon(ICON_FIND_PREVIOUS));
        this._findPreviousItem.setActionCommand(_FIND_PREVIOUS_ID);
        this._findPreviousItem.setToolTipText(label);
        this._findPreviousItem.addActionListener(this._listener);
        JPanel findToolBar = new JPanel(new BorderLayout(3, 0));
        findToolBar.add("West", this._findNextItem);
        findToolBar.add("East", this._findPreviousItem);
        findArea.add("Center", labelArea);
        findArea.add("East", findToolBar);
        return findArea;
    }

    private void _updatePinState(boolean isPinned) {
        String label = isPinned ? this.__getTranslatedString(_KEY_PIN) : this.__getTranslatedString(_KEY_UNPIN);
        this._pinItem.setToolTipText(label);
        this._pinItem.setIconIndex(isPinned ? 1 : 0);
        this.getInspectorGroup().setInspectorPinned(this, isPinned);
    }

    private void _setIntersection(boolean intersection) {
        this._updateIntersectionItem(intersection);
        this.setIntersection(intersection);
    }

    private void _updateIntersectionItem(boolean intersection) {
        String label = intersection ? this.__getTranslatedString(_KEY_INTERSECTION) : this.__getTranslatedString(_KEY_UNION);
        this._unionItem.setToolTipText(label);
        this._unionItem.setIconIndex(intersection ? 1 : 0);
    }

    private void _setCategorized(boolean categorized) {
        this._updateCategorizedItem(categorized);
        this.setCategorized(categorized);
    }

    private void _updateCategorizedItem(boolean categorized) {
        String label = categorized ? this.__getTranslatedString(_KEY_CATEGORIZED) : this.__getTranslatedString(_KEY_SORTED);
        this._categorizedItem.setToolTipText(label);
        this._categorizedItem.setIconIndex(categorized ? 0 : 1);
    }

    private PropertyFilterer _getPropertyFilterer() {
        TableModel model;
        if (this._table != null && (model = this._table.getModel()) instanceof PropertyFilterer) {
            return (PropertyFilterer)model;
        }
        return null;
    }

    String __getTranslatedString(String key) {
        ResourceBundle b = ResourceBundle.getBundle(__RESOURCE_BUNDLE, LocaleUtils.getDefaultableLocale((Component)this));
        return b.getString(key);
    }

    private void _updateCaches(boolean columnChanged) {
        if (columnChanged) {
            PropertyModel ds = this.getPropertyModel();
            int editorIndex = ds.getColumnIndex(PropertyModel.COLUMN_EDITOR_FACTORY);
            int levelIndex = ds.getColumnIndex(PropertyModel.COLUMN_LEVEL);
            int valueIndex = ds.getColumnIndex(PropertyModel.COLUMN_VALUE);
            int nameIndex = ds.getColumnIndex(PropertyModel.COLUMN_DISPLAY_NAME);
            int writableIndex = ds.getColumnIndex(PropertyModel.COLUMN_IS_WRITABLE);
            int drillableIndex = ds.getColumnIndex(PropertyModel.COLUMN_IS_DRILLABLE);
            this._groupCellHandler.setIndicies(levelIndex, drillableIndex);
            this._propertyEditorHandler.setIndicies(valueIndex, editorIndex);
            ((ExtendedTable)this.getPropertyTable()).setIndicies(nameIndex, levelIndex, valueIndex, writableIndex);
        }
        this._editingInputHandler.init();
    }

    void __commitEdit() {
        TableCellEditor editor = this.getPropertyTable().getCellEditor();
        if (editor != null) {
            boolean bl = editor.stopCellEditing();
        }
    }

    static final int __getAnchorSelectionIndex(ListSelectionModel model) {
        return _USE_LEAD ? model.getLeadSelectionIndex() : model.getAnchorSelectionIndex();
    }

    private static int _nextRow(int currRow, boolean searchForward, int numRows) {
        if (searchForward) {
            if (++currRow == numRows) {
                currRow = 0;
            }
        } else if (--currRow == -1) {
            currRow = numRows - 1;
        }
        return currRow;
    }

    static {
        String version = System.getProperty("java.version");
        _USE_LEAD = version == null || !version.startsWith("1.1") && !version.startsWith("1.2") && !version.startsWith("1.3") && !version.startsWith("1.4");
        _BUTTON_SIZE = new Dimension(26, 26);
        _sDEFAULT_FIND_ARRAY = new Object[]{PropertyModel.COLUMN_DISPLAY_NAME};
    }

    private class AccessLabel
    extends JLabel {
        private AccessLabel() {
        }

        public void setText(String text) {
            String old = this.getText();
            super.setText(text);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleName", old, text);
            }
        }
    }

    private class Access
    extends JComponent.AccessibleJComponent {
        private Access() {
            super(PropertyInspector.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }

    private class Splitter
    extends JSplitPane {
        public Splitter(Component top, Component bottom) {
            super(0, top, bottom);
            Class<?> c = this.getClass();
            try {
                Class[] params = new Class[]{Double.TYPE};
                Method m = c.getMethod("setResizeWeight", params);
                Object[] args = new Object[]{new Double(1.0)};
                m.invoke((Object)this, args);
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        public void reshape(int x, int y, int width, int height) {
            int oldHeight = this.getHeight();
            int oldLocation = this.getDividerLocation();
            super.reshape(x, y, width, height);
            if (oldHeight != 0 && oldLocation != 0) {
                int newLocation = this.getDividerLocation();
                int oldSize = oldHeight - oldLocation;
                newLocation = height - oldSize;
                this.setDividerLocation(newLocation);
            } else if (!PropertyInspector.this._splitterSet) {
                this.setDividerLocation(0.92f);
                PropertyInspector.this._splitterSet = true;
            }
        }
    }

    private class MultiIconButton
    extends JButton {
        private int _index;
        private Icon _image0;
        private Icon _image1;

        public MultiIconButton(String cmd, Icon[] images) {
            super(images[0]);
            this._index = 0;
            this._image0 = images[0];
            this._image1 = images[1];
            this.setActionCommand(cmd);
        }

        public void updateUI() {
            super.updateUI();
            this.setPreferredSize(_BUTTON_SIZE);
            this.setMinimumSize(_BUTTON_SIZE);
            this.setMaximumSize(_BUTTON_SIZE);
        }

        public int getIconIndex() {
            return this._index;
        }

        public void setIconIndex(int index) {
            this._index = index;
            if (index == 0) {
                this.setIcon(this._image0);
            } else {
                this.setIcon(this._image1);
            }
        }
    }

    private class ToggleButton
    extends JToggleButton {
        public ToggleButton(Icon icon) {
            super(icon);
        }

        public void updateUI() {
            super.updateUI();
            this.setPreferredSize(_BUTTON_SIZE);
            this.setMinimumSize(_BUTTON_SIZE);
            this.setMaximumSize(_BUTTON_SIZE);
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    ItemListener,
    PropertyChangeListener,
    ListSelectionListener,
    TableModelListener,
    FocusListener {
        private Listener() {
        }

        public void focusGained(FocusEvent e) {
            int length = PropertyInspector.this._statusText.getDocument().getLength();
            PropertyInspector.this._statusText.setCaretPosition(length);
            PropertyInspector.this._statusText.moveCaretPosition(0);
        }

        public void focusLost(FocusEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (PropertyInspector.this.isEnabled()) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    JPopupMenu menu = PropertyInspector.this.getMenuForRow(-1, PropertyInspector.this.getUnderlyingPropertyModel(), null);
                    if (menu != null) {
                        MenuUtils.showPopupMenu((JPopupMenu)menu, (Component)e.getComponent(), (int)e.getX(), (int)e.getY());
                    }
                } else {
                    PropertyInspector.this.getPropertyTable().requestFocus();
                }
            }
        }

        public void tableChanged(TableModelEvent e) {
            PropertyInspector.this._updateCaches(true);
        }

        public void valueChanged(ListSelectionEvent e) {
            int row = PropertyInspector.this.getPropertyTable().getSelectedRow();
            PropertyModel model = PropertyInspector.this.getPropertyModel();
            if (row == -1) {
                PropertyInspector.this.setStatusText(null);
            } else if (PropertyInspector.this.getPropertyTable().getSelectedRowCount() == 1) {
                PropertyInspector.this.setStatusText(model.getPropertyDescription(row));
            } else {
                PropertyInspector.this.setStatusText(PropertyInspector.this.__getTranslatedString(PropertyInspector._KEY_MULTIPLE_SELECTION));
            }
            PropertyInspector.this.updateRowActions(row, model);
        }

        public void propertyChange(PropertyChangeEvent e) {
            if ("targetDisplayName".equals(e.getPropertyName())) {
                PropertyModel ds = (PropertyModel)e.getSource();
                PropertyInspector.this.firePropertyChange(PropertyInspector.__PROPERTY_TARGET_NAME, e.getOldValue(), ds.getTargetDisplayName());
            }
        }

        public void itemStateChanged(ItemEvent e) {
            PropertyInspector.this.setFindVisible(PropertyInspector.this._findItem.isSelected());
        }

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if ("union".equals(cmd)) {
                PropertyInspector.this._setIntersection(PropertyInspector.this._unionItem.getIconIndex() == 0);
            } else if ("categorized".equals(cmd)) {
                boolean categorized = PropertyInspector.this._categorizedItem.getIconIndex() == 0;
                PropertyInspector.this._setCategorized(!categorized);
            } else if (PropertyInspector.ID_UNPIN_PIN.equals(cmd)) {
                PropertyInspector.this._updatePinState(PropertyInspector.this._pinItem.getIconIndex() == 0);
            } else if (PropertyInspector._FIND_NEXT_ID.equals(cmd) || PropertyInspector._FIND_PREVIOUS_ID.equals(cmd)) {
                this._findText(PropertyInspector.this._findText.getText(), PropertyInspector._FIND_NEXT_ID.equals(cmd));
            } else {
                this._findText(PropertyInspector.this._findText.getText(), true);
            }
        }

        private void _findText(String searchText, boolean searchForward) {
            PropertyModel model = PropertyInspector.this.getPropertyModel();
            if (model == null) {
                return;
            }
            int numRows = model.getRowCount();
            if (numRows == 0) {
                return;
            }
            int textLen = searchText.length();
            if (textLen == 0) {
                return;
            }
            JTable table = PropertyInspector.this.getPropertyTable();
            int startRow = table.getSelectedRow();
            startRow = startRow != -1 ? PropertyInspector._nextRow(startRow, searchForward, numRows) : (searchForward ? 0 : numRows - 1);
            int row = PropertyInspector.this.findText(model, searchText, startRow, searchForward, _sDEFAULT_FIND_ARRAY);
            if (row != -1) {
                table.setRowSelectionInterval(row, row);
                int column = table.getColumnCount() - 1;
                table.setColumnSelectionInterval(column, column);
                table.scrollRectToVisible(table.getCellRect(row, 0, false));
                String o = model.getPropertyDisplayName(row);
                if (o instanceof String) {
                    PropertyInspector.this._fireAccessibleChange(o.toString());
                }
            } else {
                String message = PropertyInspector.this.__getTranslatedString(PropertyInspector._KEY_FIND_ERROR);
                String title = PropertyInspector.this.__getTranslatedString(PropertyInspector._KEY_FIND_ERROR_TITLE);
                MessageFormat mf = new MessageFormat(message);
                Object[] args = new Object[]{searchText};
                message = mf.format(args);
                JOptionPane.showMessageDialog(table, message, title, 1);
            }
        }
    }

    private class ImmutableSelectionModel
    extends DefaultListSelectionModel {
        private ImmutableSelectionModel() {
        }

        public void clearSelection() {
            if (PropertyInspector.this.isEnabled()) {
                super.clearSelection();
            }
        }

        public void addSelectionInterval(int a, int b) {
            if (PropertyInspector.this.isEnabled()) {
                super.addSelectionInterval(a, b);
            }
        }

        public void insertIndexInterval(int a, int b, boolean before) {
            if (PropertyInspector.this.isEnabled()) {
                super.insertIndexInterval(a, b, before);
            }
        }

        public void removeIndexInterval(int a, int b) {
            if (PropertyInspector.this.isEnabled()) {
                super.removeIndexInterval(a, b);
            }
        }

        public void setSelectionInterval(int a, int b) {
            if (PropertyInspector.this.isEnabled()) {
                super.setSelectionInterval(a, b);
            }
        }

        public void setAnchorSelectionIndex(int a) {
            if (PropertyInspector.this.isEnabled()) {
                super.setAnchorSelectionIndex(a);
            }
        }

        public void setLeadSelectionIndex(int a) {
            if (PropertyInspector.this.isEnabled()) {
                super.setLeadSelectionIndex(a);
            }
        }
    }

    class ExtendedTable
    extends JTable {
        private boolean _inEditingStopped = false;
        private TableResizer _resizer;
        private InspectorAppearance _appearance;
        private FocusHelper _focusHelper;

        public ExtendedTable() {
            this.setTableHeader(null);
            this._appearance = new InspectorAppearance(this);
            this.putClientProperty("terminateEditOnFocusLost", Boolean.FALSE);
            this._focusHelper = new FocusHelper(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics g) {
            PropertyInspector.this.getPropertyModel().startRead();
            try {
                super.paint(g);
            }
            finally {
                PropertyInspector.this.getPropertyModel().stopRead();
            }
        }

        public boolean getSurrendersFocusOnKeystroke() {
            return true;
        }

        public String getToolTipText(MouseEvent e) {
            String tooltipText = super.getToolTipText(e);
            if (tooltipText != null && !"".equals(tooltipText) && !tooltipText.equals(this.getToolTipText())) {
                return tooltipText;
            }
            Point p = new Point(e.getX(), e.getY());
            int row = this.rowAtPoint(p);
            int column = this.columnAtPoint(p);
            if (column < 0 || column >= this.getColumnCount() || row < 0 || row >= this.getRowCount()) {
                return null;
            }
            TableCellRenderer tcr = this.getCellRenderer(row, column);
            Component c = this.prepareRenderer(tcr, row, column);
            Dimension d = c.getPreferredSize();
            int width = this.getColumnModel().getColumn(column).getWidth();
            int margin = this.getColumnModel().getColumnMargin() * 2;
            if (d.width + margin >= width) {
                String s;
                Object displayValue;
                int displayValueIndex;
                PropertyModel m;
                Object o = this.getValueAt(row, column);
                if (!(o instanceof String) && (m = (PropertyModel)this.getModel()).getColumnIndex(PropertyModel.COLUMN_VALUE) == column && (displayValueIndex = m.getColumnIndex(PropertyModel.COLUMN_DISPLAY_VALUE)) != -1 && (displayValue = m.getValueAt(row, displayValueIndex)) != null && !"".equals(s = displayValue.toString())) {
                    return s;
                }
                return o == null ? null : o.toString();
            }
            return null;
        }

        public void updateUI() {
            if (this._resizer != null) {
                this._resizer.dispose();
            }
            this._resizer = new TableResizer(this);
            super.updateUI();
            FocusUtils.setFocusTraversalKeysEnabled((Component)this, (boolean)false);
            ActionListener editListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ListSelectionModel rsm = ExtendedTable.this.getSelectionModel();
                    int row = PropertyInspector.__getAnchorSelectionIndex(rsm);
                    ListSelectionModel csm = ExtendedTable.this.getColumnModel().getSelectionModel();
                    int column = PropertyInspector.__getAnchorSelectionIndex(csm);
                    ExtendedTable.this.editCellAt(row, column);
                }
            };
            KeyStroke keyStroke = KeyStroke.getKeyStroke(113, 0);
            this.registerKeyboardAction(editListener, keyStroke, 1);
            ActionListener enterListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int editingColumn = ExtendedTable.this.getEditingColumn();
                    int editingRow = ExtendedTable.this.getEditingRow();
                    if (editingColumn != -1 && editingRow != -1) {
                        PropertyInspector.this.__commitEdit();
                    } else {
                        ListSelectionModel csm = ExtendedTable.this.getColumnModel().getSelectionModel();
                        int column = PropertyInspector.__getAnchorSelectionIndex(csm);
                        TableColumn tc = ExtendedTable.this.getColumnModel().getColumn(column);
                        if (tc.getIdentifier() == PropertyModel.COLUMN_DISPLAY_NAME) {
                            ListSelectionModel rsm = ExtendedTable.this.getSelectionModel();
                            int row = PropertyInspector.__getAnchorSelectionIndex(rsm);
                            PropertyModel model = PropertyInspector.this.getPropertyModel();
                            if (PropertyInspector.this._groupCellHandler.__cellHasChildren(model, row)) {
                                boolean expanded = !PropertyInspector.this._groupCellHandler.__isCellExpanded(model, row);
                                PropertyInspector.this._groupCellHandler.__setCellExpanded(model, row, expanded);
                            }
                        }
                    }
                }
            };
            keyStroke = KeyStroke.getKeyStroke(10, 0);
            this.registerKeyboardAction(enterListener, keyStroke, 1);
            keyStroke = KeyStroke.getKeyStroke(10, 1);
            this.unregisterKeyboardAction(keyStroke);
            ActionListener menuListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ListSelectionModel rsm = ExtendedTable.this.getSelectionModel();
                    int row = PropertyInspector.__getAnchorSelectionIndex(rsm);
                    ListSelectionModel csm = ExtendedTable.this.getColumnModel().getSelectionModel();
                    int column = PropertyInspector.__getAnchorSelectionIndex(csm);
                    Rectangle r = ExtendedTable.this.getCellRect(row, column, true);
                    ExtendedTable.this._showMenu(column, row, r.x + r.width / 3, r.y + r.height / 2);
                }
            };
            keyStroke = KeyStroke.getKeyStroke(121, 1);
            this.registerKeyboardAction(menuListener, keyStroke, 0);
        }

        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component c = super.prepareRenderer(renderer, row, column);
            boolean isSelected = this.isCellSelected(row, column);
            boolean rowIsAnchor = PropertyInspector.__getAnchorSelectionIndex(this.getSelectionModel()) == row;
            boolean colIsAnchor = PropertyInspector.__getAnchorSelectionIndex(this.columnModel.getSelectionModel()) == column;
            boolean hasFocus = rowIsAnchor && colIsAnchor && this.hasFocus();
            this._appearance.prepareRenderer(this, isSelected, hasFocus, row, column, c);
            return c;
        }

        public Component prepareEditor(TableCellEditor editor, int row, int column) {
            Component c = super.prepareEditor(editor, row, column);
            if (c != null) {
                SwingUtilities.updateComponentTreeUI(c);
            }
            return c;
        }

        public void columnMarginChanged(ChangeEvent e) {
            PropertyInspector.this.__commitEdit();
            super.columnMarginChanged(e);
        }

        public void sizeColumnsToFit(int resizingColumn) {
            if (resizingColumn == -1) {
                resizingColumn = this.getColumnCount() - 1;
            }
            super.sizeColumnsToFit(resizingColumn);
        }

        public boolean editCellAt(int row, int column, EventObject e) {
            Component focus;
            boolean result = super.editCellAt(row, column, e);
            if (result && (focus = this.getEditorComponent()) != null && (e == null || e instanceof KeyEvent)) {
                focus.requestFocus();
            }
            return result;
        }

        public void removeEditor() {
            TableCellEditor editor = this.getCellEditor();
            if (editor != null) {
                boolean requestFocus;
                editor.removeCellEditorListener(this);
                boolean bl = requestFocus = SwingUtilities.findFocusOwner(this) != null;
                if (this.editorComp != null) {
                    this._focusHelper.remove(this.editorComp);
                }
                if (requestFocus) {
                    this.requestFocus();
                }
                Rectangle cellRect = this.getCellRect(this.editingRow, this.editingColumn, false);
                this.setCellEditor(null);
                this.setEditingColumn(-1);
                this.setEditingRow(-1);
                this.editorComp = null;
                this.repaint(cellRect);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void editingStopped(ChangeEvent e) {
            int editRow = this.getEditingRow();
            int editColumn = this.getEditingColumn();
            Rectangle visibleRect = this.getVisibleRect();
            try {
                this._inEditingStopped = true;
                this._real_editingStopped(e);
            }
            finally {
                int nowSelected;
                this._inEditingStopped = false;
                if (editRow >= 0 && editColumn >= 0 && editRow < this.getRowCount() && editColumn < this.getColumnCount() && (nowSelected = this.getSelectedRow()) != editRow) {
                    this.changeSelection(editRow, editColumn, false, false);
                }
                if (visibleRect != null) {
                    this.scrollRectToVisible(visibleRect);
                }
            }
        }

        public void scrollRectToVisible(Rectangle aRect) {
            if (!this._inEditingStopped) {
                super.scrollRectToVisible(aRect);
            }
        }

        private void _real_editingStopped(ChangeEvent e) {
            Object oldValue;
            int column = this.getEditingColumn();
            if (column == -1) {
                return;
            }
            column = PropertyInspector.this._columnModel.getColumn(column).getModelIndex();
            int valueIndex = PropertyInspector.this.getPropertyModel().getColumnIndex(PropertyModel.COLUMN_VALUE);
            PropertyModel model = (PropertyModel)this.getModel();
            int row = this.getEditingRow();
            Object newValue = oldValue = model.getPropertyValue(row);
            TableCellEditor editor = this.getCellEditor();
            if (editor != null) {
                newValue = editor.getCellEditorValue();
            }
            if (column != valueIndex) {
                if (column == PropertyInspector.this.getPropertyModel().getColumnIndex(PropertyModel.COLUMN_DISPLAY_NAME)) {
                    super.editingCanceled(e);
                    return;
                }
                try {
                    super.editingStopped(e);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable th) {
                    Object id = model.getPropertyID(row);
                    PropertyEditorFactory factory = model.getPropertyEditorFactory(row);
                    PropertyInspector.this.getInspectorGroup().showErrorMessage(id, factory, PropertyInspector.this, th, newValue);
                }
                model.invalidateValueData();
                return;
            }
            if (!model.isSettable(oldValue, newValue) && !model.isDataConflicting(valueIndex, row)) {
                this.removeEditor();
            } else {
                try {
                    super.editingStopped(e);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable th) {
                    Object id = model.getPropertyID(row);
                    PropertyEditorFactory factory = model.getPropertyEditorFactory(row);
                    PropertyInspector.this.getInspectorGroup().showErrorMessage(id, factory, PropertyInspector.this, th, newValue);
                }
                model.invalidateValueData();
            }
        }

        public void setIndicies(int nameIndex, int levelIndex, int valueIndex, int writableIndex) {
            this._appearance.setIndicies(nameIndex, levelIndex, valueIndex, writableIndex);
        }

        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            if (!this.isEnabled() || e.getID() != 501 || !SwingUtilities.isRightMouseButton(e)) {
                return;
            }
            Point p = new Point(e.getX(), e.getY());
            int column = this.columnAtPoint(p);
            int row = this.rowAtPoint(p);
            if (column == -1 || row == -1) {
                return;
            }
            this._showMenu(column, row, e.getX(), e.getY());
        }

        PropertyInspector __getInspector() {
            return PropertyInspector.this;
        }

        private void _showMenu(int column, int row, int x, int y) {
            TableColumn tc = this.getColumnModel().getColumn(column);
            Object c = tc.getIdentifier();
            PropertyFilterer pf = PropertyInspector.this._getPropertyFilterer();
            int modelIndex = pf.getModelIndex(row);
            JPopupMenu m = null;
            if (modelIndex >= 0) {
                m = PropertyInspector.this.getMenuForRow(modelIndex, PropertyInspector.this.getUnderlyingPropertyModel(), c);
            } else {
                PropertyGroup group = pf.getPropertyGroupAtIndex(modelIndex);
                m = PropertyInspector.this.getMenuForPropertyGroup(group, PropertyInspector.this.getUnderlyingPropertyModel(), c);
            }
            if (m != null) {
                MenuUtils.showPopupMenu((JPopupMenu)m, (Component)this, (int)x, (int)y);
            }
        }
    }
}

