/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.share.security.SecurityContextMap;

public class PermissionEvaluator
extends SecurityContextMap {
    protected static ADFLogger _adfSecLogger = ADFSecurityUtil.getADFLogger();
    private SecurityContext mSecurityContext;
    private Hashtable<String, Object> properties = new Hashtable();
    public static final String TASKFLOW_PERMISSION_CLASS = "oracle.adf.controller.security.TaskFlowPermission";
    public static final String REGION_PERMISSION_CLASS = "oracle.adf.share.security.authorization.RegionPermission";
    public static final String RESOURCE_PERMISSION_CLASS = "oracle.security.jps.ResourcePermission";
    public static final String JAAS_PERMISSION_ACTION = "action";
    public static final String PERMISSION_PARAM_LIST = "PermissionParams";
    private static final String DEFAULT_PRIVILEGE = "view";
    private static final String DELIMITER = "[;,]";
    private static final String EQUALS = "=";
    private static final String[] RESOURCE_PARAMS = new String[]{"resourceType", "resourceName", "action"};
    public static final String[] PERMISSION_PARAMS = new String[]{"target", "privilege"};
    private static final ThreadLocal<StringBuilder> _STRING_BUILDER = new ThreadLocal();

    public PermissionEvaluator(SecurityContext secCtx) {
        this.mSecurityContext = secCtx;
    }

    public PermissionEvaluator(SecurityContext secCtx, String permissionClass) {
        this(secCtx);
        if (permissionClass != null) {
            this.properties.put("permissionClass", permissionClass);
            this.properties.put("privilege", DEFAULT_PRIVILEGE);
        }
    }

    @Override
    protected Object internalGet(String key) {
        int equalPos = key.indexOf(EQUALS);
        if (equalPos >= 0) {
            String clsName = (String)this.properties.get("permissionClass");
            if (clsName == null) {
                this.properties.put("permissionClass", TASKFLOW_PERMISSION_CLASS);
            }
            PermissionEvaluator.tokenize(key, this.properties);
            clsName = (String)this.properties.get("permissionClass");
            if (clsName.equals(RESOURCE_PERMISSION_CLASS)) {
                this.properties.put(PERMISSION_PARAM_LIST, PermissionEvaluator.getPermissionParamList(RESOURCE_PARAMS, this.properties));
            } else {
                String privilege = (String)this.properties.get(JAAS_PERMISSION_ACTION);
                if (privilege != null) {
                    this.properties.put("privilege", privilege != null ? privilege : DEFAULT_PRIVILEGE);
                }
            }
        } else {
            this.properties.put("target", key);
        }
        Permission permission = this.mSecurityContext.createPermissionInstance(this.properties);
        return new Boolean(this.mSecurityContext.hasPermission(permission));
    }

    static void tokenize(String key, Hashtable<String, Object> props) {
        String[] pairs;
        for (String p : pairs = key.split(DELIMITER)) {
            String[] tokens = p.split(EQUALS);
            if (tokens.length != 2) continue;
            String name = tokens[0];
            String value = tokens[1];
            if (name != null) {
                name = name.trim();
            }
            if (value != null) {
                value = value.trim();
            }
            if (name == null || name.length() == 0) continue;
            props.put(name, value);
            if (!_adfSecLogger.isFinest()) continue;
            StringBuilder s = _STRING_BUILDER.get();
            if (s == null) {
                s = new StringBuilder(100);
                _STRING_BUILDER.set(s);
            }
            s.setLength(0);
            s.append("token pair [name, value] = [").append(name).append(", ").append(value).append("]");
            _adfSecLogger.log(Level.FINEST, s.toString());
        }
    }

    static ArrayList<String> getPermissionParamList(String[] paramNames, Hashtable<String, Object> props) {
        ArrayList<String> params = new ArrayList<String>(paramNames.length);
        for (String param : paramNames) {
            String value = (String)props.get(param);
            params.add(value);
        }
        return params;
    }
}

