/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.io.StringWriter;
import javax.naming.RefAddr;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DocumentFragment;

public class XmlRefAddr
extends RefAddr {
    private static final long serialVersionUID = -7152338982425662223L;
    private DocumentFragment mFragment;

    public XmlRefAddr(String addrType, DocumentFragment doc) {
        super(addrType);
        this.mFragment = doc;
    }

    @Override
    public Object getContent() {
        return this.getDocumentFragment();
    }

    public DocumentFragment getDocumentFragment() {
        return this.mFragment;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof XmlRefAddr) {
            XmlRefAddr xmlRefAddr = (XmlRefAddr)obj;
            return this.toString().equals(xmlRefAddr.toString());
        }
        return super.equals(obj);
    }

    @Override
    public String toString() {
        StringBuffer str = new StringBuffer("Type: " + this.addrType + "\n");
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult strResult = new StreamResult(new StringWriter());
            DOMSource domSource = new DOMSource(this.getDocumentFragment());
            transformer.transform(domSource, strResult);
            str.append("Content: " + strResult.getWriter().toString() + "\n");
        }
        catch (TransformerConfigurationException e) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return str.toString();
    }
}

