/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.config.properties;

import java.util.HashMap;
import java.util.Map;
import oracle.adf.share.config.ADFConfigCallback;
import oracle.adf.share.config.ADFConfigParsingContext;
import oracle.adf.share.logging.ADFLogger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ADFContextPropertiesCallback
implements ADFConfigCallback {
    private static ADFLogger LOG = null;
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VALUE = "value";
    private static final String ADF_CONTEXT_NODE = "adf-property";
    public static final String PROPERTIES_NODE = "adf-properties-child";

    public ADFContextPropertiesCallback() {
        LOG = this.getLogger();
    }

    private ADFLogger getLogger() {
        if (LOG == null) {
            LOG = ADFLogger.createADFLogger(ADFContextPropertiesCallback.class);
        }
        return LOG;
    }

    @Override
    public Map parseADFConfiguration(Element el, Map storedResult, ADFConfigParsingContext currentCtx) {
        if (storedResult != null) {
            return storedResult;
        }
        NodeList nl = el.getElementsByTagNameNS("http://xmlns.oracle.com/adf/config/properties", ADF_CONTEXT_NODE);
        if (nl.getLength() <= 0) {
            LOG.info("No ADFContext properties defined in adf-config.xml.");
            return null;
        }
        int len = nl.getLength();
        HashMap<String, String> mContextEnv = new HashMap<String, String>(len);
        for (int i = 0; i < len; ++i) {
            Element elem = (Element)nl.item(i);
            String attrKeyValue = elem.getAttribute(ATTR_NAME);
            String attrValueValue = elem.getAttribute(ATTR_VALUE);
            mContextEnv.put(attrKeyValue, attrValueValue);
        }
        return mContextEnv;
    }
}

