/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.config;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.adf.share.ADFShareException;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.config.ADFConfigImpl;
import oracle.adf.share.jndi.AdfInitialContext;
import oracle.adf.share.jndi.AdfJndiConfig;
import oracle.adf.share.security.JAASInitialContextFactory;
import oracle.adf.share.security.SecurityEnv;

public class FallbackConfigImpl
extends ADFConfigImpl {
    private List sessionDefPackages = null;
    private Object ADFMDSConfig = null;
    private Method getDefaultMDSInstance = null;

    FallbackConfigImpl() {
    }

    @Override
    public Object getMDSInstance() {
        try {
            if (this.ADFMDSConfig == null) {
                Class cls = ClassUtils.forName((String)"oracle.adf.share.config.ADFMDSConfig");
                this.ADFMDSConfig = cls.newInstance();
                this.getDefaultMDSInstance = this.ADFMDSConfig.getClass().getDeclaredMethod("getDefaultMDSInstance", String.class);
            }
            return this.getDefaultMDSInstance.invoke(this.ADFMDSConfig, this._applicationName);
        }
        catch (ADFShareException ex) {
            throw ex;
        }
        catch (InvocationTargetException e) {
            Throwable t = e;
            if (e.getCause() != null) {
                t = e.getCause();
            }
            if (t instanceof ADFShareException) {
                throw (ADFShareException)t;
            }
            throw new ADFShareException("getMDSInstance error", t);
        }
        catch (Exception ex) {
            throw new ADFShareException("getMDSInstance error", ex);
        }
    }

    static Object getDefaultMDSInstance() {
        return new FallbackConfigImpl().getMDSInstance();
    }

    @Override
    public List getSessionDefPackages() {
        try {
            Map sessDefMap = this.getConfigObject("http://xmlns.oracle.com/adf/mds/config");
            if (sessDefMap != null) {
                this.sessionDefPackages = (List)sessDefMap.get("SessionDefPackages");
            }
            if (this.sessionDefPackages == null) {
                Class cls = ClassUtils.forName((String)"oracle.adf.share.config.ADFMDSConfig");
                Object obj = cls.newInstance();
                Method m = obj.getClass().getDeclaredMethod("getDefaultSessionDefPackages", String.class);
                this.sessionDefPackages = (List)m.invoke(obj, this._applicationName);
            }
            return this.sessionDefPackages;
        }
        catch (ADFShareException ex) {
            throw ex;
        }
        catch (InvocationTargetException e) {
            Throwable t = e;
            if (e.getCause() != null) {
                t = e.getCause();
            }
            if (t instanceof ADFShareException) {
                throw (ADFShareException)t;
            }
            throw new ADFShareException("getSessionDefPackages error", t);
        }
        catch (Exception ex) {
            throw new ADFShareException("getSessionDefPackages error", ex);
        }
    }

    static List getDefaultSessionDefPackages() {
        return new FallbackConfigImpl().getSessionDefPackages();
    }

    @Override
    public Context getConnectionsContext() throws NamingException {
        Map connMap = this.getConfigObject("http://xmlns.oracle.com/adf/jndi/config");
        if (connMap == null) {
            return FallbackConfigImpl.getDefaultConnectionsContext();
        }
        return new AdfInitialContext(new Hashtable(connMap));
    }

    static Context getDefaultConnectionsContext() throws NamingException {
        return AdfJndiConfig.getDefaultConnectionsContext();
    }

    @Override
    public Context getSecurityContext() throws NamingException {
        Map secMap = this.getConfigObject("http://xmlns.oracle.com/adf/security/config");
        if (secMap == null) {
            return FallbackConfigImpl.getDefaultSecurityContext();
        }
        JAASInitialContextFactory factory = new JAASInitialContextFactory();
        return factory.getInitialContext(secMap);
    }

    static Context getDefaultSecurityContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>(4);
        env.put("java.naming.factory.initial", "oracle.adf.share.security.JAASInitialContextFactory");
        String auth = System.getProperty("oracle.adf.security.authorization.enforce");
        env.put("oracle.adf.security.authorization.enforce", auth == null || auth.length() == 0 ? SecurityEnv.AUTHORIZATION_ENFORCE_DEFAULT : auth);
        String jaznConfig = System.getProperty("oracle.security.jazn.config");
        if (jaznConfig != null && jaznConfig.length() > 0) {
            env.put("oracle.security.jazn.config", jaznConfig);
        }
        env.put("oracle.adf.security.credentialstore", SecurityEnv.CREDENTIAL_STORE_PROVIDER_DEFAULT);
        JAASInitialContextFactory factory = new JAASInitialContextFactory();
        return factory.getInitialContext((Hashtable)env);
    }

    @Override
    public void releaseResources() {
        super.releaseResources();
        this.ADFMDSConfig = null;
        this.getDefaultMDSInstance = null;
    }
}

