/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.config;

import java.beans.Beans;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import oracle.adf.share.ADFConfigEx;
import oracle.adf.share.ADFConfigLifecycle;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.common.ClassUtilsGetResourceAsStreamPrivAction;
import oracle.adf.share.common.ClassUtilsGetResourcePrivAction;
import oracle.adf.share.config.ADFConfigImpl;
import oracle.adf.share.config.FallbackConfigImpl;
import oracle.adf.share.logging.ADFLogger;

public class ADFConfigFactory {
    private static Map<Object, ADFConfigEx> applications = new WeakHashMap<Object, ADFConfigEx>(4);
    private static final String CLASSNAME = "oracle.adf.share.config.ADFConfigFactory";
    private static final String resourceBundle = "oracle.adf.share.config.resources.Messages";
    private static final ResourceBundle resBundle = ResourceBundle.getBundle("oracle.adf.share.config.resources.Messages");
    private static final ADFLogger mLogger = ADFLogger.createADFLogger((String)"oracle.adf.share.config.ADFConfigFactory", (String)"oracle.adf.share.config.resources.Messages");
    private static final Object applicationsLock = new Object();

    public static ADFConfigEx findOrCreateADFConfig() {
        return ADFConfigFactory.findOrCreateADFConfig("META-INF/adf-config.xml");
    }

    public static ADFConfigEx findOrCreateADFConfig(boolean reparse) {
        return ADFConfigFactory.getInstance().findOrCreateADFConfig("META-INF/adf-config.xml", reparse);
    }

    public static ADFConfigEx findOrCreateADFConfig(String resourceName) {
        return ADFConfigFactory.getInstance().findOrCreateADFConfig(resourceName, false);
    }

    private static ADFConfigFactory getInstance() {
        return InstanceHolder.INSTANCE;
    }

    protected synchronized ADFConfigImpl createApplication(ClassLoader targetCL, String resourceName) {
        return this.createApplicationFromInputStream(targetCL, resourceName);
    }

    protected ADFConfigImpl createDefaultConfig() {
        return new FallbackConfigImpl();
    }

    private static ADFConfigImpl getApplicationFromMap(Object key) {
        ADFConfigImpl app = null;
        app = (ADFConfigImpl)applications.get(key);
        return app;
    }

    private static void putApplicationInMap(Object key, ADFConfigEx impl) {
        applications.put(key, impl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ADFConfigEx findOrCreateADFConfig(String resourceName, boolean reparse) {
        String method = "findOrCreateADFConfig";
        ClassLoader cl = ClassUtils.getClassLoader();
        ADFConfigImpl app = ADFConfigFactory.getApplicationFromMap(cl);
        if (app == null) {
            Map<Object, ADFConfigEx> map = applications;
            synchronized (map) {
                app = ADFConfigFactory.getApplicationFromMap(cl);
                List<ClassLoader> targetCLs = null;
                if (app == null) {
                    ClassLoader tgtCL2;
                    targetCLs = this.getAllTargetClassLoaders(cl, resourceName);
                    Iterator<ClassLoader> i$ = targetCLs.iterator();
                    while (i$.hasNext() && (app = ADFConfigFactory.getApplicationFromMap(tgtCL2 = i$.next())) == null) {
                    }
                    if (app == null) {
                        app = this.createApplication(cl, resourceName);
                        if (app == null) {
                            if (mLogger.isFine()) {
                                mLogger.fine(CLASSNAME, "findOrCreateADFConfig", resBundle.getString("RESOURCE_NOT_FOUND"), (Object)resourceName);
                            }
                            app = this.createDefaultConfig();
                        }
                    } else {
                        app.registerCallbackListeners();
                    }
                    ADFConfigFactory.putApplicationInMap(cl, app);
                    for (ClassLoader tgtCL2 : targetCLs) {
                        if (mLogger.isFine()) {
                            mLogger.fine("Adding classloader to ADFConfigFactory: " + tgtCL2);
                        }
                        ADFConfigFactory.putApplicationInMap(tgtCL2, app);
                    }
                    if (mLogger.isFine()) {
                        this.printClasspathDiagnostic(cl, resourceName);
                    }
                } else if (app instanceof ADFConfigImpl) {
                    this.adfConfigFound(cl, app, resourceName, reparse);
                }
            }
        } else if (app instanceof ADFConfigImpl) {
            this.adfConfigFound(cl, app, resourceName, reparse);
        }
        return app;
    }

    private void adfConfigFound(ClassLoader cl, ADFConfigImpl app, String resourceName, boolean reparse) {
        boolean resourceRead = app.isResourceVisited(resourceName);
        if (reparse || !resourceRead) {
            InputStream is = cl.getResourceAsStream(resourceName);
            if (is != null) {
                app.readConfig(is, resourceName, reparse);
            } else {
                app.setResourceVisited(resourceName);
            }
        }
    }

    private void printClasspathDiagnostic(ClassLoader cl, String resourceName) {
        try {
            if (mLogger.isFine()) {
                Enumeration<URL> urlList = cl.getResources(resourceName);
                int count = 0;
                String mesg = resBundle.getString("PRINT_URLS");
                mLogger.fine(CLASSNAME, "printClasspathDiagnostic", mesg, (Object)resourceName);
                while (urlList.hasMoreElements()) {
                    URL url = urlList.nextElement();
                    mLogger.fine(count++ + ": " + url.getPath());
                }
                mLogger.fine("\n");
                if (count > 1) {
                    mLogger.warning(CLASSNAME, "printClasspathDiagnostic", resBundle.getString("MULTIPLE_RESOURCES_FOUND"), (Object)resourceName);
                }
            }
        }
        catch (IOException ignore) {
            // empty catch block
        }
    }

    private ADFConfigImpl createApplicationFromInputStream(ClassLoader cl, String resourceName) {
        ClassUtilsGetResourceAsStreamPrivAction getResourceAsStreamPrivAction = new ClassUtilsGetResourceAsStreamPrivAction(cl, resourceName);
        InputStream is = (InputStream)AccessController.doPrivileged(getResourceAsStreamPrivAction);
        if (is != null) {
            if (mLogger.isFine()) {
                URL url = cl.getResource(resourceName);
                mLogger.fine(CLASSNAME, "createApplicationFromInputStream", resBundle.getString("READING_URL"), (Object)url.getPath());
            }
            return new ADFConfigImpl(is, resourceName);
        }
        return null;
    }

    private List<ClassLoader> getAllTargetClassLoaders(ClassLoader cl, String resourceName) {
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>(4);
        ClassLoader childCL = cl;
        ClassLoader targetCL = cl;
        boolean done = false;
        while (!done) {
            targetCL = this.getTargetClassLoader(cl, resourceName);
            if (targetCL != cl) {
                classLoaders.add(targetCL);
            } else {
                done = true;
            }
            cl = targetCL;
        }
        return classLoaders;
    }

    private ClassLoader getTargetClassLoader(ClassLoader cl, String resourceName) {
        ClassLoader parentCl = null;
        ClassLoader targetCL = cl;
        parentCl = System.getSecurityManager() == null ? cl.getParent() : (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassUtils.getClassLoader().getParent();
            }
        });
        if (parentCl != null) {
            ClassUtilsGetResourcePrivAction fromContextLoaderPrivAction = new ClassUtilsGetResourcePrivAction(cl, resourceName);
            ClassUtilsGetResourcePrivAction fromParentContextLoaderPrivAction = new ClassUtilsGetResourcePrivAction(parentCl, resourceName);
            URL fromContextClassLoader = (URL)AccessController.doPrivileged(fromContextLoaderPrivAction);
            URL fromParentClassLoader = (URL)AccessController.doPrivileged(fromParentContextLoaderPrivAction);
            if (fromContextClassLoader != null && fromParentClassLoader != null && fromContextClassLoader.getPath().equals(fromParentClassLoader.getPath())) {
                targetCL = parentCl;
            }
        }
        return targetCL;
    }

    public static ADFConfigEx findADFConfig(String namedConfig) {
        return ADFConfigFactory.getApplicationFromMap(namedConfig);
    }

    public static ADFConfigEx findOrCreateADFConfig(String name, URL adfConfigUrl) {
        return ADFConfigFactory.findOrCreateADFConfig(name, adfConfigUrl, ADFConfigImpl.class);
    }

    public static synchronized ADFConfigEx findOrCreateADFConfig(String name, URL adfConfigUrl, Class configClass) {
        ADFConfigEx app = ADFConfigFactory.getApplicationFromMap(name);
        if (app == null) {
            Object[] parameters = new Object[]{name, adfConfigUrl};
            Class[] parameterTypes = new Class[]{String.class, URL.class};
            try {
                Constructor constructor = configClass.getConstructor(parameterTypes);
                app = (ADFConfigEx)constructor.newInstance(parameters);
            }
            catch (Exception e) {
                mLogger.warning((Throwable)e);
                app = null;
            }
            if (app != null) {
                ADFConfigFactory.putApplicationInMap(name, app);
            }
        }
        return app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterNamedConfig(String namedConfig) {
        Object object = applicationsLock;
        synchronized (object) {
            applications.remove(namedConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUpApplicationState(ClassLoader appClassLoader) {
        if (mLogger.isFine()) {
            mLogger.fine(resBundle.getString("CLEAN_APPLICATION_STATE"));
        }
        WeakHashMap<Object, Object> applicationsCopy = new WeakHashMap(4);
        boolean mapEdited = false;
        Object object = applicationsLock;
        synchronized (object) {
            applicationsCopy = new WeakHashMap<Object, ADFConfigEx>(applications);
        }
        Object app = applicationsCopy.get(appClassLoader);
        if (app == null) {
            for (Object key : applicationsCopy.keySet()) {
                ClassLoader cl;
                if (!(key instanceof ClassLoader) || (cl = (ClassLoader)key).getParent() != appClassLoader) continue;
                app = applicationsCopy.get(cl);
                break;
            }
        }
        if (app != null) {
            if (app instanceof ADFConfigEx) {
                ADFConfigEx config = (ADFConfigEx)app;
                mLogger.info(resBundle.getString("ADF_CONFIG_IMPLEMENTATION"), (Object)config.getClass().toString());
                config.releaseResources();
            }
            while (applicationsCopy.containsValue(app)) {
                applicationsCopy.values().remove(app);
                mapEdited = true;
            }
        }
        if (mapEdited) {
            Object object2 = applicationsLock;
            synchronized (object2) {
                applications = applicationsCopy;
            }
        }
        applicationsCopy = null;
    }

    private static ADFConfigFactory initInstance() {
        ADFConfigFactory instance = null;
        if (!Beans.isDesignTime()) {
            try {
                Class factoryclass = ClassUtils.forName((String)"oracle.adf.share.config.MDSConfigFactory");
                instance = (ADFConfigFactory)factoryclass.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (instance == null) {
            instance = new ADFConfigFactory();
        }
        mLogger.finest(resBundle.getString("CONFIG_INSTANCE_IMPL"), (Object)instance.getClass().getName());
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUpApplicationCaches(ClassLoader appClassLoader) {
        if (mLogger.isFinest()) {
            mLogger.info("Clean up Application Caches");
        }
        WeakHashMap<Object, ADFConfigEx> applicationsCopy = new WeakHashMap(4);
        Object object = applicationsLock;
        synchronized (object) {
            applicationsCopy = new WeakHashMap<Object, ADFConfigEx>(applications);
        }
        if (mLogger.isFinest()) {
            ADFConfigFactory.dumpApplicationsMap(applicationsCopy);
        }
        Object app = null;
        for (Object key : applicationsCopy.keySet()) {
            ClassLoader cl;
            if (!(key instanceof ClassLoader) || (cl = (ClassLoader)key) != appClassLoader && cl.getParent() != appClassLoader || (app = (Object)applicationsCopy.get(cl)) == null || !ADFConfigEx.class.isAssignableFrom(app.getClass())) continue;
            ADFConfigFactory.clearAdfConfigCaches((ADFConfigEx)app);
        }
        applicationsCopy = null;
    }

    public static void dumpApplicationsMap(Map<Object, ADFConfigEx> curApplications) {
        try {
            Iterator<Object> iterator;
            Set<Object> keys = curApplications.keySet();
            Iterator<Object> iterator2 = iterator = keys != null ? keys.iterator() : null;
            if (iterator != null) {
                StringBuffer adfConfigMap = new StringBuffer(100);
                while (iterator.hasNext()) {
                    Object currKey = iterator.next();
                    ADFConfigEx adfConfig = curApplications.get(currKey);
                    Object mdsInstance = adfConfig.getMDSInstance();
                    adfConfigMap.append("Key = " + currKey.toString() + ", ADFConfig = " + adfConfig.toString() + ", MDS Instance = " + mdsInstance.toString() + ".\n");
                }
                mLogger.finest("ADFConfig Map. \n" + adfConfigMap.toString());
            }
        }
        catch (Throwable t) {
            mLogger.finest("Error dumping ADFConfig Map = " + t.getMessage());
        }
    }

    public static void clearAdfConfigCaches(ADFConfigEx adfConfig) {
        if (null == adfConfig || !ADFConfigLifecycle.class.isAssignableFrom(adfConfig.getClass())) {
            return;
        }
        if (mLogger.isFinest()) {
            mLogger.finest("ADFConfigFactory.cleanUpApplicationCaches. " + resBundle.getString("ADF_CONFIG_IMPLEMENTATION"), (Object)adfConfig.getClass().toString());
        }
        ((ADFConfigLifecycle)((Object)adfConfig)).clearCaches();
    }

    static /* synthetic */ ADFConfigFactory access$000() {
        return ADFConfigFactory.initInstance();
    }

    private static class InstanceHolder {
        public static final ADFConfigFactory INSTANCE = ADFConfigFactory.access$000();

        private InstanceHolder() {
        }
    }
}

