/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import oracle.jdeveloper.cm.ConnectInfoPrompter;
import oracle.jdeveloper.cm.ConnectInfoPrompterFixture;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionFixture;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ConnectionStore;
import oracle.jdeveloper.cm.ConnectionType;
import oracle.jdeveloper.cm.ConnectionWrapper;
import oracle.jdeveloper.cm.DefaultConnectionStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConnectionManagerTests {
    private ConnectionFixture m_fixture1 = new ConnectionFixture();
    private ConnectionManager m_connection;
    private ConnectInfoPrompterFixture m_infoPrompter;

    @Before
    public void setUp() throws Exception {
        this.m_fixture1.setUp();
        this.m_connection = this.m_fixture1.getConnectionManager();
        this.m_infoPrompter = new ConnectInfoPrompterFixture();
    }

    @After
    public void tearDown() throws Exception {
        this.m_fixture1.tearDown();
    }

    @Test
    public void getInstance() {
        Assert.assertNotNull((String)"getInstance", (Object)this.m_connection);
    }

    @Test
    public void getConnectionTypeNames() throws Exception {
        this.checkConnectionTypes(this.m_connection.getConnectionTypeNames());
    }

    @Test
    public void getConnectionType() {
        this.checkConnectionType("JDBC");
        this.checkConnectionType("JDBC_ODBC");
        this.checkConnectionType("ORACLE_LITE");
        this.checkConnectionType("OTHER_JDBC");
        this.checkConnectionType("OC4J");
        this.checkConnectionType("IAS_via_LOCAL_DCM");
        this.checkConnectionType("IAS_via_REMOTE_DCM");
        this.checkConnectionType("WEBLOGIC");
        this.checkConnectionType("WebLogic_7.x");
        this.checkConnectionType("BI_JDBC");
    }

    @Test
    public void getConnectionTypes() {
        Iterator iter = this.m_connection.getConnectionTypes();
        Assert.assertNotNull((String)"Connection Types", (Object)iter);
        while (iter.hasNext()) {
            ConnectionType type = (ConnectionType)iter.next();
            Assert.assertNotNull((String)"Type Name", (Object)type.getTypeName());
        }
    }

    @Test
    public void putConnectionDescriptor() throws Exception {
        this.m_connection.putConnectionDescriptor("standalone_oc4j", this.m_fixture1.standalone_oc4j);
        Assert.assertNotNull((String)"standalone_oc4j - Descriptor", (Object)this.m_connection.getConnectionDescriptor("standalone_oc4j"));
        Assert.assertTrue((String)"get Connection Descriptor", (boolean)this.m_fixture1.standalone_oc4j.equals((Object)this.m_connection.getConnectionDescriptor("standalone_oc4j")));
    }

    @Test
    public void deployToFile() throws Exception {
        this.m_connection.deployToFile("connections.xml");
        this.checkFile();
    }

    @Test
    public void deployToFile1() throws Exception {
        this.m_connection.deployToFile("connections.xml", false);
        this.checkFile();
        this.m_connection.deployToFile("connections.xml", true);
        this.checkFile();
    }

    @Test
    public void getPrivateInstance() {
        Assert.assertNotNull((String)"getPrivateInstance", (Object)ConnectionManager.getPrivateInstance());
    }

    @Test
    public void getConnection() throws Exception {
        ConnectionWrapper oracle9i = this.m_connection.getConnection("oracle9i_jdbc");
        Assert.assertNotNull((String)"get connection oracle9i", (Object)oracle9i);
    }

    @Test
    public void getConnection1() throws Exception {
        ConnectionWrapper oracle9i = this.m_connection.getConnection("oracle9i_jdbc", (ConnectInfoPrompter)this.m_infoPrompter);
        Assert.assertNotNull((String)"get connection oracle9i", (Object)oracle9i);
    }

    @Test
    public void getConnection2() throws Exception {
        Properties prop = new Properties();
        prop.setProperty("ConnectionType", "OC4J");
        prop.setProperty("user", "scott");
        prop.setProperty("password", "tiger");
        prop.setProperty("DeployPassword", "TRUE");
        ConnectionWrapper oracle9i = this.m_connection.getConnection("oracle9i_jdbc", prop);
        Assert.assertNotNull((String)"get connection oracle9i", (Object)oracle9i);
    }

    @Test
    public void getConnection3() throws Exception {
        Properties prop = new Properties();
        prop.setProperty("ConnectionType", "OC4J");
        prop.setProperty("user", "scott");
        prop.setProperty("password", "tiger");
        prop.setProperty("DeployPassword", "TRUE");
        ConnectionWrapper oracle9i = this.m_connection.getConnection("oracle9i_jdbc", prop, (ConnectInfoPrompter)this.m_infoPrompter);
        Assert.assertNotNull((String)"get connection oracle9i", (Object)oracle9i);
    }

    @Test
    public void getConnection4() throws Exception {
        ConnectionWrapper oracle9i = this.m_connection.getConnection(this.m_fixture1.oracle9i_jdbc);
        Assert.assertNotNull((String)"get connection oracle9i", (Object)oracle9i);
    }

    @Test
    public void getConnection5() throws Exception {
        ConnectionWrapper oracle9i = this.m_connection.getConnection(this.m_fixture1.oracle9i_jdbc, (ConnectInfoPrompter)this.m_infoPrompter);
        Assert.assertNotNull((String)"get connection oracle9i", (Object)oracle9i);
    }

    @Test
    public void getUniqueConnectionDescriptor() throws Exception {
        Assert.assertNotNull((String)"Get Unique Connection Descriptor", (Object)this.m_connection.getUniqueConnectionDescriptor("TestDesc"));
    }

    @Test
    public void getConnectionDescriptor() throws Exception {
        Assert.assertNotNull((String)"get Connection Descriptor", (Object)this.m_connection.getConnectionDescriptor("oracle9i_jdbc"));
    }

    @Test
    public void connectionDescriptorExists() throws Exception {
        Assert.assertTrue((boolean)this.m_connection.connectionDescriptorExists("oracle9i_jdbc"));
        Assert.assertFalse((boolean)this.m_connection.connectionDescriptorExists("nothing"));
    }

    @Test
    public void getConnectionNames() throws Exception {
        this.checkConnectionDescriptorNames(this.m_connection.getConnectionNames());
    }

    @Test
    public void getConnectionNames1() throws Exception {
        this.checkConnectionDescriptorNames(this.m_connection.getConnectionNames("JDBC"));
    }

    @Test
    public void getConnectionNames2() throws Exception {
        this.checkConnectionDescriptorNames(this.m_connection.getConnectionNames("JDBC", true));
    }

    @Test
    public void getConnectionNames3() throws Exception {
        Properties prop = new Properties();
        prop.setProperty("ConnectionType", "OC4J");
        prop.setProperty("user", "admin");
        prop.setProperty("password", "welcome");
        prop.setProperty("DeployPassword", "TRUE");
        prop.setProperty("URL", "ormi://localhost/");
        prop.setProperty("TARGET_NODE", "http-web-site");
        this.checkConnectionDescriptorNames(this.m_connection.getConnectionNames(prop));
    }

    @Test
    public void getConnectionNamesForClass() throws Exception {
        this.checkConnectionDescriptorNames(this.m_connection.getConnectionNamesForClass("CLASS_DATABASE"));
    }

    @Test
    public void getDefaultPrompter() {
        this.m_connection.setDefaultPrompter((ConnectInfoPrompter)this.m_infoPrompter);
        ConnectInfoPrompter defaultPrompter = this.m_connection.getDefaultPrompter();
        Assert.assertNotNull((Object)defaultPrompter);
    }

    @Test
    public void getConnectionTypeNamesForClass() throws Exception {
        this.checkConnectionTypes(this.m_connection.getConnectionTypeNamesForClass("CLASS_DATABASE"));
    }

    @Test
    public void removeConnectionDescriptor() throws Exception {
        this.m_connection.removeConnectionDescriptor("oracle9i_jdbc");
        Assert.assertNull((String)"Remove oracle9i_jdbc connection", (Object)this.m_connection.getConnection("oracle9i_jdbc"));
    }

    @Test
    public void setPrompter() {
        this.m_connection.setPrompter((ConnectInfoPrompter)this.m_infoPrompter);
        ConnectInfoPrompter defaultPrompter = this.m_connection.getDefaultPrompter();
        Assert.assertNotNull((Object)defaultPrompter);
    }

    @Test
    public void setDefaultPrompter() {
        this.m_connection.setDefaultPrompter((ConnectInfoPrompter)this.m_infoPrompter);
        ConnectInfoPrompter defaultPrompter = this.m_connection.getDefaultPrompter();
        Assert.assertNotNull((Object)defaultPrompter);
    }

    @Test
    public void setConnectionStore() throws Exception {
        DefaultConnectionStore store = (DefaultConnectionStore)this.m_connection.getConnectionStore();
        Assert.assertNotNull((String)"Connection Store", (Object)store);
        List list = store.read();
        Assert.assertNotNull((String)"Connection Store List", (Object)list);
        list.add(this.m_fixture1.standalone_oc4j);
        this.m_connection.setConnectionStore((ConnectionStore)store);
        Assert.assertNotNull((String)"Set ConnectionStore", (Object)this.m_connection.getConnectionDescriptor("standalone_oc4j"));
        Assert.assertTrue((boolean)this.m_fixture1.standalone_oc4j.equals((Object)this.m_connection.getConnectionDescriptor("standalone_oc4j")));
    }

    @Test
    public void getConnectionStore() {
        ConnectionStore store = this.m_connection.getConnectionStore();
        Assert.assertNotNull((String)"Connection Store", (Object)store);
        List list = store.read();
        ListIterator iter = list.listIterator();
        Assert.assertNotNull((String)"Connection Types", iter);
        while (iter.hasNext()) {
            ConnectionDescriptor desc = (ConnectionDescriptor)iter.next();
            Assert.assertNotNull((String)"ConnectionDescriptor", (Object)desc);
            Assert.assertNotNull((String)"Connection Name", (Object)desc.getConnectionName());
        }
    }

    @Test
    public void registerConnectionType() throws Exception {
        Class<?> c = Class.forName("oracle.jdeveloper.cm.JdbcConnectionTypeFixture");
        this.m_connection.registerConnectionType((ConnectionType)c.newInstance());
        ConnectionType type = this.m_connection.getConnectionType("TEST_JDBC");
        Assert.assertNotNull((String)"TEST_JDBC", (Object)type);
        Assert.assertEquals((Object)type.getTypeName(), (Object)"TEST_JDBC");
    }

    private void checkConnectionType(String name) {
        ConnectionType type = this.m_connection.getConnectionType(name);
        Assert.assertNotNull((String)name, (Object)type);
        Assert.assertEquals((Object)type.getTypeName(), (Object)name);
    }

    private void checkConnectionDescriptorNames(String[] connections) throws Exception {
        Assert.assertNotNull((String)"Connection Descriptors", (Object)connections);
        for (int i = 0; i < connections.length; ++i) {
            Assert.assertNotNull((Object)connections[i]);
            Assert.assertTrue((boolean)connections[i].equals(this.m_connection.getConnectionDescriptor(connections[i]).getConnectionName()));
        }
    }

    private void checkConnectionTypes(String[] types) throws Exception {
        Assert.assertNotNull((String)"Connection Types", (Object)types);
        for (int i = 0; i < types.length; ++i) {
            Assert.assertNotNull((Object)types[i]);
            Assert.assertTrue((boolean)types[i].equals(this.m_connection.getConnectionType(types[i]).getTypeName()));
        }
    }

    private void checkFile() {
        File output = new File("connections.xml");
        Assert.assertTrue((String)"Read the connections.xml", (boolean)output.canRead());
    }
}

