/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm;

import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ConnectionStore;
import oracle.jdeveloper.cm.DefaultConnectionStore;

public class ConnectionFixture {
    private ConnectionManager cm;
    ConnectionDescriptor oracle9i_jdbc;
    ConnectionDescriptor standalone_oc4j;
    ConnectionDescriptor weblogic_7;
    private String fName = "connections.xml";

    protected void setUp() throws Exception {
        this.cm = ConnectionManager.getInstance();
        this.oracle9i_jdbc = new ConnectionDescriptor();
        this.oracle9i_jdbc.setProperty("ConnectionName", "oracle9i_jdbc");
        this.oracle9i_jdbc.setProperty("ConnectionType", "JDBC");
        this.oracle9i_jdbc.setProperty("user", "scott");
        this.oracle9i_jdbc.setProperty("password", "tiger");
        this.oracle9i_jdbc.setProperty("DeployPassword", "TRUE");
        this.oracle9i_jdbc.setProperty("HOSTNAME", "jtnt9i.us.oracle.com");
        this.oracle9i_jdbc.setProperty("SID", "ORCL");
        this.oracle9i_jdbc.setProperty("JDBC_PORT", "1521");
        this.oracle9i_jdbc.setProperty("IIOP_PORT", "9303");
        this.oracle9i_jdbc.setProperty("JdbcDriver", "oracle.jdbc.driver.OracleDriver");
        this.oracle9i_jdbc.setProperty("Role", "user");
        this.oracle9i_jdbc.setProperty("EXPERT_MODE", "true");
        this.oracle9i_jdbc.setProperty("ORACLE_JDBC_TYPE", "false");
        this.cm.putConnectionDescriptor("oracle9i_jdbc", this.oracle9i_jdbc);
        this.standalone_oc4j = new ConnectionDescriptor();
        this.standalone_oc4j.setProperty("ConnectionName", "standalone_oc4j");
        this.standalone_oc4j.setProperty("ConnectionType", "OC4J");
        this.standalone_oc4j.setProperty("user", "admin");
        this.standalone_oc4j.setProperty("password", "welcome");
        this.standalone_oc4j.setProperty("DeployPassword", "TRUE");
        this.standalone_oc4j.setProperty("URL", "ormi://localhost/");
        this.standalone_oc4j.setProperty("TARGET_NODE", "http-web-site");
        this.weblogic_7 = new ConnectionDescriptor();
        this.weblogic_7.setProperty("ConnectionName", "weblogic_7");
        this.weblogic_7.setProperty("ConnectionType", "WebLogic_7.x");
        this.weblogic_7.setProperty("user", "jdev");
        this.weblogic_7.setProperty("password", "weblogic");
        this.weblogic_7.setProperty("DeployPassword", "TRUE");
        this.weblogic_7.setProperty("IIOP_PORT", "7001");
        this.weblogic_7.setProperty("TARGET_NODE", "myserver");
    }

    protected void tearDown() {
        this.oracle9i_jdbc.clear();
        this.standalone_oc4j.clear();
        this.weblogic_7.clear();
    }

    public ConnectionManager getConnectionManager() {
        if (this.cm != null) {
            this.cm.setDefaultPrompter(null);
            DefaultConnectionStore dc = new DefaultConnectionStore(this.fName, true);
            this.cm.setConnectionStore((ConnectionStore)dc);
        }
        return this.cm;
    }
}

