/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.xmleditor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.utils.DeferUIOperationTask;
import oracle.dbtools.raptor.controls.display.DisplayAdapter;
import oracle.dbtools.raptor.controls.display.DisplayCodeEditor;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayPanel;
import oracle.dbtools.raptor.controls.display.DisplayResultTable;
import oracle.dbtools.raptor.controls.display.IDisplay;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.navigator.BaseNavigatorController;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.oviewer.Messages;
import oracle.dbtools.raptor.oviewer.base.ViewerAddin;
import oracle.dbtools.raptor.oviewer.base.ViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.DataBaseNodeUtil;
import oracle.dbtools.util.objectpriv.PermissionRegistry;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.view.StatusProvider;
import oracle.ide.view.View;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.icons.OracleIcons;

public class XMLBasedEditor
extends ViewerEditor
implements FindableEditor,
IDBEditor,
Controller,
StatusProvider {
    protected DBObject m_dbObject;
    protected DBObject _lastdbObject;
    protected DisplayModel _editor;
    private IdeAction _refreshAction = IdeAction.get((int)REFRESH_EDITOR_CMD_ID, null, (String)Messages.getString("XMLBasedEditor.2"), null, null, (Icon)OracleIcons.getIcon((String)"refresh.png"), null, (boolean)true).newLocalAction((View)this);
    public static final int REFRESH_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"Refresh_XML_Editor");
    private IdeAction _editDBNodeAction;
    public static final int EDIT_DBNODE_CMD_ID = Ide.findOrCreateCmdID((String)"Edit_DBNode_XML_Editor");
    private JPopupMenu _gridCtxMenu;
    private DisplayPanel _panel;
    private JLabel _connName;
    private JLabel _ownerName;
    private JLabel _objName;
    private JComponent[] _statusBarCells;
    private BasicEditorPane _lastBasicEditorPane;
    private boolean firstOpen = true;
    private IDisplay _mainUI;

    public XMLBasedEditor() {
        this._refreshAction.addController((Controller)this);
        this._editDBNodeAction = IdeAction.get((int)EDIT_DBNODE_CMD_ID, null, (String)Messages.getString("XMLBasedEditor.3"), null, null, (Icon)RaptorImage.getIcon((String)"edit_code.png"), null, (boolean)true).newLocalAction((View)this);
        this._editDBNodeAction.addController((Controller)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        DBObject dBObject = this.getDBObject(false);
        String string = dBObject != null ? dBObject.getConnectionName() : null;
        boolean bl = false;
        if (string != null) {
            if (Connections.getInstance().lock(string, true)) {
                bl = true;
            } else {
                throw new OpenAbortedException();
            }
        }
        try {
            super.open();
        }
        finally {
            if (bl) {
                Connections.getInstance().unlock(string);
            }
        }
    }

    public synchronized Icon getTabIcon() {
        return this._editor.getIcon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == REFRESH_EDITOR_CMD_ID) {
            this.updateContent(true);
            return true;
        }
        if (n == EDIT_DBNODE_CMD_ID) {
            if (this.getDatabaseNode() instanceof TextNode) {
                Context context2 = Context.newIdeContext((Element)this.getDatabaseNode());
                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context2);
                openEditorOptions.setFlags(1);
                WaitCursor waitCursor = Ide.getWaitCursor();
                context2.setProject(Ide.getDefaultProject());
                try {
                    waitCursor.show();
                    EditorManager.getEditorManager().openEditor(openEditorOptions);
                }
                finally {
                    waitCursor.hide();
                }
                return true;
            }
            DataBaseNodeUtil.editNodeWizard((DatabaseNode)this.getDatabaseNode());
            return true;
        }
        return super.handleEvent(ideAction, context);
    }

    @Override
    public boolean update(final IdeAction ideAction, final Context context) {
        boolean bl = false;
        View view = context.getView();
        int n = ideAction.getCommandId();
        if (view == this) {
            if (n == 23) {
                ideAction.setEnabled(false);
                bl = true;
            } else if (n == EDIT_DBNODE_CMD_ID && this.firstOpen) {
                ideAction.setEnabled(false);
                this.firstOpen = false;
                DeferUIOperationTask deferUIOperationTask = new DeferUIOperationTask(Messages.getString("XMLBasedEditor.0")){

                    public String getConnectionName() {
                        return XMLBasedEditor.this._editor.getConnName();
                    }

                    protected void invokeLater() {
                        boolean bl = XMLBasedEditor.this.checkCanEdit(context) || XMLBasedEditor.this.checkForMigrationObjectEditable(context);
                        ideAction.setEnabled(bl);
                    }
                };
                RaptorTaskManager.getInstance().addTask((RaptorTask)deferUIOperationTask);
                bl = true;
            }
        }
        return bl || super.update(ideAction, context);
    }

    private boolean checkCanEdit(Context context) {
        SchemaObject schemaObject;
        Database database;
        boolean bl = false;
        DBObject dBObject = new DBObject((Element)context.getNode());
        String string = dBObject.getObjectType();
        if (BaseNavigatorController.EDITABLE_TYPES.contains(string) && PermissionRegistry.canAlter((DBObject)dBObject) && (database = dBObject.getDatabase()) != null && (schemaObject = dBObject.getSchemaObject()) != null) {
            bl = DBEditorFactoryRegistry.getEditFactory((SchemaObject)schemaObject, (DBObjectProvider)database) != null;
        }
        return bl;
    }

    private DBObject getDBObject(boolean bl) {
        if (this.m_dbObject == null || bl) {
            Context context = this.getContext();
            Node node = context.getNode();
            this.m_dbObject = node instanceof ViewerNode ? ((ViewerNode)node).getDBObject() : new DBObject((Element)node);
        }
        return this.m_dbObject;
    }

    private boolean hasPopupEditor(DBObject dBObject, String string) {
        return !string.equals("INDEX") && !string.equals("SYNONYM") && !string.equals("RECYCLEBIN") && !string.equals("DIRECTORY") && !string.equals("PUBLIC_SYNONYM") && !string.startsWith("APEX") && !string.startsWith("JAVA") && !string.startsWith("EDITION") && !string.startsWith("XML") && !string.startsWith("XDB") && !string.startsWith("SCHSCHEDULE") && !string.startsWith("SCHJOB") && !string.startsWith("SCHNEWJOB") && !string.startsWith("SCHJOBCLASS") && !string.startsWith("SCHDBDESTINATION") && !string.startsWith("SCHCREDENTIAL") && !string.startsWith("SCHCHAIN") && (dBObject.isOracle() || this.checkForMigrationObjectEditable(this.getContext()));
    }

    @Override
    protected JComponent createViewerUI() {
        Object object = null;
        DBObject dBObject = this.getDBObject(false);
        String string = dBObject.getObjectType();
        ViewerAddin viewerAddin = (ViewerAddin)AddinManager.getAddinManager().getAddin(ViewerAddin.class);
        String string2 = ((Object)((Object)this)).getClass().toString();
        int n = Integer.parseInt(string2.substring(string2.lastIndexOf(114) + 1));
        this._editor = viewerAddin.getModel(dBObject, n);
        this._editor.setConnName(dBObject.getConnectionName());
        this._editor.getExtValues().put("no.refresh.in.toolbar", "true");
        this._editor.getExtValues().put("no.run.in.toolbar", "true");
        this._panel = new DisplayPanel(this._editor, dBObject.getDictionary(), true, (Toolbar)this.getFixedTopMargin());
        this._mainUI = this._panel.getMainUI();
        if (this._mainUI instanceof DisplayAdapter && ((DisplayAdapter)this._mainUI).getCodeEditor() != null) {
            object = (JComponent)((DisplayAdapter)this._mainUI).getCodeEditor().getParent().getParent();
        } else if (!this._editor.hasChildren() && this._mainUI.getUI() instanceof JTable) {
            object = this._mainUI.getUI();
            this._mainUI.setView((View)this);
        } else {
            object = this._panel;
        }
        this.buildToolbar(dBObject, string);
        this.getContext().setProperty("MAIN_UI", (Object)this._mainUI);
        return object;
    }

    private void buildToolbar(DBObject dBObject, String string) {
        if (this._panel.getMainUI() instanceof IDisplay && this._panel.getMainUI().isUpdatable()) {
            boolean bl = false;
            if (this._editor.getInsertClass() != null || this._editor.getInsertScript() != null) {
                bl = true;
            }
            if (this._editor.getDeleteClass() != null || this._editor.getDeleteScript() != null) {
                bl = true;
            }
            if (this._editor.getUpdateClass() != null || this._editor.getUpdateScript() != null) {
                bl = true;
            }
            if (bl) {
                // empty if block
            }
        }
        ToolButton toolButton = null;
        if (this.hasPopupEditor(dBObject, string)) {
            toolButton = ((Toolbar)this.getFixedTopMargin()).add((ToggleAction)this._editDBNodeAction);
            toolButton.setName(this._editDBNodeAction.getValue("Name").toString());
        }
        toolButton = ((Toolbar)this.getFixedTopMargin()).add((ToggleAction)this._refreshAction);
        toolButton.setName(this._refreshAction.getValue("Name").toString());
        ((Toolbar)this.getFixedTopMargin()).putClientProperty((Object)"EditableGridControl.NO_REFRESH_CMD", (Object)Boolean.TRUE.toString());
    }

    private DatabaseNode getDatabaseNode() {
        ViewerNode viewerNode = this.getViewerNode();
        return (DatabaseNode)(viewerNode != null ? viewerNode.getBaseNode() : this.getContext().getNode());
    }

    public Object getEditorAttribute(String string) {
        boolean bl = true;
        if (this._editor.hasChildren() || this._panel.getMainUI() instanceof DisplayAdapter && ((DisplayAdapter)this._panel.getMainUI()).getCodeEditor() != null) {
            bl = false;
        }
        if ("horizontal_scrollbar_policy".equals(string) && !bl) {
            return new Integer(31);
        }
        if ("vertical_scrollbar_policy".equals(string) && !bl) {
            return new Integer(21);
        }
        if ("scrollable".equals(string) && !bl) {
            return Boolean.FALSE;
        }
        return super.getEditorAttribute(string);
    }

    public Component getScrollableTopMargin() {
        if (!this._editor.hasChildren() && this._panel.getMainUI() instanceof DisplayResultTable) {
            JTable jTable = (JTable)this._panel.getMainUI().getUI();
            return jTable.getTableHeader();
        }
        return null;
    }

    protected void updateContent() {
        this.updateContent(false);
    }

    @Override
    protected void updateContent(boolean bl) {
        this.firstOpen = true;
        DBObject dBObject = this.getDBObject(true);
        if (bl || this._lastdbObject == null || !dBObject.checkQualifiedNameEquals(this._lastdbObject) || dBObject.getSchemaObject() != this._lastdbObject.getSchemaObject()) {
            if (!bl) {
                this._panel.clear();
            }
            String string = dBObject.getConnectionName();
            Map map = dBObject.getDictionary();
            this._editor.setConnName(string);
            this._panel.setMainPanelBinds(map);
            this._lastdbObject = dBObject;
            this._panel.refresh(bl);
            this.updateToolbar();
        }
    }

    public void updateToolbar() {
    }

    public BasicEditorPane getFocusedEditorPane() {
        Component component = this._panel.getFocusedComponent();
        Component[] componentArray = this._panel.getComponents();
        if (component != null) {
            BasicEditorPane basicEditorPane = this._lastBasicEditorPane = component instanceof BasicEditorPane ? (BasicEditorPane)component : null;
        }
        if (this._lastBasicEditorPane == null && this._panel.getMainUI() instanceof DisplayCodeEditor) {
            this._lastBasicEditorPane = ((DisplayCodeEditor)this._panel.getMainUI()).getCodeEditor();
        }
        return this._lastBasicEditorPane;
    }

    @Override
    public Object getPrintable() {
        return this._panel;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_bdbtableviewer_html");
    }

    public Database getDatabase() {
        return this.m_dbObject.getDatabase();
    }

    public Connection getConnection() {
        return this.m_dbObject.getConnection();
    }

    public String getConnectionName() {
        return this.m_dbObject.getConnectionName();
    }

    @Override
    public void cleanUp() {
        this._panel.close();
        if (this._editor != null) {
            this._editor.setConnName(null);
            this._editor.setConnection(null);
        }
        if (this._panel != null) {
            this._panel.close();
        }
    }

    public void attachGutterMenu(BasicEditorPane basicEditorPane, final LineGutterPlugin lineGutterPlugin) {
        this._gridCtxMenu = new JPopupMenu(Messages.getString("XMLBasedEditor.12"));
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("XMLBasedEditor.13"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditorProperties editorProperties = EditorProperties.getProperties();
                boolean bl = !editorProperties.getBooleanProperty("show-line-numbers");
                editorProperties.putBooleanProperty("show-line-numbers", bl);
            }
        });
        this._gridCtxMenu.add(jMenuItem);
        lineGutterPlugin.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = mouseEvent.getModifiers();
                if ((n & 8) != 0 || (n & 4) != 0) {
                    XMLBasedEditor.this._gridCtxMenu.show((Component)lineGutterPlugin, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        basicEditorPane.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = mouseEvent.getModifiers();
                if ((n & 8) != 0 || (n & 4) != 0) {
                    XMLBasedEditor.this._gridCtxMenu.show((Component)lineGutterPlugin, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    public String getStatus() {
        return this.getDisplayConnectionName() + " " + this.m_dbObject.getSchemaName() + "." + this.m_dbObject.getObjectName();
    }

    private String getDisplayConnectionName() {
        return Connections.getDisplayName((String)this.m_dbObject.getConnectionName());
    }

    public JComponent[] getCustomCells() {
        if (this._connName == null) {
            this._connName = new JLabel();
            this._connName.setToolTipText(Messages.getString("XMLBasedEditor.16"));
        }
        if (this._ownerName == null) {
            this._ownerName = new JLabel();
            this._ownerName.setToolTipText(Messages.getString("XMLBasedEditor.17"));
        }
        if (this._objName == null) {
            this._objName = new JLabel();
            this._objName.setToolTipText(Messages.getString("XMLBasedEditor.18"));
        }
        if (this._statusBarCells == null) {
            this._statusBarCells = new JComponent[3];
            this._statusBarCells[0] = this._connName;
            this._statusBarCells[1] = this._ownerName;
            this._statusBarCells[2] = this._objName;
        }
        this._connName.setText(this.getDisplayConnectionName());
        this._ownerName.setText(this.m_dbObject.getSchemaName());
        this._objName.setText(this.m_dbObject.getObjectName());
        return this._statusBarCells;
    }

    public boolean isExpandable(JComponent jComponent) {
        return false;
    }

    public boolean checkForMigrationObjectEditable(Context context) {
        IViewerNode iViewerNode = (IViewerNode)context.getNode();
        Node node = iViewerNode.getBaseNode();
        if (node instanceof DatabaseNode) {
            DatabaseNode databaseNode = (DatabaseNode)node;
            String string = (String)databaseNode.getProperty("TYPE");
            String string2 = (String)databaseNode.getProperty("ConnectionType");
            if ((string.indexOf("MD_PROCEDURE") >= 0 || string.indexOf("MD_TRIGGER") >= 0 || string.indexOf("MD_VIEW") >= 0 || string.indexOf("MD_FUNCTION") >= 0) && ("MIGREPO".equals(string2) || "MIGREPOC".equals(string2))) {
                return true;
            }
        }
        return false;
    }

    public Component getScrollableLeftMargin() {
        Component component = null;
        if (this._mainUI != null) {
            component = this._mainUI.getScrollableLeftMargin();
        }
        if (component == null) {
            component = super.getScrollableLeftMargin();
        }
        return component;
    }
}

