/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.table;

import java.awt.Component;
import java.io.IOException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.controls.IActionUpdater;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.grid.EditableGridController;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTable;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.GridFilterField;
import oracle.dbtools.raptor.controls.grid.IRaptorGridUpdater;
import oracle.dbtools.raptor.controls.grid.RaptorEditableGridTaskWrapper;
import oracle.dbtools.raptor.controls.grid.RaptorGridCopyAdapter;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridSorter;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.oviewer.OBResourcesArb;
import oracle.dbtools.raptor.oviewer.base.ViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.help.HelpInfo;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.model.Element;
import oracle.ide.view.View;
import oracle.javatools.db.Database;

public class GridDataEditor
extends ViewerEditor
implements IDBEditor,
Controller,
ViewerNode.DirtyComponent,
IActionUpdater {
    protected static Logger LOGGER = Logger.getLogger(GridDataEditor.class.getName());
    protected EditableGridController _controller = null;
    protected static final String QUERY_SCHEMA_AND_NAME = "SELECT * FROM {0}.{1}";
    protected String _tableName;
    protected String _schemaName;
    protected JButton sortButton;
    protected GridSorter sorter = (GridSorter)GridSorter.getInstance();
    protected JLabel filterLabel;
    protected GridFilterField filter;
    protected EditableResultSetTable _grid = null;
    protected RaptorGridCopyAdapter _copyAdapter = null;
    protected DBObject _dbObject;
    protected FetchTaskListener _fetchListener = new FetchTaskListener();

    public GridDataEditor() {
        this._grid = new EditableResultSetTable((IActionUpdater)this);
        this._controller = this._grid.getController();
        this.filter = this._controller.getGridFilterField();
        this._controller.setView((View)this);
        this._copyAdapter = this._grid.getGridCopyAdapter();
        this._tableName = null;
        this._schemaName = null;
        final KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        keyStrokeOptions.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                GridDataEditor.this.updateKeyMap(keyStrokeOptions);
            }
        });
        this.updateKeyMap(keyStrokeOptions);
        this._grid.setView((View)this);
    }

    @Override
    public Component getGUI() {
        return this._grid;
    }

    public void open(boolean bl) {
        this.open(bl, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void open(boolean bl, List<String> list, List<String> list2) {
        boolean bl2;
        DBObject dBObject = new DBObject((Element)this.getViewerNode());
        boolean bl3 = bl2 = !dBObject.checkQualifiedNameEquals(this._dbObject);
        if (bl || bl2) {
            Object object;
            this._dbObject = dBObject;
            boolean bl4 = false;
            String string = this.getConnectionName();
            if (string != null) {
                if (Connections.getInstance().lock(string, true)) {
                    bl4 = true;
                } else {
                    throw new OpenAbortedException();
                }
            }
            try {
                object = DBUtil.getInstance((Connection)this.getConnection());
                this._schemaName = object.addDbQuotes(dBObject.getSchemaName());
                this._tableName = object.addDbQuotes(dBObject.getObjectName());
            }
            finally {
                if (bl4) {
                    Connections.getInstance().unlock(string);
                }
            }
            try {
                object = this.getSql();
                this._grid.setQuery(this.getConnectionName(), (String)object, null, this._dbObject.getDictionary(), this._dbObject, list, list2);
                this._grid.registerGridUpdater((IRaptorGridUpdater)new EditableResultSetTableModel.DataTabGridUpdater(this._grid.getGridModel()));
                this._grid.getRowHeader().setModel((TableModel)this._grid.getGridModel().getRowHeaderModel());
                this._grid.getRowHeader().setSize(this._grid.getRowHeader().getPreferredSize());
                this._grid.getRowHeader().repaint();
                ArrayList<FetchTaskListener> arrayList = new ArrayList<FetchTaskListener>();
                arrayList.add(this._fetchListener);
                this._grid.open(new RaptorEditableGridTaskWrapper((String)object, IRaptorTaskRunMode.MODAL, false, arrayList, null, null, null));
                this.filter.reset();
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    protected String getSql() {
        return MessageFormat.format(QUERY_SCHEMA_AND_NAME, this._schemaName, this._tableName);
    }

    @Override
    public void open() {
        this.open(true);
    }

    @Override
    public boolean update(IdeAction ideAction, Context context) {
        return this._controller.update(ideAction, context);
    }

    @Override
    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (this._controller.handleEvent(ideAction, context)) {
            return true;
        }
        return super.handleEvent(ideAction, context);
    }

    @Override
    protected void cleanUp() {
        this._grid.closeModel();
        this._controller.setView(null);
    }

    @Override
    protected JComponent createViewerUI() {
        return this._grid;
    }

    @Override
    public Object getPrintable() {
        return this._grid;
    }

    @Override
    protected void updateContent(boolean bl) {
        this.open(bl);
        this.updateVisibleActions();
    }

    public Database getDatabase() {
        return this._dbObject != null ? this._dbObject.getDatabase() : null;
    }

    public Connection getConnection() {
        return this._dbObject != null ? this._dbObject.getConnection() : null;
    }

    public String getConnectionName() {
        return this._dbObject != null ? this._dbObject.getConnectionName() : null;
    }

    @Override
    public Controller getController() {
        this._controller.setSuperController(super.getController());
        return this._controller;
    }

    public Component getScrollableLeftMargin() {
        return this._grid.getGridModel() == null ? null : this._grid.getRowHeader();
    }

    public Component getScrollableTopMargin() {
        return this._grid.getGridModel() == null ? null : this._grid.getTableHeader();
    }

    public boolean insertRow() {
        boolean bl = this._grid.addRow();
        if (bl) {
            this.markDirty(true);
        }
        return bl;
    }

    public boolean deleteRow() {
        boolean bl = this._grid.deleteRow();
        if (bl) {
            this.markDirty(true);
        }
        return bl;
    }

    private void markDirty(boolean bl) {
        ViewerNode viewerNode = this.getViewerNode();
        if (bl) {
            viewerNode.addDirtyComponent(this);
        } else {
            viewerNode.removeDirtyComponent(this);
        }
    }

    @Override
    public void save(ViewerNode viewerNode) throws IOException {
        if (!this._grid.save(false, true)) {
            throw new IOException(OBResourcesArb.getString("SAVE_CHANGES_FAILED_MESSAGE"));
        }
    }

    @Override
    public Component getFixedTopMargin() {
        if (this._toolbar == null) {
            super.getFixedTopMargin();
            this._controller.addToolBarActions(this._toolbar);
        }
        return this._toolbar;
    }

    private void updateKeyMap(KeyStrokeOptions keyStrokeOptions) {
        UIUtils.addIdeKeyBindings((JComponent)this._grid, (int)1, (String)"oracle/dbtools/raptor/oviewer/base/accelerators.xml");
    }

    private IdeAction createLocalAction(int n) {
        return IdeAction.get((int)n).newLocalAction((View)this);
    }

    public Component getDefaultFocusComponent() {
        return this._grid;
    }

    public Object getEditorAttribute(String string) {
        if (string.equals("menu_id")) {
            return "Ta&ble";
        }
        return super.getEditorAttribute(string);
    }

    public void updateActions() {
        this.updateVisibleActions();
        this.markDirty(this._grid.isChanged());
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_bdbtableviewer_html");
    }

    public ContextMenu getContextMenu() {
        return null == this._grid ? null : this._grid.getContextMenu();
    }

    private class FetchTaskListener
    extends RaptorTaskAdapter {
        private FetchTaskListener() {
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            if (GridDataEditor.this._grid.getGridModel().getGridColumns() == null) {
                this.updateControllerActions(false);
            }
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            if (GridDataEditor.this._grid.getGridModel().getGridColumns() == null) {
                this.updateControllerActions(false);
            }
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
        }

        private void updateControllerActions(final boolean bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GridDataEditor.this._controller.updateControllerActions(bl);
                }
            });
        }
    }
}

