/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.search;

import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorManager;
import oracle.dbtools.raptor.oviewer.Messages;
import oracle.dbtools.raptor.oviewer.search.SearchWindow;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.DockingParam;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.layout.ViewId;
import oracle.ide.navigator.NavigatorManager;
import oracle.javatools.icons.OracleIcons;

public class NavSearchAddin
implements DockableFactory,
Addin {
    private int _viewActionId;
    static final String VIEW_TYPE = "SEARCH_VIEW_TYPE";
    private SearchWindow _searchWindow;

    public void initialize() {
        this.createActions();
        try {
            DockStation dockStation = DockStation.getDockStation();
            dockStation.registerDockableFactory(VIEW_TYPE, (DockableFactory)this);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void createActions() {
        this._viewActionId = Ide.findOrCreateCmdID((String)"ViewSearch");
        String string = Messages.getString("NavSearchAddin.1");
        IdeAction ideAction = IdeAction.get((int)this._viewActionId, null, (String)StringUtils.stripMnemonic((String)string), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), (Icon)OracleIcons.getIcon((String)"find.png"), null, (boolean)true);
        ideAction.addController((Controller)new SController());
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, MenuConstants.increment((float)MenuConstants.WEIGHT_VIEW_CONNECTION_NAVIGATOR));
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"View"), MenuConstants.SECTION_VIEW_NAVIGATOR);
    }

    public Dockable getDockable(ViewId viewId) {
        return this.getSearchWindow();
    }

    public void install() {
        if (RaptorExtensionConstants.isStandAlone()) {
            ExplorerManager explorerManager;
            DockingParam dockingParam = new DockingParam();
            NavigatorManager navigatorManager = DatabaseNavigatorManager.getInstance();
            if (navigatorManager.getNavigatorWindow() != null) {
                dockingParam.setPosition((Dockable)navigatorManager.getNavigatorWindow(), 3, 0);
            } else {
                explorerManager = ExplorerManager.getExplorerManager();
                Dockable dockable = null;
                if (explorerManager != null) {
                    ViewId viewId = explorerManager.getDefaultViewId();
                    dockable = DockStation.getDockStation().findDockable(viewId);
                }
                dockingParam.setPosition(dockable, 4, 0);
            }
            explorerManager = DockStation.getDockStation();
            explorerManager.dock((Dockable)this.getSearchWindow(), dockingParam);
            this._searchWindow.setDockableVisible(false);
        }
    }

    private SearchWindow getSearchWindow() {
        if (this._searchWindow == null) {
            this._searchWindow = new SearchWindow();
        }
        return this._searchWindow;
    }

    private class SController
    implements Controller {
        private SController() {
        }

        public boolean update(IdeAction ideAction, Context context) {
            return false;
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n != NavSearchAddin.this._viewActionId) {
                return false;
            }
            DockUtil.showDockableWindow((DockableView)NavSearchAddin.this.getSearchWindow());
            return true;
        }
    }
}

