/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.oviewer.xmleditor.XMLBasedEditor;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.navigation.DefaultNavigationPoint;
import oracle.ide.navigation.NavigationPointEvent;
import oracle.ide.view.View;

public class ViewerNavigationPoint
extends DefaultNavigationPoint {
    private String longLabel;
    private Element element;

    public String getLongLabel() {
        return this.longLabel != null ? this.longLabel : this.getShortLabel();
    }

    public void setContext(Context context) {
        Node node;
        super.setContext(context);
        if (context != null && (node = context.getNode()) != null && node instanceof ViewerNode) {
            ViewerNode viewerNode = (ViewerNode)node;
            this.longLabel = viewerNode.getLongLabel();
            DBObject dBObject = viewerNode.getDBObject();
            if (dBObject != null) {
                this.element = dBObject.getElement();
            }
        }
    }

    protected int renavigate() throws Exception {
        Editor editor;
        EditorInfo editorInfo = this.findExistingEditor();
        Editor editor2 = editor = editorInfo != null ? editorInfo._getEditor() : null;
        if (editor == null) {
            if (this.viewClass != null) {
                EditorManager editorManager = EditorManager.getEditorManager();
                Context context = this.getContext();
                ViewerNode viewerNode = (ViewerNode)context.getNode();
                this.closeObjectViewer(viewerNode);
                viewerNode.setViewedObject(new DBObject(this.element));
                context = Context.newIdeContext((Node)viewerNode);
                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                openEditorOptions.setFlags(1);
                editor = editorManager.openEditor(openEditorOptions);
                if (editor != null) {
                    View.updateToolbarActions((Toolbar)editor.getToolbar());
                }
            }
            if (editor != null) {
                this.viewClass = editor.getClass();
                this.viewID = editor.getId();
                this.fireDescriptionChanged(new NavigationPointEvent((Object)this));
                return 0;
            }
        } else {
            EditorManager editorManager = EditorManager.getEditorManager();
            if (editorManager != null) {
                if (this.element != null) {
                    DBObject dBObject = new DBObject(this.element);
                    Node node = this.getContext().getNode();
                    if (node != null && node instanceof ViewerNode) {
                        ViewerNode viewerNode = (ViewerNode)node;
                        DBObject dBObject2 = viewerNode.getDBObject();
                        if (dBObject == null || !dBObject.getURL().equals(dBObject2)) {
                            viewerNode.setViewedObject(dBObject);
                        }
                    }
                }
                editorManager.activateEditor(editorInfo);
                return 0;
            }
        }
        return 1;
    }

    private void closeObjectViewer(ViewerNode viewerNode) {
        EditorManager editorManager = EditorManager.getEditorManager();
        List list = editorManager.getAllEditors();
        for (int i = list.size() - 1; i >= 0; --i) {
            Editor editor = (Editor)list.get(i);
            Context context = editor.getContext();
            Node node = context.getNode();
            if (viewerNode == node) continue;
            list.remove(i);
        }
        if (!list.isEmpty()) {
            editorManager.closeEditors(list);
        }
    }

    protected EditorInfo findExistingEditor() {
        Iterator iterator;
        EditorInfo editorInfo = null;
        EditorManager editorManager = EditorManager.getEditorManager();
        List list = editorManager != null ? editorManager.getEditorsInfo() : null;
        Iterator iterator2 = iterator = list != null ? list.iterator() : null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                DBObject dBObject;
                XMLBasedEditor xMLBasedEditor;
                ViewerNode viewerNode;
                EditorInfo editorInfo2 = (EditorInfo)iterator.next();
                Editor editor = editorInfo2._getEditor();
                if (editor == null || !(editor instanceof XMLBasedEditor) || (viewerNode = (xMLBasedEditor = (XMLBasedEditor)editor).getViewerNode()) == null || (dBObject = viewerNode.getDBObject()) == null || dBObject.getElement() != this.element) continue;
                editorInfo = editorInfo2;
                break;
            }
        }
        if (editorInfo == null) {
            editorInfo = ViewerNavigationPoint.findEditorInfo((String)this.viewID, (URL)this.nodeURL);
        }
        return editorInfo;
    }
}

