/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.awt.Component;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.oviewer.base.NavContextController;
import oracle.dbtools.raptor.oviewer.base.NavSelectionListener;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Element;
import oracle.ide.model.TextNode;

public class NavContextListener
implements ContextMenuListener {
    private JMenuItem m_openObject;
    public static final String OPEN_OBJECT_CMD = "DatabaseNavigator.OpenObject";
    public static final int OPEN_OBJECT_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.OpenObject");
    public static final IdeAction ACTION_OPENOBJECT = IdeAction.get((int)OPEN_OBJECT_CMD_ID, (String)StringUtils.stripMnemonic((String)DatabaseNavigatorResources.getString((String)"OPEN_OBJECT_MENU")), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)DatabaseNavigatorResources.getString((String)"OPEN_OBJECT_MENU"))));

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        Element[] elementArray = context.getSelection();
        if (elementArray.length == 0) {
            return;
        }
        boolean bl = elementArray.length > 1;
        Element element = elementArray[0];
        this.buildMenus((MenuManager)contextMenu);
        if (!bl && (element instanceof DatabaseNode || element instanceof ObjectFolder) && !(element instanceof PlSqlNode)) {
            DBObject dBObject = new DBObject(element);
            if (NavSelectionListener.getInstance().hasViewer(dBObject)) {
                contextMenu.add((Component)this.m_openObject, element instanceof TextNode || element instanceof ObjectFolder ? 1.0f : MenuConstants.SECTION_EDIT_CTXT_MENU);
            }
        }
    }

    private void buildMenus(MenuManager menuManager) {
        if (this.m_openObject == null) {
            this.m_openObject = menuManager.createMenuItem((ToggleAction)ACTION_OPENOBJECT);
            ACTION_OPENOBJECT.addController((Controller)new NavContextController());
        }
    }
}

