/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.model.DatabaseFolder;
import oracle.dbtools.raptor.oviewer.OBResourcesArb;
import oracle.dbtools.raptor.oviewer.base.Messages;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.SimpleIdeCore;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.util.IdeUtil;

public class ConnectionExportPanel
extends JPanel {
    private JList fromList;
    private JList toList;
    private ListPicker fromPicker;
    private ReorderableListPicker toPicker;
    private DBObject m_selectedObject;
    private static URL s_selectedURL;
    private JTextField m_txfFilePath;
    private JCheckBox m_chkCreateEmpty;

    public ConnectionExportPanel(DBObject dBObject) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createFileBrowser(), "North");
        this.add((Component)this.createShuttle(), "Center");
        this.m_chkCreateEmpty = new JCheckBox(Messages.getString("ConnectionExportTask.checkGenerateEmpty"));
        this.m_chkCreateEmpty.setSelected(true);
        this.add((Component)this.m_chkCreateEmpty, "South");
        this.m_selectedObject = dBObject;
    }

    private void populateShuttle(DBFolderInstance[] dBFolderInstanceArray, DBFolderInstance[] dBFolderInstanceArray2) {
        int n;
        DefaultListModel defaultListModel = (DefaultListModel)this.fromList.getModel();
        defaultListModel.removeAllElements();
        DefaultListModel defaultListModel2 = (DefaultListModel)this.toList.getModel();
        defaultListModel2.removeAllElements();
        if (dBFolderInstanceArray != null) {
            for (n = 0; n < dBFolderInstanceArray.length; ++n) {
                defaultListModel.addElement(dBFolderInstanceArray[n]);
            }
        }
        if (dBFolderInstanceArray2 != null) {
            for (n = 0; n < dBFolderInstanceArray2.length; ++n) {
                defaultListModel2.addElement(dBFolderInstanceArray2[n]);
            }
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.m_selectedObject != null && this.toList.getModel().getSize() == 0 && this.fromList.getModel().getSize() == 0) {
            String string = this.m_selectedObject.getConnectionName();
            Connection connection = this.m_selectedObject.getConnection();
            ObjectFactory objectFactory = ObjectFactory.getFactory((String)string, (Connection)connection);
            DBSchemaInstance dBSchemaInstance = objectFactory.createSchemaInstance(this.m_selectedObject.getSchemaName());
            Set<DBFolderInstance> set = this.getSortedFolderList(dBSchemaInstance);
            this.populateShuttle(new DBFolderInstance[0], set.toArray(new DBFolderInstance[0]));
        }
    }

    private Set<DBFolderInstance> getSortedFolderList(DBSchemaInstance dBSchemaInstance) {
        TreeSet<DBFolderInstance> treeSet = new TreeSet<DBFolderInstance>(new Comparator<DBFolderInstance>(){

            @Override
            public int compare(DBFolderInstance dBFolderInstance, DBFolderInstance dBFolderInstance2) {
                if (dBFolderInstance == dBFolderInstance2) {
                    return 0;
                }
                DatabaseFolder databaseFolder = (DatabaseFolder)dBFolderInstance.getDescriptor();
                DatabaseFolder databaseFolder2 = (DatabaseFolder)dBFolderInstance2.getDescriptor();
                double d = databaseFolder.getWeight() - databaseFolder2.getWeight();
                if (d == 0.0) {
                    return dBFolderInstance.getType().compareTo(dBFolderInstance2.getType());
                }
                return (int)d;
            }
        });
        for (DBFolderInstance dBFolderInstance : dBSchemaInstance.listTypeFolders()) {
            String string = dBFolderInstance.getDescriptor().getType().toUpperCase();
            if (string.equals("RECYCLEBIN") || string.equals("PUBLIC_SYNONYM")) continue;
            treeSet.add(dBFolderInstance);
        }
        return treeSet;
    }

    private JPanel createFileBrowser() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.m_txfFilePath = new JTextField();
        this.updatePathText(this.m_txfFilePath);
        jPanel.add((Component)this.m_txfFilePath, "Center");
        JButton jButton = new JButton(Messages.getString("ConnectionExportPanel.Browse"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                URLFileChooser uRLFileChooser = new URLFileChooser();
                uRLFileChooser.clearChooseableURLFilters();
                uRLFileChooser.setSelectionScope(1);
                uRLFileChooser.setSelectionMode(0);
                if (ConnectionExportPanel.this.m_txfFilePath.getText().trim().length() > 0) {
                    try {
                        uRLFileChooser.setSelectedURL(new File(ConnectionExportPanel.this.m_txfFilePath.getText()).toURI().toURL());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if ((n = uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow(), OBResourcesArb.getString("DBDOC_SELECT_DIR"))) == 0) {
                    s_selectedURL = uRLFileChooser.getSelectedURL();
                    ConnectionExportPanel.this.updatePathText(ConnectionExportPanel.this.m_txfFilePath);
                }
            }
        });
        jPanel.add((Component)jButton, "East");
        jPanel.add((Component)new JLabel(Messages.getString("ConnectionExportPanel.1")), "West");
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(Messages.getString("ConnectionExportPanel.2"));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        jPanel.add((Component)jTextPane, "North");
        String string = IdeUtil.getIdeEncoding();
        if (string == null) {
            string = "UTF-8";
        }
        JLabel jLabel = new JLabel(Messages.getString("ConnectionExportPanel.3") + string);
        jPanel.add((Component)jLabel, "South");
        return jPanel;
    }

    private void updatePathText(JTextField jTextField) {
        if (s_selectedURL != null && s_selectedURL.toString().length() > 0) {
            String string = new File(s_selectedURL.getPath()).getAbsolutePath();
            jTextField.setText(string);
        }
    }

    public static void main(String[] stringArray) {
        SimpleIdeCore.initIde();
        System.setSecurityManager(null);
        ConnectionExportPanel connectionExportPanel = new ConnectionExportPanel(null);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)connectionExportPanel, (Component)connectionExportPanel, (String)Messages.getString("ConnectionExportPanel.4"), (int)7);
        jEWTDialog.setSize(connectionExportPanel.getPreferredSize().width + 30, connectionExportPanel.getPreferredSize().height + 30);
        jEWTDialog.setDefaultCloseOperation(2);
        boolean bl = jEWTDialog.runDialog();
        if (bl) {
            Object[] objectArray;
            for (Object object : objectArray = connectionExportPanel.getSelectedTypes()) {
                System.out.println(object);
            }
        }
    }

    private Shuttle createShuttle() {
        Shuttle shuttle = new Shuttle();
        DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof DBFolderInstance) {
                    String string = ((DBFolderInstance)object).getDescriptor().getType();
                    return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        };
        this.fromList = new JList(new DefaultListModel());
        this.toList = new JList(new DefaultListModel());
        this.fromList.setCellRenderer(defaultListCellRenderer);
        this.toList.setCellRenderer(defaultListCellRenderer);
        this.fromPicker = new ListPicker(this.fromList);
        this.toPicker = new ReorderableListPicker(this.toList);
        shuttle.setToPicker((ItemPicker)this.toPicker);
        shuttle.setFromPicker((ItemPicker)this.fromPicker);
        shuttle.add((Component)new JLabel(DataImportArb.getString((String)"SHUTTLE_AVAIL_COLUMNS")), (Object)"FromHeader");
        shuttle.add((Component)new JLabel(DataImportArb.getString((String)"SHUTTLE_CHOSEN_COLUMNS")), (Object)"ToHeader");
        return shuttle;
    }

    public Object[] getSelectedTypes() {
        return ((DefaultListModel)this.toList.getModel()).toArray();
    }

    public File getSelectedOutputDir() {
        return new File(this.m_txfFilePath.getText());
    }

    public boolean isGenerateEmptySelected() {
        return this.m_chkCreateEmpty.isSelected();
    }
}

