/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.backgroundTask.utils.DeferUIOperationTask;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.oviewer.Messages;
import oracle.dbtools.raptor.oviewer.OBResourcesArb;
import oracle.dbtools.raptor.oviewer.base.ConnectionExportPanel;
import oracle.dbtools.raptor.oviewer.base.ConnectionExportTask;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;

public class ConnectionExportDataProvider
extends AbstractMenuAction {
    private JComponent _optionsPanel;

    public boolean isEnabled(Context context) {
        boolean bl = false;
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length == 1) {
            bl = elementArray[0] instanceof DatabaseConnection && ((DatabaseConnection)elementArray[0]).isConnectionOpen();
        }
        return bl;
    }

    public void launch() {
        DBObject dBObject = this.getDBObject();
        String string = dBObject.getConnectionName();
        if (dBObject.getConnection() == null) {
            return;
        }
        DbDoc dbDoc = new DbDoc(Messages.getString("ConnectionExportDataProvider.1"), string, this.getDBObject());
        RaptorTaskManager.getInstance().addTask((RaptorTask)dbDoc);
    }

    protected JComponent getOptionsPanel(DBObject dBObject) {
        if (null == this._optionsPanel) {
            ConnectionExportPanel connectionExportPanel = new ConnectionExportPanel(dBObject);
            HelpSystem.getHelpSystem().registerTopic((JComponent)connectionExportPanel, "f1_generatedbdoc_html");
            this._optionsPanel = connectionExportPanel;
        }
        return this._optionsPanel;
    }

    protected File getSelectedOutputDir() {
        return ((ConnectionExportPanel)this.getOptionsPanel(null)).getSelectedOutputDir();
    }

    protected DatabaseQueryTask<File> getTask(File file, DBObject dBObject) {
        ConnectionExportTask connectionExportTask = new ConnectionExportTask(OBResourcesArb.getString("DBDOC_PROGRESS_TITLE"), file, dBObject);
        ConnectionExportPanel connectionExportPanel = (ConnectionExportPanel)this.getOptionsPanel(dBObject);
        connectionExportTask.setFilter(connectionExportPanel.getSelectedTypes());
        connectionExportTask.setGenerateEmptyTypes(connectionExportPanel.isGenerateEmptySelected());
        return connectionExportTask;
    }

    public void launchReal(DBObject dBObject) {
        File file;
        boolean bl = true;
        JComponent jComponent = this.getOptionsPanel(dBObject);
        if (jComponent != null) {
            file = OnePageWizardDialogFactory.createJEWTDialog((Component)jComponent, (Component)jComponent, (String)Messages.getString("ConnectionExportDataProvider.1"), (int)7);
            file.setSize(jComponent.getPreferredSize().width + 30, jComponent.getPreferredSize().height + 30);
            file.setDefaultCloseOperation(2);
            bl = file.runDialog();
        }
        if (bl && (file = this.getSelectedOutputDir()) != null && file.getAbsolutePath().trim().length() > 0) {
            final DatabaseQueryTask<File> databaseQueryTask = this.getTask(file, dBObject);
            databaseQueryTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                    Logger.severe(((Object)((Object)this)).getClass(), (String)Messages.getString("ConnectionExportDataProvider.2"));
                    Logger.severe(((Object)((Object)this)).getClass(), (String)RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()));
                }

                public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                    Logger.severe(((Object)((Object)this)).getClass(), (String)Messages.getString("ConnectionExportDataProvider.3"));
                    Logger.severe(((Object)((Object)this)).getClass(), (String)RaptorTaskUtils.getErrorMessage((Throwable)raptorTaskEvent.getThrowable()));
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    try {
                        File file = (File)databaseQueryTask.getResult();
                        if (file != null) {
                            ConnectionExportDataProvider.this.openFile(file);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Logger.ignore(((Object)((Object)this)).getClass(), (Throwable)interruptedException);
                    }
                    catch (ExecutionException executionException) {
                        Logger.warn(((Object)((Object)this)).getClass(), (Throwable)executionException);
                    }
                }
            });
            RaptorTaskManager.getInstance().addTask(databaseQueryTask);
        }
    }

    public void openFile(File file) {
        try {
            Desktop.getDesktop().browse(new File(file.getPath() + "/index.html").toURI());
        }
        catch (IOException iOException) {
            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)iOException);
        }
    }

    public void setArgs(String string) {
    }

    private class DbDoc
    extends DeferUIOperationTask {
        DBObject _dbObject;
        String _connectionName;

        public DbDoc(String string, String string2, DBObject dBObject) {
            super(string);
            this._dbObject = null;
            this._connectionName = null;
            this._connectionName = string2;
            this._dbObject = dBObject;
        }

        protected Object doWork() throws TaskException {
            return null;
        }

        public String getConnectionName() {
            return this._connectionName;
        }

        protected void invokeLater() {
            try {
                if (this._dbObject != null && this._dbObject.getConnection() != null) {
                    ConnectionExportDataProvider.this.launchReal(this._dbObject);
                }
            }
            catch (Exception exception) {
                Logger.warn(((Object)((Object)this)).getClass(), (Throwable)exception);
            }
        }
    }
}

