/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.x3p.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import oracle.dbtools.common.buffers.BufferHandle;
import oracle.dbtools.common.util.AbstractIterator;
import oracle.dbtools.common.util.ChunkedInputStream;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.x3p.X3PReader;
import oracle.dbtools.common.x3p.X3PWriterOptions;
import oracle.dbtools.common.x3p.impl.X3PChunkedWriter;

final class X3PStream
extends ChunkedInputStream {
    public X3PStream(X3PReader input, X3PWriterOptions options) throws IOException {
        super(new XmlChunker(input, options));
    }

    private static class XmlChunker
    extends AbstractIterator<byte[]>
    implements ChunkedInputStream.Chunker {
        private BufferHandle handle;
        private final X3PChunkedWriter output;
        private final X3PReader reader;
        private InputStream stream;
        private static final int CHUNK_SIZE = 4096;

        public XmlChunker(X3PReader input, X3PWriterOptions options) throws IOException {
            this.reader = input;
            this.output = new X3PChunkedWriter(options);
            this.reader.setHandler(this.output);
        }

        @Override
        public byte[] advance() {
            try {
                byte[] chunk = null;
                boolean empty = true;
                boolean more = true;
                while (empty && more) {
                    if (this.stream != null) {
                        chunk = new byte[4096];
                        int read = this.stream.read(chunk);
                        if (read < chunk.length) {
                            chunk = read == -1 ? new byte[]{} : Arrays.copyOf(chunk, read);
                            this.stream.close();
                            this.handle.close();
                            this.stream = null;
                            this.handle = null;
                        }
                        empty = false;
                        continue;
                    }
                    more = this.reader.next();
                    BufferHandle h = this.output.getStream();
                    if (h == null) {
                        String text = this.output.toString();
                        chunk = text.getBytes("UTF-8");
                        this.output.reset();
                        empty = chunk.length == 0;
                        continue;
                    }
                    this.handle = h;
                    this.stream = this.handle.getStream();
                    this.output.reset();
                    empty = true;
                }
                return chunk;
            }
            catch (IOException e) {
                this.dispose();
                throw new RuntimeException(e);
            }
            catch (RuntimeException e) {
                this.dispose();
                throw e;
            }
        }

        @Override
        public void close() throws IOException {
            this.dispose();
            this.reader.close();
        }

        private void dispose() {
            Closeables.close(this.stream, this.handle);
        }
    }
}

