/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.x3p.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.xml.namespace.QName;
import oracle.dbtools.common.buffers.BufferHandle;
import oracle.dbtools.common.x3p.X3PAttribute;
import oracle.dbtools.common.x3p.X3PAttributes;
import oracle.dbtools.common.x3p.X3PBuilder;
import oracle.dbtools.common.x3p.X3PHandlerAdaptor;
import oracle.dbtools.common.x3p.X3PReader;
import oracle.dbtools.common.x3p.impl.Event;
import oracle.dbtools.common.x3p.impl.X3PAttributeImpl;
import oracle.dbtools.common.x3p.impl.X3PAttributesImpl;
import oracle.dbtools.common.x3p.impl.X3PReaderAdaptor;

public class X3PBuilderImpl
extends X3PBuilder {
    private final List<Event> events = new ArrayList<Event>();

    protected X3PBuilderImpl(boolean emitDocumentEvents) {
        super(emitDocumentEvents);
    }

    @Override
    public X3PBuilder addAttributes(final X3PAttributes updated) {
        final ListIterator<Event> i = this.events.listIterator(this.events.size());
        Event e = null;
        while (i.hasPrevious() && e == null && (e = i.previous()).getType() != Event.Type.SE) {
            e = null;
        }
        if (e == null) {
            throw new IllegalStateException("No startElement event found");
        }
        e.invoke(new X3PHandlerAdaptor(){

            @Override
            public void startElement(QName name, X3PAttributes existing) {
                i.remove();
                i.add(Event.startElement(name, X3PBuilder.merge(existing, updated)));
            }
        });
        return this;
    }

    @Override
    public X3PReader build() {
        return this.iterator().next();
    }

    @Override
    public X3PBuilder characters(char[] chars, int start, int length) {
        this.events.add(Event.characters(chars, start, length));
        return this;
    }

    @Override
    public X3PBuilder endDocument() {
        if (this.emitDocumentEvents) {
            this.events.add(Event.endDocument());
        }
        return this;
    }

    @Override
    public X3PBuilder endElement(QName name) {
        this.events.add(Event.endElement(name));
        return this;
    }

    @Override
    public X3PBuilder endPrefixMapping(String prefix) {
        this.events.add(Event.endPrefixMapping(prefix));
        return this;
    }

    public Iterator<Event> eventIterator() {
        return this.events.iterator();
    }

    @Override
    public Iterator<X3PReader> iterator() {
        return X3PReaderAdaptor.wrap(this.eventIterator()).iterator();
    }

    @Override
    public X3PBuilder processingInstruction(String target, String data) {
        this.events.add(Event.processingInstruction(target, data));
        return this;
    }

    @Override
    public X3PBuilder skippedEntity(String name) {
        this.events.add(Event.skippedEntity(name));
        return this;
    }

    @Override
    public X3PBuilder startDocument() {
        if (this.emitDocumentEvents) {
            this.events.add(Event.startDocument());
        }
        return this;
    }

    @Override
    public X3PBuilder startElement(QName name, X3PAttributes attrs) {
        this.events.add(Event.startElement(name, attrs));
        return this;
    }

    @Override
    public X3PBuilder startPrefixMapping(String prefix, String uri) {
        this.events.add(Event.startPrefixMapping(prefix, uri));
        return this;
    }

    @Override
    public X3PBuilder stream(BufferHandle stream) {
        this.events.add(Event.stream(stream));
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("X3PBuilderImpl [events=");
        builder.append(this.events);
        builder.append("]");
        return builder.toString();
    }

    public static X3PAttribute attribute(QName name, String value) {
        return new X3PAttributeImpl(name, value);
    }

    public static X3PAttributes attributes(Iterable<X3PAttribute> attributes) {
        X3PAttributesImpl impl = new X3PAttributesImpl();
        for (X3PAttribute att : attributes) {
            impl.add(att);
        }
        return impl;
    }

    public static X3PAttributes attributes(String ... attributePairs) {
        if (attributePairs.length % 2 != 0) {
            throw new IllegalArgumentException("Excepted an even number of arguments, " + attributePairs.length + " supplied");
        }
        X3PAttributesImpl attrs = new X3PAttributesImpl();
        for (int i = 0; i < attributePairs.length; ++i) {
            String key = attributePairs[i];
            String value = attributePairs[++i];
            if (key == null || value == null) continue;
            attrs.add(key, value);
        }
        return attrs;
    }

    public static X3PBuilderImpl builder(boolean emitDocumentEvents) {
        return new X3PBuilderImpl(emitDocumentEvents);
    }
}

