/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.x3p;

import java.io.PrintStream;
import javax.xml.namespace.QName;
import oracle.dbtools.common.buffers.BufferHandle;
import oracle.dbtools.common.x3p.X3PAttributes;
import oracle.dbtools.common.x3p.X3PFilter;

public class TraceFilter
implements X3PFilter {
    private final StringBuilder events = new StringBuilder();
    private final PrintStream out;
    public static final X3PFilter FILTER = new TraceFilter();

    public TraceFilter() {
        this(System.out);
    }

    public TraceFilter(PrintStream out) {
        this.out = out;
    }

    @Override
    public void characters(char[] ch, int start, int length, X3PFilter.Mutator mutator) {
        this.print("CH(");
        this.print(new String(ch, start, length));
        this.print(") ");
    }

    @Override
    public void endDocument(X3PFilter.Mutator mutator) {
        this.print("ED ");
    }

    @Override
    public void endElement(QName name, X3PFilter.Mutator mutator) {
        this.print("EE(");
        this.print(name);
        this.print(") ");
    }

    @Override
    public void endPrefixMapping(String prefix, X3PFilter.Mutator mutator) {
        this.print("EP(");
        this.print(prefix);
        this.print(") ");
    }

    @Override
    public void processingInstruction(String target, String data, X3PFilter.Mutator mutator) {
        this.print("PI(");
        this.print(target);
        this.print(", ");
        this.print(data);
        this.print(") ");
    }

    @Override
    public void skippedEntity(String name, X3PFilter.Mutator mutator) {
        this.print("SK(");
        this.print(name);
        this.print(") ");
    }

    @Override
    public void startDocument(X3PFilter.Mutator mutator) {
        this.print("SD ");
    }

    @Override
    public void startElement(QName name, X3PAttributes atts, X3PFilter.Mutator mutator) {
        this.print("SE(");
        this.print(name);
        this.print(") ");
    }

    @Override
    public void startPrefixMapping(String prefix, String uri, X3PFilter.Mutator mutator) {
        this.print("SP(");
        this.print(prefix);
        this.print(", ");
        this.print(uri);
        this.print(") ");
    }

    @Override
    public void stream(BufferHandle stream, X3PFilter.Mutator mutator) {
        this.print("ST(");
        this.out.print(stream);
        this.print(")");
    }

    private void print(CharSequence chars) {
        this.events.append(chars);
        this.out.print(chars);
    }

    private void print(Object obj) {
        this.print(obj.toString());
    }
}

