/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.StreamCopy;

public class ZipBuilder {
    public static final int MAX_COMPRESSION = 9;
    private final ByteArrayOutputStream bytes = new ByteArrayOutputStream();
    private final ZipOutputStream zip = new ZipOutputStream(this.bytes);
    private final List<String> toc = new ArrayList<String>();

    private ZipBuilder() {
        this.storageMethod(StorageMethod.DEFLATED);
        this.compressionLevel(9);
    }

    public static ZipBuilder builder() {
        return new ZipBuilder();
    }

    public ZipBuilder storageMethod(StorageMethod storageMethod) {
        if (storageMethod == StorageMethod.STORED) {
            this.zip.setMethod(0);
        } else {
            this.zip.setMethod(8);
        }
        return this;
    }

    public ZipBuilder compressionLevel(int level) {
        this.zip.setLevel(level);
        return this;
    }

    public ZipBuilder addEntry(String name, InputStream stream) throws IOException {
        this.zip.putNextEntry(new ZipEntry(name));
        StreamCopy.drain(stream, this.zip);
        this.zip.closeEntry();
        this.toc.add(name);
        return this;
    }

    public String toString() {
        return Iterables.join(this.toc, ", ");
    }

    public InputStream build() throws IOException {
        Closeables.close(this.zip);
        return new ByteArrayInputStream(this.bytes.toByteArray());
    }

    public ZipInputStream buildZipInputStream() throws IOException {
        return new ZipInputStream(this.build());
    }

    public static enum StorageMethod {
        STORED,
        DEFLATED;

    }
}

