/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Transform;

public class SortedProperties
extends Properties {
    @Override
    public synchronized String toString() {
        StringBuilder b = new StringBuilder();
        b.append("{");
        b.append(Iterables.join(Iterables.transform(this.sortedKeys(), new Transform<Object, String>(){

            @Override
            public String apply(Object key) {
                StringBuilder b = new StringBuilder();
                Object value = SortedProperties.this.get(key);
                b.append(key);
                b.append("=");
                b.append(value);
                return b.toString();
            }
        }), ", "));
        b.append("}");
        return b.toString();
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        return Iterators.enumeration(this.sortedKeys().iterator());
    }

    @Override
    public Set<Object> keySet() {
        return this.sortedKeys();
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        if (value == null) {
            return this.remove(key);
        }
        return super.put(key, value);
    }

    private Set<Object> sortedKeys() {
        Enumeration<Object> keys = super.keys();
        TreeSet<Object> sorted = new TreeSet<Object>();
        while (keys.hasMoreElements()) {
            sorted.add(keys.nextElement());
        }
        return sorted;
    }
}

