/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Iterators;

public abstract class Readers {
    public static Reader reader(CharSequence chars) {
        return chars == null ? null : new CharSequenceReader(chars);
    }

    public static Reader sequence(Reader ... readers) {
        return new SequencedReader(readers);
    }

    private static class SequencedReader
    extends Reader {
        private Reader reader;
        private final Iterator<Reader> readers;

        SequencedReader(Reader[] readers) {
            this.readers = Iterators.iterator(readers);
            this.reader = this.nextReader();
        }

        @Override
        public void close() throws IOException {
            Closeables.close(this.readers);
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.reader == null) {
                return -1;
            }
            int count = 0;
            int remaining = len;
            int destPos = off;
            while (remaining > 0 && this.reader != null) {
                int read = this.reader.read(cbuf, destPos, remaining);
                if (read > 0) {
                    remaining -= read;
                    destPos += read;
                    count += read;
                    continue;
                }
                this.reader = this.nextReader();
            }
            return count;
        }

        public String toString() {
            return this.readers.toString();
        }

        private Reader nextReader() {
            Reader reader = null;
            while (this.readers.hasNext() && reader == null) {
                reader = this.readers.next();
            }
            return reader;
        }
    }

    private static class CharSequenceReader
    extends Reader {
        private final CharSequence chars;
        private int start = 0;

        public CharSequenceReader(CharSequence chars) {
            this.chars = chars;
        }

        @Override
        public void close() throws IOException {
            if (this.chars instanceof Closeable) {
                Closeables.close(this.chars);
            }
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int available = this.chars.length() - this.start;
            int amt = Math.min(available, len);
            if (amt > 0) {
                CharSequence sub = this.chars.subSequence(this.start, this.start + amt);
                char[] chars = ((Object)sub).toString().toCharArray();
                System.arraycopy(chars, 0, cbuf, off, amt);
                this.start += amt;
                return amt;
            }
            return -1;
        }

        public String toString() {
            return ((Object)this.chars).toString();
        }
    }
}

