/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.common.util.SensitiveAssociativeArray;
import oracle.dbtools.common.util.SortedProperties;
import oracle.dbtools.common.util.Transform;

public abstract class AssociativeArrays {
    private static final Empty EMPTY = new Empty();

    private AssociativeArrays() {
    }

    public static <E> AssociativeArray<E, E> asArray(E ... valuePairs) {
        LinkedHashMap<E, E> map = new LinkedHashMap<E, E>();
        for (int i = 0; i < valuePairs.length; ++i) {
            E key = valuePairs[i];
            E value = valuePairs[++i];
            map.put(key, value);
        }
        return AssociativeArrays.fromMap(map);
    }

    public static Properties asProperties(AssociativeArray<?, ?> assocArray) {
        SortedProperties props = new SortedProperties();
        for (Object key : assocArray) {
            props.put(key, assocArray.get(key));
        }
        return props;
    }

    public static AssociativeArray<Object, Object> detype(AssociativeArray<?, ?> target) {
        AssociativeArray<Object, Object> ick = target;
        return ick;
    }

    public static <K, V> void dump(AssociativeArray<K, V> assocArray, Appendable out) {
        Iterator<K> keys = assocArray.iterator();
        if (!keys.hasNext()) {
            return;
        }
        try {
            while (keys.hasNext()) {
                K key = keys.next();
                V value = assocArray.get(key);
                out.append(key.toString());
                out.append('=');
                out.append(value == null ? "null" : value.toString());
                out.append("\n");
            }
        }
        catch (IOException e) {
            throw UnrecoverableException.unrecoverable(e);
        }
    }

    public static <K, V> AssociativeArray<K, V> empty() {
        return EMPTY;
    }

    public static <K, V> boolean equals(AssociativeArray<K, V> o1, AssociativeArray<K, V> o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        Iterator<K> i1 = o1.iterator();
        Iterator<K> i2 = o2.iterator();
        while (i1.hasNext()) {
            V v2;
            K n2;
            if (!i2.hasNext()) {
                return false;
            }
            K n1 = i1.next();
            if (!n1.equals(n2 = i2.next())) {
                return false;
            }
            V v1 = o1.get(n1);
            if (v1.equals(v2 = o2.get(n2))) continue;
            return false;
        }
        return !i2.hasNext();
    }

    public static <K, V> AssociativeArray<K, V> fromMap(Map<K, V> map) {
        return new FromMap(map);
    }

    public static <K, V> AssociativeArray<K, V> merge(AssociativeArray<K, V> child, AssociativeArray<K, V> parent) {
        return new Merged(child, parent);
    }

    public static <K, V> AssociativeArray<K, V> sensitive(AssociativeArray<K, V> target, V substitute, Selector<K> isSensitive) {
        return new SensitiveAssociativeArray<K, V>(target, substitute, isSensitive);
    }

    public static <K, V> AssociativeArray<K, V> unmerge(AssociativeArray<K, V> values) {
        if (values instanceof MergedArray) {
            return ((MergedArray)((Object)values)).child();
        }
        return values;
    }

    private static class Merged<K, V>
    extends Base<K, V>
    implements MergedArray<K, V> {
        private final AssociativeArray<K, V> child;
        private final AssociativeArray<K, V> parent;

        private Merged(AssociativeArray<K, V> child, AssociativeArray<K, V> parent) {
            this.child = child;
            this.parent = parent;
        }

        @Override
        public AssociativeArray<K, V> child() {
            return this.child;
        }

        @Override
        public V get(Object key) {
            V value = this.child.get(key);
            if (value == null && this.parent != null) {
                value = this.parent.get(key);
            }
            return value;
        }

        @Override
        public Iterator<K> iterator() {
            if (this.parent == null) {
                return this.child.iterator();
            }
            LinkedHashSet keys = new LinkedHashSet();
            Iterables.add(keys, this.parent);
            Iterables.add(keys, this.child);
            return keys.iterator();
        }
    }

    private static final class FromMap<K, V>
    extends Base<K, V> {
        private final Map<K, V> map;

        private FromMap(Map<K, V> map) {
            this.map = map;
        }

        @Override
        public V get(Object key) {
            return this.map.get(key);
        }

        @Override
        public Iterator<K> iterator() {
            return this.map.keySet().iterator();
        }
    }

    private static class Empty
    extends Base<Object, Object> {
        private Empty() {
        }

        @Override
        public Object get(Object key) {
            return null;
        }

        @Override
        public Iterator<Object> iterator() {
            return Iterators.empty();
        }
    }

    public static interface MergedArray<K, V> {
        public AssociativeArray<K, V> child();
    }

    public static abstract class Base<K, V>
    implements AssociativeArray<K, V> {
        public boolean equals(AssociativeArray<K, V> other) {
            return AssociativeArrays.equals(this, other);
        }

        public boolean equals(Object obj) {
            return obj instanceof AssociativeArray ? this.equals((AssociativeArray)obj) : false;
        }

        public int hashCode() {
            int h = 0;
            for (Object key : this) {
                h += key.hashCode();
                Object value = this.get(key);
                if (value == null) continue;
                h += value.hashCode();
            }
            return h;
        }

        @Override
        public AssociativeArray<K, V> put(AssociativeArray<K, V> values) {
            return AssociativeArrays.merge(values, this);
        }

        @Override
        public AssociativeArray<K, V> put(K key, V value) {
            HashMap<K, V> values = new HashMap<K, V>();
            values.put(key, value);
            return this.put(AssociativeArrays.fromMap(values));
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("{");
            b.append(Iterables.join(Iterables.transform(this, new Transform<K, String>(){

                @Override
                public String apply(K key) {
                    StringBuilder b = new StringBuilder();
                    Object value = Base.this.get(key);
                    b.append(key);
                    b.append("=");
                    b.append(value);
                    return b.toString();
                }
            }), ", "));
            b.append("}");
            return b.toString();
        }
    }
}

